/**
 * $Id: HLTask.java,v 1.3 2001/09/14 01:54:22 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.hotline;

class HLTask {

    public int type;
    boolean locked = false, disposeWhenReceived = true;
    SynchronizedContainer synchronizedContainer = new SynchronizedContainer();

    class SynchronizedContainer {

        boolean got = false;
        HLException error = null;
        Object data = null;

        synchronized Object get() throws HLException, InterruptedException {

            while(!got) 
                wait();

            if(error != null)
                throw error;

            return data;

        }

        synchronized void put(Object data) {

            this.data = data;
            got = true;
            notifyAll();

        }

        synchronized void putError(HLException error) {

            this.error = error;
            got = true;
            notifyAll();

        }

        public String toString() {

            return "SynchronizedContainer[got = " + got + ", data = " + data + ", error = " + error + "]";

        }

    }

    public HLTask(int type, boolean disposeWhenReceived) {

        this.type = type;
        this.disposeWhenReceived = disposeWhenReceived;

    }
    

    public Object getData() throws HLException, InterruptedException {

        return synchronizedContainer.get();

    }

    public void setData(Object data) {

        synchronizedContainer.put(data);

    }

    public void setError(HLException error) {

        synchronizedContainer.putError(error);

    }

    public String toString() {

	return "HLTask[type = 0x" + Integer.toHexString(type) + ", locked = " + locked + ", disposeWhenReceived = " + disposeWhenReceived + ", " + synchronizedContainer + "]";

    }

    public synchronized boolean isLocked() {
        
        return locked;

    }

    public synchronized void lock() {

        locked = true;

    }

}



