/**
 * $Id: Spinner.java,v 1.1.1.1 2001/07/22 02:44:39 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.graphics;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Dimension;
import java.awt.Graphics;

import redlight.utils.DebuggerOutput;

/**
 * Spinner implements an animated component.
 * The start() and stop() methods respectively start and stop the 
 * animation. When stopped, the component draws a rectangle in the 
 * background color.
 */ 
public class Spinner extends java.awt.Component implements Runnable {
    Image[] images;
    Thread spinner;
    protected int speed, width, height;
    int currentImage;
    boolean busy;
    
    /**
     * @param imgs an array of image objects to use
     * @param s the delay between each frame
     * @param w the width of the component
     * @param h the height of the component
     */
    public Spinner(Image[] imgs, int s, int w, int h) {
	super();
	speed = s;
	width = w;
	height = h;
	images = imgs;
	busy = false;

    }

    public void run() {

        Thread.currentThread().setName("Spinner " + images[0]);
	try {
	    do {
		currentImage++;
		if(currentImage == images.length)
		    currentImage = 0;
		repaint();
		Thread.currentThread().sleep(speed);
	    } while(busy);
	} catch (InterruptedException e) {
	    //	    e.printStackTrace();
	    //	    System.out.println(e);
	}

    }

    public java.awt.Dimension getPreferredSize() {

	return new Dimension(width, height);

    }
	
    public java.awt.Dimension getMinimumSize() {

	return new Dimension(width, height);

    }
	
    public void update(Graphics g) {

	paint(g);

    }

    public void paint(Graphics g) {

	if(busy) 
	    g.drawImage(images[currentImage], 0, 0, this);
	else 
	    g.clearRect(0, 0, width, height);

    }

    public void start() {

        if(!busy) {

            busy = true;
            spinner = new Thread(this);
            spinner.start();

        }

    }
    
    public void stop() {

	busy = false;
	spinner.interrupt();

        try {

            spinner.join();
            
        } catch(InterruptedException e) {}

	repaint();

    }
    
    public boolean isBusy() {
	return busy;
    }
}

