/**
 * $Id: ViewInterface.java,v 1.5 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;

import java.io.PipedInputStream;
import java.io.IOException;
import javax.swing.SwingUtilities;

import redlight.hotline.HLProtocol;
import redlight.hotline.HLException;
import redlight.utils.DebuggerOutput;
import redlight.utils.Meter;
import redlight.utils.MeterSource;

/**
 * Interface for downloading files to be viewed.
 */
public class ViewInterface extends TransferInterface {
    String path;
    HLProtocol.FileListComponent file;
    PipedInputStream inputPipe;
    AbstractViewInterface inWindow = null;

    public ViewInterface(Machine machine, 
                         String path, 
                         HLProtocol.FileListComponent file, 
                         AbstractViewInterface inWindow) {

	super(machine, file.fileName);
	this.path = path;
	this.file = file;
        this.inWindow = inWindow;

	/* When doRequest() succeeds, granted() is called by the
           superclass. */

	doRequest();

    }

    /**
     * Invoked by the superclass when this transfer is ready to be
     * started.
     */
    public void granted() {

	if(rlm == null || rlm.getHLC() != null) {

	    try {

                startViewing();

	    } catch (NullPointerException ex) {

		rlm.getInterface().error("The connection has been closed.");
                close();

	    } catch (Exception ex) {

		rlm.getInterface().error("An unknown error occurred: "+ex.getMessage());
		close();

	    }

	}

    }

    void startViewing() {

        /* Send the request to the server and wait ... */
        
        try {
            
            DebuggerOutput.debug("ViewInterface.startViewing: requesting data fork download " + path);
            inputPipe = new PipedInputStream();
            DebuggerOutput.debug("ViewInterface.startViewing: created pipe");
            setTransferTask(rlm.getHLC().
                            requestDataForkDownload(path, 
                                                    inputPipe,
                                                    this));
                            
            SwingUtilities.invokeLater(new Runnable() {
                    
                    public void run() {
                        
                        info.setText(filename + "   [waiting for server to respond]");
                        repaintStatus();
                        
                    }
                    
                });
            
        } catch (IOException e) {

            DebuggerOutput.stackTrace(e);

        }
        
    }

    public void startMeter(MeterSource ms, int ref, String f, final long size) {

        super.startMeter(ms, ref, f, size);

        DebuggerOutput.debug("inputPipe = " + inputPipe);

        if(file.fileType.equals("GIFf") || 
           filename.toLowerCase().endsWith(".gif") ||
           file.fileType.equals("JPEG") ||
           filename.toLowerCase().endsWith(".jpg")) {

            new ViewImageInterface(rlm, this, "image", filename, size, inputPipe);

        } else if(file.fileType.equals("HTML") ||
                  (filename.toLowerCase().endsWith(".html") ||
                   filename.toLowerCase().endsWith(".htm"))) {

            if(inWindow == null)
                new ViewHTMLInterface(rlm, this, filename, size, inputPipe);
            else
                inWindow.setContent(rlm, this, "HTML", filename, size, inputPipe);
        } else {

            new ViewTextInterface(rlm, this, filename, size, inputPipe);

        }

    }

    public void handleTaskError(int task, String error) {
        
        stopMeterWithError(xfref, new HLException(error));

    }

}
