/**
 * $Id: UserToolBar.java,v 1.1 2001/10/04 01:03:59 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;

import java.io.IOException;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import redlight.utils.DebuggerOutput;

/**
 * Toolbar of reload, info, msg, privchat & kick buttons with
 * appropriate action listeners.
 */
class UserToolBar extends JToolBar implements ActionListener {

    JButton reload, info, priv, msg, kick;
    User user;
    Machine rlm;

    UserToolBar(Machine rlm, User user) {

        this.rlm = rlm;
        this.user = user;

        GridBagConstraints gbc = new GridBagConstraints();
	reload = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[Options.REFRESH_ICON]));
	info = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[Options.INFO_ICON]));
	msg = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[Options.MESSAGE_ICON]));
	priv = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[Options.CHAT_ICON]));
	kick = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[Options.DISCONNECT_ICON]));
        reload.setActionCommand("ActivateReload");
        info.setActionCommand("ActivateInfo");
        priv.setActionCommand("ActivatePrivChat");
        msg.setActionCommand("ActivateMessage");
        kick.setActionCommand("ActivateKick");
        reload.setToolTipText("Reload view");
	priv.setToolTipText("Invite user to a private chat");
	info.setToolTipText("Get info on the user");
	msg.setToolTipText("Send a message to the user");
	kick.setToolTipText("Disconnect the user");
        reload.addActionListener(this);
        info.addActionListener(this);
        priv.addActionListener(this);
        msg.addActionListener(this);
        kick.addActionListener(this);

        setFloatable(false);

        add(reload);
        add(info);
        add(msg);
        add(priv);
        add(kick);

    }
    
    public void actionPerformed(ActionEvent e) {
        
        try {
            
            if(e.getActionCommand().equals("ActivatePrivChat")) {
                
                rlm.getHLC().requestPrivateChatCreate(user.sock);
                
            } else if(e.getActionCommand().equals("ActivateInfo")) {
                
                new UserInfoInterface(rlm, user);
                
            } else if(e.getActionCommand().equals("ActivateMessage")) {
                
                new MessageTransmit(rlm, user);
                
            } else if(e.getActionCommand().equals("ActivateKick")) {
                
                if((e.getModifiers() & ActionEvent.SHIFT_MASK) == 
                   ActionEvent.SHIFT_MASK)
                    rlm.getHLC().requestUserKickBan(user.sock);
                else		
                    rlm.getHLC().requestUserKick(user.sock);
                
            }
            
        } catch(IOException ex) {
            
            DebuggerOutput.stackTrace(ex);
            
        }
        
    }
    
}
