/**
 * $Id: UploadInterface.java,v 1.4 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import redlight.utils.TextUtils;
import redlight.macfiles.*;
import redlight.hotline.*;
import redlight.utils.FilenameUtils;
import redlight.utils.Meter;
import redlight.utils.DebuggerOutput;

public class UploadInterface extends TransferInterface {
    int transferTask;
    String path;
    File file;
    ResumeInterface resumeUI;

    UploadInterface(Machine machine, String path, File file) {
        
	super(machine, file.getName());
	this.path = path;
	this.file = file;

	/* When doRequest succeeds, granted() is invoked by the
           superclass. */

	doRequest();

    }

    /**
     * Following methods overridden from superclass.
     */
    public void granted() {

        SwingUtilities.invokeLater(new Runnable() {
                
                public void run() {
                    
                    info.setText(filename + "   [checking whether file exists] ");
                    repaintStatus();

                }
                
            });
        
	try {

            localFile = MacFile.createMacFile((String) Main.rlo.getProperty("MacFileMethod"), file, MacFile.READ_PERM);
            
	} catch(Exception ex) {

	    rlm.getInterface().error("Could not upload " + file +": " + ex.getMessage());
            DebuggerOutput.stackTrace(ex);
	    close();

	}

        /* Ask the user whether or not to resume. */
        
        resumeUI = new ResumeInterface(file.getName(), autoResume, new ResumeActionListener() {
                
                public boolean canResume() {

                    boolean exists = false;

                    /* Get a list of files in the destination path. */
                    
                    try {
                        
                        HLProtocol.FileListComponent[] files = 
                            rlm.getHLC().getFileList(path);
                        
                        String n = localFile.getFile().getName();
                        
                        for(int i = 0; i < files.length; i++)
                            if(!files[i].fileType.equals("fldr") &&
                               (n.equals(files[i].fileName) || 
                                files[i].fileName.equals(n + ".hpf")))
                                exists = true;
                        
                    } catch(IOException e) {
                    } catch(HLException e) {
                    } catch(InterruptedException e) {}

                    return exists;

                }
                
                public void resumeCancelled() {
                    
                    if(!interrupted)
                        close();
        
                }
                
                public void resumeAnswered(boolean resume) {
                    
                    try {
                        
                        DebuggerOutput.debug("UploadInterface.confirm: requesting file upload for " + file + " to " + path);
                        setTransferTask(rlm.getHLC().requestFileUpload(localFile, path, meter, resume));
                        info.setText(filename + "   [waiting for server to respond]        ");
                        repaintStatus();
                        closeLocalFile = false;
                        
                    } catch(IOException e) {}
                    
                }
                
            });
                

    }

    /**
     * This method overridden to ignore the results from any
     * outstanding "Resume downloads" windows when we get closed.
     */
    protected void interrupt() {
        
	if(resumeUI != null)
            resumeUI.interrupt();
        
	super.interrupt();
        
    }

}
