/**
 * $Id: OptionsInterface.java,v 1.9 2001/10/07 04:43:39 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.Enumeration;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.Box;

import redlight.hotline.*;
import redlight.utils.DebuggerOutput;
import redlight.graphics.GraphicsUtils;
import redlight.macfiles.MacFile;

public class OptionsInterface implements ActionListener {
    Options rlo;
    Parent parent;
    Container contentPane;
    static JFrame f;
    JButton confirm, cancel;
    NickIconPanel nickIconPanel = new NickIconPanel();
    OptionsPanel optionsPanel = new OptionsPanel();
    PathsPanel pathsPanel = new PathsPanel();
    AutoPanel autoPanel = new AutoPanel();
    
    public OptionsInterface(Parent parent, Options options) {

	this.parent = parent;
	this.rlo = options;

        HelpTextPanel nickIconHelpPanel = new HelpTextPanel("Nick&icon", "Your nickname and icon.", nickIconPanel);
        HelpTextPanel optionsHelpPanel = new HelpTextPanel("Options", "Font settings, transfer method, switches.", optionsPanel);
        HelpTextPanel pathsHelpPanel = new HelpTextPanel("Paths", "Where files live on your disk.", pathsPanel);
        HelpTextPanel autoHelpPanel = new HelpTextPanel("Auto", "Timeouts, retries.", autoPanel);

	Font guiFont = ((Font) Main.rlo.getProperty("Font.gui"));

	f = new JFrame("Red Light Options");
	contentPane = f.getContentPane();

	GridBagConstraints gbc = new GridBagConstraints();
        JTabbedPane tabbedPane = new JTabbedPane();

	cancel = new JButton("Cancel");
	confirm = new JButton("Save");

        contentPane.setLayout(new GridBagLayout());

        cancel.setMnemonic('C');
	confirm.setDefaultCapable(true);
        confirm.setMnemonic('S');
        //        contentPane.registerKeyboardAction(this, "Cancel", KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0),JComponent.WHEN_IN_FOCUSED_WINDOW);

        /* Add panels to tabbed pane. */
        
        tabbedPane.addTab("Nick & icon", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[Options.SPACER_ICON]), nickIconHelpPanel, "Set your nick & icon");
        tabbedPane.addTab("Options", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[Options.SPACER_ICON]), optionsHelpPanel, "Options");
        tabbedPane.addTab("Paths", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[Options.SPACER_ICON]), pathsHelpPanel, "Where files live");
        tabbedPane.addTab("Auto", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[Options.SPACER_ICON]), autoHelpPanel, "Control automatic behaviour");
        

        JButton[] buttons = new JButton[2];
        buttons[0] = cancel;
        buttons[1] = confirm;
	ButtonPanel buttonPanel = new ButtonPanel(null, buttons);
        ButtonedPanel buttonedPanel = new ButtonedPanel(tabbedPane,
                                                        buttonPanel);

        contentPane.setLayout(new BorderLayout());
        contentPane.add(buttonedPanel, BorderLayout.CENTER);

        SwingUtilities.getRootPane(f).setDefaultButton(confirm);

	cancel.addActionListener(this);
	confirm.addActionListener(this);

	f.addWindowListener(new WindowAdapter() {

                public void windowClosing(WindowEvent e) {
                    
                    f.setVisible(false);
                    
                }

            });
        

	f.pack();

	Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
	Dimension w = f.getSize();
		
	f.setLocation((d.width / 2) - (w.width / 2), 
		      (d.height / 2) - (w.height / 3));
		
	f.show();

    }

    public void actionPerformed(ActionEvent e) {

	if(e.getActionCommand().equals("Save")) {	    

            nickIconPanel.actionPerformed(e);
            optionsPanel.actionPerformed(e);
            pathsPanel.actionPerformed(e);
            autoPanel.actionPerformed(e);
            
            try {
                
                Main.rlo.store(Main.CONFIGURATION_FILE);
                
            } catch(IOException ex) {
                
                System.out.println("Exception writing " + Main.CONFIGURATION_FILE + ": " + ex);
                
            }
            
            parent.displayPropertyChanged("textfont", (Font) Main.rlo.getProperty("Font.text"));
            parent.displayPropertyChanged("listfont", (Font) Main.rlo.getProperty("Font.list"));

	    f.setVisible(false);

	} else if(e.getActionCommand().equals("Cancel")) {

	    f.setVisible(false);

	}

    }
	
    public void show() {

	if(!f.isVisible()) {
            
            nickIconPanel.setup(Main.rlo);
            optionsPanel.setup(Main.rlo);
            pathsPanel.setup(Main.rlo);
            autoPanel.setup(Main.rlo);

	}

	f.show();

    }

}

class AutoPanel extends JPanel implements ActionListener {

    JTextField folderErrors, retries, stallTimeout;

    AutoPanel() {

        GridBagConstraints gbc = new GridBagConstraints();
        setLayout(new GridBagLayout());

	retries = new JTextField("", 15);
	folderErrors = new JTextField("", 5);
	stallTimeout = new JTextField("", 5);

        retries.setToolTipText("This number determines how often Red Light will retry a transfer if an error occurs.");
        folderErrors.setToolTipText("For folder downloads, this number determines how many errors to tolerate before giving up.");
        stallTimeout.setToolTipText("If no data is received or sent on a transfer for this many seconds, it is retried. Use 0 to disable.");

        gbc.gridx = 1;
        gbc.gridy = 1;
        addRow(new JLabel("Transfer retries:"), retries, gbc);
        addRow(new JLabel("Max. folder errors:"), folderErrors, gbc);
        addRow(new JLabel("Stalled transfer timeout (s):"), stallTimeout, gbc);
        gbc.weightx = 1;
        gbc.weighty = 1;
        gbc.fill = gbc.BOTH;
        addRow(Box.createGlue(), Box.createGlue(), gbc);

        setup(Main.rlo);

    }

    void addRow(Component l, Component v, GridBagConstraints gbc) {

        gbc.anchor = gbc.WEST;
        gbc.fill = gbc.NONE;
        add(l, gbc);
        gbc.gridx++;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1;
        add(v, gbc);
        gbc.gridx = 1;
        gbc.gridy++;

    }

    void setup(Options o) {

        retries.setText(Main.rlo.getStringProperty("Auto.DownloadRetries"));
        folderErrors.setText(new Integer(Main.rlo.getIntegerProperty("Auto.MaxFolderErrors")).toString());
        stallTimeout.setText(new Integer(Main.rlo.getIntegerProperty("Auto.StallTimeout")).toString());

    }

    public void actionPerformed(ActionEvent e) {
        
	if(e.getActionCommand().equals("Save")) {

	    try {

		Main.rlo.setIntegerProperty("Auto.MaxFolderErrors", new Integer(folderErrors.getText()).intValue());
		Main.rlo.setIntegerProperty("Auto.DownloadRetries", new Integer(retries.getText()).intValue());
		Main.rlo.setIntegerProperty("Auto.StallTimeout", new Integer(stallTimeout.getText()).intValue());

	    } catch (NumberFormatException ex) {
                
                System.out.println(ex.toString() + " is not a number");
                
	    }
            
        }

    }

}

class NickIconPanel extends JPanel implements ActionListener {

    JTextField nick, icon;

    NickIconPanel() {

        GridBagConstraints gbc = new GridBagConstraints();
        setLayout(new GridBagLayout());

	nick = new JTextField("", 15);
	icon = new JTextField("", 5);

        gbc.gridx = 1;
        gbc.gridy = 1;
        addRow(new JLabel("Nick:"), nick, gbc);
        addRow(new JLabel("Icon number:"), icon, gbc);
        gbc.weightx = 1;
        gbc.weighty = 1;
        gbc.fill = gbc.BOTH;
        addRow(Box.createGlue(), Box.createGlue(), gbc);

        setup(Main.rlo);
        
    }

    void addRow(Component l, Component v, GridBagConstraints gbc) {

        gbc.anchor = gbc.WEST;
        gbc.fill = gbc.NONE;
        add(l, gbc);
        gbc.gridx++;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1;
        add(v, gbc);
        gbc.gridx = 1;
        gbc.gridy++;

    }

    void setup(Options o) {

        nick.setText(Main.rlo.getStringProperty("User.Nick"));
        icon.setText(new Integer(Main.rlo.getIntegerProperty("User.IconNumber")).toString());

    }

    public void actionPerformed(ActionEvent e) {
        
	if(e.getActionCommand().equals("Save")) {

	    Main.rlo.setStringProperty("User.Nick", nick.getText());
            
	    try {

                Main.rlo.setIntegerProperty("User.IconNumber", new Integer(icon.getText()).intValue());

	    } catch (NumberFormatException ex) {
                
                System.out.println(icon.getText() + " is not a number");
                
	    }
            
        }

    }

}

class OptionsPanel extends JPanel implements ActionListener {

    String[] macFileMethods = MacFile.getSupportedMacFileMethods();
    String defaultMFMethod = 
        (String) Main.rlo.getProperty("MacFileMethod");
    JComboBox fontChoice, listFontChoice, macFileChoice;
    JCheckBox loadnews, queue, colors, joinleave, log, swallow, liveResize, showIcons;
    JTextField fontSize, listFontSize;

    OptionsPanel() {

        GridBagConstraints gbc = new GridBagConstraints();
        setLayout(new GridBagLayout());

	Font guiFont = ((Font) Main.rlo.getProperty("Font.gui"));

        macFileChoice = createComboBox(macFileMethods, defaultMFMethod);
        fontChoice = createFontComboBox("Font.text");
	listFontChoice = createFontComboBox("Font.list");
	fontSize = new JTextField("", 2);
	listFontSize = new JTextField("", 2);

	queue = new JCheckBox("Queue downloads", true);
	loadnews = new JCheckBox("Load news", true);
	joinleave = new JCheckBox("Show join/leave in chat", true);
	log = new JCheckBox("Log chat by default", true);
	liveResize = new JCheckBox("Resize in real-time", true);
	showIcons = new JCheckBox("Show user icons", true);

	log.setToolTipText("Logs public and private chat to " + Main.CONFIGURATION_DIRECTORY + System.getProperty("file.separator") + "Log" + System.getProperty("file.separator"));
	queue.setToolTipText("Limits the number of simultaneous downloads per server to 1.");
	loadnews.setToolTipText("Loads news upon connecting. Slows down the connection process.");
	joinleave.setToolTipText("Shows user arrival and departure in the public chat.");
	liveResize.setToolTipText("Enables realtime interface updating. Needs a fast computer.");
        showIcons.setToolTipText("Shows user icons, turn off to save memory.");

        JPanel fontChoicePanel = new JPanel();
        fontChoicePanel.setLayout(new BorderLayout());
        fontChoicePanel.add(fontChoice, BorderLayout.CENTER);
        fontChoicePanel.add(fontSize, BorderLayout.EAST);
        JPanel listFontChoicePanel = new JPanel();
        listFontChoicePanel.setLayout(new BorderLayout());
        listFontChoicePanel.add(listFontChoice, BorderLayout.CENTER);
        listFontChoicePanel.add(listFontSize, BorderLayout.EAST);

        gbc.gridx = 1;
        gbc.gridy = 1;
        addRow(new JLabel("Text font:"), fontChoicePanel, gbc);
        addRow(new JLabel("List font:"), listFontChoicePanel, gbc);
        addRow(new JLabel("Transfer method:"), macFileChoice, gbc);
        addRow(queue, joinleave, gbc);
        addRow(loadnews, liveResize, gbc);
        addRow(log, showIcons, gbc);
        gbc.weightx = 1;
        gbc.weighty = 1;
        gbc.fill = gbc.BOTH;
        addRow(Box.createGlue(), Box.createGlue(), gbc);

        setup(Main.rlo);

    }

    void addRow(Component l, Component v, GridBagConstraints gbc) {

        gbc.anchor = gbc.WEST;
        gbc.fill = gbc.NONE;
        add(l, gbc);
        gbc.gridx++;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1;
        add(v, gbc);
        gbc.gridx = 1;
        gbc.gridy++;

    }

    void setup(Options o) {

        setComboBoxDefault(fontChoice, ((Font) o.getProperty("Font.text")).getName());
        setComboBoxDefault(listFontChoice, ((Font) o.getProperty("Font.list")).getName());
        setComboBoxDefault(macFileChoice, o.getStringProperty("MacFileMethod"));
        fontSize.setText(new Integer(((Font) o.getProperty("Font.text")).getSize()).toString());
        listFontSize.setText(new Integer(((Font) o.getProperty("Font.list")).getSize()).toString());
        queue.setSelected(o.getBooleanProperty("Toggle.QueueDownloads"));
        loadnews.setSelected(o.getBooleanProperty("Toggle.LoadNews"));
        joinleave.setSelected(o.getBooleanProperty("Toggle.JoinLeave"));
        log.setSelected(o.getBooleanProperty("Toggle.Log"));
        liveResize.setSelected(o.getBooleanProperty("Toggle.LiveResizing"));
        showIcons.setSelected(o.getBooleanProperty("Toggle.ShowIcons"));

    }

    public void actionPerformed(ActionEvent e) {

	if(e.getActionCommand().equals("Save")) {

            try {

                Main.rlo.setProperty("Font.text", new Font((String) fontChoice.getSelectedItem(), Font.PLAIN, new Integer(fontSize.getText()).intValue()));

            } catch(NumberFormatException ex) {

                System.out.println("Text font size not a number");

            }
            
            try {

                Main.rlo.setProperty("Font.list", new Font((String) listFontChoice.getSelectedItem(), Font.PLAIN, new Integer(listFontSize.getText()).intValue()));

            } catch(NumberFormatException ex) {

                System.out.println("List font size not a number");

            }

            Main.rlo.setStringProperty("MacFileMethod", (String) macFileChoice.getSelectedItem());
	    Main.rlo.setBooleanProperty("Toggle.LoadNews", loadnews.isSelected());
	    Main.rlo.setBooleanProperty("Toggle.QueueDownloads", queue.isSelected());
	    Main.rlo.setBooleanProperty("Toggle.JoinLeave", joinleave.isSelected());
	    Main.rlo.setBooleanProperty("Toggle.Log", log.isSelected());
	    Main.rlo.setBooleanProperty("Toggle.LiveResizing", liveResize.isSelected());
	    Main.rlo.setBooleanProperty("Toggle.ShowIcons", showIcons.isSelected());
            
        }

    }

    void setComboBoxDefault(JComboBox comboBox, String def) {

        /* FIXME: This should select the default item in the combo box. */

        DebuggerOutput.debug("FIXME");

    }
    
    JComboBox createComboBox(String[] items, String def) {

	boolean setDefault = false;
	JComboBox box = new JComboBox();
	box.setEditable(false);
	box.setLightWeightPopupEnabled(true);

	for(int i=0; i<items.length; ++i) {
            
	    box.addItem(items[i]);
            
	    if(items[i].equals(def)) {

		box.setSelectedIndex(i);
		setDefault = true;

	    }

	}

	if(!setDefault)
	    box.setSelectedIndex(0);

	return box;

    }

    JComboBox createFontComboBox(String whichFont) {

	String[] fontNames = GraphicsUtils.getAvailableFontFamilyNames();
	String defaultFontName = ((Font) Main.rlo.getProperty(whichFont)).getName();
	return createComboBox(fontNames, defaultFontName);

    }
    
}

class PathsPanel extends JPanel implements ActionListener {

    JTextField downloads, bookmarks;
    JButton browseDownloadPath, browseBookmarkPath;

    PathsPanel() {

        GridBagConstraints gbc = new GridBagConstraints();
        setLayout(new GridBagLayout());

        downloads = new JTextField();
        bookmarks = new JTextField();
        browseDownloadPath = new JButton("Browse ...");
        browseDownloadPath.setActionCommand("ActivateBrowseDownloadPath");
        browseBookmarkPath = new JButton("Browse ...");
        browseBookmarkPath.setActionCommand("ActivateBrowseBookmarkPath");

        JPanel downloadDirPanel = new JPanel();
        downloadDirPanel.setLayout(new BorderLayout());
        downloadDirPanel.add(downloads, BorderLayout.CENTER);
        downloadDirPanel.add(browseDownloadPath, BorderLayout.EAST);
        JPanel bookmarksDirPanel = new JPanel();
        bookmarksDirPanel.setLayout(new BorderLayout());
        bookmarksDirPanel.add(bookmarks, BorderLayout.CENTER);
        bookmarksDirPanel.add(browseBookmarkPath, BorderLayout.EAST);

        gbc.gridx = 1;
        gbc.gridy = 1;
        addRow(new JLabel("Downloads:"), downloadDirPanel, gbc);
        addRow(new JLabel("Bookmarks:"), bookmarksDirPanel, gbc);
        gbc.fill = gbc.BOTH;
        gbc.weightx = 1;
        gbc.weighty = 1;
        addRow(Box.createGlue(), Box.createGlue(), gbc);

        setup(Main.rlo);

        ActionListener actionListener = new ActionListener() {

                public void actionPerformed(ActionEvent e) {

                    if(e.getActionCommand().startsWith("ActivateBrowse")) {

                        String path;
                        
                        if(e.getActionCommand().endsWith("BookmarkPath")) 
                            path = bookmarks.getText();
                        else
                            path = downloads.getText();
                        
                        FileDialog fd = new FileDialog(OptionsInterface.f, 
                                                       "Select a file.", 
                                                       FileDialog.LOAD);
                        
                        fd.setDirectory(path);
                        fd.show();
            
                        if(fd.getDirectory() != null) {
                            
                            if(e.getActionCommand().endsWith("BookmarkPath")) 
                                bookmarks.setText(fd.getDirectory());
                            else
                                downloads.setText(fd.getDirectory());

                        }
                        
                    }
                    
                }

            };

        browseDownloadPath.addActionListener(actionListener);
        browseBookmarkPath.addActionListener(actionListener);

    }

    void addRow(Component l, Component v, GridBagConstraints gbc) {
        
        gbc.anchor = gbc.WEST;
        gbc.fill = gbc.NONE;
        add(l, gbc);
        gbc.gridx++;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 1;
        add(v, gbc);
        gbc.gridx = 1;
        gbc.gridy++;

    }

    void setup(Options options) {

        bookmarks.setText(Main.rlo.getProperty("Path.Bookmarks").toString());
        downloads.setText(Main.rlo.getProperty("Path.Downloads").toString());

    }

    public void actionPerformed(ActionEvent e) {
        
	if(e.getActionCommand().equals("Save")) {
            
            Main.rlo.setProperty("Path.Bookmarks", new File(bookmarks.getText()));
            Main.rlo.setProperty("Path.Downloads", new File(downloads.getText()));
            
	}

    }

}
