/**
 * $Id: MessageReceive.java,v 1.8 2001/10/04 01:03:59 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.awt.event.*;
import java.text.DateFormat;
import java.util.StringTokenizer;
import java.util.Date;
import javax.swing.*;

import redlight.utils.TextUtils;

/**
 * Small subclass for the message receive interface.
 */
public class MessageReceive extends MessageInterface {

    String quotedMessage = null;

    public MessageReceive(Machine machine,
                          User user,
                          String msg) {

	super(machine, user, true);

        msg = msg.replace('\r', '\n');

        /* Store a quoted version of the message. */

        quotedMessage = "";
        String wrapMsg = TextUtils.wordWrap(msg, 48);
        StringTokenizer st = new StringTokenizer(wrapMsg, "\n", false);

        while(st.hasMoreTokens()) 
            quotedMessage += "> " + st.nextToken() + "\n";
            
	message.setText(msg);

	f.setTitle("Message from " + user.nick + " ["+
		   DateFormat.getInstance().
		   format(new Date(System.currentTimeMillis()))+"] (" +
		   rlm.getServerName() + ")");

        machine.playAudio("receivemsg");

        f.setVisible(true);

    }

    /**
     * Following method implements ActionListener.
     */
    public void actionPerformed(ActionEvent e) {

	if(e.getActionCommand().equals("Send"))
	    new MessageTransmit(rlm, user, quotedMessage);

        closeWindow();

    }

}



