/*
 * Decompiled with CFR 0.152.
 */
package redlight.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import redlight.utils.DebuggerOutput;

public class InterruptableInputStream
extends InputStream {
    private boolean interrupted = false;
    private InputStream input;

    public InterruptableInputStream(InputStream i) {
        this.input = i;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        while (!this.interrupted) {
            try {
                return this.input.read(b, off, len);
            }
            catch (InterruptedIOException e) {
                if (!this.interrupted) continue;
                throw new IOException("interrupted");
            }
        }
        throw new IOException("interrupted");
    }

    public int read() throws IOException {
        while (!this.interrupted) {
            try {
                return this.input.read();
            }
            catch (InterruptedIOException e) {
                if (!this.interrupted) continue;
                throw new IOException("interrupted");
            }
        }
        throw new IOException("interrupted");
    }

    public void close() throws IOException {
        try {
            super.close();
            this.input.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            DebuggerOutput.debug("InterruptableInputStream.close: interrupted = true");
            this.interrupted = true;
            throw throwable;
        }
        DebuggerOutput.debug("InterruptableInputStream.close: interrupted = true");
        this.interrupted = true;
    }
}

