/*
 * Decompiled with CFR 0.152.
 */
package redlight.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import redlight.hotline.HLServer;
import redlight.hotline.HLServerTrackerTable;

public class TrackerTable
extends HLServerTrackerTable {
    File trackerTableFile;
    long lastModified;

    public TrackerTable(HLServer h, File file) {
        super(h);
        this.trackerTableFile = file;
    }

    public void hasChanged() {
        this.write();
    }

    public void checkModified() {
        if (this.trackerTableFile.lastModified() != this.lastModified) {
            this.hls.log("Tracker table " + this.trackerTableFile.toString() + " changed, reloading.");
            this.load();
        }
    }

    public void load() {
        this.load(this.trackerTableFile);
        this.lastModified = this.trackerTableFile.lastModified();
    }

    public void load(InputStream in) {
        LineNumberReader lr = null;
        Hashtable<String, HLServerTrackerTable.TrackerRecord> tempTable = new Hashtable<String, HLServerTrackerTable.TrackerRecord>();
        try {
            lr = new LineNumberReader(new InputStreamReader(in));
            String line = lr.readLine();
            while (line != null) {
                if (line != null) {
                    InetAddress ip = null;
                    String password = null;
                    if (line.indexOf(" ") == -1) {
                        ip = InetAddress.getByName(line);
                    } else {
                        ip = InetAddress.getByName(line.substring(0, line.indexOf(" ")));
                        password = line.substring(line.indexOf(" ") + 1);
                    }
                    HLServerTrackerTable.TrackerRecord t = new HLServerTrackerTable.TrackerRecord(ip, password);
                    tempTable.put(ip.getHostAddress(), t);
                }
                line = lr.readLine();
            }
        }
        catch (IOException e) {
            tempTable = null;
            String error = "Error reading trackertable " + this.trackerTableFile.toString();
            if (lr != null) {
                error = error + " at line " + lr.getLineNumber();
            }
            error = error + " (" + e.toString() + ").";
            this.hls.log(error);
        }
        if (tempTable != null) {
            this.table.clear();
            this.table = tempTable;
        }
    }

    public void write() {
        this.write(this.trackerTableFile);
    }

    public void write(OutputStream os) {
        try {
            Enumeration en = this.table.elements();
            while (en.hasMoreElements()) {
                String line = new String();
                HLServerTrackerTable.TrackerRecord t = (HLServerTrackerTable.TrackerRecord)en.nextElement();
                line = line + t.address.getHostName();
                if (t.password != null) {
                    line = line + " " + t.password;
                }
                line = line + System.getProperty("line.separator");
                os.write(line.getBytes());
            }
        }
        catch (IOException e) {
            this.hls.log("Error writing trackertable file " + this.trackerTableFile.toString() + " (" + e.toString() + ").");
        }
    }
}

