/*
 * Decompiled with CFR 0.152.
 */
package redlight.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import redlight.hotline.HLServer;
import redlight.hotline.HLServerBanTable;
import redlight.server.Main;

public class BanTable
extends HLServerBanTable {
    File banTableFile;
    long lastModified;

    public BanTable(HLServer h, File file) {
        super(h);
        this.banTableFile = file;
    }

    public void hasChanged() {
        this.write();
    }

    public void checkModified() {
        if (this.banTableFile.lastModified() != this.lastModified) {
            Main.logLine("Ban table " + this.banTableFile.toString() + " changed, reloading.");
            this.load();
        }
    }

    public void load() {
        this.load(this.banTableFile);
        this.lastModified = this.banTableFile.lastModified();
    }

    public void load(InputStream in) {
        LineNumberReader lr = null;
        Hashtable<String, HLServerBanTable.BanRecord> tempTable = new Hashtable<String, HLServerBanTable.BanRecord>();
        try {
            lr = new LineNumberReader(new InputStreamReader(in));
            String line = lr.readLine();
            while (line != null) {
                if (line != null) {
                    if (line.indexOf(" ") != -1) {
                        InetAddress ip = InetAddress.getByName(line.substring(0, line.indexOf(" ")));
                        long expires = Long.parseLong(line.substring(line.indexOf(" ") + 1));
                        HLServerBanTable.BanRecord b = new HLServerBanTable.BanRecord(ip, expires);
                        tempTable.put(ip.getHostAddress(), b);
                    } else {
                        throw new RuntimeException("missing space");
                    }
                }
                line = lr.readLine();
            }
        }
        catch (Exception e) {
            tempTable = null;
            String error = "Error reading bantable " + this.banTableFile.toString();
            if (lr != null) {
                error = error + " at line " + lr.getLineNumber();
            }
            error = error + " (" + e.toString() + ").";
            Main.logLine(error);
        }
        if (tempTable != null) {
            this.table.clear();
            this.table = tempTable;
        }
    }

    public void write() {
        this.write(this.banTableFile);
    }

    public void write(OutputStream os) {
        try {
            Enumeration en = this.table.elements();
            while (en.hasMoreElements()) {
                String line = new String();
                HLServerBanTable.BanRecord b = (HLServerBanTable.BanRecord)en.nextElement();
                line = line + b.address.getHostAddress() + " ";
                line = line + b.expires + System.getProperty("line.separator");
                os.write(line.getBytes());
            }
        }
        catch (IOException e) {
            Main.logLine("Error writing bantable file " + this.banTableFile.toString() + " (" + e.toString() + ").");
        }
    }
}

