/*
 * Decompiled with CFR 0.152.
 */
package redlight.server;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import redlight.hotline.HLServer;
import redlight.hotline.HLServerAgreement;
import redlight.server.Main;

public class Agreement
extends HLServerAgreement {
    File agreementFile;
    long lastModified;

    public Agreement(HLServer h, File file) {
        super(h);
        this.agreementFile = file;
    }

    public void checkModified() {
        if (this.agreementFile.lastModified() != this.lastModified) {
            Main.logLine("Agreement file " + this.agreementFile.toString() + " changed, reloading.");
            this.load();
        }
    }

    public void load() {
        if (this.agreementFile.exists()) {
            this.load(this.agreementFile);
            this.lastModified = this.agreementFile.lastModified();
        } else {
            this.agreement = null;
        }
    }

    public void load(InputStream in) {
        LineNumberReader lr = null;
        String n = null;
        try {
            lr = new LineNumberReader(new InputStreamReader(in));
            String line = lr.readLine();
            while (line != null) {
                if (line != null) {
                    n = n == null ? line + "\r" : n + line + "\r";
                }
                line = lr.readLine();
            }
        }
        catch (Exception e) {
            n = null;
            String error = "Error reading agreement file " + this.agreementFile.toString();
            if (lr != null) {
                error = error + " at line " + lr.getLineNumber();
            }
            error = error + " (" + e.toString() + ").";
            Main.logLine(error);
        }
        this.agreement = n;
    }
}

