/*
 * Decompiled with CFR 0.152.
 */
package redlight.rltools;

import java.io.File;
import java.io.IOException;
import redlight.hotline.HLClient;
import redlight.hotline.HLException;
import redlight.macfiles.MacFile;
import redlight.macfiles.SplitMacFile;
import redlight.rltools.RemoteFile;
import redlight.utils.DebuggerOutput;
import redlight.utils.FilenameUtils;
import redlight.utils.Meter;
import redlight.utils.MeterSource;

public class rlget {
    static boolean showProgress = false;
    static boolean verbose = false;
    static File localFile = null;
    static boolean progressShown = false;
    static Meter meter = new Meter(){
        MeterSource ms;
        String file;

        public void startMeter(MeterSource ms, int key, String s, long size) {
            this.ms = ms;
            this.file = s;
            rlget.verboseln("rlget: " + localFile + ": " + size + " bytes.");
            progressShown = false;
        }

        public void progressMeter(int key, long done) {
            if (showProgress) {
                rlget.verbose("rlget: " + localFile + ": " + done + "                     \r");
            }
            progressShown = true;
        }

        public void stopMeter(int key) {
            if (progressShown) {
                rlget.verboseln();
            }
            rlget.verboseln("rlget: " + localFile + ": transfer complete.             ");
        }

        public void stopMeterWithError(int key, Throwable t) {
            if (progressShown) {
                rlget.verboseln();
            }
            rlget.verboseln("rlget: " + localFile + ": error: " + t + "           ");
        }

        public MeterSource getMeterSource() {
            return this.ms;
        }
    };

    static void printUsage() {
        System.out.println("Usage: rlget [-v] [-p] [--debug] REMOTE... LOCAL");
        System.out.println("Examples:");
        System.out.println("rlget hotline://user%pass@hostname.net/dir/file /local/directory");
        System.out.println("rlget user@hostname.net/dir/file /local/directory");
        System.out.println("rlget hostname.net/dir/file1 hostname.net/dir/file2 /local/directory");
    }

    static RemoteFile parseArg(String arg) throws IllegalArgumentException {
        DebuggerOutput.debug("parseArg: arg = " + arg);
        RemoteFile r = new RemoteFile();
        if (arg.startsWith("hotline://")) {
            arg = arg.substring(10);
        }
        int atLoc = arg.indexOf(64);
        int pcLoc = arg.indexOf(37);
        if (atLoc != -1) {
            if (pcLoc < atLoc) {
                r.user = arg.substring(0, pcLoc);
                r.pass = arg.substring(pcLoc, atLoc);
                arg = arg.substring(atLoc);
            } else {
                r.user = arg.substring(0, atLoc);
                arg = arg.substring(atLoc);
            }
        }
        DebuggerOutput.debug("parseArg: path component = " + arg);
        int slashLoc = arg.indexOf(47);
        if (slashLoc == -1) {
            throw new IllegalArgumentException("Missing / in " + arg);
        }
        r.host = arg.substring(0, slashLoc);
        r.file = arg.substring(slashLoc);
        return r;
    }

    static RemoteFile[] parseArgs(String[] args, int offset) {
        RemoteFile[] fl = new RemoteFile[args.length - 1 - offset];
        int i = offset;
        while (i < args.length - 1) {
            fl[i - offset] = rlget.parseArg(args[i]);
            ++i;
        }
        return fl;
    }

    static int parseOptions(String[] args) {
        int offset = 0;
        int maxOptions = 3;
        int i = 0;
        while (i < maxOptions && i < args.length) {
            if (args[i].equals("--debug")) {
                DebuggerOutput.setEnabled(true);
                ++offset;
            } else if (args[i].equals("-v")) {
                verbose = true;
                ++offset;
            } else if (args[i].equals("-p")) {
                showProgress = true;
                ++offset;
            } else if (args[i].equals("--")) {
                return offset;
            }
            ++i;
        }
        return offset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws IOException, HLException, InterruptedException {
        if (args.length < 2) {
            rlget.printUsage();
            System.exit(1);
        }
        int offset = rlget.parseOptions(args);
        RemoteFile[] remoteFiles = null;
        try {
            remoteFiles = rlget.parseArgs(args, offset);
        }
        catch (IllegalArgumentException e) {
            System.out.println("rlget: illegal argument: " + e.getMessage());
            System.exit(1);
        }
        File local = new File(args[args.length - 1]);
        if (args.length > 2) {
            if (!local.isDirectory()) {
                System.out.println("rlget: When copying multiple files last argument must be a directory.");
                System.exit(1);
            }
            if (!local.exists()) {
                System.out.println("rlget: Destination directory does not exist.");
                System.exit(1);
            }
        }
        int errors = 0;
        int i = 0;
        while (true) {
            block17: {
                Object var12_13;
                if (i >= remoteFiles.length) {
                    System.exit(-errors);
                    return;
                }
                HLClient hlc = null;
                try {
                    try {
                        hlc = new HLClient(remoteFiles[i].host);
                        hlc.connect();
                        hlc.login(remoteFiles[i].user, remoteFiles[i].pass, "rlget", 100);
                        String remotePath = remoteFiles[i].file.replace('/', ':');
                        String remoteFile = remotePath.substring(remotePath.lastIndexOf(58) + 1);
                        localFile = local;
                        if (localFile.isDirectory()) {
                            localFile = new File(local, FilenameUtils.qualify(remoteFile));
                        }
                        SplitMacFile mf = new SplitMacFile(localFile, new Integer(MacFile.READ_PERM | MacFile.WRITE_PERM));
                        int id = hlc.requestFileDownload(remoteFile, mf, meter, false);
                        hlc.waitFor(id);
                    }
                    catch (Exception e) {
                        String reason = e.toString();
                        if (e.getMessage() != null) {
                            reason = e.getMessage();
                        }
                        if (progressShown) {
                            rlget.verboseln();
                        }
                        rlget.verboseln("rlget: " + localFile + ": " + reason);
                        ++errors;
                        var12_13 = null;
                        if (hlc != null) {
                            hlc.close();
                        }
                        break block17;
                    }
                    var12_13 = null;
                    if (hlc == null) break block17;
                }
                catch (Throwable throwable) {
                    var12_13 = null;
                    if (hlc != null) {
                        hlc.close();
                    }
                    throw throwable;
                }
                hlc.close();
            }
            ++i;
        }
    }

    static void verbose(String s) {
        if (verbose) {
            System.out.print(s);
        }
    }

    static void verboseln(String s) {
        if (verbose) {
            System.out.println(s);
        }
    }

    static void verboseln() {
        if (verbose) {
            System.out.println();
        }
    }
}

