/*
 * Decompiled with CFR 0.152.
 */
package redlight.macfiles;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import redlight.macfiles.Fork;
import redlight.macfiles.MacFile;
import redlight.utils.DebuggerOutput;

public class SplitFork
extends Fork {
    RandomAccessFile forkFile;
    String perms = new String();
    String id = "DATA";
    String ext = "";
    File forkFileAvatar;
    boolean isOpen = false;

    public SplitFork(MacFile parent, Integer p, String id, String ext) {
        super(parent);
        this.id = id;
        this.ext = ext;
        if ((p & MacFile.READ_PERM) == MacFile.READ_PERM) {
            this.perms = "r";
        }
        if ((p & MacFile.WRITE_PERM) == MacFile.WRITE_PERM) {
            this.perms = this.perms + "w";
        }
        this.forkFileAvatar = ext == "" ? new File(parent.getFile().toString()) : new File(parent.getFile().getParent(), "." + parent.getFile().getName() + ext);
    }

    private boolean openFork() throws IOException {
        if (this.forkFile == null) {
            try {
                this.forkFile = new RandomAccessFile(this.forkFileAvatar, this.perms);
                this.isOpen = true;
                DebuggerOutput.debug(this.toString() + ": opened (" + this.forkFileAvatar.length() + ")");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return this.isOpen;
    }

    public long size() {
        return this.forkFileAvatar.length();
    }

    public long seek(long s) throws IOException {
        if (this.openFork()) {
            this.forkFile.seek(s);
            DebuggerOutput.debug(this.toString() + ": seek to " + s + ")");
            return s;
        }
        return -1L;
    }

    public DataOutput getDataOutput() throws IOException {
        if (this.openFork()) {
            return this.forkFile;
        }
        throw new IOException("Could not open " + this.forkFileAvatar.toString());
    }

    public DataInput getDataInput() throws IOException {
        if (this.openFork()) {
            return this.forkFile;
        }
        throw new IOException("Could not open " + this.forkFileAvatar.toString());
    }

    public void close() throws IOException {
        if (this.forkFile != null) {
            this.forkFile.close();
            this.forkFile = null;
            this.isOpen = false;
            if (this.size() == 0L) {
                this.forkFileAvatar.delete();
                DebuggerOutput.debug(this.toString() + ": deleted empty fork file on close");
            }
            DebuggerOutput.debug(this.toString() + ": closed.");
        }
    }

    public boolean exists() {
        return this.size() > 0L;
    }

    public boolean delete() {
        boolean s = false;
        try {
            this.close();
            s = this.forkFileAvatar.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return s;
    }

    public boolean renameTo(File f) {
        boolean s = false;
        try {
            this.close();
            s = this.forkFileAvatar.renameTo(f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return s;
    }

    public String toString() {
        return "SplitFork[" + this.id + " fork @ " + this.forkFileAvatar.toString() + " (" + this.perms + ")]";
    }
}

