/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import redlight.hotline.HLException;

class HLTask {
    public int type;
    boolean locked = false;
    boolean disposeWhenReceived = true;
    SynchronizedContainer synchronizedContainer = new SynchronizedContainer();

    public HLTask(int type, boolean disposeWhenReceived) {
        this.type = type;
        this.disposeWhenReceived = disposeWhenReceived;
    }

    public Object getData() throws HLException, InterruptedException {
        return this.synchronizedContainer.get();
    }

    public void setData(Object data) {
        this.synchronizedContainer.put(data);
    }

    public void setError(HLException error) {
        this.synchronizedContainer.putError(error);
    }

    public String toString() {
        return "HLTask[type = 0x" + Integer.toHexString(this.type) + ", locked = " + this.locked + ", disposeWhenReceived = " + this.disposeWhenReceived + ", " + this.synchronizedContainer + "]";
    }

    public synchronized boolean isLocked() {
        return this.locked;
    }

    public synchronized void lock() {
        this.locked = true;
    }

    class SynchronizedContainer {
        boolean got = false;
        HLException error = null;
        Object data = null;

        SynchronizedContainer() {
        }

        synchronized Object get() throws HLException, InterruptedException {
            while (!this.got) {
                this.wait();
            }
            if (this.error != null) {
                throw this.error;
            }
            return this.data;
        }

        synchronized void put(Object data) {
            this.data = data;
            this.got = true;
            this.notifyAll();
        }

        synchronized void putError(HLException error) {
            this.error = error;
            this.got = true;
            this.notifyAll();
        }

        public String toString() {
            return "SynchronizedContainer[got = " + this.got + ", data = " + this.data + ", error = " + this.error + "]";
        }
    }
}

