/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import redlight.crypto.UnixCrypt;
import redlight.hotline.HLProtocol;
import redlight.hotline.HLServer;
import redlight.hotline.HLServerAccountsTable;
import redlight.hotline.HLServerPolicy;
import redlight.hotline.InvalidRealmException;
import redlight.hotline.OutOfSocketIDsException;
import redlight.hotline.TooManyTransfersException;
import redlight.macfiles.MacFile;
import redlight.utils.DebuggerOutput;
import redlight.utils.InterruptableInputStream;
import redlight.utils.TextUtils;
import redlight.utils.ToArrayConverters;

public class HLServerDispatcher
extends Thread {
    public Socket client;
    public Integer userStateLock = new Integer(1);
    public String nick = "???";
    public short icon = 0;
    public short color = 0;
    public String login = "guest";
    public String password = "guest";
    public short sock = (short)-1;
    public String homeDirectory;
    public long privileges;
    public int downloadsInProgress = 0;
    public int uploadsInProgress = 0;
    public int downloadsInQueue = 0;
    public int uploadsInQueue = 0;
    public long lastTransmissionTime = 0L;
    public long firstTransmissionTime = 0L;
    public Object policyObject;
    private long floodMarker = 0L;
    private int numberOfPacketsSinceFloodMarker = 0;
    private int trans = 0;
    private int protocolErrors = 0;
    private boolean protocolErrorOccurredDuringDispatch = false;
    private HLServer hls;
    private DataInputStream input;
    private DataOutputStream output;
    private boolean connected = false;
    private boolean disconnected = false;

    public HLServerDispatcher(HLServer s, Socket c) {
        this.hls = s;
        this.client = c;
        this.numberOfPacketsSinceFloodMarker = 0;
        this.floodMarker = 0L;
        this.policyObject = HLServerPolicy.createPolicyObject();
        this.setName("HLServerDispatcher " + c);
    }

    synchronized int nextTrans() {
        return this.trans++;
    }

    public HLProtocol.UserListComponent getUser() {
        Integer n = this.userStateLock;
        synchronized (n) {
            HLProtocol.UserListComponent userListComponent = HLServer.hlp.new HLProtocol.UserListComponent(this.sock, this.icon, this.color, this.nick);
            return userListComponent;
        }
    }

    void sendQueuePosition(int ref, int position) {
        HLProtocol.DataComponent[] dataComponentArray = new HLProtocol.DataComponent[2];
        dataComponentArray[0] = HLServer.hlp.new HLProtocol.DataComponent(107, ToArrayConverters.intToByteArray(ref));
        dataComponentArray[1] = HLServer.hlp.new HLProtocol.DataComponent(116, ToArrayConverters.intToByteArray(position));
        HLProtocol.DataComponent[] dataComponents = dataComponentArray;
        this.send(HLServer.hlp.new HLProtocol.Packet(211, this.nextTrans(), dataComponents));
    }

    void send(HLProtocol.Packet packet) {
        if (this.connected) {
            try {
                if (packet.header.id != 106 || (this.privileges & 0x2000L) == 8192L) {
                    DebuggerOutput.debug("HLServerDispatcher.send: sending packet " + packet.toString());
                    packet.write(this.output);
                }
            }
            catch (IOException e) {
                this.hls.log(this.client.getInetAddress(), "Disconnected client because of a write error: " + e.getMessage());
                this.connected = false;
            }
        }
    }

    void sendTaskReply(HLProtocol.Packet packet) {
        packet.header.cls = 1;
        this.send(packet);
    }

    void sendTaskError(int trans, String msg) {
        HLProtocol.DataComponent[] dataComponentArray = new HLProtocol.DataComponent[1];
        dataComponentArray[0] = HLServer.hlp.new HLProtocol.DataComponent(100, msg.getBytes());
        HLProtocol.DataComponent[] dataComponents = dataComponentArray;
        HLProtocol.Packet p = HLServer.hlp.new HLProtocol.Packet(65536, trans, dataComponents);
        p.header.isError = 1;
        p.header.cls = 1;
        this.send(p);
    }

    synchronized void disconnect() {
        block2: {
            DebuggerOutput.debug("HLServerDispatcher.disconnect: disconnecting ...");
            this.connected = false;
            this.disconnected = true;
            try {
                this.client.close();
            }
            catch (IOException e) {
                if (!DebuggerOutput.on) break block2;
                e.printStackTrace();
            }
        }
        DebuggerOutput.debug("HLServerDispatcher.disconnect: exiting");
    }

    synchronized void castSpells() throws IOException {
        if (!this.disconnected) {
            this.output = new DataOutputStream(new BufferedOutputStream(this.client.getOutputStream()));
            this.input = new DataInputStream(new InterruptableInputStream(this.client.getInputStream()));
            byte[] buf = new byte[12];
            this.input.readFully(buf, 0, 12);
            DebuggerOutput.debug("HLServerDispatcher.run: read client magic");
            if (!"TRTPHOTL\u0000\u0001\u0000\u0002".equals(new String(buf))) {
                this.client.close();
                this.hls.log(this.client.getInetAddress(), "Not a Hotline client: bad magic");
            } else {
                this.output.writeBytes("TRTP\u0000\u0000\u0000\u0000");
                this.output.flush();
                DebuggerOutput.debug("HLServerDispatcher.run: wrote server magic");
                this.connected = true;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void run() {
        block24: {
            block22: {
                this.lastTransmissionTime = this.firstTransmissionTime = System.currentTimeMillis();
                this.hls.log(this.client.getInetAddress(), "Accepted connection.");
                this.castSpells();
                this.protocolErrorOccurredDuringDispatch = false;
                while (this.connected) {
                    this.dispatch(HLServer.hlp.new HLProtocol.Packet(this.input));
                }
                if (this.protocolErrorOccurredDuringDispatch) break block22;
                this.protocolErrors = 0;
            }
            Object var5_1 = null;
            try {
                this.client.close();
            }
            catch (IOException _e) {
                // empty catch block
            }
            this.hls.log(this.client.getInetAddress(), "Connection closed.");
            this.hls.removeClient(this);
            {
                break block24;
                catch (EOFException e) {
                    if (this.connected) {
                        if (e.getMessage() != null) {
                            this.hls.log(this.client.getInetAddress(), "Client dropped connection: " + e.getMessage());
                        } else {
                            this.hls.log(this.client.getInetAddress(), "Client dropped connection.");
                        }
                    }
                    Object var5_2 = null;
                    try {
                        this.client.close();
                    }
                    catch (IOException _e) {
                        // empty catch block
                    }
                    this.hls.log(this.client.getInetAddress(), "Connection closed.");
                    this.hls.removeClient(this);
                    break block24;
                }
                catch (IOException e) {
                    if (this.connected) {
                        if (e.getMessage() != null) {
                            this.hls.log(this.client.getInetAddress(), "I/O error: " + e.getMessage());
                        } else {
                            this.hls.log(this.client.getInetAddress(), "Unspecified I/O error.");
                        }
                    }
                    Object var5_3 = null;
                    try {
                        this.client.close();
                    }
                    catch (IOException _e) {
                        // empty catch block
                    }
                    this.hls.log(this.client.getInetAddress(), "Connection closed.");
                    this.hls.removeClient(this);
                    break block24;
                }
                catch (Exception e) {
                    if (this.connected) {
                        e.printStackTrace();
                        if (e.getMessage() != null) {
                            this.hls.log(this.client.getInetAddress(), "Internal error: " + e.getMessage());
                        } else {
                            this.hls.log(this.client.getInetAddress(), "Unspecified internal error.");
                        }
                    }
                    Object var5_4 = null;
                    try {
                        this.client.close();
                    }
                    catch (IOException _e) {
                        // empty catch block
                    }
                    this.hls.log(this.client.getInetAddress(), "Connection closed.");
                    this.hls.removeClient(this);
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    this.client.close();
                }
                catch (IOException _e) {
                    // empty catch block
                }
                this.hls.log(this.client.getInetAddress(), "Connection closed.");
                this.hls.removeClient(this);
                throw throwable;
            }
        }
        DebuggerOutput.debug("HLServerDispatcher.run: exiting");
    }

    boolean dam() {
        ++this.numberOfPacketsSinceFloodMarker;
        if (this.numberOfPacketsSinceFloodMarker == 25) {
            DebuggerOutput.debug("floodMarker = " + this.floodMarker + ", currentTime = " + System.currentTimeMillis() + ", delta = " + (System.currentTimeMillis() - this.floodMarker));
            if (System.currentTimeMillis() - this.floodMarker < 500L) {
                this.hls.log(this.client.getInetAddress(), "Disconnecting client because of flooding.");
                this.connected = false;
                return true;
            }
            this.floodMarker = System.currentTimeMillis();
            this.numberOfPacketsSinceFloodMarker = 0;
        }
        return false;
    }

    void dispatch(HLProtocol.Packet packet) {
        String packetAllowed;
        DebuggerOutput.debug("HLServerDispatcher.dispatch: got packet " + packet.toString());
        if (this.dam()) {
            return;
        }
        this.lastTransmissionTime = System.currentTimeMillis();
        if (this.hls.hsp.isAuthenticated(this) && (this.color & 1) == 1) {
            this.hls.changeUser(this, this.sock, this.nick, this.icon, (short)(this.color & 0xFFFFFFFE));
        }
        if ((packetAllowed = this.hls.hsp.approvePacket(this, packet)) != null) {
            this.hls.log(this.client.getInetAddress(), packetAllowed);
            this.connected = false;
            return;
        }
        switch (packet.header.id) {
            case 107: {
                this.dispatchLogin(packet);
                break;
            }
            case 304: {
                this.dispatchUserChange(packet);
                break;
            }
            case 105: {
                this.dispatchChat(packet);
                break;
            }
            case 300: {
                this.dispatchUserList(packet);
                break;
            }
            case 101: {
                this.dispatchFlatnewsGet(packet);
                break;
            }
            case 103: {
                this.dispatchFlatnewsPost(packet);
                break;
            }
            case 352: {
                this.dispatchAccountRead(packet);
                break;
            }
            case 350: {
                this.dispatchAccountCreate(packet);
                break;
            }
            case 353: {
                this.dispatchAccountModify(packet);
                break;
            }
            case 351: {
                this.dispatchAccountDelete(packet);
                break;
            }
            case 108: {
                this.dispatchMessage(packet);
                break;
            }
            case 110: {
                this.dispatchUserKick(packet);
                break;
            }
            case 200: {
                this.dispatchDirectoryListing(packet);
                break;
            }
            case 202: {
                this.dispatchFileDownload(packet);
                break;
            }
            case 203: {
                this.dispatchFileUpload(packet);
                break;
            }
            case 204: {
                this.dispatchFileDelete(packet);
                break;
            }
            case 208: {
                this.dispatchFileMove(packet);
                break;
            }
            case 205: {
                this.dispatchDirectoryCreate(packet);
                break;
            }
            case 206: {
                this.dispatchFileInfoGet(packet);
                break;
            }
            case 207: {
                this.dispatchFileInfoSet(packet);
                break;
            }
            case 112: {
                this.dispatchPrivateChatCreate(packet);
                break;
            }
            case 115: {
                this.dispatchPrivateChatJoin(packet);
                break;
            }
            case 116: {
                this.dispatchPrivateChatLeave(packet);
                break;
            }
            case 114: {
                this.dispatchPrivateChatDecline(packet);
                break;
            }
            case 113: {
                this.dispatchPrivateChatInvite(packet);
                break;
            }
            case 120: {
                this.dispatchPrivateChatSubject(packet);
                break;
            }
            case 303: {
                this.dispatchUserInfoGet(packet);
                break;
            }
            default: {
                this.protocolError("Unknown header type: 0x" + Integer.toHexString(packet.header.id));
                this.sendTaskError(packet.header.trans, "This server does not support your request.");
            }
        }
        DebuggerOutput.debug("HLServerDispatcher.dispatch: dispatch finished.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void dispatchLogin(HLProtocol.Packet packet) {
        Integer n = this.userStateLock;
        // MONITORENTER : n
        block10: while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 105: {
                    if (dh.data.length <= 0) continue block10;
                    this.login = new String(HLProtocol.invert(dh.data));
                    break;
                }
                case 106: {
                    if (dh.data.length <= 0 || dh.data.length == 1 && dh.data[0] == 0) continue block10;
                    this.password = new String(HLProtocol.invert(dh.data));
                    break;
                }
                case 102: {
                    this.nick = new String(dh.data);
                    break;
                }
                case 104: {
                    this.icon = (short)ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
            }
        }
        String loginApproved = this.hls.hsp.approveLogin(this);
        if (loginApproved != null) {
            this.sendTaskError(packet.header.trans, loginApproved);
            this.hls.log(this.client.getInetAddress(), loginApproved);
            this.connected = false;
        } else {
            this.hls.log(this.client.getInetAddress(), "Authentication successful for " + this.login);
            try {
                String agreement;
                this.sock = this.hls.allocateSocketID();
                HLProtocol.DataComponent[] dataComponentArray = new HLProtocol.DataComponent[1];
                dataComponentArray[0] = HLServer.hlp.new HLProtocol.DataComponent(160, ToArrayConverters.intToByteArray(121));
                HLProtocol.DataComponent[] dataComponents = dataComponentArray;
                this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, dataComponents));
                if ((this.privileges & 0x10000000L) != 0x10000000L && (agreement = this.hls.getAgreement().get()) != null) {
                    HLProtocol.DataComponent[] dataComponentArray2 = new HLProtocol.DataComponent[1];
                    dataComponentArray2[0] = HLServer.hlp.new HLProtocol.DataComponent(101, agreement.getBytes());
                    dataComponents = dataComponentArray2;
                    this.send(HLServer.hlp.new HLProtocol.Packet(109, packet.header.trans, dataComponents));
                }
                this.setName(this.toString());
            }
            catch (OutOfSocketIDsException e) {
                this.hls.log(this.client.getInetAddress(), "Connection refused because the server is out of socket ID's (too many connected users).");
                this.connected = false;
            }
        }
        // MONITOREXIT : n
        if (!this.connected) return;
        this.hls.changeUserExcept(this, this.sock, this.nick, this.icon, this.color);
        this.hls.hsl.userJoined(this);
    }

    void dispatchChat(HLProtocol.Packet packet) {
        HLProtocol.DataComponent[] dataComponents;
        byte[] msg = null;
        short action = 0;
        Object refObject = new String("Public");
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 101: {
                    msg = dh.data;
                    break;
                }
                case 109: {
                    action = ToArrayConverters.byteArrayToShort(dh.data);
                    break;
                }
                case 114: {
                    refObject = new Integer(ToArrayConverters.byteArrayToInt(dh.data));
                }
            }
        }
        if (msg == null) {
            this.protocolError("Didn't receive content for public chat event.");
            return;
        }
        String chatAllowed = this.hls.hsp.approveChat(this, new String(msg), action != 0);
        if (chatAllowed != null) {
            this.sendTaskError(packet.header.trans, chatAllowed);
            return;
        }
        if (refObject.toString().equals("Public")) {
            dataComponents = new HLProtocol.DataComponent[1];
        } else {
            dataComponents = new HLProtocol.DataComponent[2];
            dataComponents[1] = HLServer.hlp.new HLProtocol.DataComponent(114, ToArrayConverters.intToByteArray((Integer)refObject));
        }
        dataComponents[0] = HLServer.hlp.new HLProtocol.DataComponent(101, HLServerPolicy.formatChat(this, new String(msg), action == 1).getBytes());
        try {
            this.hls.getRealmTable().broadcastPacket(refObject, HLServer.hlp.new HLProtocol.Packet(106, this.nextTrans(), dataComponents));
        }
        catch (InvalidRealmException e) {
            // empty catch block
        }
    }

    void dispatchUserChange(HLProtocol.Packet packet) {
        byte[] n = null;
        short icon = -1;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 102: {
                    n = dh.data;
                    break;
                }
                case 104: {
                    icon = ToArrayConverters.byteArrayToShort(dh.data);
                }
            }
        }
        Integer n2 = this.userStateLock;
        synchronized (n2) {
            String changeAllowed = this.hls.hsp.approveUserChange(this, HLServer.hlp.new HLProtocol.UserListComponent(this.sock, icon, this.color, new String(n)));
            if (changeAllowed != null) {
                this.hls.log(this.client.getInetAddress(), "User change not allowed: " + changeAllowed);
                HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[1];
                dataComponents[0] = HLServer.hlp.new HLProtocol.DataComponent(101, changeAllowed.getBytes());
                this.send(HLServer.hlp.new HLProtocol.Packet(104, this.trans++, dataComponents));
                return;
            }
            if (n != null && (this.privileges & 0x20000000L) == 0x20000000L) {
                this.nick = new String(n);
            }
            this.icon = icon == -1 ? (short)this.icon : icon;
        }
        this.hls.changeUser(this, this.sock, this.nick, icon, this.color);
        this.hls.hsl.userChanged(this);
    }

    void dispatchUserList(HLProtocol.Packet packet) {
        HLServerDispatcher[] clients = this.hls.getClients();
        int numberOfConnectedClients = 0;
        HLProtocol.UserListComponent[] ul = new HLProtocol.UserListComponent[clients.length];
        int i = 0;
        while (i < clients.length) {
            ul[i] = clients[i].getUser();
            if (ul[i].sock != -1) {
                ++numberOfConnectedClients;
            }
            ++i;
        }
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[numberOfConnectedClients];
        int j = 0;
        int i2 = 0;
        while (i2 < clients.length) {
            if (ul[i2].sock != -1) {
                dataComponents[j++] = ul[i2];
            }
            ++i2;
        }
        this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, dataComponents));
    }

    void dispatchFlatnewsGet(HLProtocol.Packet packet) {
        String flatnewsGetAllowed = this.hls.hsp.approveFlatnewsGet(this);
        if (flatnewsGetAllowed == null) {
            HLProtocol.DataComponent[] dataComponentArray = new HLProtocol.DataComponent[1];
            dataComponentArray[0] = HLServer.hlp.new HLProtocol.DataComponent(101, this.hls.getFlatnews().get().getBytes());
            HLProtocol.DataComponent[] dataComponents = dataComponentArray;
            this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, dataComponents));
        } else {
            this.sendTaskError(packet.header.trans, flatnewsGetAllowed);
        }
    }

    void dispatchFlatnewsPost(HLProtocol.Packet packet) {
        String newPost = null;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 101: {
                    newPost = new String(dh.data);
                }
            }
        }
        if (newPost == null) {
            this.protocolError("Didn't receive content for flat news post.");
            return;
        }
        String flatnewsPostAllowed = this.hls.hsp.approveFlatnewsPost(this, newPost);
        if (flatnewsPostAllowed == null) {
            this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, null));
            this.hls.postFlatnews(this.hls.hsp.formatFlatnewsPost(this, newPost));
            this.hls.log(this.client.getInetAddress(), "Accepted flat news post.");
        } else {
            this.hls.log(this.client.getInetAddress(), "Rejected flat news post (" + flatnewsPostAllowed + ")");
            this.sendTaskError(packet.header.trans, flatnewsPostAllowed);
        }
    }

    void dispatchAccountRead(HLProtocol.Packet packet) {
        String l = null;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 105: {
                    l = new String(dh.data);
                }
            }
        }
        if (l == null) {
            this.protocolError("Did not receive required components for account read.");
            return;
        }
        try {
            HLServerAccountsTable accountsTable = this.hls.getAccountsTable();
            accountsTable.lock();
            if (accountsTable.exists(l)) {
                String accountReadAllowed = this.hls.hsp.approveAccountRead(this, l);
                if (accountReadAllowed == null) {
                    HLProtocol.AccountInfo account = accountsTable.get(l);
                    byte[] pw = new byte[]{7};
                    HLProtocol.DataComponent[] dataComponentArray = new HLProtocol.DataComponent[4];
                    dataComponentArray[0] = HLServer.hlp.new HLProtocol.DataComponent(102, account.nick.getBytes());
                    dataComponentArray[1] = HLServer.hlp.new HLProtocol.DataComponent(105, HLProtocol.invert(account.login.getBytes()));
                    dataComponentArray[2] = HLServer.hlp.new HLProtocol.DataComponent(106, pw);
                    dataComponentArray[3] = HLServer.hlp.new HLProtocol.DataComponent(110, ToArrayConverters.swapByteArray(ToArrayConverters.longToByteArray(account.privileges)));
                    HLProtocol.DataComponent[] dataComponents = dataComponentArray;
                    this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, dataComponents));
                } else {
                    this.sendTaskError(packet.header.trans, accountReadAllowed);
                    this.hls.log(this.client.getInetAddress(), "Account read disapproved (" + accountReadAllowed + ")");
                }
            } else {
                this.sendTaskError(packet.header.trans, "Cannot read account '" + l + "' because that account does not exist.");
                this.hls.log(this.client.getInetAddress(), "Could not read account '" + l + "' because it does not exist.");
            }
            accountsTable.unlock();
        }
        catch (InterruptedException _e) {
            this.hls.log(this.client.getInetAddress(), "[internal error] Disconnecting client because of a failure to acquire the account lock.");
            this.connected = false;
        }
    }

    void dispatchAccountCreate(HLProtocol.Packet packet) {
        String l = null;
        String p = null;
        String n = null;
        long pr = 0L;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 105: {
                    l = new String(HLProtocol.invert(dh.data));
                    break;
                }
                case 106: {
                    p = new String(HLProtocol.invert(dh.data));
                    break;
                }
                case 102: {
                    n = new String(dh.data);
                    break;
                }
                case 110: {
                    pr = ToArrayConverters.byteArrayToLong(ToArrayConverters.swapByteArray(dh.data));
                }
            }
        }
        if (p == null) {
            p = "guest";
        }
        if (n == null) {
            n = l;
        }
        if (l == null) {
            this.protocolError("Did not receive required components for account creation.");
            return;
        }
        try {
            HLServerAccountsTable accountsTable = this.hls.getAccountsTable();
            accountsTable.lock();
            if (!accountsTable.exists(l)) {
                HLProtocol.AccountInfo newAccount = HLServer.hlp.new HLProtocol.AccountInfo(l, n, UnixCrypt.crypt("aa", p), pr, null);
                String accountCreateAllowed = this.hls.hsp.approveAccountCreate(this, newAccount);
                if (accountCreateAllowed == null) {
                    accountsTable.put(l, newAccount);
                    this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, null));
                } else {
                    this.sendTaskError(packet.header.trans, accountCreateAllowed);
                }
            } else {
                this.hls.log(this.client.getInetAddress(), "Could not create account '" + l + "' because it already exists.");
                if ((this.privileges & 0x800000L) == 0x800000L) {
                    this.sendTaskError(packet.header.trans, "Cannot create account '" + l + "' because that account already exists.");
                } else {
                    this.sendTaskError(packet.header.trans, "Cannot create account.");
                }
            }
            accountsTable.unlock();
        }
        catch (InterruptedException _e) {
            this.hls.log(this.client.getInetAddress(), "[internal error] Disconnecting client because of a failure to acquire the account lock.");
            this.connected = false;
        }
    }

    void dispatchAccountModify(HLProtocol.Packet packet) {
        byte[] p = null;
        String l = null;
        String n = null;
        long pr = 0L;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 105: {
                    l = new String(HLProtocol.invert(dh.data));
                    break;
                }
                case 106: {
                    p = dh.data;
                    break;
                }
                case 102: {
                    n = new String(dh.data);
                    break;
                }
                case 110: {
                    pr = ToArrayConverters.byteArrayToLong(ToArrayConverters.swapByteArray(dh.data));
                }
            }
        }
        if (p == null) {
            p = new String("guest").getBytes();
        }
        if (l == null || n == null) {
            this.protocolError("Did not receive required components for account modification.");
            return;
        }
        try {
            HLServerAccountsTable accountsTable = this.hls.getAccountsTable();
            accountsTable.lock();
            if (accountsTable.exists(l)) {
                HLProtocol.AccountInfo oldAccount = accountsTable.get(l);
                p = p.length == 1 && p[0] == 0 ? oldAccount.password.getBytes() : UnixCrypt.crypt("aa", new String(HLProtocol.invert(p))).getBytes();
                HLProtocol.AccountInfo newAccount = HLServer.hlp.new HLProtocol.AccountInfo(l, n, new String(p), pr, null);
                String accountModifyAllowed = this.hls.hsp.approveAccountModify(this, oldAccount, newAccount);
                if (accountModifyAllowed == null) {
                    accountsTable.put(l, newAccount);
                    this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, null));
                } else {
                    this.sendTaskError(packet.header.trans, accountModifyAllowed);
                }
            } else {
                this.hls.log(this.client.getInetAddress(), "Could not modify account '" + l + "' because it does not exist.");
                if ((this.privileges & 0x800000L) == 0x800000L) {
                    this.sendTaskError(packet.header.trans, "Cannot modify account '" + l + "' because that account does not exist.");
                } else {
                    this.sendTaskError(packet.header.trans, "Cannot modify account.");
                }
            }
            accountsTable.unlock();
        }
        catch (InterruptedException _e) {
            this.hls.log(this.client.getInetAddress(), "[internal error] Disconnecting client because of a failure to acquire the account lock.");
            this.connected = false;
        }
    }

    void dispatchAccountDelete(HLProtocol.Packet packet) {
        String l = null;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 105: {
                    l = new String(HLProtocol.invert(dh.data));
                }
            }
        }
        if (l == null) {
            this.protocolError("Did not receive required components for account deletion.");
            return;
        }
        try {
            HLServerAccountsTable accountsTable = this.hls.getAccountsTable();
            accountsTable.lock();
            if (accountsTable.exists(l)) {
                String accountDeleteAllowed = this.hls.hsp.approveAccountDelete(this, accountsTable.get(l));
                if (accountDeleteAllowed == null) {
                    accountsTable.remove(l);
                    this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, null));
                } else {
                    this.sendTaskError(packet.header.trans, accountDeleteAllowed);
                }
            } else {
                this.hls.log(this.client.getInetAddress(), "Could not delete account '" + l + "' because it does not exist.");
                if ((this.privileges & 0x800000L) == 0x800000L) {
                    this.sendTaskError(packet.header.trans, "Cannot delete account '" + l + "' because that account does not exist.");
                } else {
                    this.sendTaskError(packet.header.trans, "Cannot delete account.");
                }
            }
            accountsTable.unlock();
        }
        catch (InterruptedException _e) {
            this.hls.log(this.client.getInetAddress(), "[internal error] Disconnecting client because of a failure to acquire the account lock.");
            this.connected = false;
        }
    }

    void dispatchMessage(HLProtocol.Packet packet) {
        String msg = null;
        int sock = -1;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 103: {
                    sock = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 101: {
                    msg = new String(dh.data);
                }
            }
        }
        if (sock == -1 || msg == null) {
            this.protocolError("Did not receive required components for message transmit.");
            return;
        }
        String messageAllowed = this.hls.hsp.approveMessage(this, sock, msg);
        if (messageAllowed == null) {
            if (this.hls.sendPrivateMessage(this, sock, msg)) {
                this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, null));
            } else {
                this.sendTaskError(packet.header.trans, "Could not send message because the user is no longer connected to the server.");
            }
        } else {
            this.sendTaskError(packet.header.trans, messageAllowed);
        }
    }

    void dispatchUserKick(HLProtocol.Packet packet) {
        int sock = -1;
        short ban = 0;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 103: {
                    sock = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 113: {
                    ban = ToArrayConverters.byteArrayToShort(dh.data);
                }
            }
        }
        if (sock != -1) {
            String userKickAllowed = this.hls.hsp.approveUserKick(this, sock, ban == 1);
            if (userKickAllowed == null) {
                if (this.hls.kickUser(sock, ban == 1)) {
                    HLServerDispatcher[] clients = this.hls.getClients();
                    int i = 0;
                    while (i < clients.length) {
                        if (clients[i].getUser().sock == sock) {
                            this.hls.log(this.client.getInetAddress(), new String(this.getUser().nick) + " has kicked " + (ban == 1 ? "(and banned)" : "") + new String(clients[i].getUser().nick));
                            break;
                        }
                        ++i;
                    }
                    this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, null));
                } else {
                    this.sendTaskError(packet.header.trans, "Could not disconnect user.");
                }
            } else {
                this.sendTaskError(packet.header.trans, userKickAllowed);
            }
        } else {
            this.protocolError("Did not receive required components for user kick.");
        }
    }

    void dispatchDirectoryListing(HLProtocol.Packet packet) {
        String path = ":";
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 202: {
                    path = ((HLProtocol.PathComponent)dh).path;
                }
            }
        }
        String fileListAllowed = this.hls.hsp.approveDirectoryListing(this, path);
        if (fileListAllowed == null) {
            try {
                HLProtocol.DataComponent[] dataComponents = this.hls.hsp.obtainDirectoryListing(this, path);
                this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, dataComponents));
            }
            catch (IOException e) {
                DebuggerOutput.stackTrace(e);
                this.sendTaskError(packet.header.trans, e.toString());
            }
        } else {
            this.sendTaskError(packet.header.trans, fileListAllowed);
        }
    }

    void dispatchFileDownload(HLProtocol.Packet packet) {
        String path = "";
        String file = null;
        int forkOrFile = 0;
        HLProtocol.ResumeTransferComponent rflt = HLServer.hlp.new HLProtocol.ResumeTransferComponent();
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 204: {
                    forkOrFile = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 203: {
                    rflt = (HLProtocol.ResumeTransferComponent)dh;
                    break;
                }
                case 202: {
                    path = ((HLProtocol.PathComponent)dh).path;
                    break;
                }
                case 201: {
                    file = ((HLProtocol.FileComponent)dh).file;
                }
            }
        }
        if (file == null) {
            this.protocolError("Did not receive required components for file download.");
            return;
        }
        String fileDownloadAllowed = this.hls.hsp.approveFileDownload(this, path, ':' + file);
        if (fileDownloadAllowed != null) {
            this.sendTaskError(packet.header.trans, fileDownloadAllowed);
            return;
        }
        try {
            MacFile hostPath = this.hls.hsp.resolvePathOrPartial(this, path + ':' + file);
            HLServer.TransferRequest request = this.hls.getTransferQueue().createDownload(this, hostPath, rflt, forkOrFile);
            HLProtocol.FileTransferInfo fti = HLServer.hlp.new HLProtocol.FileTransferInfo(hostPath.getFile().getName(), hostPath.getType(), hostPath.getCreator(), hostPath.getComment(), hostPath.getCreationDate(), hostPath.getModificationDate(), hostPath.getFinderFlags());
            HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[request.queuePosition == 0 ? 2 : 3];
            dataComponents[0] = HLServer.hlp.new HLProtocol.DataComponent(107, ToArrayConverters.intToByteArray(request.ref));
            long dataSize = (Long)rflt.chunks.get("DATA");
            long rsrcSize = (Long)rflt.chunks.get("MACR");
            long dataRemaining = request.local.getDataFork().size() - dataSize;
            long rsrcRemaining = request.local.getResourceFork().size() - rsrcSize;
            if (dataRemaining < 0L || rsrcRemaining < 0L) {
                String error = "Attempt to resume beyond end of file (dataRemain = " + dataRemaining + ", rsrcRemain = " + rsrcRemaining + ")";
                DebuggerOutput.debug("HLServerDispatcher.dispatchFileDownload: " + error);
                this.sendTaskError(packet.header.trans, error);
                this.hls.getTransferQueue().destroy(request.ref);
                return;
            }
            dataComponents[1] = HLServer.hlp.new HLProtocol.DataComponent(108, ToArrayConverters.intToByteArray(forkOrFile == 2 ? (int)hostPath.getDataFork().size() : (int)(dataRemaining + rsrcRemaining + (long)fti.data.length)));
            if (request.queuePosition > 0) {
                dataComponents[2] = HLServer.hlp.new HLProtocol.DataComponent(116, ToArrayConverters.intToByteArray(request.queuePosition));
            }
            this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, dataComponents));
        }
        catch (IOException e) {
            DebuggerOutput.stackTrace(e);
            this.sendTaskError(packet.header.trans, e.toString());
        }
        catch (TooManyTransfersException e) {
            this.sendTaskError(packet.header.trans, e.getMessage());
        }
    }

    void dispatchFileUpload(HLProtocol.Packet packet) {
        String path = "";
        String file = null;
        boolean resume = false;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 204: {
                    resume = ToArrayConverters.byteArrayToShort(dh.data) == 1;
                    break;
                }
                case 202: {
                    path = ((HLProtocol.PathComponent)dh).path;
                    break;
                }
                case 201: {
                    file = ((HLProtocol.FileComponent)dh).file;
                }
            }
        }
        if (file == null) {
            this.protocolError("Did not receive required components for file upload.");
            return;
        }
        String fileUploadAllowed = this.hls.hsp.approveFileUpload(this, path, ':' + file, resume);
        if (fileUploadAllowed != null) {
            this.sendTaskError(packet.header.trans, fileUploadAllowed);
            return;
        }
        try {
            MacFile hostPath = this.hls.hsp.resolvePath(this, path + ':' + file + ".hpf", true);
            HLServer.TransferRequest request = this.hls.getTransferQueue().createUpload(this, hostPath);
            HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[resume ? 2 : 1];
            dataComponents[0] = HLServer.hlp.new HLProtocol.DataComponent(107, ToArrayConverters.intToByteArray(request.ref));
            if (resume) {
                dataComponents[1] = HLServer.hlp.new HLProtocol.ResumeTransferComponent(hostPath.getDataFork().size(), hostPath.getResourceFork().size());
            }
            this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, dataComponents));
        }
        catch (IOException e) {
            if (DebuggerOutput.on) {
                e.printStackTrace();
            }
            this.sendTaskError(packet.header.trans, e.toString());
        }
        catch (TooManyTransfersException e) {
            this.sendTaskError(packet.header.trans, e.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void dispatchFileDelete(HLProtocol.Packet packet) {
        MacFile hostPath;
        block17: {
            String path = "";
            String file = null;
            while (packet.hasMoreComponents()) {
                HLProtocol.DataComponent dh = packet.nextComponent();
                if (dh.data == null) continue;
                switch (dh.type) {
                    case 202: {
                        path = ((HLProtocol.PathComponent)dh).path;
                        break;
                    }
                    case 201: {
                        file = ((HLProtocol.FileComponent)dh).file;
                    }
                }
            }
            if (file == null) {
                this.protocolError("Did not receive required components for file delete.");
                return;
            }
            String fileDeleteAllowed = this.hls.hsp.approveFileDelete(this, path, file);
            if (fileDeleteAllowed != null) {
                this.sendTaskError(packet.header.trans, fileDeleteAllowed);
                return;
            }
            hostPath = null;
            hostPath = this.hls.hsp.resolvePathOrPartial(this, path + ':' + file);
            if (hostPath.renameTo(new File(this.hls.getTrashDirectory(), file))) {
                this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, null));
                break block17;
            }
            this.sendTaskError(packet.header.trans, "Could not delete the file or directory. Perhaps the trash is full or there is a file or directory in the way.");
        }
        Object var8_6 = null;
        if (hostPath == null) return;
        try {
            hostPath.close();
            return;
        }
        catch (IOException e2) {
            DebuggerOutput.stackTrace(e2);
        }
        return;
        {
            catch (IOException e) {
                if (DebuggerOutput.on) {
                    e.printStackTrace();
                }
                this.sendTaskError(packet.header.trans, e.toString());
                Object var8_7 = null;
                if (hostPath == null) return;
                try {
                    hostPath.close();
                    return;
                }
                catch (IOException e2) {
                    DebuggerOutput.stackTrace(e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (hostPath == null) throw throwable;
            try {
                hostPath.close();
                throw throwable;
            }
            catch (IOException e2) {
                DebuggerOutput.stackTrace(e2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    void dispatchFileMove(HLProtocol.Packet packet) {
        block31: {
            IOException e222;
            MacFile targetFile;
            MacFile sourceFile;
            block29: {
                block28: {
                    String source = null;
                    String target = null;
                    String file = null;
                    while (packet.hasMoreComponents()) {
                        HLProtocol.DataComponent dh = packet.nextComponent();
                        if (dh.data == null) continue;
                        switch (dh.type) {
                            case 201: {
                                file = new String(dh.data);
                                break;
                            }
                            case 202: {
                                source = ((HLProtocol.PathComponent)dh).path;
                                break;
                            }
                            case 212: {
                                target = ((HLProtocol.PathComponent)dh).path;
                            }
                        }
                    }
                    if (source == null) {
                        source = "";
                    }
                    if (file == null || target == null) {
                        this.protocolError("Did not receive required components for file move.");
                        return;
                    }
                    String fileMoveAllowed = this.hls.hsp.approveFileMove(this, source + ':' + file, target);
                    if (fileMoveAllowed != null) {
                        this.sendTaskError(packet.header.trans, fileMoveAllowed);
                        return;
                    }
                    sourceFile = null;
                    targetFile = null;
                    sourceFile = this.hls.hsp.resolvePathOrPartial(this, source + ':' + file);
                    targetFile = this.hls.hsp.resolvePathOrPartial(this, target);
                    DebuggerOutput.debug("HLServerDispatcher.dispatchFileMove: sourceFile = " + sourceFile);
                    DebuggerOutput.debug("HLServerDispatcher.dispatchFileMove: targetFile = " + targetFile);
                    if (sourceFile.renameTo(new File(targetFile.getFile(), file))) {
                        this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, null));
                        break block28;
                    }
                    this.sendTaskError(packet.header.trans, "Could not move the file or directory. Perhaps there is a file or directory in the way.");
                }
                Object var10_8 = null;
                if (sourceFile == null) break block29;
                try {
                    sourceFile.close();
                }
                catch (IOException e222) {
                    DebuggerOutput.stackTrace(e222);
                }
            }
            if (targetFile != null) {
                try {
                    targetFile.close();
                }
                catch (IOException e222) {
                    DebuggerOutput.stackTrace(e222);
                }
            }
            break block31;
            {
                catch (IOException e3) {
                    IOException e222;
                    if (DebuggerOutput.on) {
                        e3.printStackTrace();
                    }
                    this.sendTaskError(packet.header.trans, e3.toString());
                    Object var10_9 = null;
                    if (sourceFile != null) {
                        try {
                            sourceFile.close();
                        }
                        catch (IOException e222) {
                            DebuggerOutput.stackTrace(e222);
                        }
                    }
                    if (targetFile != null) {
                        try {
                            targetFile.close();
                        }
                        catch (IOException e222) {
                            DebuggerOutput.stackTrace(e222);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e222;
                Object var10_10 = null;
                if (sourceFile != null) {
                    try {
                        sourceFile.close();
                    }
                    catch (IOException e222) {
                        DebuggerOutput.stackTrace(e222);
                    }
                }
                if (targetFile != null) {
                    try {
                        targetFile.close();
                    }
                    catch (IOException e222) {
                        DebuggerOutput.stackTrace(e222);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void dispatchDirectoryCreate(HLProtocol.Packet packet) {
        MacFile hostPath;
        block17: {
            String path = "";
            String file = null;
            while (packet.hasMoreComponents()) {
                HLProtocol.DataComponent dh = packet.nextComponent();
                if (dh.data == null) continue;
                switch (dh.type) {
                    case 202: {
                        path = ((HLProtocol.PathComponent)dh).path;
                        break;
                    }
                    case 201: {
                        file = ((HLProtocol.FileComponent)dh).file;
                    }
                }
            }
            if (file == null) {
                this.protocolError("Did not receive required components for directory create.");
                return;
            }
            String dirCreateAllowed = this.hls.hsp.approveDirectoryCreate(this, path, file);
            if (dirCreateAllowed != null) {
                this.sendTaskError(packet.header.trans, dirCreateAllowed);
                return;
            }
            hostPath = null;
            hostPath = this.hls.hsp.resolvePath(this, path + ':' + file, true);
            File newPath = hostPath.getFile();
            if (newPath.mkdir()) {
                this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, null));
                break block17;
            }
            this.sendTaskError(packet.header.trans, "Could not create directory.");
        }
        Object var8_8 = null;
        if (hostPath == null) return;
        try {
            hostPath.close();
            return;
        }
        catch (IOException e2) {
            if (!DebuggerOutput.on) return;
            e2.printStackTrace();
        }
        return;
        {
            catch (IOException e) {
                if (DebuggerOutput.on) {
                    e.printStackTrace();
                }
                this.sendTaskError(packet.header.trans, e.toString());
                Object var8_9 = null;
                if (hostPath == null) return;
                try {
                    hostPath.close();
                    return;
                }
                catch (IOException e2) {
                    if (!DebuggerOutput.on) return;
                    e2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (hostPath == null) throw throwable;
            try {
                hostPath.close();
                throw throwable;
            }
            catch (IOException e2) {
                if (!DebuggerOutput.on) throw throwable;
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    void dispatchFileInfoGet(HLProtocol.Packet packet) {
        String path = "";
        String file = null;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 202: {
                    path = ((HLProtocol.PathComponent)dh).path;
                    break;
                }
                case 201: {
                    file = ((HLProtocol.FileComponent)dh).file;
                }
            }
        }
        if (file == null) {
            this.protocolError("Did not receive required components for file get info.");
            return;
        }
        String fileGetInfoAllowed = this.hls.hsp.approveFileGetInfo(this, path, file);
        if (fileGetInfoAllowed != null) {
            this.sendTaskError(packet.header.trans, fileGetInfoAllowed);
            return;
        }
        try {
            HLProtocol.FileInfo fileInfo = this.hls.hsp.obtainFileInfo(this, path, file);
            HLProtocol.DataComponent[] dataComponentArray = new HLProtocol.DataComponent[8];
            dataComponentArray[0] = HLServer.hlp.new HLProtocol.DataComponent(201, fileInfo.name.getBytes());
            dataComponentArray[1] = HLServer.hlp.new HLProtocol.DataComponent(210, fileInfo.comment.getBytes());
            dataComponentArray[2] = HLServer.hlp.new HLProtocol.DataComponent(207, ToArrayConverters.intToByteArray((int)fileInfo.size));
            dataComponentArray[3] = HLServer.hlp.new HLProtocol.DataComponent(205, fileInfo.type.getBytes());
            dataComponentArray[4] = HLServer.hlp.new HLProtocol.DataComponent(206, fileInfo.creator.getBytes());
            dataComponentArray[5] = HLServer.hlp.new HLProtocol.DataComponent(213, fileInfo.icon.getBytes());
            dataComponentArray[6] = HLServer.hlp.new HLProtocol.DateComponent(208, fileInfo.created);
            dataComponentArray[7] = HLServer.hlp.new HLProtocol.DateComponent(209, fileInfo.modified);
            HLProtocol.DataComponent[] dataComponents = dataComponentArray;
            this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, dataComponents));
        }
        catch (IOException e) {
            if (DebuggerOutput.on) {
                e.printStackTrace();
            }
            this.sendTaskError(packet.header.trans, e.toString());
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void dispatchFileInfoSet(HLProtocol.Packet packet) {
        String path = "";
        String file = null;
        String newName = null;
        String newComment = null;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 202: {
                    path = ((HLProtocol.PathComponent)dh).path;
                    break;
                }
                case 201: {
                    file = ((HLProtocol.FileComponent)dh).file;
                    break;
                }
                case 211: {
                    newName = new String(dh.data);
                    break;
                }
                case 210: {
                    newComment = new String(dh.data);
                }
            }
        }
        if (file == null || newName == null && newComment == null) {
            this.protocolError("Did not receive required components for file set info.");
            return;
        }
        String fileSetInfoAllowed = this.hls.hsp.approveFileSetInfo(this, path, file, newName, newComment);
        if (fileSetInfoAllowed != null) {
            this.sendTaskError(packet.header.trans, fileSetInfoAllowed);
            return;
        }
        MacFile hostPath = null;
        hostPath = this.hls.hsp.resolvePathOrPartial(this, path + ':' + file);
        if (newName != null && !hostPath.renameTo(new File(hostPath.getFile().getParent(), newName))) {
            throw new IOException("Could not rename " + file + ". Perhaps a problem with symbolic links.");
        }
        if (newComment != null) {
            hostPath.writeHeader(hostPath.getFile().getName(), hostPath.getType(), hostPath.getCreator(), newComment, hostPath.getCreationDate(), hostPath.getModificationDate(), hostPath.getFinderFlags());
        }
        this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, null));
        Object var10_8 = null;
        if (hostPath == null) return;
        try {
            hostPath.close();
            return;
        }
        catch (IOException e2) {
            if (!DebuggerOutput.on) return;
            e2.printStackTrace();
        }
        return;
        {
            catch (IOException e) {
                if (DebuggerOutput.on) {
                    e.printStackTrace();
                }
                this.sendTaskError(packet.header.trans, e.toString());
                Object var10_9 = null;
                if (hostPath == null) return;
                try {
                    hostPath.close();
                    return;
                }
                catch (IOException e2) {
                    if (!DebuggerOutput.on) return;
                    e2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (hostPath == null) throw throwable;
            try {
                hostPath.close();
                throw throwable;
            }
            catch (IOException e2) {
                if (!DebuggerOutput.on) throw throwable;
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    void dispatchPrivateChatCreate(HLProtocol.Packet packet) {
        short sock = -1;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 103: {
                    sock = ToArrayConverters.byteArrayToInt(dh.data);
                }
            }
        }
        if (sock == -1) {
            this.protocolError("Did not receive required components for private chat create.");
            return;
        }
        HLServerDispatcher client = this.hls.resolveSocketID(sock);
        if (client == null) {
            this.sendTaskError(packet.header.trans, "Could not create private chat because your party is no longer connected to the server.");
            return;
        }
        String privChatCreateAllowed = this.hls.hsp.approvePrivateChatCreate(this, sock);
        if (privChatCreateAllowed != null) {
            this.sendTaskError(packet.header.trans, privChatCreateAllowed);
            return;
        }
        Integer refObject = (Integer)this.hls.getRealmTable().createRealm(this.sock);
        HLProtocol.DataComponent[] dataComponents = null;
        Integer n = this.userStateLock;
        synchronized (n) {
            HLProtocol.DataComponent[] dataComponentArray = new HLProtocol.DataComponent[5];
            dataComponentArray[0] = HLServer.hlp.new HLProtocol.DataComponent(114, ToArrayConverters.intToByteArray(refObject));
            dataComponentArray[1] = HLServer.hlp.new HLProtocol.DataComponent(104, ToArrayConverters.intToByteArray(this.icon));
            dataComponentArray[2] = HLServer.hlp.new HLProtocol.DataComponent(102, this.nick.getBytes());
            dataComponentArray[3] = HLServer.hlp.new HLProtocol.DataComponent(112, ToArrayConverters.intToByteArray(this.color));
            dataComponentArray[4] = HLServer.hlp.new HLProtocol.DataComponent(103, ToArrayConverters.intToByteArray(this.sock));
            dataComponents = dataComponentArray;
        }
        this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, dataComponents));
        if (this.sock != sock) {
            HLProtocol.DataComponent[] dataComponentArray = new HLProtocol.DataComponent[3];
            dataComponentArray[0] = HLServer.hlp.new HLProtocol.DataComponent(114, ToArrayConverters.intToByteArray(refObject));
            dataComponentArray[1] = HLServer.hlp.new HLProtocol.DataComponent(103, ToArrayConverters.intToByteArray(this.sock));
            dataComponentArray[2] = HLServer.hlp.new HLProtocol.DataComponent(102, this.nick.getBytes());
            dataComponents = dataComponentArray;
            client.send(HLServer.hlp.new HLProtocol.Packet(113, 0, dataComponents));
        }
    }

    void dispatchPrivateChatJoin(HLProtocol.Packet packet) {
        Integer refObject = null;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 114: {
                    refObject = new Integer(ToArrayConverters.byteArrayToInt(dh.data));
                }
            }
        }
        if (refObject == null) {
            this.protocolError("Did not receive required components for private chat join.");
            return;
        }
        Integer n = this.userStateLock;
        synchronized (n) {
            if (!this.hls.getRealmTable().addUser(refObject, this.sock)) {
                this.sendTaskError(packet.header.trans, "Cannot join that private chat because it has already been closed.");
                return;
            }
        }
        String privChatJoinAllowed = this.hls.hsp.approvePrivateChatJoin(this, refObject);
        if (privChatJoinAllowed != null) {
            this.sendTaskError(packet.header.trans, privChatJoinAllowed);
            return;
        }
        try {
            HLProtocol.DataComponent[] dataComponents = this.hls.getRealmTable().getUsers(refObject);
            this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, dataComponents));
            this.hls.changeUser(this, this.sock, this.nick, this.icon, this.color, refObject, 117, -1);
        }
        catch (InvalidRealmException e) {
            // empty catch block
        }
    }

    void dispatchPrivateChatLeave(HLProtocol.Packet packet) {
        Integer refObject = null;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 114: {
                    refObject = new Integer(ToArrayConverters.byteArrayToInt(dh.data));
                }
            }
        }
        if (refObject == null) {
            this.protocolError("Did not receive required components for private chat leave.");
            return;
        }
        Integer n = this.userStateLock;
        synchronized (n) {
            if (!this.hls.getRealmTable().removeUser(refObject, this.sock)) {
                this.sendTaskError(packet.header.trans, "Cannot leave private chat that does not exist (anymore).");
                return;
            }
        }
    }

    void dispatchPrivateChatDecline(HLProtocol.Packet packet) {
        Integer refObject = null;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 114: {
                    refObject = new Integer(ToArrayConverters.byteArrayToInt(dh.data));
                }
            }
        }
        if (refObject == null) {
            this.protocolError("Did not receive required components for private chat decline.");
            return;
        }
        try {
            HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[2];
            Integer n = this.userStateLock;
            synchronized (n) {
                dataComponents[0] = HLServer.hlp.new HLProtocol.DataComponent(101, new String("<<< " + this.nick + " declined invitation to chat >>>").getBytes());
            }
            dataComponents[1] = HLServer.hlp.new HLProtocol.DataComponent(114, ToArrayConverters.intToByteArray(refObject));
            this.hls.getRealmTable().broadcastPacket(refObject, HLServer.hlp.new HLProtocol.Packet(106, this.nextTrans(), dataComponents));
        }
        catch (InvalidRealmException e) {
            this.sendTaskError(packet.header.trans, "Cannot decline private chat that does not exist (anymore).");
        }
    }

    void dispatchPrivateChatInvite(HLProtocol.Packet packet) {
        short sock = -1;
        Integer refObject = null;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 103: {
                    sock = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 114: {
                    refObject = new Integer(ToArrayConverters.byteArrayToInt(dh.data));
                }
            }
        }
        if (sock == -1 || refObject == null) {
            this.protocolError("Did not receive required components for private chat invite.");
            return;
        }
        HLServerDispatcher client = this.hls.resolveSocketID(sock);
        if (client == null) {
            this.sendTaskError(packet.header.trans, "Could not invite user because your party is no longer connected to the server.");
            return;
        }
        String privChatInviteAllowed = this.hls.hsp.approvePrivateChatInvite(this, refObject, sock);
        if (privChatInviteAllowed != null) {
            this.sendTaskError(packet.header.trans, privChatInviteAllowed);
            return;
        }
        HLProtocol.DataComponent[] dataComponents = null;
        if (this.sock != sock) {
            HLProtocol.DataComponent[] dataComponentArray = new HLProtocol.DataComponent[3];
            dataComponentArray[0] = HLServer.hlp.new HLProtocol.DataComponent(114, ToArrayConverters.intToByteArray(refObject));
            dataComponentArray[1] = HLServer.hlp.new HLProtocol.DataComponent(103, ToArrayConverters.intToByteArray(this.sock));
            dataComponentArray[2] = HLServer.hlp.new HLProtocol.DataComponent(102, this.nick.getBytes());
            dataComponents = dataComponentArray;
            client.send(HLServer.hlp.new HLProtocol.Packet(113, 0, dataComponents));
        }
    }

    void dispatchPrivateChatSubject(HLProtocol.Packet packet) {
        String subject = null;
        Integer refObject = null;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 115: {
                    subject = new String(dh.data);
                    break;
                }
                case 114: {
                    refObject = new Integer(ToArrayConverters.byteArrayToInt(dh.data));
                }
            }
        }
        if (subject == null || refObject == null) {
            this.protocolError("Did not receive required components for private chat subject.");
            return;
        }
        String privChatSubjectAllowed = this.hls.hsp.approvePrivateChatSubject(this, refObject, subject);
        if (privChatSubjectAllowed != null) {
            this.sendTaskError(packet.header.trans, privChatSubjectAllowed);
            return;
        }
        try {
            HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[2];
            dataComponents[0] = HLServer.hlp.new HLProtocol.DataComponent(114, ToArrayConverters.intToByteArray(refObject));
            dataComponents[1] = HLServer.hlp.new HLProtocol.DataComponent(115, subject.getBytes());
            this.hls.getRealmTable().broadcastPacket(refObject, HLServer.hlp.new HLProtocol.Packet(119, this.nextTrans(), dataComponents));
        }
        catch (InvalidRealmException e) {
            this.sendTaskError(packet.header.trans, "Cannot set chat subject on that chat because it does not exist (anymore).");
        }
    }

    void dispatchUserInfoGet(HLProtocol.Packet packet) {
        int sock = -1;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 103: {
                    sock = ToArrayConverters.byteArrayToInt(dh.data);
                }
            }
        }
        if (sock == -1) {
            this.protocolError("Did not receive required components for user get info.");
            return;
        }
        String userInfoGetAllowed = this.hls.hsp.approveUserGetInfo(this, sock);
        if (userInfoGetAllowed == null) {
            String userInfo = this.hls.getUserInfo(sock);
            if (userInfo != null) {
                HLProtocol.DataComponent[] dataComponentArray = new HLProtocol.DataComponent[1];
                dataComponentArray[0] = HLServer.hlp.new HLProtocol.DataComponent(101, TextUtils.findAndReplace(userInfo, System.getProperty("line.separator"), "\r").getBytes());
                HLProtocol.DataComponent[] dataComponents = dataComponentArray;
                this.sendTaskReply(HLServer.hlp.new HLProtocol.Packet(65536, packet.header.trans, dataComponents));
            } else {
                this.sendTaskError(packet.header.trans, "Could not get info because the user is no longer connected to the server.");
            }
        } else {
            this.sendTaskError(packet.header.trans, userInfoGetAllowed);
        }
    }

    void protocolError(String err) {
        this.hls.log(this.client.getInetAddress(), "[protocol error] " + err);
        ++this.protocolErrors;
        this.protocolErrorOccurredDuringDispatch = true;
        if (this.protocolErrors > this.hls.getMaximumProtocolErrors()) {
            this.hls.log(this.client.getInetAddress(), "Disconnecting client because too many consecutive protocol errors occurred (" + this.protocolErrors + ").");
            this.connected = false;
        }
    }

    public String toString() {
        return "HLServerDispatcher[address: " + this.client.getInetAddress() + ", login: " + this.login + ", privs: " + this.privileges + ", home: " + this.homeDirectory + ", " + this.getUser() + "]";
    }
}

