/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.util.Enumeration;
import java.util.Hashtable;
import redlight.hotline.HLProtocol;
import redlight.hotline.HLServer;
import redlight.hotline.HLServerComponent;

public class HLServerAccountsTable
extends HLServerComponent {
    boolean accountLock = false;
    protected Hashtable table = new Hashtable();

    public HLServerAccountsTable(HLServer h) {
        super(h);
    }

    public boolean exists(String login) {
        this.checkModified();
        return this.table.containsKey(login);
    }

    public HLProtocol.AccountInfo get(String login) {
        return (HLProtocol.AccountInfo)this.table.get(login);
    }

    public void put(String login, HLProtocol.AccountInfo newAccount) {
        this.table.put(login, newAccount);
        this.hasChanged();
    }

    public void remove(String login) {
        this.table.remove(login);
        this.hasChanged();
    }

    public HLProtocol.AccountInfo[] list() {
        this.checkModified();
        HLProtocol.AccountInfo[] list = new HLProtocol.AccountInfo[this.table.size()];
        Enumeration en = this.table.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            list[i] = (HLProtocol.AccountInfo)en.nextElement();
            ++i;
        }
        return list;
    }

    public synchronized void lock() throws InterruptedException {
        while (this.accountLock) {
            this.wait();
        }
        this.accountLock = true;
    }

    public synchronized void unlock() {
        if (!this.accountLock) {
            throw new RuntimeException("attempt to unlock accounts, but they were never locked");
        }
        this.accountLock = false;
        this.notify();
    }

    public void hasChanged() {
    }

    public void checkModified() {
    }
}

