/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import redlight.client.ChatWindow;
import redlight.client.Child;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.MessageTransmit;
import redlight.client.OptionCellRenderer;
import redlight.client.OptionCheckBox;
import redlight.client.StateObject;
import redlight.client.User;
import redlight.client.UserCellRenderer;
import redlight.client.UserMenuItem;
import redlight.hotline.HLProtocol;
import redlight.script.ScriptBroker;
import redlight.script.ScriptObject;
import redlight.script.ScriptResult;
import redlight.script.Scriptable;
import redlight.script.UnknownMessageException;
import redlight.utils.DebuggerOutput;

public class PrivChatInterface
extends ChatWindow
implements ActionListener,
MouseListener,
WindowListener,
Scriptable,
Child {
    Machine rlm;
    Container contentPane;
    JComboBox options;
    JTextField input;
    JList list;
    JPopupMenu invitePopup;
    JMenuItem[] inviteMenuItems;
    JSplitPane topPart;
    JFrame f;
    OptionCheckBox joinLeaveOption;
    OptionCheckBox logOption;
    DefaultListModel listModel;
    String nick;
    Hashtable users;
    Hashtable indices;
    Font guiFont;
    static int x = 0;
    static int y = 0;
    static Integer lock = new Integer(0);
    int sock = 0;
    int pcref = 0;
    int color = 0;
    int icon = 0;
    int joinID;

    public PrivChatInterface(Machine machine, int ref, int s, String n, int i, int c) {
        this(machine, ref, s, n, -1);
    }

    public PrivChatInterface(Machine machine, int ref, int s, String n, int jid) {
        this.rlm = machine;
        this.pcref = ref;
        this.sock = s;
        this.nick = n;
        this.joinID = jid;
        this.users = new Hashtable();
        this.indices = new Hashtable();
        this.guiFont = (Font)Main.rlo.getProperty("Font.gui");
        this.f = new JFrame("Private chat (" + this.rlm.getServerName() + ")");
        this.contentPane = this.f.getContentPane();
        this.invitePopup = new JPopupMenu();
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagConstraints gbc2 = new GridBagConstraints();
        JMenuItem x = new JMenuItem("Invite:");
        this.chat = new JTextArea("", 10, 45);
        this.input = new JTextField();
        DebuggerOutput.debug("PrivChatInterface: getting user list model");
        this.listModel = this.rlm.getUserListModel(new Integer(this.pcref));
        DebuggerOutput.debug("PrivChatInterface: got user list model " + this.listModel);
        this.list = new JList(this.listModel);
        DebuggerOutput.debug("PrivChatInterface: created new list");
        this.joinLeaveOption = new OptionCheckBox("Show join/leave", Main.rlo.getBooleanProperty("Toggle.JoinLeave"));
        this.logOption = new OptionCheckBox("Log", Main.rlo.getBooleanProperty("Toggle.Log"));
        this.options = new JComboBox<Object>(new Object[]{"Options...", this.joinLeaveOption, this.logOption});
        JPanel optionPane = new JPanel();
        JPanel bottomPart = new JPanel();
        this.topPart = new JSplitPane(1, Main.rlo.getBooleanProperty("Toggle.LiveResizing"), new JScrollPane(this.chat), new JScrollPane(this.list));
        EmptyBorder emptyBorder = new EmptyBorder((Insets)Main.rlo.getProperty("BorderInsets"));
        TitledBorder lineBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Private chat");
        CompoundBorder chatBorder = BorderFactory.createCompoundBorder(lineBorder, emptyBorder);
        JPanel borderPanel = new JPanel();
        bottomPart.setLayout(new GridBagLayout());
        optionPane.setLayout(new GridBagLayout());
        borderPanel.setLayout(new BorderLayout());
        this.joinLeaveOption.setFont(this.guiFont);
        this.logOption.setFont(this.guiFont);
        this.options.setFont(this.guiFont);
        x.setEnabled(false);
        x.setFont(this.guiFont);
        this.chat.setLineWrap(true);
        this.chat.setWrapStyleWord(true);
        this.chat.setFont((Font)Main.rlo.getProperty("Font.text"));
        this.chat.setEditable(false);
        this.input.setFont((Font)Main.rlo.getProperty("Font.text"));
        this.input.requestFocus();
        this.list.setToolTipText("Invite users by right-clicking (or control-clicking)");
        this.list.setCellRenderer(new UserCellRenderer((Font)Main.rlo.getProperty("Font.list")));
        this.list.setFont((Font)Main.rlo.getProperty("Font.list"));
        this.options.setSelectedIndex(0);
        this.options.setMaximumRowCount(5);
        this.options.setRenderer(new OptionCellRenderer());
        this.input.addActionListener(this);
        this.list.addMouseListener(this);
        this.options.addActionListener(this);
        this.f.addWindowListener(this);
        this.joinLeaveOption.addActionListener(this);
        this.logOption.addActionListener(this);
        this.invitePopup.add(x);
        borderPanel.add((Component)this.topPart, "Center");
        gbc2.anchor = 13;
        gbc2.insets = (Insets)Main.rlo.getProperty("BorderInsets");
        optionPane.add((Component)this.options, gbc2);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 1;
        gbc.ipady = 2;
        gbc.ipadx = 2;
        bottomPart.add((Component)this.input, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        bottomPart.add((Component)optionPane, gbc);
        borderPanel.add((Component)bottomPart, "South");
        borderPanel.setBorder(BorderFactory.createCompoundBorder(emptyBorder, chatBorder));
        this.contentPane.add(borderPanel);
        this.setElementColors();
        this.f.pack();
        this.topPart.setDividerLocation(this.input.getWidth());
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = this.f.getSize();
        this.f.setLocation(d.width / 2 - w.width / 2, d.height / 2 - w.height / 2);
        this.f.setVisible(true);
        DebuggerOutput.debug("PrivChatInterface: registering as child ...");
        this.rlm.getInterface().registerChild(this);
        DebuggerOutput.debug("PrivChatInterface: registered as child");
        this.rlm.getHLC().addHLClientListener(this);
        DebuggerOutput.debug("PrivChatInterface: registered as event listener");
        this.rlm.registerChat(new Integer(this.pcref), this);
        DebuggerOutput.debug("PrivChatInterface: registered as chat");
        this.rlm.getScriptBroker().addTarget(this);
        DebuggerOutput.debug("PrivChatInterface: registered as script target");
        DebuggerOutput.debug("PrivChatInterface: created");
    }

    void setElementColors() {
        this.input.setBackground(this.rlm.getSchemeColor("background"));
        this.input.setForeground(this.rlm.getSchemeColor("foreground"));
        this.chat.setBackground(this.rlm.getSchemeColor("background"));
        this.chat.setForeground(this.rlm.getSchemeColor("foreground"));
        this.list.setBackground(this.rlm.getSchemeColor("background"));
        this.list.setForeground(this.rlm.getSchemeColor("foreground"));
    }

    ScriptResult processStateChange(StateObject state) {
        Integer domain = new Integer(this.pcref);
        if (state.domain.equals(domain)) {
            switch (state.what) {
                case 1: {
                    this.logOption.setSelected(this.rlm.isLogEnabled(domain));
                    break;
                }
                case 2: {
                    this.joinLeaveOption.setSelected(this.rlm.isShowJoinLeaveEnabled(domain));
                }
            }
        }
        return new ScriptResult((Scriptable)this, null);
    }

    public void handlePrivateChatJoin(int id, HLProtocol.UserListComponent[] uh) {
        if (id == this.joinID) {
            this.rlm.addUsersToDomain(new Integer(this.pcref), uh);
        }
    }

    public void handlePrivateChatSubject(int ref, String subject) {
        if (ref == this.pcref) {
            this.f.setTitle("Private chat [" + subject + "] (" + this.rlm.getServerName() + ")");
        }
    }

    public void handleTaskError(int id, String s) {
        if (id == this.joinID) {
            this.rlm.getInterface().unregisterChild(this);
            this.close();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.options) {
            if (this.options.getSelectedIndex() > 0) {
                JCheckBox box;
                box.setSelected(!(box = (JCheckBox)this.options.getSelectedItem()).isSelected());
                this.options.setSelectedIndex(0);
                if (box.getText().equals("Log")) {
                    this.rlm.setState(new Integer(this.pcref), 1, new Boolean(this.logOption.isSelected()));
                } else if (box.getText().equals("Show join/leave")) {
                    this.rlm.setState(new Integer(this.pcref), 2, new Boolean(this.joinLeaveOption.isSelected()));
                }
            }
        } else if (e.getSource() == this.input) {
            if (!this.input.getText().trim().equals("")) {
                try {
                    if ((e.getModifiers() & 1) == 1 || this.input.getText().length() > 4 && this.input.getText().substring(0, 4).equals("/me ")) {
                        this.rlm.getHLC().sendPrivateChatAction(this.pcref, this.input.getText().substring(4));
                    } else {
                        this.rlm.getHLC().sendPrivateChat(this.pcref, this.input.getText());
                    }
                    this.input.setText("");
                }
                catch (IOException ex) {
                    DebuggerOutput.stackTrace(ex);
                }
            }
        } else if (e.getSource() instanceof JMenuItem) {
            try {
                this.rlm.getHLC().requestPrivateChatInvite(this.pcref, ((UserMenuItem)e.getSource()).getUser().sock);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void windowActivated(WindowEvent e) {
        this.chat.requestFocus();
        this.input.requestFocus();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.rlm.getInterface().unregisterChild(this);
        this.close();
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.mouseReleased(e);
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (this.inviteMenuItems != null) {
                int i = 0;
                while (i < this.inviteMenuItems.length) {
                    this.inviteMenuItems[i].removeActionListener(this);
                    this.invitePopup.remove(this.inviteMenuItems[i]);
                    ++i;
                }
            }
            User[] u = this.rlm.getUsers();
            this.inviteMenuItems = new JMenuItem[u.length];
            int i = 0;
            while (i < u.length) {
                this.inviteMenuItems[i] = new UserMenuItem(u[i]);
                this.inviteMenuItems[i].setFont(this.guiFont);
                this.inviteMenuItems[i].addActionListener(this);
                this.invitePopup.add(this.inviteMenuItems[i]);
                ++i;
            }
            this.invitePopup.show(this.list, e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent e) {
        User user;
        if (e.getClickCount() == 2 && (user = (User)this.list.getSelectedValue()) != null) {
            new MessageTransmit(this.rlm, user);
        }
    }

    public void close() {
        if (this.rlm.getHLC() != null) {
            this.rlm.getHLC().removeHLClientListener(this);
            try {
                this.rlm.getHLC().sendPrivateChatLeave(this.pcref);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.rlm.getScriptBroker().removeTarget(this);
        this.rlm.unregisterChat(new Integer(this.pcref), this);
        this.rlm.destroyDomain(new Integer(this.pcref));
        this.f.setVisible(false);
        this.f.dispose();
    }

    public void displayPropertyChanged(String what, Object property) {
        if (what.equals("textfont")) {
            this.chat.setEnabled(false);
            this.chat.setFont((Font)property);
            this.input.setFont((Font)property);
            this.chat.setText(this.chat.getText());
            this.chat.repaint();
            this.input.repaint();
            this.chat.setEnabled(true);
        } else if (what.equals("listfont")) {
            this.list.setFont((Font)property);
            this.list.repaint();
        }
        this.setElementColors();
        this.topPart.setContinuousLayout(Main.rlo.getBooleanProperty("Toggle.LiveResizing"));
    }

    public void gotTarget(ScriptBroker sb) {
    }

    public void lostTarget(ScriptBroker sb) {
    }

    public long getKnownMessages() {
        return 16L;
    }

    public ScriptResult executeScript(ScriptObject s) throws UnknownMessageException {
        int value = (int)s.getType();
        switch (value) {
            case 16: {
                StateObject state = (StateObject)s.getUserObject();
                return this.processStateChange(state);
            }
        }
        throw new UnknownMessageException();
    }
}

