/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.utils.DebuggerOutput;
import redlight.utils.TextUtils;

public class PostInterface
implements ActionListener,
WindowListener {
    Machine rlm;
    JTextArea message;
    JButton post;
    JButton cancel;
    JFrame f;
    Container contentPane;

    public PostInterface(Machine machine) {
        this.rlm = machine;
        Font guiFont = (Font)Main.rlo.getProperty("Font.gui");
        this.f = new JFrame("Post news (" + machine.getServerName() + ")");
        this.contentPane = this.f.getContentPane();
        GridBagConstraints gbc = new GridBagConstraints();
        this.message = new JTextArea("", 10, 30);
        JPanel messagePane = new JPanel();
        JPanel buttonPanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane(this.message);
        this.post = new JButton("Post");
        this.cancel = new JButton("Cancel");
        EmptyBorder emptyBorder = new EmptyBorder((Insets)Main.rlo.getProperty("BorderInsets"));
        TitledBorder lineBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Post news");
        CompoundBorder postBorder = BorderFactory.createCompoundBorder(lineBorder, emptyBorder);
        JTextArea postHelpText = new JTextArea("Enter a message and hit 'Post' to it add to the news:");
        postHelpText.setLineWrap(true);
        postHelpText.setWrapStyleWord(true);
        postHelpText.setOpaque(false);
        postHelpText.setEditable(false);
        this.message.setLineWrap(true);
        this.message.setWrapStyleWord(true);
        this.contentPane.setLayout(new GridBagLayout());
        messagePane.setLayout(new GridBagLayout());
        messagePane.setBorder(postBorder);
        buttonPanel.setLayout(new FlowLayout(2));
        this.message.setBackground(this.rlm.getSchemeColor("background"));
        this.message.setForeground(this.rlm.getSchemeColor("foreground"));
        this.post.setMnemonic('P');
        this.cancel.setMnemonic('C');
        this.cancel.registerKeyboardAction(this, "Cancel", KeyStroke.getKeyStroke(27, 0), 2);
        this.post.addActionListener(this);
        this.cancel.addActionListener(this);
        SwingUtilities.getRootPane(this.f).setDefaultButton(this.post);
        gbc.anchor = 12;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.ipadx = 4;
        gbc.ipady = 4;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        Insets oldInsets = gbc.insets;
        gbc.insets = new Insets(0, 0, 8, 0);
        messagePane.add((Component)postHelpText, gbc);
        gbc.insets = oldInsets;
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        messagePane.add((Component)scrollPane, gbc);
        buttonPanel.add(this.cancel);
        buttonPanel.add(this.post);
        gbc.insets = (Insets)Main.rlo.getProperty("BorderInsets");
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        this.contentPane.add((Component)messagePane, gbc);
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 8);
        this.contentPane.add((Component)buttonPanel, gbc);
        this.f.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = this.f.getSize();
        this.f.setLocation(d.width / 2 - w.width / 2, d.height / 2 - w.height / 2);
        this.message.requestFocus();
        this.message.setCaretPosition(0);
        this.f.setVisible(true);
    }

    public void displayPropertyChanged(final String what, final Object property) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (what.equals("textfont")) {
                    PostInterface.this.f.setFont((Font)property);
                } else {
                    PostInterface.this.f.setBackground(PostInterface.this.rlm.getSchemeColor("background"));
                    PostInterface.this.f.setForeground(PostInterface.this.rlm.getSchemeColor("foreground"));
                }
            }
        });
    }

    public void show() {
        this.f.setVisible(true);
        this.f.toFront();
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getActionCommand().equals("Post")) {
                this.rlm.getHLC().requestNewsPost(TextUtils.findAndReplace(this.message.getText(), "\n", "\r"));
                this.f.setVisible(false);
                this.f.dispose();
            } else {
                this.f.setVisible(false);
                this.f.dispose();
            }
        }
        catch (IOException ex) {
            DebuggerOutput.stackTrace(ex);
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        e.getWindow().setVisible(false);
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

