/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import redlight.client.Main;
import redlight.client.Options;
import redlight.client.OptionsInterface;

class PathsPanel
extends JPanel
implements ActionListener {
    JTextField downloads;
    JTextField bookmarks;
    JButton browseDownloadPath;
    JButton browseBookmarkPath;

    PathsPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.downloads = new JTextField();
        this.bookmarks = new JTextField();
        this.browseDownloadPath = new JButton("Browse ...");
        this.browseDownloadPath.setActionCommand("ActivateBrowseDownloadPath");
        this.browseBookmarkPath = new JButton("Browse ...");
        this.browseBookmarkPath.setActionCommand("ActivateBrowseBookmarkPath");
        JPanel downloadDirPanel = new JPanel();
        downloadDirPanel.setLayout(new BorderLayout());
        downloadDirPanel.add((Component)this.downloads, "Center");
        downloadDirPanel.add((Component)this.browseDownloadPath, "East");
        JPanel bookmarksDirPanel = new JPanel();
        bookmarksDirPanel.setLayout(new BorderLayout());
        bookmarksDirPanel.add((Component)this.bookmarks, "Center");
        bookmarksDirPanel.add((Component)this.browseBookmarkPath, "East");
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.addRow(new JLabel("Downloads:"), downloadDirPanel, gbc);
        this.addRow(new JLabel("Bookmarks:"), bookmarksDirPanel, gbc);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.addRow(Box.createGlue(), Box.createGlue(), gbc);
        this.setup(Main.rlo);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().startsWith("ActivateBrowse")) {
                    String path = e.getActionCommand().endsWith("BookmarkPath") ? PathsPanel.this.bookmarks.getText() : PathsPanel.this.downloads.getText();
                    FileDialog fd = new FileDialog((Frame)OptionsInterface.f, "Select a file.", 0);
                    fd.setDirectory(path);
                    fd.show();
                    if (fd.getDirectory() != null) {
                        if (e.getActionCommand().endsWith("BookmarkPath")) {
                            PathsPanel.this.bookmarks.setText(fd.getDirectory());
                        } else {
                            PathsPanel.this.downloads.setText(fd.getDirectory());
                        }
                    }
                }
            }
        };
        this.browseDownloadPath.addActionListener(actionListener);
        this.browseBookmarkPath.addActionListener(actionListener);
    }

    void addRow(Component l, Component v, GridBagConstraints gbc) {
        gbc.anchor = 17;
        gbc.fill = 0;
        this.add(l, gbc);
        ++gbc.gridx;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add(v, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
    }

    void setup(Options options) {
        this.bookmarks.setText(Main.rlo.getProperty("Path.Bookmarks").toString());
        this.downloads.setText(Main.rlo.getProperty("Path.Downloads").toString());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Save")) {
            Main.rlo.setProperty("Path.Bookmarks", new File(this.bookmarks.getText()));
            Main.rlo.setProperty("Path.Downloads", new File(this.downloads.getText()));
        }
    }
}

