/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.PostInterface;
import redlight.graphics.Spinner;
import redlight.hotline.HLClientAdapter;
import redlight.hotline.HLException;
import redlight.script.ScriptBroker;
import redlight.script.ScriptObject;
import redlight.script.ScriptResult;
import redlight.script.Scriptable;
import redlight.script.UnknownMessageException;

public class NewsInterface
extends HLClientAdapter
implements Runnable,
ActionListener,
WindowListener,
Scriptable {
    static int x = 0;
    static int y = 0;
    Machine rlm;
    Container contentPane;
    JTextArea news;
    JTextField find;
    JScrollPane scrollPane;
    Spinner spinner;
    JButton reload;
    JButton post;
    JFrame newsFrame;
    Thread getter;
    boolean swallow;
    boolean getterInterrupted = false;

    public NewsInterface(Machine machine) {
        this(machine, false);
    }

    public NewsInterface(Machine machine, boolean sw) {
        this.rlm = machine;
        this.swallow = sw;
        Font guiFont = (Font)Main.rlo.getProperty("Font.gui");
        this.rlm.getScriptBroker().addTarget(this);
        if (!this.swallow) {
            this.newsFrame = new JFrame("News (" + this.rlm.getServerName() + ")");
            this.contentPane = this.newsFrame.getContentPane();
        } else {
            try {
                ScriptResult[] sr = this.rlm.getScriptBroker().executeScript(new ScriptObject(1L, this));
                this.contentPane = (Container)sr[0].getUserObject();
            }
            catch (UnknownMessageException e) {
                e.printStackTrace();
            }
        }
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JToolBar toolbar = new JToolBar();
        this.reload = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[9]));
        this.post = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[1]));
        this.find = new JTextField("", 12);
        this.news = new JTextArea("", 10, 70);
        this.spinner = new Spinner(Main.rlo.getImageSet("Spinner"), 100, 16, 16);
        JPanel spinnerPanel = new JPanel();
        this.scrollPane = new JScrollPane(this.news);
        JLabel l1 = new JLabel("Find:");
        this.reload.setActionCommand("Reload");
        this.reload.setMnemonic('R');
        this.reload.setToolTipText("Reloads the news.");
        this.find.setFont(guiFont);
        this.post.setActionCommand("Post");
        this.post.setToolTipText("Post a new message.");
        this.news.setBackground(this.rlm.getSchemeColor("background"));
        this.news.setForeground(this.rlm.getSchemeColor("foreground"));
        this.news.setLineWrap(true);
        this.news.setWrapStyleWord(true);
        this.news.setFont((Font)Main.rlo.getProperty("Font.text"));
        this.news.setEditable(false);
        l1.setFont(guiFont);
        this.reload.addActionListener(this);
        this.find.addActionListener(this);
        this.post.addActionListener(this);
        this.contentPane.setLayout(gbl);
        toolbar.setFloatable(false);
        spinnerPanel.setLayout(new FlowLayout(2));
        toolbar.add(this.reload);
        toolbar.add(this.post);
        toolbar.addSeparator();
        toolbar.add(l1);
        toolbar.add(this.find);
        spinnerPanel.add(this.spinner);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.gridwidth = -1;
        gbc.gridheight = 1;
        this.contentPane.add((Component)toolbar, gbc);
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.gridwidth = 0;
        gbc.gridheight = -1;
        this.contentPane.add((Component)spinnerPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 3);
        this.contentPane.add((Component)this.scrollPane, gbc);
        if (!this.swallow) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension w = this.newsFrame.getSize();
            if (x == 0) {
                x = d.width / 100 * 2;
                y = d.height / 100 * 60;
            }
            this.newsFrame.setLocation(x, y);
            if ((x += w.width / 2) > d.width / 100 * 60 - w.width) {
                x = d.width / 100 * 2;
                y += w.height / 2;
            }
            if (y > d.height - w.height) {
                y = d.height / 100 * 60;
                x += w.width / 2;
            }
            this.newsFrame.addWindowListener(this);
            this.newsFrame.pack();
            this.newsFrame.show();
        }
        this.retrieveNews(true);
        this.rlm.getHLC().addHLClientListener(this);
    }

    public void run() {
        this.reload.setEnabled(false);
        this.spinner.start();
        try {
            String newsdata = this.rlm.getHLC().getNews();
            if (newsdata == null) {
                newsdata = "";
            }
            if (this.getterInterrupted) {
                throw new InterruptedException();
            }
            if (this.news != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        NewsInterface.this.news.setText("Formatting...");
                    }
                });
                final String s = newsdata.replace('\r', '\n');
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        NewsInterface.this.news.setText(s);
                        NewsInterface.this.news.setCaretPosition(0);
                    }
                });
            }
        }
        catch (HLException e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NewsInterface.this.news.setText("An error occurred: " + e.getMessage());
                }
            });
        }
        catch (IOException e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NewsInterface.this.news.setText("An error occurred: " + e.toString());
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.spinner.stop();
        this.reload.setEnabled(true);
    }

    public void handleNewsPost(String msg) {
        final String s = msg.replace('\r', '\n');
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewsInterface.this.news.insert(s, 0);
                NewsInterface.this.news.setColumns(80);
            }
        });
        this.rlm.playAudio("receivenewspost");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.find) {
            if (!this.find.getText().equals("")) {
                String data = this.news.getText();
                int selectionEnd = this.news.getSelectionEnd();
                int firstMatch = (data = data.substring(selectionEnd)).toUpperCase().indexOf(this.find.getText().toUpperCase());
                if (firstMatch != -1) {
                    this.news.setSelectionStart(firstMatch + selectionEnd);
                    this.news.setSelectionEnd(firstMatch + selectionEnd + this.find.getText().length());
                } else if (selectionEnd != 0 && (firstMatch = (data = this.news.getText()).toUpperCase().indexOf(this.find.getText().toUpperCase())) != -1) {
                    this.news.setSelectionStart(firstMatch);
                    this.news.setSelectionEnd(firstMatch + this.find.getText().length());
                }
            }
        } else if (e.getActionCommand().equals("Post")) {
            new PostInterface(this.rlm);
        } else if (e.getActionCommand().equals("Reload")) {
            this.retrieveNews(false);
        }
    }

    void retrieveNews(boolean firstTime) {
        if (firstTime && !Main.rlo.getBooleanProperty("Toggle.LoadNews")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NewsInterface.this.news.setText("No news was fetched. To fetch news, click 'Reload'.\nTo fetch news automatically upon login, turn on 'Load News' in Options.");
                }
            });
        } else {
            this.getterInterrupted = false;
            this.getter = new Thread((Runnable)this, "NewsInterface " + this.rlm.getServerName());
            this.getter.start();
        }
    }

    public void show() {
        if (this.newsFrame != null) {
            this.newsFrame.show();
        }
    }

    public void close() {
        if (this.rlm.getHLC() != null) {
            this.rlm.getHLC().removeHLClientListener(this);
        }
        JTextArea jTextArea = this.news;
        synchronized (jTextArea) {
            if (!this.swallow) {
                this.newsFrame.setVisible(false);
                this.newsFrame.dispose();
            } else {
                try {
                    this.rlm.getScriptBroker().executeScript(new ScriptObject(2L, this.contentPane));
                }
                catch (UnknownMessageException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.getter != null) {
            this.getterInterrupted = true;
            this.getter.interrupt();
            try {
                this.getter.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.rlm.getScriptBroker().removeTarget(this);
    }

    public void displayPropertyChanged(String what, Object property) {
        if (what.equals("textfont")) {
            final Font f = (Font)property;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NewsInterface.this.news.setFont(f);
                    NewsInterface.this.news.setEnabled(false);
                    NewsInterface.this.news.setText(NewsInterface.this.news.getText());
                    NewsInterface.this.news.setCaretPosition(0);
                    NewsInterface.this.news.setEnabled(true);
                }
            });
        } else {
            this.news.setBackground(this.rlm.getSchemeColor("background"));
            this.news.setForeground(this.rlm.getSchemeColor("foreground"));
        }
        if (!this.swallow) {
            this.newsFrame.repaint();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        e.getWindow().setVisible(false);
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void gotTarget(ScriptBroker sb) {
    }

    public void lostTarget(ScriptBroker sb) {
    }

    public long getKnownMessages() {
        return 8L;
    }

    public ScriptResult executeScript(ScriptObject s) throws UnknownMessageException {
        int value = (int)s.getType();
        switch (value) {
            case 8: {
                if ((Container)s.getUserObject() != this.contentPane) break;
                return new ScriptResult((Scriptable)this, null);
            }
        }
        throw new UnknownMessageException();
    }
}

