/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import redlight.client.Child;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.User;
import redlight.client.UserCellRenderer;
import redlight.client.UserToolBar;
import redlight.hotline.HLProtocol;
import redlight.utils.TextUtils;

public abstract class MessageInterface
implements ActionListener,
WindowListener,
Child {
    Machine rlm;
    Container contentPane;
    JTextArea message;
    JButton send;
    JButton cancel;
    JScrollPane scrollPane;
    JFrame f;
    HLProtocol hlp;
    User user;

    public MessageInterface(Machine rlm, User user, boolean isReceived) {
        JTextArea messageHelpText;
        TitledBorder lineBorder;
        this.rlm = rlm;
        this.user = user;
        Font guiFont = (Font)Main.rlo.getProperty("Font.gui");
        this.f = new JFrame("Message for " + user.nick);
        this.contentPane = this.f.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.message = new JTextArea("", 10, 50);
        this.scrollPane = new JScrollPane(this.message);
        JPanel messagePane = new JPanel();
        JPanel buttonPanel = new JPanel();
        JLabel date = new JLabel(new Date(System.currentTimeMillis()).toString());
        UserCellRenderer from = new UserCellRenderer(user, false);
        UserToolBar toolBar = new UserToolBar(rlm, user);
        this.send = new JButton("Send");
        this.cancel = new JButton("Dismiss");
        EmptyBorder emptyBorder = new EmptyBorder((Insets)Main.rlo.getProperty("BorderInsets"));
        if (isReceived) {
            lineBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Message received");
            messageHelpText = new JTextArea("You've received a message from \"" + user.nick + "\":");
            this.message.setEditable(false);
        } else {
            lineBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sending message");
            messageHelpText = new JTextArea("Sending a message to \"" + user.nick + "\":");
        }
        CompoundBorder messageBorder = BorderFactory.createCompoundBorder(lineBorder, emptyBorder);
        this.contentPane.setLayout(gbl);
        messagePane.setLayout(new GridBagLayout());
        buttonPanel.setLayout(new FlowLayout(2));
        toolBar.msg.setVisible(false);
        toolBar.reload.setVisible(false);
        messageHelpText.setVisible(false);
        this.message.setBackground(rlm.getSchemeColor("background"));
        this.message.setForeground(rlm.getSchemeColor("foreground"));
        this.message.setLineWrap(true);
        this.message.setWrapStyleWord(true);
        this.message.setFont((Font)Main.rlo.getProperty("Font.text"));
        this.message.setCaretPosition(0);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        SwingUtilities.getRootPane(this.f).setDefaultButton(this.send);
        this.send.setActionCommand("Send");
        if (isReceived) {
            this.send.setText("Reply");
            this.send.setMnemonic('R');
            this.send.setToolTipText("Reply to this message");
        } else {
            this.send.setMnemonic('S');
            this.send.setToolTipText("Send this message");
        }
        this.cancel.setMnemonic('D');
        this.cancel.setToolTipText("Discard the message");
        messagePane.setBorder(messageBorder);
        messageHelpText.setLineWrap(true);
        messageHelpText.setWrapStyleWord(true);
        messageHelpText.setOpaque(false);
        messageHelpText.setEditable(false);
        date.setFont(guiFont);
        date.setForeground(messageHelpText.getForeground());
        this.cancel.registerKeyboardAction(this, "Cancel", KeyStroke.getKeyStroke(27, 0), 2);
        this.send.addActionListener(this);
        this.cancel.addActionListener(this);
        gbc.anchor = 12;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.ipadx = 4;
        gbc.ipady = 4;
        gbc.weightx = 0.0;
        gbc.fill = 2;
        Insets oldInsets = gbc.insets;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 0, 8, 0);
        messagePane.add((Component)messageHelpText, gbc);
        gbc.insets = oldInsets;
        gbc.gridwidth = 1;
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.anchor = 13;
        messagePane.add((Component)new JLabel(isReceived ? "From:" : "To:"), gbc);
        ++gbc.gridy;
        messagePane.add((Component)new JLabel("Date:"), gbc);
        ++gbc.gridx;
        gbc.gridy = 1;
        messagePane.add((Component)from, gbc);
        ++gbc.gridy;
        messagePane.add((Component)date, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        messagePane.add((Component)toolBar, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        messagePane.add((Component)this.scrollPane, gbc);
        buttonPanel.add(this.cancel);
        buttonPanel.add(this.send);
        gbc.insets = (Insets)Main.rlo.getProperty("BorderInsets");
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        this.contentPane.add((Component)messagePane, gbc);
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 8);
        this.contentPane.add((Component)buttonPanel, gbc);
        this.f.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = this.f.getSize();
        this.f.setLocation(d.width / 2 - w.width / 2, d.height / 2 - w.height / 2);
        rlm.getInterface().registerChild(this);
    }

    void closeWindow() {
        this.close();
        this.f.dispose();
        this.f = null;
        this.rlm = null;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getActionCommand().equals("Send")) {
                this.rlm.getHLC().requestMessageSend(this.user.sock, TextUtils.findAndReplace(this.message.getText(), "\n", "\r"));
                this.closeWindow();
            } else {
                this.closeWindow();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.rlm.getInterface().error(ex);
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.closeWindow();
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void close() {
        this.send.setEnabled(false);
        if (this.rlm.getInterface() != null) {
            this.rlm.getInterface().unregisterChild(this);
        }
    }

    public void displayPropertyChanged(String what, final Object property) {
        if (what.equals("textfont")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MessageInterface.this.message.setFont((Font)property);
                    MessageInterface.this.message.setEnabled(false);
                    MessageInterface.this.message.setText(MessageInterface.this.message.getText());
                    MessageInterface.this.message.setCaretPosition(0);
                    MessageInterface.this.message.setEnabled(true);
                }
            });
        } else {
            this.message.setBackground(this.rlm.getSchemeColor("background"));
            this.message.setForeground(this.rlm.getSchemeColor("foreground"));
        }
    }
}

