/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import redlight.client.Child;
import redlight.client.DirCreateInterface;
import redlight.client.DirOpener;
import redlight.client.DownloadInterface;
import redlight.client.FileInfoInterface;
import redlight.client.FileNameTreeCellRenderer;
import redlight.client.FileSeeker;
import redlight.client.FileSizeTableCellRenderer;
import redlight.client.FileTCTableCellRenderer;
import redlight.client.FileTreeTableModel;
import redlight.client.FolderDownloadInterface;
import redlight.client.JTreeTable;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.UploadInterface;
import redlight.client.ViewInterface;
import redlight.graphics.Spinner;
import redlight.hotline.HLException;
import redlight.hotline.HLProtocol;
import redlight.script.ScriptObject;
import redlight.script.ScriptResult;
import redlight.script.UnknownMessageException;
import redlight.utils.DebuggerOutput;
import redlight.utils.QuickSort;
import redlight.utils.TextUtils;

public class FilesInterface
implements ActionListener,
Child {
    Machine rlm;
    Container contentPane;
    JTreeTable list;
    JFrame f;
    JScrollPane scrollPane;
    JPopupMenu popupMenu;
    JMenuItem infoItems;
    JMenuItem deleteItems;
    JMenuItem downloadItems;
    JMenuItem uploadItem;
    JMenuItem openInNewWindow;
    JMenuItem viewItem;
    JButton reload;
    JButton download;
    JButton upload;
    JButton delete;
    JButton mkdir;
    JButton search;
    JButton getinfo;
    JButton newWindow;
    JLabel info;
    Spinner spinner;
    HLProtocol.FileListComponent[] fileList;
    boolean threadsInterrupted;
    String path;
    String previousDirectory;
    Hashtable expandedPaths;
    int previousItemState = 2;
    int fileGettersActive;
    FileTreeTableModel treeModel;
    DefaultMutableTreeNode rootNode;
    TreePath openNewWindowPrimedPath;
    boolean swallow;

    public FilesInterface(Machine machine, String pa, boolean sw) {
        this.rlm = machine;
        this.path = pa;
        this.swallow = sw;
        Font guiFont = (Font)Main.rlo.getProperty("Font.gui");
        if (!this.swallow) {
            this.f = new JFrame("Files (" + this.rlm.getServerName() + ")");
            this.contentPane = this.f.getContentPane();
        } else {
            try {
                ScriptResult[] sr = this.rlm.getScriptBroker().executeScript(new ScriptObject(1L, this));
                this.contentPane = (Container)sr[0].getUserObject();
            }
            catch (UnknownMessageException e) {
                e.printStackTrace();
            }
        }
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JToolBar toolbar = new JToolBar();
        this.reload = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[9]));
        this.newWindow = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[2]));
        this.getinfo = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[13]));
        this.download = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[8]));
        this.upload = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[7]));
        this.mkdir = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[11]));
        this.delete = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[10]));
        this.search = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[12]));
        this.spinner = new Spinner(Main.rlo.getImageSet("Spinner"), 100, 16, 16);
        JPanel spinnerPanel = new JPanel();
        this.rootNode = new DefaultMutableTreeNode(this.path);
        this.treeModel = new FileTreeTableModel(this.rootNode);
        this.list = new JTreeTable(this.rlm, this.path, this.treeModel);
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.getViewport().setBackground(this.list.getBackground());
        this.info = new JLabel();
        this.popupMenu = new JPopupMenu();
        this.infoItems = new JMenuItem("Get info on selected items");
        this.downloadItems = new JMenuItem("Download selected items");
        this.openInNewWindow = new JMenuItem("Open in new window");
        this.deleteItems = new JMenuItem("Delete selected items");
        this.uploadItem = new JMenuItem("Upload into selected directory");
        this.viewItem = new JMenuItem("View selected items");
        FileTCTableCellRenderer ftcTableCellRenderer = new FileTCTableCellRenderer();
        this.contentPane.setLayout(gbl);
        toolbar.setFloatable(false);
        spinnerPanel.setLayout(new FlowLayout(2));
        this.reload.setMnemonic('R');
        this.reload.setActionCommand("Reload");
        this.newWindow.setActionCommand("ActivateNewWindow");
        this.download.setActionCommand("Download");
        this.upload.setActionCommand("Upload");
        this.getinfo.setActionCommand("Info");
        this.mkdir.setActionCommand("MkDir");
        this.delete.setActionCommand("Delete");
        this.search.setActionCommand("Search");
        this.reload.setFont(guiFont);
        this.newWindow.setFont(guiFont);
        this.download.setFont(guiFont);
        this.upload.setFont(guiFont);
        this.mkdir.setFont(guiFont);
        this.delete.setFont(guiFont);
        this.search.setFont(guiFont);
        this.getinfo.setFont(guiFont);
        this.popupMenu.setFont(guiFont);
        this.infoItems.setFont(guiFont);
        this.downloadItems.setFont(guiFont);
        this.openInNewWindow.setFont(guiFont);
        this.deleteItems.setFont(guiFont);
        this.uploadItem.setFont(guiFont);
        this.viewItem.setFont(guiFont);
        this.getinfo.setEnabled(false);
        this.delete.setEnabled(false);
        this.download.setEnabled(false);
        this.reload.setToolTipText("Refresh the list of files");
        this.newWindow.setToolTipText("Open in separate window");
        this.search.setToolTipText("Search for files on the server");
        this.download.setToolTipText("Download selected files");
        this.upload.setToolTipText("Upload a file");
        this.mkdir.setToolTipText("Create new directory");
        this.getinfo.setToolTipText("Get info on selected items");
        this.delete.setToolTipText("Delete selected items");
        this.info.setFont((Font)Main.rlo.getProperty("Font.info"));
        this.list.setBackground(this.rlm.getSchemeColor("background"));
        this.list.setForeground(this.rlm.getSchemeColor("foreground"));
        this.list.getTree().setBackground(this.rlm.getSchemeColor("background"));
        this.list.getTree().setForeground(this.rlm.getSchemeColor("foreground"));
        this.list.setFont((Font)Main.rlo.getProperty("Font.list"));
        this.list.getColumnModel().getColumn(0).setPreferredWidth(750);
        this.list.getColumnModel().getColumn(1).setPreferredWidth(175);
        this.list.getTree().setCellRenderer(new FileNameTreeCellRenderer());
        this.list.getColumn("Size").setCellRenderer(new FileSizeTableCellRenderer());
        this.list.getTree().setFont((Font)Main.rlo.getProperty("Font.list"));
        this.list.getTree().addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent e) {
            }

            public void treeWillExpand(TreeExpansionEvent e) {
                TreePath tp = e.getPath();
                if (!FilesInterface.this.expandedPaths.containsKey(tp) && tp.getPathCount() > 1) {
                    FilesInterface.this.expandedPaths.put(tp, FilesInterface.treePathToFilePath(FilesInterface.this.path, tp));
                    new GetFiles(FilesInterface.treePathToFilePath(FilesInterface.this.path, tp), (DefaultMutableTreeNode)tp.getLastPathComponent());
                }
            }
        });
        this.list.getTree().addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
                FilesInterface.this.updateInfo();
            }

            public void treeExpanded(TreeExpansionEvent e) {
                FilesInterface.this.updateInfo();
            }
        });
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.viewItem.addActionListener(this);
        this.uploadItem.addActionListener(this);
        this.downloadItems.addActionListener(this);
        this.deleteItems.addActionListener(this);
        this.openInNewWindow.addActionListener(this);
        this.infoItems.addActionListener(this);
        this.reload.addActionListener(this);
        this.newWindow.addActionListener(this);
        this.download.addActionListener(this);
        this.upload.addActionListener(this);
        this.delete.addActionListener(this);
        this.mkdir.addActionListener(this);
        this.search.addActionListener(this);
        this.getinfo.addActionListener(this);
        this.list.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.mouseReleased(e);
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int[] selectedItems = FilesInterface.this.list.getTree().getSelectionRows();
                    FilesInterface.this.deleteItems.setEnabled(selectedItems != null);
                    FilesInterface.this.downloadItems.setEnabled(selectedItems != null);
                    FilesInterface.this.openInNewWindow.setEnabled(false);
                    FilesInterface.this.uploadItem.setEnabled(false);
                    FilesInterface.this.viewItem.setEnabled(selectedItems != null);
                    int selRow = FilesInterface.this.list.getTree().getClosestRowForLocation(e.getX(), e.getY());
                    TreePath selPath = FilesInterface.this.list.getTree().getPathForRow(selRow);
                    if (selRow != -1) {
                        HLProtocol.FileListComponent files = (HLProtocol.FileListComponent)((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject();
                        if (files.fileType.equals("fldr")) {
                            if (selectedItems != null && selectedItems.length == 1) {
                                FilesInterface.this.openInNewWindow.setEnabled(true);
                                FilesInterface.this.uploadItem.setEnabled(true);
                            }
                            FilesInterface.this.openNewWindowPrimedPath = selPath;
                        }
                    }
                    FilesInterface.this.popupMenu.show(FilesInterface.this.list, e.getX(), e.getY());
                }
            }

            public void mouseClicked(MouseEvent e) {
                int selRow = FilesInterface.this.list.getTree().getClosestRowForLocation(e.getX(), e.getY());
                TreePath selPath = FilesInterface.this.list.getTree().getPathForRow(selRow);
                if (selRow != -1 && ((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject() instanceof HLProtocol.FileListComponent) {
                    HLProtocol.FileListComponent files = (HLProtocol.FileListComponent)((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject();
                    if (e.getClickCount() == 2 && !files.fileType.equals("fldr")) {
                        FilesInterface.this.itemActivated(e, selPath);
                    }
                }
            }
        });
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    FilesInterface.this.delete.setEnabled(e.getFirstIndex() != -1);
                    FilesInterface.this.getinfo.setEnabled(e.getFirstIndex() != -1);
                    FilesInterface.this.download.setEnabled(e.getFirstIndex() != -1);
                }
            }
        });
        this.list.registerKeyboardAction(this, "Activate", KeyStroke.getKeyStroke(32, 0), 2);
        this.popupMenu.add(this.infoItems);
        this.popupMenu.add(this.viewItem);
        this.popupMenu.add(this.downloadItems);
        this.popupMenu.add(this.uploadItem);
        this.popupMenu.add(this.openInNewWindow);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.deleteItems);
        toolbar.add(this.reload);
        toolbar.add(this.newWindow);
        toolbar.add(this.search);
        toolbar.add(this.getinfo);
        toolbar.add(this.download);
        toolbar.add(this.upload);
        toolbar.add(this.mkdir);
        toolbar.add(this.delete);
        gbc.gridwidth = -1;
        gbc.fill = 1;
        this.contentPane.add((Component)toolbar, gbc);
        spinnerPanel.add(this.spinner);
        gbc.gridx = 1;
        gbc.gridwidth = 0;
        this.contentPane.add((Component)spinnerPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.insets = (Insets)Main.rlo.getProperty("BorderInsets");
        this.contentPane.add((Component)scrollPane, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.anchor = 13;
        this.contentPane.add((Component)this.info, gbc);
        if (!this.swallow) {
            this.f.pack();
            this.f.setSize(350, 375);
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension w = this.f.getSize();
            this.f.setLocation(d.width / 2 - w.width / 2, d.height / 2 - w.height / 2);
            this.f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    FilesInterface.this.close();
                }
            });
            this.f.show();
            this.rlm.getInterface().registerChild(this);
        }
        this.expandedPaths = new Hashtable();
        new GetFiles(this.path, this.rootNode);
    }

    void updateInfo() {
        new Thread(new Runnable(){

            public void run() {
                if (FilesInterface.this.fileGettersActive != 0) {
                    return;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                    if (FilesInterface.this.reload.isEnabled()) {
                        ItemCount ic = FilesInterface.this.getItemCountForTree();
                        FilesInterface.this.info.setText(ic.files + ic.dirs + " items (" + ic.files + " files, " + ic.dirs + " directories).");
                        FilesInterface.this.info.repaint();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }).start();
    }

    ItemCount getItemCountForTree() {
        ItemCount ic = new ItemCount();
        JTree tree = this.list.getTree();
        int i = 0;
        while (i < tree.getRowCount()) {
            TreePath tp = tree.getPathForRow(i);
            Object userObject = ((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
            if (!(userObject instanceof String)) {
                HLProtocol.FileListComponent file = (HLProtocol.FileListComponent)userObject;
                if (!file.fileType.equals("fldr")) {
                    ++ic.files;
                } else {
                    ++ic.dirs;
                }
            }
            ++i;
        }
        return ic;
    }

    void itemDelete(TreePath[] treePaths) {
        boolean okToDelete = false;
        boolean deleteBatch = false;
        if (treePaths.length > 1) {
            int r = JOptionPane.showConfirmDialog(this.f, "Are you sure you wish to delete ALL selected items?", "Delete?", 0, 2);
            if (r == 0) {
                deleteBatch = true;
            }
            if (!deleteBatch) {
                return;
            }
        }
        int i = 0;
        while (i < treePaths.length) {
            String filePath = FilesInterface.treePathToFilePath(this.path, treePaths[i]);
            if (!deleteBatch) {
                okToDelete = false;
                int r = JOptionPane.showConfirmDialog(this.f, TextUtils.wordWrap("Are you sure you wish to delete " + filePath, 40), "Delete?", 0, 2);
                if (r == 0) {
                    okToDelete = true;
                }
            }
            if (deleteBatch || okToDelete) {
                try {
                    this.rlm.getHLC().requestFileDelete(filePath);
                    Thread.currentThread();
                    Thread.sleep(20L);
                }
                catch (IOException ex) {
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    void itemGetInfo(TreePath[] treePaths) {
        int i = 0;
        while (i < treePaths.length) {
            String filePath = FilesInterface.treePathToFilePath(this.path, treePaths[i]);
            new FileInfoInterface(this.rlm, filePath);
            ++i;
        }
    }

    void itemUpload(TreePath[] treePaths) {
        String target = null;
        if (treePaths != null && treePaths.length == 1) {
            TreePath tp = treePaths[0];
            HLProtocol.FileListComponent files = (HLProtocol.FileListComponent)((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
            String filePath = FilesInterface.treePathToFilePath(this.path, tp);
            if (files.fileType.equals("fldr")) {
                target = filePath;
            }
        }
        if (target == null) {
            target = this.path;
        }
        if (target != null) {
            FileDialog fd = new FileDialog((Frame)Main.getActiveShell().f, "Upload file", 0);
            if (this.previousDirectory != null) {
                fd.setDirectory(this.previousDirectory);
            }
            fd.show();
            if (fd.getDirectory() != null) {
                this.previousDirectory = fd.getDirectory();
            }
            if (fd.getFile() != null) {
                File sourceFile = new File(fd.getDirectory(), fd.getFile());
                new UploadInterface(this.rlm, target, sourceFile);
            }
        }
    }

    void itemView(TreePath[] treePaths) {
        int i = 0;
        while (i < treePaths.length) {
            TreePath tp = treePaths[i];
            String filePath = FilesInterface.treePathToFilePath(this.path, tp);
            Object o = ((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
            if (o instanceof HLProtocol.FileListComponent) {
                HLProtocol.FileListComponent files = (HLProtocol.FileListComponent)o;
                if (files.fileType.equals("fldr")) {
                    DebuggerOutput.debug(filePath + ": Can't view directories");
                } else {
                    new ViewInterface(this.rlm, filePath, files, null);
                }
            }
            ++i;
        }
    }

    void itemDownload(TreePath[] treePaths) {
        int i = 0;
        while (i < treePaths.length) {
            TreePath tp = treePaths[i];
            HLProtocol.FileListComponent files = (HLProtocol.FileListComponent)((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
            String filePath = FilesInterface.treePathToFilePath(this.path, tp);
            if (files.fileType.equals("fldr")) {
                new FolderDownloadInterface(this.rlm, filePath, files);
            } else {
                new DownloadInterface(this.rlm, filePath, files);
            }
            ++i;
        }
    }

    void itemActivated(InputEvent e, TreePath tp) {
        HLProtocol.FileListComponent files = (HLProtocol.FileListComponent)((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
        String filePath = FilesInterface.treePathToFilePath(this.path, tp);
        if (files.fileType.equals("fldr")) {
            DirOpener.open(this.rlm, filePath);
        } else {
            new DownloadInterface(this.rlm, filePath, files);
        }
    }

    static String treePathToFilePath(String rootPath, TreePath tp) {
        Object[] components = tp.getPath();
        String thePath = new String();
        thePath = rootPath.equals(":") ? "" : rootPath;
        int i = 1;
        while (i < components.length) {
            DefaultMutableTreeNode mtn = (DefaultMutableTreeNode)components[i];
            String label = mtn.getUserObject().toString();
            if (mtn.getUserObject() instanceof HLProtocol.FileListComponent) {
                label = ((HLProtocol.FileListComponent)mtn.getUserObject()).fileName;
            }
            thePath = thePath + ':' + label;
            ++i;
        }
        return thePath;
    }

    void cancelAllThreads() {
        this.threadsInterrupted = true;
    }

    protected void show() {
        if (!this.swallow) {
            this.f.toFront();
        }
        this.list.requestFocus();
    }

    public void actionPerformed(ActionEvent e) {
        TreePath[] treePaths = this.list.getTree().getSelectionPaths();
        if (e.getActionCommand().equals("Reload")) {
            this.rootNode = new DefaultMutableTreeNode(this.path);
            this.expandedPaths.clear();
            FileTreeTableModel fileTreeTableModel = this.treeModel;
            synchronized (fileTreeTableModel) {
                this.treeModel.setRoot(this.rootNode);
                this.treeModel.reload();
            }
            new GetFiles(this.path, this.rootNode);
            this.reload.setEnabled(false);
        } else if (e.getActionCommand().equals("ActivateNewWindow")) {
            DirOpener.open(this.rlm, this.path);
        } else if (e.getActionCommand().equals("MkDir")) {
            new DirCreateInterface(this.rlm, this.path);
        } else if (e.getActionCommand().equals("Search")) {
            new FileSeeker(this.rlm, this.path);
        } else if (e.getSource() == this.openInNewWindow) {
            this.itemActivated(null, this.openNewWindowPrimedPath);
        } else if (e.getActionCommand().equals("Upload")) {
            if (treePaths == null) {
                this.itemUpload(null);
            } else if (treePaths.length == 1) {
                this.itemUpload(treePaths);
            }
        } else {
            if (treePaths == null) {
                return;
            }
            if (e.getActionCommand().equals("Info")) {
                this.itemGetInfo(treePaths);
            } else if (e.getActionCommand().equals("Delete")) {
                this.itemDelete(treePaths);
            } else if (e.getActionCommand().equals("Download")) {
                this.itemDownload(treePaths);
            } else if (e.getSource() == this.deleteItems) {
                this.itemDelete(treePaths);
            } else if (e.getSource() == this.downloadItems) {
                this.itemDownload(treePaths);
            } else if (e.getSource() == this.infoItems) {
                this.itemGetInfo(treePaths);
            } else if (e.getSource() == this.uploadItem) {
                this.itemUpload(treePaths);
            } else if (e.getSource() == this.viewItem) {
                this.itemView(treePaths);
            } else if (e.getActionCommand().equals("Activate")) {
                if (treePaths.length != 1) {
                    return;
                }
                TreePath selPath = treePaths[0];
                Object o = ((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject();
                if (!(o instanceof HLProtocol.FileListComponent)) {
                    return;
                }
                HLProtocol.FileListComponent files = (HLProtocol.FileListComponent)o;
                if (!files.fileType.equals("fldr")) {
                    this.itemActivated(null, selPath);
                    return;
                }
                if (this.list.getTree().isExpanded(selPath)) {
                    this.list.getTree().collapsePath(selPath);
                    return;
                }
                this.list.getTree().expandPath(selPath);
            }
        }
    }

    public void close() {
        this.rlm.getInterface().unregisterChild(this);
        this.cancelAllThreads();
        DirOpener.close(this.rlm, this.path);
        if (!this.swallow) {
            this.f.setVisible(false);
            this.f.dispose();
        } else {
            try {
                this.rlm.getScriptBroker().executeScript(new ScriptObject(2L, this.contentPane));
            }
            catch (UnknownMessageException e) {
                e.printStackTrace();
            }
        }
    }

    public void displayPropertyChanged(String what, final Object property) {
        if (what.equals("listfont")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FilesInterface.this.list.setFont((Font)property);
                    FilesInterface.this.list.getTree().setFont((Font)property);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FilesInterface.this.list.setBackground(FilesInterface.this.rlm.getSchemeColor("background"));
                    FilesInterface.this.list.setForeground(FilesInterface.this.rlm.getSchemeColor("foreground"));
                    FilesInterface.this.list.getTree().setBackground(FilesInterface.this.rlm.getSchemeColor("background"));
                    FilesInterface.this.list.getTree().setForeground(FilesInterface.this.rlm.getSchemeColor("foreground"));
                }
            });
        }
        this.list.repaint();
    }

    class ItemCount {
        int files = 0;
        int dirs = 0;

        ItemCount() {
        }
    }

    class GetFiles
    implements Runnable {
        String pathToGet;
        DefaultMutableTreeNode nodeToExpand;
        Thread me;

        GetFiles(String p, DefaultMutableTreeNode n) {
            this.pathToGet = p;
            this.nodeToExpand = n;
            if (!FilesInterface.this.threadsInterrupted) {
                this.me = new Thread((Runnable)this, "Files: " + FilesInterface.this.path + "; " + FilesInterface.this.rlm.getServerName());
                this.me.start();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block21: {
                if (!FilesInterface.this.threadsInterrupted) {
                    block22: {
                        ++FilesInterface.this.fileGettersActive;
                        FilesInterface.this.spinner.start();
                        FilesInterface.this.reload.setEnabled(false);
                        FilesInterface.this.delete.setEnabled(false);
                        FilesInterface.this.getinfo.setEnabled(false);
                        FilesInterface.this.download.setEnabled(false);
                        try {
                            try {
                                FilesInterface.this.info.setText("Getting information...");
                                FilesInterface.this.fileList = FilesInterface.this.rlm.getHLC().getFileList(this.pathToGet);
                            }
                            catch (HLException _e) {
                                FilesInterface.this.fileList = null;
                                Object var5_2 = null;
                                if (!FilesInterface.this.threadsInterrupted) {
                                    if (FilesInterface.this.fileList == null) {
                                        FilesInterface.this.fileList = new HLProtocol.FileListComponent[0];
                                    }
                                    QuickSort.sort(FilesInterface.this.fileList, 0, FilesInterface.this.fileList.length - 1);
                                    SwingUtilities.invokeLater(new AddFilesToNode(FilesInterface.this.fileList, this.nodeToExpand));
                                    if (!FilesInterface.this.swallow) {
                                        FilesInterface.this.f.setTitle((FilesInterface.this.path.equals("") ? "Files" : FilesInterface.this.path) + " (" + FilesInterface.this.rlm.getServerName() + ")");
                                    }
                                    FilesInterface.this.expandedPaths.put(this.pathToGet, new Integer(1));
                                }
                                break block21;
                            }
                            catch (IOException _e) {
                                FilesInterface.this.fileList = null;
                                Object var5_3 = null;
                                if (!FilesInterface.this.threadsInterrupted) {
                                    if (FilesInterface.this.fileList == null) {
                                        FilesInterface.this.fileList = new HLProtocol.FileListComponent[0];
                                    }
                                    QuickSort.sort(FilesInterface.this.fileList, 0, FilesInterface.this.fileList.length - 1);
                                    SwingUtilities.invokeLater(new AddFilesToNode(FilesInterface.this.fileList, this.nodeToExpand));
                                    if (!FilesInterface.this.swallow) {
                                        FilesInterface.this.f.setTitle((FilesInterface.this.path.equals("") ? "Files" : FilesInterface.this.path) + " (" + FilesInterface.this.rlm.getServerName() + ")");
                                    }
                                    FilesInterface.this.expandedPaths.put(this.pathToGet, new Integer(1));
                                }
                                break block21;
                            }
                            catch (InterruptedException _e) {
                                FilesInterface.this.fileList = null;
                                Object var5_4 = null;
                                if (!FilesInterface.this.threadsInterrupted) {
                                    if (FilesInterface.this.fileList == null) {
                                        FilesInterface.this.fileList = new HLProtocol.FileListComponent[0];
                                    }
                                    QuickSort.sort(FilesInterface.this.fileList, 0, FilesInterface.this.fileList.length - 1);
                                    SwingUtilities.invokeLater(new AddFilesToNode(FilesInterface.this.fileList, this.nodeToExpand));
                                    if (!FilesInterface.this.swallow) {
                                        FilesInterface.this.f.setTitle((FilesInterface.this.path.equals("") ? "Files" : FilesInterface.this.path) + " (" + FilesInterface.this.rlm.getServerName() + ")");
                                    }
                                    FilesInterface.this.expandedPaths.put(this.pathToGet, new Integer(1));
                                }
                                break block21;
                            }
                            Object var5_1 = null;
                            if (FilesInterface.this.threadsInterrupted) break block21;
                            if (FilesInterface.this.fileList != null) break block22;
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            if (!FilesInterface.this.threadsInterrupted) {
                                if (FilesInterface.this.fileList == null) {
                                    FilesInterface.this.fileList = new HLProtocol.FileListComponent[0];
                                }
                                QuickSort.sort(FilesInterface.this.fileList, 0, FilesInterface.this.fileList.length - 1);
                                SwingUtilities.invokeLater(new AddFilesToNode(FilesInterface.this.fileList, this.nodeToExpand));
                                if (!FilesInterface.this.swallow) {
                                    FilesInterface.this.f.setTitle((FilesInterface.this.path.equals("") ? "Files" : FilesInterface.this.path) + " (" + FilesInterface.this.rlm.getServerName() + ")");
                                }
                                FilesInterface.this.expandedPaths.put(this.pathToGet, new Integer(1));
                            }
                            throw throwable;
                        }
                        FilesInterface.this.fileList = new HLProtocol.FileListComponent[0];
                    }
                    QuickSort.sort(FilesInterface.this.fileList, 0, FilesInterface.this.fileList.length - 1);
                    SwingUtilities.invokeLater(new AddFilesToNode(FilesInterface.this.fileList, this.nodeToExpand));
                    if (!FilesInterface.this.swallow) {
                        FilesInterface.this.f.setTitle((FilesInterface.this.path.equals("") ? "Files" : FilesInterface.this.path) + " (" + FilesInterface.this.rlm.getServerName() + ")");
                    }
                    FilesInterface.this.expandedPaths.put(this.pathToGet, new Integer(1));
                }
            }
            if (!FilesInterface.this.threadsInterrupted) {
                FilesInterface.this.reload.setEnabled(true);
                FilesInterface.this.spinner.stop();
                --FilesInterface.this.fileGettersActive;
                FilesInterface.this.updateInfo();
            }
        }
    }

    class AddFilesToNode
    implements Runnable {
        HLProtocol.FileListComponent[] fileList;
        DefaultMutableTreeNode root;

        AddFilesToNode(HLProtocol.FileListComponent[] f, DefaultMutableTreeNode n) {
            this.fileList = f;
            this.root = n;
        }

        public void run() {
            FileTreeTableModel fileTreeTableModel = FilesInterface.this.treeModel;
            synchronized (fileTreeTableModel) {
                int i = 0;
                while (i < this.fileList.length) {
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(this.fileList[i], this.fileList[i].fileType.equals("fldr"));
                    if (this.fileList[i].fileType.equals("fldr")) {
                        node.add(new DefaultMutableTreeNode("?"));
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode = this.root;
                    synchronized (defaultMutableTreeNode) {
                        this.root.add(node);
                    }
                    ++i;
                }
                if (this.root != FilesInterface.this.rootNode) {
                    DefaultMutableTreeNode c = (DefaultMutableTreeNode)FilesInterface.this.treeModel.getChild(this.root, 0);
                    FilesInterface.this.treeModel.removeNodeFromParent(c);
                }
                FilesInterface.this.treeModel.nodeStructureChanged(this.root);
                FilesInterface.this.list.getTree().setRootVisible(false);
                FilesInterface.this.list.repaint();
            }
        }
    }
}

