/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.core.filters.AbstractTaskFilter;
import org.cesilko.rachota.gui.HistoryChart;
import org.cesilko.rachota.gui.PNGImageWriter;
import org.cesilko.rachota.gui.Tools;

public class ReportGenerator {
    private File file;
    private String title;
    private boolean showChart;
    private boolean showFilters;
    private String rowsRepresent;
    private boolean includeDuration;
    private boolean includeProjectsTasks;
    private boolean includeOccurrences;
    private boolean includeNotes;
    private String sortBy;
    private Vector days;
    private HistoryChart chart;
    private AbstractTaskFilter highlightFilter;
    private Vector selectFilters;
    private static int OUTPUT_TXT = 0;
    private static int OUTPUT_CSV = 1;

    public ReportGenerator(File file, String title, boolean showChart, boolean showFilters, String rowsRepresent, boolean includeDuration, boolean includeProjectsTasks, boolean includeOccurrences, boolean includeNotes, String sortBy, Vector days, HistoryChart chart, AbstractTaskFilter highlightFilter, Vector selectFilters) {
        this.file = file;
        this.title = title;
        this.showChart = showChart;
        this.showFilters = showFilters;
        this.rowsRepresent = rowsRepresent;
        this.includeDuration = includeDuration;
        this.includeProjectsTasks = includeProjectsTasks;
        this.includeOccurrences = includeOccurrences;
        this.includeNotes = includeNotes;
        this.sortBy = sortBy;
        this.days = days;
        this.chart = chart;
        this.highlightFilter = highlightFilter;
        this.selectFilters = selectFilters;
    }

    public void generateReport() {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), (String)Settings.getDefault().getSetting("systemEncoding"));
            this.writeHeader(writer);
            if (this.showChart) {
                this.writeChart(writer);
            }
            if (this.showFilters) {
                this.writeFilters(writer);
            }
            if (this.rowsRepresent.equals("tasks")) {
                this.writeTasks(writer);
            } else {
                this.writeProjects(writer);
            }
            this.writeFooter(writer);
            writer.flush();
            writer.close();
            JOptionPane.showMessageDialog(null, Translator.getTranslation("INFORMATION.REPORT_CREATED"), Translator.getTranslation("INFORMATION.INFORMATION_TITLE"), 1);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, Translator.getTranslation("ERROR.WRITE_ERROR", new String[]{this.file.getAbsolutePath()}), Translator.getTranslation("ERROR.ERROR_TITLE"), 0);
        }
    }

    private void writeHeader(OutputStreamWriter writer) throws IOException {
        if (this.file.getAbsolutePath().endsWith(".html")) {
            this.writeHTMLHeader(writer);
        } else if (this.file.getAbsolutePath().endsWith(".txt")) {
            this.writeTXTCSVHeader(writer, "");
        } else {
            this.writeTXTCSVHeader(writer, "# ");
        }
    }

    private void writeHTMLHeader(OutputStreamWriter writer) throws IOException {
        writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        writer.write("<!--\n");
        writer.write("    Rachota 2.4 report file\n");
        writer.write("    Generated: " + new Date() + "\n");
        writer.write("-->\n");
        writer.write("<html lang=\"" + Locale.getDefault().getLanguage() + "\">\n");
        writer.write("  <head>\n");
        writer.write("    <title>" + Translator.getTranslation("REPORT.TITLE") + "</title>\n");
        writer.write("    <meta http-equiv=\"Content-Type\" content=\"text/html;charset=" + (String)Settings.getDefault().getSetting("systemEncoding") + "\">\n");
        writer.write("  </head>\n");
        writer.write("  <body>\n");
        writer.write("    <h1>" + Translator.getTranslation("REPORT.TITLE") + "</h1>\n");
        writer.write("    <table>\n");
        writer.write("      <tr><td><u>" + Translator.getTranslation("QUESTION.REPORT_DESCRIPTION") + "</u></td><td width=\"20\"/><td>" + this.title + "</td></tr>\n");
        DateFormat df = DateFormat.getDateInstance(2);
        Day firstDay = (Day)this.days.get(0);
        Day lastDay = (Day)this.days.get(this.days.size() - 1);
        int numberOfWorkingDays = 0;
        for (Day day : this.days) {
            if (day.getTotalTime((Boolean)Settings.getDefault().getSetting("countPrivateTasks")) == 0L) continue;
            ++numberOfWorkingDays;
        }
        writer.write("      <tr><td><u>" + Translator.getTranslation("REPORT.PERIOD") + "</u></td><td width=\"20\"/><td>" + df.format(firstDay.getDate()) + " - " + df.format(lastDay.getDate()) + "</td></tr>\n");
        writer.write("      <tr><td><u>" + Translator.getTranslation("REPORT.NUMBER_OF_DAYS") + "</u></td><td width=\"20\"/><td>" + this.days.size() + "</td></tr>\n");
        writer.write("      <tr><td><u>" + Translator.getTranslation("REPORT.NUMBER_OF_WORK_DAYS") + "</u></td><td width=\"20\"/><td>" + numberOfWorkingDays + "</td></tr>\n");
        writer.write("    </table><br/>\n");
    }

    private void writeTXTCSVHeader(OutputStreamWriter writer, String prefix) throws IOException {
        writer.write(prefix + this.title + "\n" + prefix);
        for (int i = 0; i < this.title.length(); ++i) {
            writer.write("=");
        }
        writer.write("\n");
        writer.write(prefix + "Rachota 2.4" + " " + Translator.getTranslation("REPORT.TITLE") + "\n");
        DateFormat df = DateFormat.getDateInstance(2);
        Day firstDay = (Day)this.days.get(0);
        Day lastDay = (Day)this.days.get(this.days.size() - 1);
        int numberOfWorkingDays = 0;
        for (Day day : this.days) {
            if (day.getTotalTime((Boolean)Settings.getDefault().getSetting("countPrivateTasks")) == 0L) continue;
            ++numberOfWorkingDays;
        }
        writer.write(prefix + Translator.getTranslation("REPORT.PERIOD") + " " + df.format(firstDay.getDate()) + " - " + df.format(lastDay.getDate()) + "\n");
        writer.write(prefix + Translator.getTranslation("REPORT.NUMBER_OF_DAYS") + " " + this.days.size() + "\n");
        writer.write(prefix + Translator.getTranslation("REPORT.NUMBER_OF_WORK_DAYS") + " " + numberOfWorkingDays + "\n" + prefix + "\n");
    }

    private void writeFooter(OutputStreamWriter writer) throws IOException {
        if (this.file.getAbsolutePath().endsWith(".html")) {
            this.writeHTMLFooter(writer);
        } else if (this.file.getAbsolutePath().endsWith(".txt")) {
            this.writeTXTCSVFooter(writer, "");
        } else {
            this.writeTXTCSVFooter(writer, "# ");
        }
    }

    private void writeHTMLFooter(OutputStreamWriter writer) throws IOException {
        writer.write("\n");
        writer.write("    <hr/><u>" + Translator.getTranslation("REPORT.GENERATED_BY") + "</u> <a href=\"http://rachota.sourceforge.net/\">" + "Rachota 2.4" + "</a> " + "(build " + "#140824" + ")<br/>\n");
        writer.write("    " + new Date() + "\n");
        writer.write("  </body>\n");
        writer.write("</html>");
    }

    private void writeTXTCSVFooter(OutputStreamWriter writer, String prefix) throws IOException {
        writer.write(prefix + "\n" + prefix + "---------------------------------------------------------------\n");
        writer.write(prefix + Translator.getTranslation("REPORT.GENERATED_BY") + " " + "Rachota 2.4" + " (build " + "#140824" + ")\n");
        writer.write(prefix + "http://rachota.sourceforge.net\n");
        writer.write(prefix + new Date());
    }

    private void writeChart(OutputStreamWriter writer) throws FileNotFoundException, IOException {
        String filename = this.file.getAbsolutePath();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filename.substring(0, filename.lastIndexOf(".")) + "_chart.png"));
        PNGImageWriter imageWriter = new PNGImageWriter();
        BufferedImage image = new BufferedImage(this.chart.getBounds().width, this.chart.getBounds().height, 1);
        this.chart.paint(image.getGraphics());
        imageWriter.write(image, out);
        writer.write("    <img src=\"" + this.file.getName().substring(0, this.file.getName().indexOf(".")) + "_chart.png\" title=\"Times chart of selected period.\" border=\"1\"/><br/><br/>\n");
        if (this.highlightFilter != null) {
            writer.write("    <u>" + Translator.getTranslation("HISTORYVIEW.LBL_HIGHLIGHT_TASKS") + "</u>\n");
            writer.write("    <ul><li>" + this.highlightFilter.toString() + " " + this.highlightFilter.getContentRules().get(this.highlightFilter.getContentRule()) + " <b>" + this.highlightFilter.getContent() + "</b></li></ul>\n");
        }
    }

    private void writeFilters(OutputStreamWriter writer) throws IOException {
        if (this.file.getAbsolutePath().endsWith(".html")) {
            this.writeHTMLFilters(writer);
        } else if (this.file.getAbsolutePath().endsWith(".txt")) {
            this.writeTXTCSVFilters(writer, "", " ");
        } else {
            this.writeTXTCSVFilters(writer, "# ", ";");
        }
    }

    private void writeHTMLFilters(OutputStreamWriter writer) throws IOException {
        writer.write("    <u>" + Translator.getTranslation("REPORT.APPLIED_FILTERS") + "</u>\n");
        writer.write("    <ul>\n");
        int count = this.selectFilters.size();
        for (int i = 0; i < count; ++i) {
            AbstractTaskFilter selectFilter = (AbstractTaskFilter)this.selectFilters.get(i);
            writer.write("      <li>" + selectFilter.toString() + " ");
            writer.write(selectFilter.getContentRules().get(selectFilter.getContentRule()) + " ");
            writer.write("<b>" + selectFilter.getContent() + "</b></li>\n");
        }
        writer.write("    </ul>\n");
    }

    private void writeTXTCSVFilters(OutputStreamWriter writer, String prefix, String delimiter) throws IOException {
        writer.write(prefix + Translator.getTranslation("REPORT.APPLIED_FILTERS") + "\n");
        int count = this.selectFilters.size();
        for (int i = 0; i < count; ++i) {
            AbstractTaskFilter selectFilter = (AbstractTaskFilter)this.selectFilters.get(i);
            writer.write("" + selectFilter.toString() + delimiter);
            writer.write(selectFilter.getContentRules().get(selectFilter.getContentRule()) + delimiter);
            writer.write(selectFilter.getContent() + "\n");
        }
        writer.write(prefix + "\n");
    }

    private void writeTasks(OutputStreamWriter writer) throws IOException {
        if (this.file.getAbsolutePath().endsWith(".html")) {
            this.writeHTMLTasks(writer);
        } else if (this.file.getAbsolutePath().endsWith(".txt")) {
            this.writeTXTCSVTasks(writer, OUTPUT_TXT);
        } else {
            this.writeTXTCSVTasks(writer, OUTPUT_CSV);
        }
    }

    private void writeHTMLTasks(OutputStreamWriter writer) throws IOException {
        writer.write("    <u>" + Translator.getTranslation("REPORT.TASKS") + "</u><br/><br/>\n");
        writer.write("    <table border=\"1\">\n");
        writer.write("      <tr bgcolor=\"CCCCCC\">\n");
        writer.write("        <td align=\"center\"><b>" + Translator.getTranslation("TASKS.DESCRIPTION") + "</b></td>\n");
        if (this.includeNotes) {
            writer.write("        <td align=\"center\"><b>" + Translator.getTranslation("TASKS.NOTES") + "</b></td>\n");
        }
        if (this.includeProjectsTasks) {
            writer.write("        <td align=\"center\"><b>" + Translator.getTranslation("TASKS.PROJECT") + "</b></td>\n");
        }
        if (this.includeDuration) {
            writer.write("        <td align=\"center\"><b>" + Translator.getTranslation("TASKS.DURATION_TIME") + "</b></td>\n");
        }
        if (this.includeOccurrences) {
            writer.write("        <td align=\"center\"><b>" + Translator.getTranslation("TASKS.OCCURRENCES") + "</b></td>\n");
        }
        writer.write("      </tr>\n");
        long totalTime = 0L;
        TaskRow[] taskRows = this.getTaskRows();
        for (int i = 0; i < taskRows.length; ++i) {
            totalTime += taskRows[i].getDuration();
            writer.write("      <tr>\n");
            writer.write("        <td>" + taskRows[i].getTaskDescription() + "</td>\n");
            if (this.includeNotes) {
                String notes = taskRows[i].getNotes();
                if (notes == null | notes.isEmpty()) {
                    writer.write("        <td>&nbsp;</td>\n");
                } else {
                    writer.write("        <td align=\"left\">\n");
                    Iterator notesIterator = taskRows[i].getNotesIterator();
                    while (notesIterator.hasNext()) {
                        String taskNotes = (String)notesIterator.next();
                        writer.write("          <li>" + taskNotes + "</li>\n");
                    }
                    writer.write("        </td>\n");
                }
            }
            if (this.includeProjectsTasks) {
                String projects = taskRows[i].getProjects();
                if (projects == null | projects.isEmpty()) {
                    writer.write("        <td>&nbsp;</td>\n");
                } else {
                    writer.write("        <td align=\"left\">\n");
                    Iterator projectsIterator = taskRows[i].getProjectsIterator();
                    while (projectsIterator.hasNext()) {
                        String projectDescription = (String)projectsIterator.next();
                        writer.write("          <li>" + projectDescription + "</li>\n");
                    }
                    writer.write("        </td>\n");
                }
            }
            if (this.includeDuration) {
                writer.write("        <td align=\"right\">" + Tools.getTime(taskRows[i].getDuration()) + "</td>\n");
            }
            if (this.includeOccurrences) {
                writer.write("        <td align=\"right\">" + taskRows[i].getOccurrences() + "</td>\n");
            }
            writer.write("      </tr>\n");
        }
        writer.write("    </table><br/>\n");
        writer.write("    <u>" + Translator.getTranslation("REPORT.TOTAL_FILTERED_TIME") + "</u> " + Tools.getTime(totalTime) + "<br/>\n");
        boolean includePrivateTime = (Boolean)Settings.getDefault().getSetting("countPrivateTasks");
        writer.write("    <u>" + Translator.getTranslation("REPORT.TOTAL_TIME") + "</u><b> " + Tools.getTime(Tools.getTotalTime(false, includePrivateTime, this.days)) + "</b><br/><br/>\n");
    }

    private void writeTXTCSVTasks(OutputStreamWriter writer, int output) throws IOException {
        String prefix = "";
        String delimiter = " | ";
        if (output == OUTPUT_CSV) {
            prefix = "#";
            delimiter = ";";
        }
        writer.write(prefix + Translator.getTranslation("REPORT.TASKS") + "\n" + prefix + "\n");
        writer.write("ID" + delimiter + Translator.getTranslation("TASKS.DESCRIPTION"));
        if (this.includeNotes) {
            writer.write(delimiter + Translator.getTranslation("TASKS.NOTES"));
        }
        if (this.includeProjectsTasks) {
            writer.write(delimiter + Translator.getTranslation("TASKS.PROJECT"));
        }
        if (this.includeDuration) {
            writer.write(delimiter + Translator.getTranslation("TASKS.DURATION_TIME"));
        }
        if (this.includeOccurrences) {
            writer.write(delimiter + Translator.getTranslation("TASKS.OCCURRENCES"));
        }
        writer.write("\n");
        long totalTime = 0L;
        TaskRow[] taskRows = this.getTaskRows();
        for (int i = 0; i < taskRows.length; ++i) {
            totalTime += taskRows[i].getDuration();
            writer.write("" + (i + 1) + "." + delimiter + taskRows[i].getTaskDescription());
            if (this.includeNotes) {
                writer.write(delimiter);
                String notes = taskRows[i].getNotes();
                if (notes != null & !notes.isEmpty()) {
                    if (output == OUTPUT_CSV) {
                        writer.write("\"");
                    }
                    Iterator notesIterator = taskRows[i].getNotesIterator();
                    while (notesIterator.hasNext()) {
                        String taskNotes = (String)notesIterator.next();
                        writer.write(" * " + taskNotes);
                    }
                    if (output == OUTPUT_CSV) {
                        writer.write("\"");
                    }
                }
            }
            if (this.includeProjectsTasks) {
                writer.write(delimiter);
                String projects = taskRows[i].getProjects();
                if (projects != null & !projects.isEmpty()) {
                    if (output == OUTPUT_CSV) {
                        writer.write("\"");
                    }
                    Iterator projectsIterator = taskRows[i].getProjectsIterator();
                    while (projectsIterator.hasNext()) {
                        String projectDescription = (String)projectsIterator.next();
                        writer.write(" * " + projectDescription);
                    }
                    if (output == OUTPUT_CSV) {
                        writer.write("\"");
                    }
                }
            }
            if (this.includeDuration) {
                writer.write(delimiter + Tools.getTime(taskRows[i].getDuration()));
            }
            if (this.includeOccurrences) {
                writer.write(delimiter + taskRows[i].getOccurrences());
            }
            writer.write("\n");
        }
        writer.write(prefix + "\n");
        writer.write(prefix + Translator.getTranslation("REPORT.TOTAL_FILTERED_TIME") + " " + Tools.getTime(totalTime) + "\n");
        boolean includePrivateTime = (Boolean)Settings.getDefault().getSetting("countPrivateTasks");
        writer.write(prefix + Translator.getTranslation("REPORT.TOTAL_TIME") + " " + Tools.getTime(Tools.getTotalTime(false, includePrivateTime, this.days)) + "\n");
    }

    private void writeProjects(OutputStreamWriter writer) throws IOException {
        if (this.file.getAbsolutePath().endsWith(".html")) {
            this.writeHTMLProjects(writer);
        } else if (this.file.getAbsolutePath().endsWith(".txt")) {
            this.writeTXTCSVProjects(writer, OUTPUT_TXT);
        } else {
            this.writeTXTCSVProjects(writer, OUTPUT_CSV);
        }
    }

    private void writeHTMLProjects(OutputStreamWriter writer) throws IOException {
        writer.write("    <u>" + Translator.getTranslation("REPORT.PROJECTS") + "</u><br/><br/>\n");
        writer.write("    <table border=\"1\">\n");
        writer.write("      <tr bgcolor=\"CCCCCC\">\n");
        writer.write("        <td align=\"center\"><b>" + Translator.getTranslation("TASKS.PROJECT") + "</b></td>\n");
        if (this.includeProjectsTasks) {
            writer.write("        <td align=\"center\"><b>" + Translator.getTranslation("TASKS.DESCRIPTION") + "</b></td>\n");
        }
        if (this.includeNotes) {
            writer.write("        <td align=\"center\"><b>" + Translator.getTranslation("TASKS.NOTES") + "</b></td>\n");
        }
        if (this.includeDuration) {
            writer.write("        <td align=\"center\"><b>" + Translator.getTranslation("TASKS.DURATION_TIME") + "</b></td>\n");
        }
        if (this.includeOccurrences) {
            writer.write("        <td align=\"center\"><b>" + Translator.getTranslation("TASKS.OCCURRENCES") + "</b></td>\n");
        }
        writer.write("      </tr>\n");
        long totalTime = 0L;
        ProjectRow[] projectRows = this.getProjectRows();
        for (int i = 0; i < projectRows.length; ++i) {
            totalTime += projectRows[i].getDuration();
            writer.write("      <tr>\n");
            writer.write("        <td>" + projectRows[i].getProjectDescription() + "</td>\n");
            if (this.includeProjectsTasks) {
                writer.write("        <td align=\"left\">\n");
                Iterator tasksIterator = projectRows[i].getTasksIterator();
                while (tasksIterator.hasNext()) {
                    String taskDescription = (String)tasksIterator.next();
                    writer.write("          <li>" + taskDescription + "</li>\n");
                }
                writer.write("        </td>\n");
            }
            if (this.includeNotes) {
                String notes = projectRows[i].getNotes();
                if (notes == null | notes.isEmpty()) {
                    writer.write("        <td>&nbsp;</td>\n");
                } else {
                    writer.write("        <td align=\"left\">\n");
                    Iterator notesIterator = projectRows[i].getNotesIterator();
                    while (notesIterator.hasNext()) {
                        String taskNotes = (String)notesIterator.next();
                        writer.write("          <li>" + taskNotes + "</li>\n");
                    }
                    writer.write("        </td>\n");
                }
            }
            if (this.includeDuration) {
                writer.write("        <td align=\"right\">" + Tools.getTime(projectRows[i].getDuration()) + "</td>\n");
            }
            if (this.includeOccurrences) {
                writer.write("        <td align=\"right\">" + projectRows[i].getOccurrences() + "</td>\n");
            }
            writer.write("      </tr>\n");
        }
        writer.write("    </table><br/>\n");
        writer.write("    <u>" + Translator.getTranslation("REPORT.TOTAL_FILTERED_TIME") + "</u> " + Tools.getTime(totalTime) + "<br/>\n");
        boolean includePrivateTime = (Boolean)Settings.getDefault().getSetting("countPrivateTasks");
        writer.write("    <u>" + Translator.getTranslation("REPORT.TOTAL_TIME") + "</u><b> " + Tools.getTime(Tools.getTotalTime(false, includePrivateTime, this.days)) + "</b><br/><br/>\n");
    }

    private void writeTXTCSVProjects(OutputStreamWriter writer, int output) throws IOException {
        String prefix = "";
        String delimiter = " | ";
        if (output == OUTPUT_CSV) {
            prefix = "#";
            delimiter = ";";
        }
        writer.write(prefix + Translator.getTranslation("REPORT.PROJECTS") + "\n" + prefix + "\n");
        writer.write("ID" + delimiter + Translator.getTranslation("TASKS.PROJECT"));
        if (this.includeProjectsTasks) {
            writer.write(delimiter + Translator.getTranslation("TASKS.DESCRIPTION"));
        }
        if (this.includeNotes) {
            writer.write(delimiter + Translator.getTranslation("TASKS.NOTES"));
        }
        if (this.includeDuration) {
            writer.write(delimiter + Translator.getTranslation("TASKS.DURATION_TIME"));
        }
        if (this.includeOccurrences) {
            writer.write(delimiter + Translator.getTranslation("TASKS.OCCURRENCES"));
        }
        writer.write("\n");
        long totalTime = 0L;
        ProjectRow[] projectRows = this.getProjectRows();
        for (int i = 0; i < projectRows.length; ++i) {
            totalTime += projectRows[i].getDuration();
            writer.write("" + (i + 1) + "." + delimiter + projectRows[i].getProjectDescription());
            if (this.includeProjectsTasks) {
                writer.write(delimiter);
                if (output == OUTPUT_CSV) {
                    writer.write("\"");
                }
                Iterator tasksIterator = projectRows[i].getTasksIterator();
                while (tasksIterator.hasNext()) {
                    String taskDescription = (String)tasksIterator.next();
                    writer.write(" * " + taskDescription);
                }
                if (output == OUTPUT_CSV) {
                    writer.write("\"");
                }
            }
            if (this.includeNotes) {
                writer.write(delimiter);
                String notes = projectRows[i].getNotes();
                if (notes != null & !notes.isEmpty()) {
                    if (output == OUTPUT_CSV) {
                        writer.write("\"");
                    }
                    Iterator notesIterator = projectRows[i].getNotesIterator();
                    while (notesIterator.hasNext()) {
                        String taskNotes = (String)notesIterator.next();
                        writer.write(" * " + taskNotes);
                    }
                    if (output == OUTPUT_CSV) {
                        writer.write("\"");
                    }
                }
            }
            if (this.includeDuration) {
                writer.write(delimiter + Tools.getTime(projectRows[i].getDuration()));
            }
            if (this.includeOccurrences) {
                writer.write(delimiter + projectRows[i].getOccurrences());
            }
            writer.write("\n");
        }
        writer.write(prefix + "\n");
        writer.write(prefix + Translator.getTranslation("REPORT.TOTAL_FILTERED_TIME") + " " + Tools.getTime(totalTime) + "\n");
        boolean includePrivateTime = (Boolean)Settings.getDefault().getSetting("countPrivateTasks");
        writer.write(prefix + Translator.getTranslation("REPORT.TOTAL_TIME") + " " + Tools.getTime(Tools.getTotalTime(false, includePrivateTime, this.days)) + "\n");
    }

    private TaskRow[] getTaskRows() {
        Hashtable<String, TaskRow> taskRowsTable = new Hashtable<String, TaskRow>();
        for (Day day : this.days) {
            Vector filteredTasks = this.filterTasks(day.getTasks());
            for (Task task : filteredTasks) {
                TaskRow taskRow;
                if (task.isIdleTask()) continue;
                boolean includePrivateTasks = (Boolean)Settings.getDefault().getSetting("countPrivateTasks");
                if (task.privateTask() & !includePrivateTasks) continue;
                if (taskRowsTable.containsKey(task.getDescription())) {
                    taskRow = (TaskRow)taskRowsTable.get(task.getDescription());
                    taskRow.includeTask(task);
                    continue;
                }
                taskRow = new TaskRow(task, this.sortBy);
                taskRowsTable.put(task.getDescription(), taskRow);
            }
        }
        int size = taskRowsTable.size();
        Object[] taskRows = new TaskRow[size];
        Iterator iterator = taskRowsTable.values().iterator();
        for (int i = 0; i < size; ++i) {
            taskRows[i] = (TaskRow)iterator.next();
        }
        Arrays.sort(taskRows);
        return taskRows;
    }

    private ProjectRow[] getProjectRows() {
        Hashtable<String, ProjectRow> projectRowsTable = new Hashtable<String, ProjectRow>();
        for (Day day : this.days) {
            Vector filteredTasks = this.filterTasks(day.getTasks());
            for (Task task : filteredTasks) {
                Iterator keywordIterator;
                if (task.isIdleTask()) continue;
                boolean includePrivateTasks = (Boolean)Settings.getDefault().getSetting("countPrivateTasks");
                if (task.privateTask() & !includePrivateTasks || !(keywordIterator = task.getKeywordIterator()).hasNext()) continue;
                while (keywordIterator.hasNext()) {
                    ProjectRow projectRow;
                    String project = (String)keywordIterator.next();
                    if (projectRowsTable.containsKey(project)) {
                        projectRow = (ProjectRow)projectRowsTable.get(project);
                        projectRow.includeTask(task);
                        continue;
                    }
                    projectRow = new ProjectRow(project, task, this.sortBy);
                    projectRowsTable.put(project, projectRow);
                }
            }
        }
        int size = projectRowsTable.size();
        Object[] projectRows = new ProjectRow[size];
        Iterator iterator = projectRowsTable.values().iterator();
        for (int i = 0; i < size; ++i) {
            projectRows[i] = (ProjectRow)iterator.next();
        }
        Arrays.sort(projectRows);
        return projectRows;
    }

    private Vector filterTasks(Vector tasks) {
        Vector filteredTasks = tasks;
        for (AbstractTaskFilter filter : this.selectFilters) {
            filteredTasks = filter.filterTasks(filteredTasks);
        }
        return filteredTasks;
    }

    class ProjectRow
    implements Comparable {
        String projectDescription;
        int occurrences;
        String tasks;
        long duration;
        String notes;
        String sortBy;

        ProjectRow(String projectDescription, Task task, String sortBy) {
            this.projectDescription = projectDescription;
            this.occurrences = 1;
            this.tasks = task.getDescription();
            this.duration = task.getDuration();
            this.notes = task.getNotes();
            this.sortBy = sortBy;
        }

        void includeTask(Task task) {
            ++this.occurrences;
            String taskDescription = task.getDescription();
            if (!this.tasks.contains(taskDescription)) {
                this.tasks = this.tasks + "," + taskDescription;
            }
            this.duration += task.getDuration();
            String notes = task.getNotes();
            if (notes != null && !notes.equals("") && !this.notes.contains(notes)) {
                this.notes = this.notes + "," + notes;
            }
        }

        String getProjectDescription() {
            return this.projectDescription;
        }

        int getOccurrences() {
            return this.occurrences;
        }

        Iterator getTasksIterator() {
            StringTokenizer tokenizer = new StringTokenizer(this.tasks, ",");
            ArrayList<String> tokens = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken());
            }
            return tokens.iterator();
        }

        String getTasks() {
            return this.tasks;
        }

        long getDuration() {
            return this.duration;
        }

        Iterator getNotesIterator() {
            StringTokenizer tokenizer = new StringTokenizer(this.notes, ",");
            ArrayList<String> tokens = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken());
            }
            return tokens.iterator();
        }

        String getNotes() {
            return this.notes;
        }

        public int compareTo(Object object) {
            if (object == null) {
                return 0;
            }
            ProjectRow projectRow = (ProjectRow)object;
            if (this.sortBy == null) {
                return this.projectDescription.compareTo(projectRow.getProjectDescription());
            }
            if (this.sortBy.equals("notes")) {
                return this.notes.compareTo(projectRow.getNotes());
            }
            if (this.sortBy.equals("duration")) {
                if (this.duration < projectRow.getDuration()) {
                    return 1;
                }
                return -1;
            }
            if (this.sortBy.equals("occurrences")) {
                if (this.occurrences < projectRow.getOccurrences()) {
                    return 1;
                }
                return -1;
            }
            if (this.sortBy.equals("projects/tasks")) {
                return this.tasks.compareTo(projectRow.getTasks());
            }
            return 0;
        }
    }

    class TaskRow
    implements Comparable {
        String taskDescription;
        int occurrences;
        String projects;
        long duration;
        String notes;
        String sortBy;

        TaskRow(Task task, String sortBy) {
            this.taskDescription = task.getDescription();
            this.occurrences = 1;
            this.projects = task.getKeyword();
            this.duration = task.getDuration();
            this.notes = task.getNotes();
            this.sortBy = sortBy;
        }

        void includeTask(Task task) {
            ++this.occurrences;
            String keyword = task.getKeyword();
            if (keyword != null && !keyword.equals("") && !this.projects.contains(keyword)) {
                this.projects = this.projects + "," + keyword;
            }
            this.duration += task.getDuration();
            String notes = task.getNotes();
            if (notes != null && !notes.equals("") && !this.notes.contains(notes)) {
                this.notes = this.notes + "," + notes;
            }
        }

        String getTaskDescription() {
            return this.taskDescription;
        }

        int getOccurrences() {
            return this.occurrences;
        }

        Iterator getProjectsIterator() {
            StringTokenizer tokenizer = new StringTokenizer(Tools.replaceAll(this.projects, " ", ","), ",");
            ArrayList<String> tokens = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken());
            }
            return tokens.iterator();
        }

        String getProjects() {
            return this.projects;
        }

        long getDuration() {
            return this.duration;
        }

        Iterator getNotesIterator() {
            StringTokenizer tokenizer = new StringTokenizer(this.notes, ",");
            ArrayList<String> tokens = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken());
            }
            return tokens.iterator();
        }

        String getNotes() {
            return this.notes;
        }

        public int compareTo(Object object) {
            if (object == null) {
                return 0;
            }
            TaskRow taskRow = (TaskRow)object;
            if (this.sortBy == null) {
                return this.taskDescription.compareTo(taskRow.getTaskDescription());
            }
            if (this.sortBy.equals("notes")) {
                return this.notes.compareTo(taskRow.getNotes());
            }
            if (this.sortBy.equals("duration")) {
                if (this.duration < taskRow.getDuration()) {
                    return 1;
                }
                return -1;
            }
            if (this.sortBy.equals("occurrences")) {
                if (this.occurrences < taskRow.getOccurrences()) {
                    return 1;
                }
                return -1;
            }
            if (this.sortBy.equals("projects/tasks")) {
                return this.projects.compareTo(taskRow.getProjects());
            }
            return 0;
        }
    }
}

