/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.Tools;

public class FilteredTasksTableModel
extends AbstractTableModel {
    public static final int DESCRIPTION = 0;
    public static final int DURATION_TIME = 1;
    public static final int DURATION_DAYS = 2;
    private boolean groupSameTasks;
    private Vector tasks;
    private int sortedColumn = 1;
    private boolean sortingOrder = false;
    private static final boolean ASCENDING = true;
    private static final boolean DESCENDING = false;

    public FilteredTasksTableModel() {
        this.setGroupSameTasks(true);
        this.setTasks(new Vector());
    }

    public void setGroupSameTasks(boolean groupSameTasks) {
        this.groupSameTasks = groupSameTasks;
        this.fireTableDataChanged();
    }

    public void setTasks(Vector tasks) {
        this.tasks = tasks;
        this.sortTable(this.sortedColumn, false);
        this.fireTableDataChanged();
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                if (!this.groupSameTasks) {
                    Task task = (Task)this.tasks.get(row);
                    return task.getDescription();
                }
                return this.getRow(row).get(0);
            }
            case 1: {
                if (!this.groupSameTasks) {
                    Task task = (Task)this.tasks.get(row);
                    return Tools.getTime(task.getDuration());
                }
                return this.getRow(row).get(1);
            }
            case 2: {
                if (!this.groupSameTasks) {
                    return "1";
                }
                return this.getRow(row).get(2);
            }
        }
        return "N/A";
    }

    public Task getSimilarTask(int row) {
        if (!this.groupSameTasks) {
            return (Task)this.tasks.get(row);
        }
        String description = (String)this.getValueAt(row, 0);
        Task similarTask = null;
        for (Task task : this.tasks) {
            if (!description.equals(task.getDescription())) continue;
            if (similarTask == null) {
                similarTask = task;
                continue;
            }
            return new Task(description, "", "", Task.PRIORITY_MEDIUM, Task.STATE_NEW, 0L, null, false, false);
        }
        if (similarTask == null) {
            return new Task(description, "", "", Task.PRIORITY_MEDIUM, Task.STATE_NEW, 0L, null, false, false);
        }
        return similarTask;
    }

    @Override
    public int getRowCount() {
        if (!this.groupSameTasks) {
            return this.tasks.size();
        }
        return this.getUniqueTaskDescriptions().size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        String suffix = this.sortingOrder ? " [-]" : " [+]";
        switch (column) {
            case 0: {
                suffix = this.sortedColumn == 0 ? suffix : "";
                return Translator.getTranslation("TASKS.DESCRIPTION") + suffix;
            }
            case 1: {
                suffix = this.sortedColumn == 1 ? suffix : "";
                return Translator.getTranslation("TASKS.DURATION_TIME") + suffix;
            }
            case 2: {
                suffix = this.sortedColumn == 2 ? suffix : "";
                return Translator.getTranslation("TASKS.DURATION_DAYS") + suffix;
            }
        }
        return null;
    }

    private Vector getUniqueTaskDescriptions() {
        Vector<String> uniqueTasks = new Vector<String>();
        for (Task task : this.tasks) {
            if (uniqueTasks.contains(task.getDescription())) continue;
            uniqueTasks.add(task.getDescription());
        }
        return uniqueTasks;
    }

    public double getTotalTime() {
        Iterator iterator = this.tasks.iterator();
        double duration = 0.0;
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            duration += (double)task.getDuration();
        }
        return duration;
    }

    private Vector getRow(int row) {
        Vector uniqueTaskDescriptions = this.getUniqueTaskDescriptions();
        if (row >= uniqueTaskDescriptions.size()) {
            Vector<String> rowData = new Vector<String>();
            rowData.add("N/A");
            rowData.add(Tools.getTime(0.0));
            rowData.add("0");
            return rowData;
        }
        String description = (String)this.getUniqueTaskDescriptions().get(row);
        Iterator iterator = this.tasks.iterator();
        int days = 0;
        long duration = 0L;
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (!task.getDescription().equals(description)) continue;
            duration += task.getDuration();
            ++days;
        }
        Vector<String> rowData = new Vector<String>();
        rowData.add(description);
        rowData.add(Tools.getTime(duration));
        rowData.add("" + days);
        return rowData;
    }

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public String getSortedOrder() {
        return this.sortingOrder ? "-" : "+";
    }

    public void sortTable(final int column, final boolean changeOrder) {
        final ProgressMonitor pm = new ProgressMonitor(null, Translator.getTranslation("MESSAGE.PROGRESS_HISTORY"), null, 0, this.getRowCount() - 1);
        Thread sortingThread = new Thread(){

            @Override
            public void run() {
                String description;
                int count = FilteredTasksTableModel.this.getRowCount();
                Vector descriptions = new Vector();
                Vector duration_times = new Vector();
                Vector duration_days = new Vector();
                for (int row = 0; row < count; ++row) {
                    Vector rowData = FilteredTasksTableModel.this.getRow(row);
                    descriptions.add(rowData.get(0));
                    duration_times.add(rowData.get(1));
                    duration_days.add(rowData.get(2));
                    final int progress = row;
                    if (row % 10 != 0 && row != count - 1) continue;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            pm.setProgress(progress);
                        }
                    });
                }
                Vector<Integer> sortedRows = new Vector<Integer>();
                for (int i = 0; i < count; ++i) {
                    Object maxValue = null;
                    int maxRow = -1;
                    block7: for (int row = 0; row < count; ++row) {
                        if (sortedRows.contains(new Integer(row))) continue;
                        switch (column) {
                            case 0: {
                                description = (String)descriptions.get(row);
                                if (maxValue != null && description.toLowerCase().compareTo((String)maxValue) <= 0) continue block7;
                                maxValue = description.toLowerCase();
                                maxRow = row;
                                continue block7;
                            }
                            case 1: {
                                long time = Tools.getTime((String)duration_times.get(row));
                                if (maxValue != null && time <= (Long)maxValue) continue block7;
                                maxValue = new Long(time);
                                maxRow = row;
                                continue block7;
                            }
                            case 2: {
                                int days = Integer.parseInt((String)duration_days.get(row));
                                if (maxValue != null && days <= (Integer)maxValue) continue block7;
                                maxValue = new Integer(days);
                                maxRow = row;
                            }
                        }
                    }
                    sortedRows.add(new Integer(maxRow));
                }
                Vector<Task> newSortedTasks = new Vector<Task>();
                Vector oldTasks = (Vector)FilteredTasksTableModel.this.tasks.clone();
                if (changeOrder) {
                    FilteredTasksTableModel.this.sortingOrder = FilteredTasksTableModel.this.sortedColumn == column ? !FilteredTasksTableModel.this.sortingOrder : true;
                }
                FilteredTasksTableModel.this.sortedColumn = column;
                for (int i = 0; i < count; ++i) {
                    Integer row = (Integer)sortedRows.get(i);
                    description = (String)FilteredTasksTableModel.this.getValueAt(row, 0);
                    Iterator iterator = oldTasks.iterator();
                    while (iterator.hasNext()) {
                        Task task = (Task)iterator.next();
                        if (!task.getDescription().equals(description)) continue;
                        if (!FilteredTasksTableModel.this.sortingOrder) {
                            newSortedTasks.add(task);
                        } else {
                            newSortedTasks.insertElementAt(task, 0);
                        }
                        oldTasks.remove(task);
                        iterator = oldTasks.iterator();
                    }
                }
                FilteredTasksTableModel.this.tasks = newSortedTasks;
                FilteredTasksTableModel.this.fireTableDataChanged();
            }
        };
        sortingThread.start();
    }
}

