/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.Tools;

public class ComparisonChart
extends JPanel {
    private long totalTimeUser;
    private long totalTimeAll;
    private long idleTimeUser;
    private long idleTimeAll;
    private long privateTimeUser;
    private long privateTimeAll;
    private String message = "";
    private String hint = "";
    private static int INSET_TOP = 10;
    private static int INSET_BOTTOM = 15;
    private static int INSET_LEFT = 10;
    private static int INSET_RIGHT = 10;

    public ComparisonChart() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (ComparisonChart.this.message == null) {
                    return;
                }
                JOptionPane.showMessageDialog(ComparisonChart.this, "<html><body><font color=\"red\">" + ComparisonChart.this.message + "</font><br><h4>" + ComparisonChart.this.hint + "</h4></body></html>", Translator.getTranslation("WARNING.WARNING_TITLE"), 2);
            }
        });
    }

    @Override
    public void paint(Graphics graphics) {
        int correction;
        graphics.setFont(Tools.getFont());
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        graphics.clearRect(0, 0, width, height);
        long maxTimeValue = Math.max(this.totalTimeUser, Math.max(this.totalTimeAll, Math.max(this.privateTimeUser, Math.max(this.privateTimeAll, Math.max(this.idleTimeUser, this.idleTimeAll)))));
        if (maxTimeValue == 0L) {
            return;
        }
        int columnWidth = (width - INSET_RIGHT - INSET_LEFT - width / 6) / 6;
        String you = Translator.getTranslation("ANALYTICSVIEW.YOU");
        String others = Translator.getTranslation("ANALYTICSVIEW.OTHERS");
        int columnHeight = (int)((long)(height - INSET_BOTTOM - INSET_TOP - 15) * this.totalTimeUser / maxTimeValue);
        this.drawColumn(INSET_LEFT, height - INSET_BOTTOM - columnHeight - 5, columnWidth, columnHeight, Color.LIGHT_GRAY, you, Tools.getTimeShort(this.totalTimeUser), graphics);
        columnHeight = (int)((long)(height - INSET_BOTTOM - INSET_TOP - 15) * this.totalTimeAll / maxTimeValue);
        this.drawColumn(INSET_LEFT + columnWidth + 2, height - INSET_BOTTOM - columnHeight - 5, columnWidth, columnHeight, Color.GRAY, others, Tools.getTimeShort(this.totalTimeAll), graphics);
        columnHeight = (int)((long)(height - INSET_BOTTOM - INSET_TOP - 15) * this.idleTimeUser / maxTimeValue);
        this.drawColumn(INSET_LEFT + columnWidth * 2 + width / 12, height - INSET_BOTTOM - columnHeight - 5, columnWidth, columnHeight, Color.CYAN, you, Tools.getTimeShort(this.idleTimeUser), graphics);
        columnHeight = (int)((long)(height - INSET_BOTTOM - INSET_TOP - 15) * this.idleTimeAll / maxTimeValue);
        this.drawColumn(INSET_LEFT + columnWidth * 3 + 2 + width / 12, height - INSET_BOTTOM - columnHeight - 5, columnWidth, columnHeight, Color.GRAY, others, Tools.getTimeShort(this.idleTimeAll), graphics);
        columnHeight = (int)((long)(height - INSET_BOTTOM - INSET_TOP - 15) * this.privateTimeUser / maxTimeValue);
        this.drawColumn(INSET_LEFT + columnWidth * 4 + width / 6, height - INSET_BOTTOM - columnHeight - 5, columnWidth, columnHeight, Color.BLUE, you, Tools.getTimeShort(this.privateTimeUser), graphics);
        columnHeight = (int)((long)(height - INSET_BOTTOM - INSET_TOP - 15) * this.privateTimeAll / maxTimeValue);
        this.drawColumn(INSET_LEFT + columnWidth * 5 + 2 + width / 6, height - INSET_BOTTOM - columnHeight - 5, columnWidth, columnHeight, Color.GRAY, others, Tools.getTimeShort(this.privateTimeAll), graphics);
        graphics.setColor(Color.BLACK);
        String working_Time = Translator.getTranslation("HISTORYCHART.WORKING_TIME");
        String private_Time = Translator.getTranslation("HISTORYCHART.PRIVATE_TIME");
        String idle_Time = Translator.getTranslation("HISTORYCHART.IDLE_TIME");
        int maxCorrection = correction = graphics.getFontMetrics().stringWidth(working_Time);
        correction = graphics.getFontMetrics().stringWidth(private_Time);
        if (correction > maxCorrection) {
            maxCorrection = correction;
        }
        if ((correction = graphics.getFontMetrics().stringWidth(idle_Time)) > maxCorrection) {
            maxCorrection = correction;
        }
        graphics.setColor(Color.WHITE);
        graphics.fillRect(width - maxCorrection - 25, 0, maxCorrection + 20, 50);
        graphics.setColor(Color.DARK_GRAY);
        graphics.drawRect(width - maxCorrection - 25, 0, maxCorrection + 20, 50);
        graphics.drawString(working_Time, width - maxCorrection - 6, 15);
        graphics.drawString(idle_Time, width - maxCorrection - 6, 30);
        graphics.drawString(private_Time, width - maxCorrection - 6, 45);
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.fillRect(width - 20 - maxCorrection, 5, 10, 10);
        graphics.setColor(Color.DARK_GRAY);
        graphics.drawRect(width - 20 - maxCorrection, 5, 10, 10);
        graphics.setColor(Color.CYAN);
        graphics.fillRect(width - 20 - maxCorrection, 20, 10, 10);
        graphics.setColor(Color.DARK_GRAY);
        graphics.drawRect(width - 20 - maxCorrection, 20, 10, 10);
        graphics.setColor(Color.BLUE);
        graphics.fillRect(width - 20 - maxCorrection, 35, 10, 10);
        graphics.setColor(Color.DARK_GRAY);
        graphics.drawRect(width - 20 - maxCorrection, 35, 10, 10);
    }

    public void setTimes(long totalTimeUser, long totalTimeAll, long idleTimeUser, long idleTimeAll, long privateTimeUser, long privateTimeAll) {
        this.totalTimeAll = totalTimeAll;
        this.totalTimeUser = totalTimeUser;
        this.idleTimeAll = idleTimeAll;
        this.idleTimeUser = idleTimeUser;
        this.privateTimeAll = privateTimeAll;
        this.privateTimeUser = privateTimeUser;
        if (totalTimeAll + privateTimeAll + idleTimeAll != 0L) {
            this.setMessage(null, null);
        }
        this.repaint();
    }

    void setMessage(String message, String hint) {
        String tooltip = message == null ? null : message + " " + Translator.getTranslation("ANALYTICSVIEW.HINT_TOOLTIP");
        this.setToolTipText(tooltip);
        this.message = message;
        this.hint = hint;
    }

    private void drawColumn(int x, int y, int columnWidth, int columnHeight, Color color, String textBelow, String textAbove, Graphics graphics) {
        graphics.setColor(color);
        graphics.fillRect(x, y, columnWidth, columnHeight);
        graphics.setColor(Color.DARK_GRAY);
        graphics.drawRect(x, y, columnWidth, columnHeight);
        graphics.drawString(textBelow, x + columnWidth / 2 - graphics.getFontMetrics().stringWidth(textBelow) / 2, y + columnHeight + INSET_BOTTOM);
        graphics.drawString(textAbove, x + columnWidth / 2 - graphics.getFontMetrics().stringWidth(textAbove) / 2, y - 10);
        long times = this.totalTimeAll + this.privateTimeAll + this.idleTimeAll;
        if (times != 0L) {
            return;
        }
        if (!textAbove.equals("00:00")) {
            return;
        }
        ImageIcon warning = new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/warning.png"));
        graphics.drawImage(warning.getImage(), x + columnWidth / 2 + graphics.getFontMetrics().stringWidth(textAbove) / 2 + 5, y - 10 - warning.getIconHeight() / 2 - graphics.getFontMetrics().getHeight() / 2, null);
    }
}

