/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.Plan;
import org.cesilko.rachota.core.RegularTask;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.ComparisonChart;
import org.cesilko.rachota.gui.Tools;

public class AnalyticsView
extends JPanel
implements PropertyChangeListener {
    private JLabel lbCategorization;
    private JLabel lbCategorizationResult;
    private JLabel lbEffectivity;
    private JLabel lbEffectivityResult;
    private JLabel lbGranularity;
    private JLabel lbGranularityResult;
    private JLabel lbPrioritization;
    private JLabel lbPrioritizationResult;
    private JLabel lbRepetition;
    private JLabel lbRepetitionResult;
    private JLabel lbStatusing;
    private JLabel lbStatusingResult;
    private JPanel pnAnalysis;
    private JPanel pnChart;
    private JPanel pnSuggestions;
    private JPanel pnTimeUsage;
    private JRadioButton rbAllTime;
    private JRadioButton rbMonth;
    private JRadioButton rbWeek;
    private JScrollPane spSuggestions;
    private JTextPane tpSuggestions;
    public static final int SCALE_PAST_WEEK = 0;
    public static final int SCALE_PAST_MONTH = 1;
    public static final int SCALE_WHOLE_TIME = 2;
    private String usageTimesAll;
    private String usageTimesUser;
    private ComparisonChart comparisonChart;
    private float effectivity;
    private float granularity;
    private float prioritization;
    private float categorization;
    private float statusing;
    private float repetition;

    public AnalyticsView() {
        this.initComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.comparisonChart = new ComparisonChart();
        this.pnChart.add((Component)this.comparisonChart, gridBagConstraints);
        this.countUserTimes(0);
        this.updateChart();
        this.updateAnalysis(0);
        this.updateSuggestions();
    }

    @Override
    public Font getFont() {
        return Tools.getFont();
    }

    private float countEffectivity(int scale) {
        this.countUserTimes(scale);
        float totalTime = this.getTotalTimeUser();
        float privateTime = this.getPrivateTimeUser();
        float idleTime = this.getIdleTimeUser();
        this.effectivity = totalTime != 0.0f ? totalTime * 5.0f / (idleTime + privateTime + totalTime) : 0.0f;
        return (float)Math.round(this.effectivity * 10.0f) / 10.0f;
    }

    private void updateEffectivity(int scale) {
        this.countEffectivity(scale);
        this.lbEffectivityResult.setIcon(this.getIcon(Math.round(this.effectivity)));
        this.lbEffectivityResult.setToolTipText("" + this.effectivity);
    }

    private float countCategorization(int scale) {
        Iterator days = Plan.getDefault().getDays(scale);
        float numberOfTasks = 0.0f;
        float numberOfCategories = 0.0f;
        while (days.hasNext()) {
            Day day = (Day)days.next();
            for (Task task : day.getTasks()) {
                if (task.isIdleTask()) continue;
                numberOfTasks += 1.0f;
                String keyword = task.getKeyword();
                if (keyword == null || keyword.equals("")) continue;
                numberOfCategories += 1.0f;
            }
        }
        if (numberOfTasks != 0.0f) {
            float categorizationRatio = numberOfCategories / numberOfTasks;
            this.categorization = categorizationRatio * 10.0f / 2.0f;
        } else {
            this.categorization = 0.0f;
        }
        return (float)Math.round(this.categorization * 10.0f) / 10.0f;
    }

    private void updateCategorization(int scale) {
        this.countCategorization(scale);
        this.lbCategorizationResult.setIcon(this.getIcon(Math.round(this.categorization)));
        this.lbCategorizationResult.setToolTipText("" + this.categorization);
    }

    private float countGranularity(int scale) {
        int tasks_80 = 0;
        int tasks_40 = 0;
        int tasks_20 = 0;
        int tasks_10 = 0;
        int tasks_4 = 0;
        int tasks_2 = 0;
        int tasks_1 = 0;
        int allTasks = 0;
        Iterator days = Plan.getDefault().getDays(scale);
        while (days.hasNext()) {
            Day day = (Day)days.next();
            long totalDayTime = day.getTotalTime(true);
            if (totalDayTime == 0L) continue;
            for (Task task : day.getTasks()) {
                if (task.isIdleTask()) continue;
                int timeShare = (int)(task.getDuration() * 100L / totalDayTime);
                if (timeShare >= 80) {
                    ++tasks_80;
                } else if (timeShare >= 40) {
                    ++tasks_40;
                } else if (timeShare >= 20) {
                    ++tasks_20;
                } else if (timeShare >= 10) {
                    ++tasks_10;
                } else if (timeShare >= 4) {
                    ++tasks_4;
                } else if (timeShare >= 2) {
                    ++tasks_2;
                } else {
                    ++tasks_1;
                }
                ++allTasks;
            }
        }
        if (allTasks != 0) {
            tasks_80 = tasks_80 * 100 / allTasks;
            tasks_40 = tasks_40 * 100 / allTasks;
            tasks_20 = tasks_20 * 100 / allTasks;
            tasks_10 = tasks_10 * 100 / allTasks;
            tasks_4 = tasks_4 * 100 / allTasks;
            tasks_2 = tasks_2 * 100 / allTasks;
            tasks_1 = tasks_1 * 100 / allTasks;
            int totalError = Math.abs(tasks_80 - 1);
            totalError += Math.abs(tasks_40 - 5);
            totalError += Math.abs(tasks_20 - 16);
            totalError += Math.abs(tasks_10 - 26);
            totalError += Math.abs(tasks_4 - 30);
            totalError += Math.abs(tasks_2 - 17);
            if ((totalError += Math.abs(tasks_1 - 5)) > 100) {
                totalError = 100;
            }
            this.granularity = (100.0f - (float)totalError) / 20.0f;
        } else {
            this.granularity = 0.0f;
        }
        return (float)Math.round(this.granularity * 10.0f) / 10.0f;
    }

    private void updateGranularity(int scale) {
        this.countGranularity(scale);
        this.lbGranularityResult.setToolTipText("" + this.granularity);
        this.lbGranularityResult.setIcon(this.getIcon(Math.round(this.granularity)));
    }

    private float countPrioritization(int scale) {
        int highPriority = 0;
        int middlePriority = 0;
        int lowPriority = 0;
        int allTasks = 0;
        Iterator days = Plan.getDefault().getDays(scale);
        while (days.hasNext()) {
            Day day = (Day)days.next();
            for (Task task : day.getTasks()) {
                if (task.isIdleTask()) continue;
                int taskPriority = task.getPriority();
                if (taskPriority == Task.PRIORITY_HIGH) {
                    ++highPriority;
                } else if (taskPriority == Task.PRIORITY_MEDIUM) {
                    ++middlePriority;
                } else {
                    ++lowPriority;
                }
                ++allTasks;
            }
        }
        if (allTasks != 0) {
            highPriority = highPriority * 100 / allTasks;
            middlePriority = middlePriority * 100 / allTasks;
            lowPriority = lowPriority * 100 / allTasks;
            int totalError = Math.abs(highPriority - 30);
            totalError += Math.abs(middlePriority - 50);
            this.prioritization = (100.0f - (float)(totalError += Math.abs(lowPriority - 20))) / 20.0f;
        } else {
            this.prioritization = 0.0f;
        }
        return (float)Math.round(this.prioritization * 10.0f) / 10.0f;
    }

    private void updatePrioritization(int scale) {
        this.countPrioritization(scale);
        this.lbPrioritizationResult.setToolTipText("" + this.prioritization);
        this.lbPrioritizationResult.setIcon(this.getIcon(Math.round(this.prioritization)));
    }

    private float countRepetition(int scale) {
        int allRegularTasks;
        int allDays = 0;
        int allTasks = 0;
        Hashtable<String, Integer> taskCounts = new Hashtable<String, Integer>();
        Iterator days = Plan.getDefault().getDays(scale);
        while (days.hasNext()) {
            Day day = (Day)days.next();
            for (Task task : day.getTasks()) {
                if (task.isIdleTask()) continue;
                ++allTasks;
                String description = task.getDescription();
                if (taskCounts.containsKey(description)) {
                    Integer count = (Integer)taskCounts.get(description);
                    taskCounts.put(description, new Integer(count + 1));
                    continue;
                }
                taskCounts.put(description, new Integer(1));
            }
            if (day.getTotalTime(true) == 0L) continue;
            ++allDays;
        }
        int missingRegularTasks = 0;
        int uselessRegularTasks = 0;
        int totalError = 0;
        Vector regularTasks = Plan.getDefault().getRegularTasks();
        if (allDays != 0) {
            Enumeration enumeration = taskCounts.keys();
            while (enumeration.hasMoreElements()) {
                String description = (String)enumeration.nextElement();
                Integer count = (Integer)taskCounts.get(description);
                int taskRepetition = count * 100 / allDays;
                if (taskRepetition <= 50) continue;
                boolean isRegular = false;
                for (RegularTask regularTask : regularTasks) {
                    if (!regularTask.getDescription().equals(description)) continue;
                    isRegular = true;
                    break;
                }
                if (isRegular) continue;
                ++missingRegularTasks;
            }
            for (RegularTask regularTask : regularTasks) {
                if (!taskCounts.containsKey(regularTask.getDescription())) {
                    ++uselessRegularTasks;
                    continue;
                }
                Integer count = (Integer)taskCounts.get(regularTask.getDescription());
                int taskRepetition = count * 100 / allDays;
                if (regularTask.getFrequency() == RegularTask.FREQUENCY_DAILY && taskRepetition < 60) {
                    ++uselessRegularTasks;
                }
                if (regularTask.getFrequency() != RegularTask.FREQUENCY_WORKDAY || taskRepetition >= 40) continue;
                ++uselessRegularTasks;
            }
            if (allTasks != 0) {
                totalError = missingRegularTasks * 100 / (allTasks / allDays);
            }
        }
        if ((allRegularTasks = regularTasks.size()) != 0) {
            totalError = (totalError + uselessRegularTasks * 100 / allRegularTasks) / 2;
        }
        this.repetition = totalError != 0 ? (100.0f - (float)totalError) / 20.0f : 0.0f;
        return (float)Math.round(this.repetition * 10.0f) / 10.0f;
    }

    private void updateRepetition(int scale) {
        this.countRepetition(scale);
        this.lbRepetitionResult.setToolTipText("" + this.repetition);
        this.lbRepetitionResult.setIcon(this.getIcon(Math.round(this.repetition)));
    }

    private float countStatusing(int scale) {
        int doneStatus = 0;
        int startedStatus = 0;
        int allTasks = 0;
        Iterator days = Plan.getDefault().getDays(scale);
        while (days.hasNext()) {
            Day day = (Day)days.next();
            for (Task task : day.getTasks()) {
                if (task.isIdleTask()) continue;
                int taskState = task.getState();
                if (taskState == Task.STATE_DONE) {
                    ++doneStatus;
                } else {
                    ++startedStatus;
                }
                ++allTasks;
            }
        }
        if (allTasks != 0) {
            doneStatus = doneStatus * 100 / allTasks;
            startedStatus = startedStatus * 100 / allTasks;
            int totalError = Math.abs(doneStatus - 40);
            this.statusing = (100.0f - (float)(totalError += Math.abs(startedStatus - 60))) / 20.0f;
        } else {
            this.statusing = 0.0f;
        }
        return (float)Math.round(this.statusing * 10.0f) / 10.0f;
    }

    private void updateStatusing(int scale) {
        this.countStatusing(scale);
        this.lbStatusingResult.setToolTipText("" + this.statusing);
        this.lbStatusingResult.setIcon(this.getIcon(Math.round(this.statusing)));
    }

    private long getIdleTimeAll() {
        if (this.usageTimesAll == null) {
            return 0L;
        }
        if (this.usageTimesAll.equals("")) {
            return 0L;
        }
        int firstIndex = this.usageTimesAll.indexOf("|");
        int lastIndex = this.usageTimesAll.lastIndexOf("|");
        return Long.parseLong(this.usageTimesAll.substring(firstIndex + 1, lastIndex));
    }

    private long getPrivateTimeAll() {
        if (this.usageTimesAll == null) {
            return 0L;
        }
        if (this.usageTimesAll.equals("")) {
            return 0L;
        }
        int lastIndex = this.usageTimesAll.lastIndexOf("|");
        return Long.parseLong(this.usageTimesAll.substring(lastIndex + 1));
    }

    private long getTotalTimeAll() {
        if (this.usageTimesAll == null) {
            return 0L;
        }
        if (this.usageTimesAll.equals("")) {
            return 0L;
        }
        int index = this.usageTimesAll.indexOf("|");
        return Long.parseLong(this.usageTimesAll.substring(0, index));
    }

    private long getIdleTimeUser() {
        int firstIndex = this.usageTimesUser.indexOf("|");
        int lastIndex = this.usageTimesUser.lastIndexOf("|");
        return Long.parseLong(this.usageTimesUser.substring(firstIndex + 1, lastIndex));
    }

    private long getPrivateTimeUser() {
        int lastIndex = this.usageTimesUser.lastIndexOf("|");
        return Long.parseLong(this.usageTimesUser.substring(lastIndex + 1));
    }

    private long getTotalTimeUser() {
        int index = this.usageTimesUser.indexOf("|");
        return Long.parseLong(this.usageTimesUser.substring(0, index));
    }

    private boolean downloadTimesAll() {
        String RID = Tools.getRID();
        try {
            RID = URLEncoder.encode(RID, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Error: Can't build URL to Rachota Analytics server.");
            e.printStackTrace();
        }
        final String url_string = "http://rachota.sourceforge.net/getUsageTimes.php?rid=" + RID;
        this.usageTimesAll = "";
        final Thread connectionThread = new Thread("Rachota Analytics Download Times"){

            @Override
            public void run() {
                try {
                    int character;
                    URL url = new URL(url_string);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setConnectTimeout(2000);
                    InputStream inputStream = connection.getInputStream();
                    while ((character = inputStream.read()) != -1) {
                        AnalyticsView.this.usageTimesAll = AnalyticsView.this.usageTimesAll + (char)character;
                    }
                    if (AnalyticsView.this.usageTimesAll.indexOf("Access denied.") != -1) {
                        AnalyticsView.this.usageTimesAll = "";
                    } else {
                        String start = "data: <b>";
                        String end = "</b><br>Records: ";
                        int indexStart = AnalyticsView.this.usageTimesAll.indexOf(start) + start.length();
                        int indexEnd = AnalyticsView.this.usageTimesAll.indexOf(end);
                        AnalyticsView.this.usageTimesAll = AnalyticsView.this.usageTimesAll.substring(indexStart, indexEnd);
                    }
                    connection.disconnect();
                }
                catch (Exception e) {
                    System.out.println("Error: Can't download weekly data from Rachota Analytics server.");
                    AnalyticsView.this.usageTimesAll = null;
                }
            }
        };
        connectionThread.start();
        new Thread("Rachota Analytics Download Times killer"){

            @Override
            public void run() {
                try {
                    2.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (connectionThread.isAlive()) {
                    System.out.println("Error: Giving up...");
                    connectionThread.interrupt();
                }
            }
        }.start();
        while (connectionThread.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return this.usageTimesAll != null;
    }

    private void countUserTimes(int scale) {
        float numberOfWeeks;
        long totalTimeUser = 0L;
        long idleTimeUser = 0L;
        long privateTimeUser = 0L;
        int numberOfDays = 0;
        Iterator days = Plan.getDefault().getDays(scale);
        while (days.hasNext()) {
            Day day = (Day)days.next();
            ++numberOfDays;
            for (Task task : day.getTasks()) {
                if (task.isIdleTask()) {
                    idleTimeUser += task.getDuration();
                    continue;
                }
                if (task.privateTask()) {
                    privateTimeUser += task.getDuration();
                    continue;
                }
                totalTimeUser += task.getDuration();
            }
        }
        if (scale != 0 && (numberOfWeeks = (float)numberOfDays / 7.0f) > 1.0f) {
            totalTimeUser = (int)((float)totalTimeUser / numberOfWeeks);
            idleTimeUser = (int)((float)idleTimeUser / numberOfWeeks);
            privateTimeUser = (int)((float)privateTimeUser / numberOfWeeks);
        }
        this.usageTimesUser = "" + totalTimeUser + "|" + idleTimeUser + "|" + privateTimeUser;
    }

    private void initComponents() {
        this.pnTimeUsage = new JPanel();
        this.pnChart = new JPanel();
        this.rbWeek = new JRadioButton();
        this.rbMonth = new JRadioButton();
        this.rbAllTime = new JRadioButton();
        this.pnAnalysis = new JPanel();
        this.lbEffectivity = new JLabel();
        this.lbEffectivityResult = new JLabel();
        this.lbGranularity = new JLabel();
        this.lbGranularityResult = new JLabel();
        this.lbPrioritization = new JLabel();
        this.lbPrioritizationResult = new JLabel();
        this.lbCategorization = new JLabel();
        this.lbCategorizationResult = new JLabel();
        this.lbStatusing = new JLabel();
        this.lbStatusingResult = new JLabel();
        this.lbRepetition = new JLabel();
        this.lbRepetitionResult = new JLabel();
        this.pnSuggestions = new JPanel();
        this.spSuggestions = new JScrollPane();
        this.tpSuggestions = new JTextPane();
        this.setName(Translator.getTranslation("ANALYTICSVIEW.TB_NAME"));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                AnalyticsView.this.formMouseMoved(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        this.pnTimeUsage.setBorder(BorderFactory.createTitledBorder(null, Translator.getTranslation("ANALYTICSVIEW.PN_COMPARISON"), 0, 0, this.getFont(), new Color(0, 0, 255)));
        this.pnTimeUsage.setLayout(new GridBagLayout());
        this.pnChart.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTimeUsage.add((Component)this.pnChart, gridBagConstraints);
        this.rbWeek.setFont(this.getFont());
        this.rbWeek.setMnemonic(Translator.getMnemonic("ANALYTICSVIEW.RB_WEEK"));
        this.rbWeek.setSelected(true);
        this.rbWeek.setText(Translator.getTranslation("ANALYTICSVIEW.RB_WEEK"));
        this.rbWeek.setToolTipText(Translator.getTranslation("ANALYTICSVIEW.RB_WEEK_TOOLTIP"));
        this.rbWeek.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalyticsView.this.rbWeekActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTimeUsage.add((Component)this.rbWeek, gridBagConstraints);
        this.rbMonth.setFont(this.getFont());
        this.rbMonth.setMnemonic(Translator.getMnemonic("ANALYTICSVIEW.RB_MONTH"));
        this.rbMonth.setText(Translator.getTranslation("ANALYTICSVIEW.RB_MONTH"));
        this.rbMonth.setToolTipText(Translator.getTranslation("ANALYTICSVIEW.RB_MONTH_TOOLTIP"));
        this.rbMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalyticsView.this.rbMonthActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTimeUsage.add((Component)this.rbMonth, gridBagConstraints);
        this.rbAllTime.setFont(this.getFont());
        this.rbAllTime.setMnemonic(Translator.getMnemonic("ANALYTICSVIEW.RB_ALLTIME"));
        this.rbAllTime.setText(Translator.getTranslation("ANALYTICSVIEW.RB_ALLTIME"));
        this.rbAllTime.setToolTipText(Translator.getTranslation("ANALYTICSVIEW.RB_ALLTIME_TOOLTIP"));
        this.rbAllTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalyticsView.this.rbAllTimeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnTimeUsage.add((Component)this.rbAllTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.pnTimeUsage, gridBagConstraints);
        this.pnAnalysis.setBorder(BorderFactory.createTitledBorder(null, Translator.getTranslation("ANALYTICSVIEW.PN_ANALYSIS"), 0, 0, this.getFont(), new Color(0, 0, 255)));
        this.pnAnalysis.setLayout(new GridBagLayout());
        this.lbEffectivity.setFont(this.getFont());
        this.lbEffectivity.setText(Translator.getTranslation("ANALYTICSVIEW.LB_EFFECTIVITY"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnAnalysis.add((Component)this.lbEffectivity, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnAnalysis.add((Component)this.lbEffectivityResult, gridBagConstraints);
        this.lbGranularity.setFont(this.getFont());
        this.lbGranularity.setText(Translator.getTranslation("ANALYTICSVIEW.LB_GRANULARITY"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnAnalysis.add((Component)this.lbGranularity, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnAnalysis.add((Component)this.lbGranularityResult, gridBagConstraints);
        this.lbPrioritization.setFont(this.getFont());
        this.lbPrioritization.setText(Translator.getTranslation("ANALYTICSVIEW.LB_PRIORITIZATION"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnAnalysis.add((Component)this.lbPrioritization, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnAnalysis.add((Component)this.lbPrioritizationResult, gridBagConstraints);
        this.lbCategorization.setFont(this.getFont());
        this.lbCategorization.setText(Translator.getTranslation("ANALYTICSVIEW.LB_CATEGORIZATION"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnAnalysis.add((Component)this.lbCategorization, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnAnalysis.add((Component)this.lbCategorizationResult, gridBagConstraints);
        this.lbStatusing.setFont(this.getFont());
        this.lbStatusing.setText(Translator.getTranslation("ANALYTICSVIEW.LB_STATUSING"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnAnalysis.add((Component)this.lbStatusing, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnAnalysis.add((Component)this.lbStatusingResult, gridBagConstraints);
        this.lbRepetition.setFont(this.getFont());
        this.lbRepetition.setText(Translator.getTranslation("ANALYTICSVIEW.LB_REPETITION"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnAnalysis.add((Component)this.lbRepetition, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnAnalysis.add((Component)this.lbRepetitionResult, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.pnAnalysis, gridBagConstraints);
        this.pnSuggestions.setBorder(BorderFactory.createTitledBorder(null, Translator.getTranslation("ANALYTICSVIEW.PN_SUGGESTIONS"), 0, 0, this.getFont(), new Color(0, 0, 255)));
        this.pnSuggestions.setLayout(new GridBagLayout());
        this.tpSuggestions.setEditable(false);
        this.tpSuggestions.setFont(this.getFont());
        this.spSuggestions.setViewportView(this.tpSuggestions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnSuggestions.add((Component)this.spSuggestions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.pnSuggestions, gridBagConstraints);
    }

    private void rbAllTimeActionPerformed(ActionEvent evt) {
        this.rbAllTime.setSelected(true);
        this.rbWeek.setSelected(false);
        this.rbMonth.setSelected(false);
        this.countUserTimes(2);
        this.comparisonChart.setTimes(this.getTotalTimeUser(), this.getTotalTimeAll(), this.getIdleTimeUser(), this.getIdleTimeAll(), this.getPrivateTimeUser(), this.getPrivateTimeAll());
        this.updateAnalysis(2);
        this.updateSuggestions();
    }

    private void rbWeekActionPerformed(ActionEvent evt) {
        this.rbAllTime.setSelected(false);
        this.rbWeek.setSelected(true);
        this.rbMonth.setSelected(false);
        this.countUserTimes(0);
        this.comparisonChart.setTimes(this.getTotalTimeUser(), this.getTotalTimeAll(), this.getIdleTimeUser(), this.getIdleTimeAll(), this.getPrivateTimeUser(), this.getPrivateTimeAll());
        this.updateAnalysis(0);
        this.updateSuggestions();
    }

    private void rbMonthActionPerformed(ActionEvent evt) {
        this.rbAllTime.setSelected(false);
        this.rbWeek.setSelected(false);
        this.rbMonth.setSelected(true);
        this.countUserTimes(1);
        this.comparisonChart.setTimes(this.getTotalTimeUser(), this.getTotalTimeAll(), this.getIdleTimeUser(), this.getIdleTimeAll(), this.getPrivateTimeUser(), this.getPrivateTimeAll());
        this.updateAnalysis(1);
        this.updateSuggestions();
    }

    private void formMouseMoved(MouseEvent evt) {
        Tools.recordActivity();
    }

    public void updateChart() {
        this.comparisonChart.setTimes(this.getTotalTimeUser(), 0L, this.getIdleTimeUser(), 0L, this.getPrivateTimeUser(), 0L);
        Boolean reportActivity = (Boolean)Settings.getDefault().getSetting("reportActivity");
        if (!reportActivity.booleanValue()) {
            this.comparisonChart.setMessage(Translator.getTranslation("ANALYTICSVIEW.NO_REPORT"), Translator.getTranslation("ANALYTICSVIEW.NO_REPORT_HINT"));
            return;
        }
        boolean timesDownloaded = this.downloadTimesAll();
        if (!timesDownloaded) {
            this.comparisonChart.setMessage(Translator.getTranslation("ANALYTICSVIEW.NO_CONNECTION"), Translator.getTranslation("ANALYTICSVIEW.NO_CONNECTION_HINT"));
            return;
        }
        this.comparisonChart.setMessage(Translator.getTranslation("ANALYTICSVIEW.NO_REPORT_THIS_WEEK"), Translator.getTranslation("ANALYTICSVIEW.NO_REPORT_THIS_WEEK_HINT"));
        if (this.usageTimesAll.equals("")) {
            return;
        }
        int currentWeek = Calendar.getInstance().get(3);
        String reportedWeek = (String)Settings.getDefault().getSetting("rachota.reported.week");
        if (reportedWeek == null) {
            return;
        }
        int week = Integer.parseInt(reportedWeek);
        if (week != currentWeek) {
            return;
        }
        this.comparisonChart.setTimes(this.getTotalTimeUser(), this.getTotalTimeAll(), this.getIdleTimeUser(), this.getIdleTimeAll(), this.getPrivateTimeUser(), this.getPrivateTimeAll());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("settings")) {
            this.updateChart();
        }
        this.repaint();
    }

    private void updateAnalysis(int scale) {
        this.updateCategorization(scale);
        this.updateEffectivity(scale);
        this.updateGranularity(scale);
        this.updatePrioritization(scale);
        this.updateRepetition(scale);
        this.updateStatusing(scale);
    }

    public String getWeeklyAnalysis() {
        return "" + this.countCategorization(0) + "|" + this.countEffectivity(0) + "|" + this.countGranularity(0) + "|" + this.countPrioritization(0) + "|" + this.countRepetition(0) + "|" + this.countStatusing(0);
    }

    private void updateSuggestions() {
        String suggestions = this.getSuggestions();
        this.tpSuggestions.setText(suggestions);
    }

    private ImageIcon getIcon(int ranking) {
        if (ranking > 5) {
            ranking = 5;
        }
        if (ranking < 0) {
            ranking = 0;
        }
        return new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/ranking_" + ranking + ".png"));
    }

    private String getSuggestions() {
        String suggestions = "";
        if (this.categorization + this.effectivity + this.granularity + this.prioritization + this.repetition + this.statusing == 0.0f) {
            return Translator.getTranslation("ANALYTICSVIEW.SUGGESTION_NO_DATA");
        }
        if (this.categorization < 3.0f) {
            suggestions = suggestions + "* " + Translator.getTranslation("ANALYTICSVIEW.SUGGESTION_CATEGORIZATION") + "\n";
        }
        if (this.effectivity < 3.0f) {
            suggestions = suggestions + "* " + Translator.getTranslation("ANALYTICSVIEW.SUGGESTION_EFFECTIVITY") + "\n";
        }
        if (this.granularity < 3.0f) {
            suggestions = suggestions + "* " + Translator.getTranslation("ANALYTICSVIEW.SUGGESTION_GRANULARITY") + "\n";
        }
        if (this.prioritization < 3.0f) {
            suggestions = suggestions + "* " + Translator.getTranslation("ANALYTICSVIEW.SUGGESTION_PRIORITIZATION") + "\n";
        }
        if (this.repetition < 3.0f) {
            suggestions = suggestions + "* " + Translator.getTranslation("ANALYTICSVIEW.SUGGESTION_REPETITION") + "\n";
        }
        if (this.statusing < 3.0f) {
            suggestions = suggestions + "* " + Translator.getTranslation("ANALYTICSVIEW.SUGGESTION_STATUSING");
        }
        if (suggestions.equals("")) {
            suggestions = "* " + Translator.getTranslation("ANALYTICSVIEW.SUGGESTION_NONE");
        }
        return suggestions;
    }
}

