/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.core.filters;

import java.util.Iterator;
import java.util.Vector;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.core.filters.AbstractTaskFilter;

public class IdleFilter
extends AbstractTaskFilter {
    public static final int RULE_EQUALS = 0;
    public static final int RULE_EQUALS_NOT = 1;

    public IdleFilter(int contentRule, Boolean idleProperty) {
        super(contentRule, idleProperty.toString());
    }

    public IdleFilter() {
        this(0, new Boolean(true));
    }

    @Override
    public Vector getContentRules() {
        Vector<String> contentRules = new Vector<String>();
        contentRules.add(Translator.getTranslation("FILTER.RULE_EQUALS"));
        contentRules.add(Translator.getTranslation("FILTER.RULE_EQUALS_NOT"));
        return contentRules;
    }

    @Override
    public Vector getContentValues() {
        Vector<String> contentValues = new Vector<String>();
        contentValues.add(Translator.getTranslation("FILTER.YES"));
        contentValues.add(Translator.getTranslation("FILTER.NO"));
        return contentValues;
    }

    @Override
    public String getContent() {
        int index = Boolean.parseBoolean(super.getContent()) ? 0 : 1;
        return (String)this.getContentValues().get(index);
    }

    @Override
    public Vector filterTasks(Vector tasks) {
        Vector filteredTasks = (Vector)tasks.clone();
        Iterator iterator = tasks.iterator();
        boolean privateProperty = Boolean.parseBoolean(super.getContent());
        int contentRule = this.getContentRule();
        block4: while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            switch (contentRule) {
                case 0: {
                    if (task.isIdleTask() == privateProperty) continue block4;
                    filteredTasks.remove(task);
                    continue block4;
                }
                case 1: {
                    if (task.isIdleTask() != privateProperty) continue block4;
                    filteredTasks.remove(task);
                    continue block4;
                }
            }
            System.out.println("Error: Task priority can't be filtered by content rule: " + this.getContentRules().get(contentRule));
        }
        return filteredTasks;
    }

    @Override
    public String toString() {
        return Translator.getTranslation("TASK_IDLE");
    }
}

