/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.Tools;

public class Settings {
    private static final Logger logger = Logger.getLogger(Settings.class.getName());
    private static Settings settings;
    private HashMap settingsMap;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static String ON_HIBERNATION_IGNORE;
    public static String ON_HIBERNATION_INCLUDE;
    public static String ON_HIBERNATION_ASK;
    public static final String ON_EXIT_ASK = "0";
    public static final String ON_EXIT_STOP = "1";
    public static final String ON_INACTIVITY_NOTIFY = "0";
    public static final String ON_INACTIVITY_ASK = "1";
    public static final String ON_INACTIVITY_STOP = "2";
    public static final String ACTIVITY_REPORT_FAILED = "-1";
    public static final String ACTIVITY_NOT_REPORTED = "-2";
    public static String UPLOAD_OFF;
    public static String UPLOAD_ON;
    public static String UPLOAD_SUSPENDED;
    public static final String DAY_WORKING_HOURS = "dayWorkHours";

    private Settings() {
        int index;
        this.settingsMap = new HashMap();
        this.settingsMap.put(DAY_WORKING_HOURS, "8.0");
        this.settingsMap.put("warnHoursNotReached", new Boolean(true));
        this.settingsMap.put("warnHoursExceeded", new Boolean(false));
        this.settingsMap.put("moveUnfinished", new Boolean(true));
        this.settingsMap.put("archiveNotStarted", new Boolean(false));
        this.settingsMap.put("checkPriority", new Boolean(true));
        this.settingsMap.put("displayFinishedTasks", new Boolean(false));
        this.settingsMap.put("countPrivateTasks", new Boolean(false));
        this.settingsMap.put("reportActivity", new Boolean(true));
        this.settingsMap.put("rachota.reported.week", ACTIVITY_NOT_REPORTED);
        this.settingsMap.put("detectInactivity", new Boolean(true));
        this.settingsMap.put("proxyHost", "");
        this.settingsMap.put("proxyPort", "");
        this.settingsMap.put("inactivityTime", "10");
        this.settingsMap.put("inactivityAction", "1");
        this.settingsMap.put("onExitAction", "0");
        this.settingsMap.put("runningTask", null);
        this.settingsMap.put("savingPeriod", "30");
        this.settingsMap.put("dictionary", "Dictionary_" + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry() + ".properties");
        this.settingsMap.put("size", null);
        this.settingsMap.put("location", null);
        this.settingsMap.put("automaticStart", new Boolean(true));
        this.settingsMap.put("recordStartStopTimeOnIdle", new Boolean(false));
        this.settingsMap.put("showTime", "both");
        this.settingsMap.put("backupAge", "10");
        this.settingsMap.put("startTask", new Boolean(false));
        this.settingsMap.put("logTaskEvents", new Boolean(false));
        this.settingsMap.put("hibernationTime", "10");
        this.settingsMap.put("hibernationAction", ON_HIBERNATION_ASK);
        System.setProperty("backupCreated", "" + new Date().getTime());
        this.settingsMap.put("minimizeOnStart", new Boolean(false));
        this.settingsMap.put("popupGroupByKeyword", new Boolean(false));
        this.settingsMap.put("dayViewUseEstimate", true);
        this.settingsMap.put("uploadDiary", UPLOAD_OFF);
        this.settingsMap.put("uploadDiaryUsername", "");
        this.settingsMap.put("uploadDiaryURL", "");
        URL url = Settings.class.getResource("Settings.class");
        String userDir = url.getFile();
        int n = index = System.getProperty("os.name").indexOf("Windows") != -1 ? 1 : 0;
        if (index == 1) {
            userDir = Tools.replaceAll(userDir, "/", "\\");
        }
        if (userDir.indexOf(".jar!") == -1) {
            userDir = userDir.substring(index, userDir.indexOf("Settings.class"));
        } else {
            userDir = userDir.substring(userDir.indexOf(":") + 1, userDir.indexOf(".jar!"));
            userDir = userDir.substring(index, userDir.lastIndexOf(index == 1 ? "\\" : "/"));
        }
        userDir = Tools.replaceAll(userDir, "%20", " ");
        if (!new File(userDir + File.separator + "diary.dtd").exists()) {
            userDir = System.getProperty("user.home") + File.separator + ".rachota";
            new File(userDir).mkdir();
        }
        this.settingsMap.put("userDir", userDir);
    }

    public static Settings getDefault() {
        if (settings == null) {
            settings = new Settings();
        }
        return settings;
    }

    public void setSetting(String setting, Object value) {
        this.settingsMap.put(setting, value);
        this.propertyChangeSupport.firePropertyChange("settings", null, setting);
    }

    public Object getSetting(String setting) {
        if (!setting.startsWith("font") && !setting.startsWith("system")) {
            return this.settingsMap.get(setting);
        }
        if (this.settingsMap.containsKey(setting)) {
            return this.settingsMap.get(setting);
        }
        String bundleValue = setting.startsWith("font") ? Translator.getTranslation("FONT." + setting.substring(4).toUpperCase()) : Translator.getTranslation("SYSTEM." + setting.substring(6).toUpperCase());
        this.setSetting(setting, bundleValue);
        return bundleValue;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public static void saveSettings() {
        Settings settings = Settings.getDefault();
        String userDir = (String)settings.getSetting("userDir");
        String location = userDir + File.separator + "settings.cfg";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(location));
            Set keys = settings.settingsMap.keySet();
            for (String key : keys) {
                if (key.equals("userDir")) continue;
                writer.write(key + " = " + settings.getSetting(key));
                writer.newLine();
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, Translator.getTranslation("ERROR.WRITE_ERROR", new String[]{location}), Translator.getTranslation("ERROR.ERROR_TITLE"), 0);
        }
    }

    public static void loadSettings() {
        Settings settings = Settings.getDefault();
        String userDir = (String)settings.getSetting("userDir");
        String location = userDir + File.separator + "settings.cfg";
        File settingsFile = new File(location);
        if (!settingsFile.exists()) {
            Settings.saveSettings();
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(location));
            while (reader.ready()) {
                String data = reader.readLine();
                int delimiterPosition = data.indexOf("=");
                String key = data.substring(0, delimiterPosition - 1);
                String value = data.substring(delimiterPosition + 2);
                if (value.equals("true") | value.equals("false")) {
                    settings.setSetting(key, new Boolean(value));
                    continue;
                }
                settings.setSetting(key, value);
            }
            String proxyHost = (String)settings.getSetting("proxyHost");
            String proxyPort = (String)settings.getSetting("proxyPort");
            if (proxyHost != null && proxyHost.length() > 0) {
                System.setProperty("http.proxyHost", proxyHost);
            } else {
                System.clearProperty("http.proxyHost");
            }
            if (proxyPort != null && proxyPort.length() > 0) {
                System.setProperty("http.proxyPort", proxyPort);
            } else {
                System.clearProperty("http.proxyPort");
            }
            String uploadDiary = (String)settings.getSetting("uploadDiary");
            if (uploadDiary.equals(UPLOAD_SUSPENDED)) {
                Settings.getDefault().setSetting("uploadDiary", UPLOAD_ON);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, Translator.getTranslation("ERROR.WRITE_ERROR", new String[]{location}), Translator.getTranslation("ERROR.ERROR_TITLE"), 0);
        }
    }

    public double getWorkingHours() {
        double returnValue = 8.0;
        try {
            returnValue = Double.parseDouble(this.getSetting(DAY_WORKING_HOURS).toString());
        }
        catch (NumberFormatException ex) {
            logger.log(Level.WARNING, "Unable to read setting: \"dayWorkHours\".", ex);
        }
        return returnValue;
    }

    public void setWorkingHours(double value) {
        this.setSetting(DAY_WORKING_HOURS, Double.toString(value));
    }

    public boolean getCountPrivateTasks() {
        return Boolean.valueOf(this.getSetting("countPrivateTasks").toString());
    }

    public void setCountPrivateTasks(boolean countPrivateTasks) {
        this.setSetting("countPrivateTasks", countPrivateTasks);
    }

    public boolean getUseEstimatedWorkDay() {
        return Boolean.valueOf(this.getSetting("dayViewUseEstimate").toString());
    }

    public void setUseEstimatedWorkDay(boolean useEstimate) {
        this.setSetting("dayViewUseEstimate", useEstimate);
    }

    static {
        ON_HIBERNATION_IGNORE = "0";
        ON_HIBERNATION_INCLUDE = "1";
        ON_HIBERNATION_ASK = ON_INACTIVITY_STOP;
        UPLOAD_OFF = "0";
        UPLOAD_ON = "1";
        UPLOAD_SUSPENDED = ON_INACTIVITY_STOP;
    }
}

