/* Rexx */
call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

SIGNAL ON NOVALUE

call RxFuncAdd 'RxDCFLoadFuncs', 'RXPMPAPI', 'RxDCFLoadFuncs'
call RxDCFLoadFuncs

/* Build array of events to monitor. */
events.0 = 12
events.1 = 'SwpGrow'
events.2 = 'CpuAvg'
events.3 = 'VRamFree'
events.4 = 'Drive1'
events.5 = 'Drive2'
events.6 = 'Drive3'
events.7 = 'Drive4'
events.8 = 'Drive5'
events.9 = 'Drive6'
events.10 = 'BatFree'
events.11 = 'SwpFree'
events.12 = 'RamFree'

/* Load initial count values into counts. */
call RxDCFGetStats 'dcfstats.'
do i = 1 to events.0
   evtName.i = TRANSLATE('event'||events.i||'Cnt')
   evtTime.i = TRANSLATE('event'||events.i||'LTime')
   evtCnt = evtName.i
   counts.i = dcfstats.evtCnt
end /* do */

/* Clear the user-defined field. */
call RxDCFUserDefined ''

say "Monitoring events:"
do i = 1 to events.0
   say events.i
end

/* Check for incremented count values every 5 seconds. */
do while 1
   call SysSleep 10

   call RxDCFGetStats 'dcfstats.'

   /* Check each event to see if it increased after last time. */
   do i = 1 to events.0
      evtCnt = evtName.i
      if counts.i < dcfstats.evtCnt then do
         count.i = dcfstats.evtCnt
         /* Set User Defined field to event name. */
         curTime = evtTime.i
         call RxDCFUserDefined events.i dcfstats.curTime
      end  /* Do */

      /* User might reset event counts to 0. */
      if counts.i \= dcfstats.evtCnt then
         counts.i = dcfstats.evtCnt

   end /* do */
end /* do */

