/*
================================================================================
  RPL/2 (R) version 4.1.4
  Copyright (C) 1989-2011 Dr. BERTRAND Jol

  This file is part of RPL/2.

  RPL/2 is free software; you can redistribute it and/or modify it
  under the terms of the CeCILL V2 License as published by the french
  CEA, CNRS and INRIA.
 
  RPL/2 is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the CeCILL V2 License
  for more details.
 
  You should have received a copy of the CeCILL License
  along with RPL/2. If not, write to info@cecill.info.
================================================================================
*/


#ifndef INCLUSION_RPLTYPES
#	define INCLUSION_RPLTYPES

#	ifdef RPLCONFIG
#		define HAVE_CONFIG_H
#	endif

#	ifdef HAVE_CONFIG_H

/*
--------------------------------------------------------------------------------
  Configuratoin hrite du script configure
--------------------------------------------------------------------------------
*/

#	include "rplconfig.h"

	/*
	 * Entiers
	 */

#		if (SIZEOF_CHAR == 1)
#			ifndef _INT1
#				define _INT1
				typedef signed char				integer1;
				typedef unsigned char			logical1;
				typedef logical1				unsigned_integer1;
#			endif
#		endif

#		if (SIZEOF_SHORT_INT == 2)
#			ifndef _INT2
#				define _INT2
				typedef short int				integer2;
				typedef unsigned short int		logical2;
				typedef logical2				unsigned_integer2;
#			endif
#		endif

#		if (SIZEOF_INT == 4)
#			ifndef _INT4
#				define _INT4
				typedef int						integer4;
				typedef unsigned int			logical4;
				typedef logical4				unsigned_integer4;
#			endif
#		endif

#		if (SIZEOF_LONG_INT == 4)
#			ifndef _INT4
#				define _INT4
				typedef long int				integer4;
				typedef unsigned long int		logical4;
				typedef logical4				unsigned_integer4;
#			endif
#		endif

#		if (SIZEOF_LONG_INT == 8)
#			ifndef _INT8
#				define _INT8
				typedef long long int			integer8;
				typedef unsigned long long int	logical8;
				typedef logical8				unsigned_integer8;
#			endif
#		endif

#		if (SIZEOF_LONG_LONG_INT == 8)
#			ifndef _INT8
#				define _INT8
				typedef long long int			integer8;
				typedef unsigned long long int	logical8;
				typedef logical8				unsigned_integer8;
#			endif
#		endif

#		if (SIZEOF_FLOAT == 4)
#			ifndef _REAL4
#				define _REAL4
				typedef float					real4;
#			endif
#		endif

#		if (SIZEOF_DOUBLE == 8)
#			ifndef _REAL8
#				define _REAL8
				typedef double					real8;
#			endif
#		endif

#		if (SIZEOF_LONG_DOUBLE == 8)
#			ifndef _REAL8
#				define _REAL8
				typedef long double				real8;
#			endif
#		endif

#		ifndef _INT1
#			error "INTEGER*1 is not defined !"
#		endif

#		ifndef _INT2
#			error "INTEGER*2 is not defined !"
#		endif

#		ifndef _INT4
#			error "INTEGER*4 is not defined !"
#		endif

#		ifndef _INT8
#			error "INTEGER*8 is not defined !"
#		endif

#		ifndef _REAL4
#			error "REAL*4 is not defined !"
#		endif

#		ifndef _REAL8
#			error "REAL*8 is not defined !"
#		endif
#	else

/*
--------------------------------------------------------------------------------
  Configuration par dfaut en absence du fichier rplconfig.h
--------------------------------------------------------------------------------
*/

#		warning "rplconfig.h header not found !"

		typedef unsigned char				logical1;
		typedef unsigned short int			logical2;
		typedef unsigned int				logical4;
		typedef unsigned long long int		logical8;

		typedef signed char					integer1;
		typedef short int					integer2;
		typedef int							integer4;
		typedef	long long int				integer8;

		typedef logical1					unsigned_integer1;
		typedef logical2					unsigned_integer2;
		typedef logical4					unsigned_integer4;
		typedef logical8					unsigned_integer8;

		typedef float						real4;
		typedef double						real8;
#	endif

	typedef struct complex8
	{
		real4								partie_reelle;
		real4								partie_imaginaire;
	} struct_complexe8;

	typedef struct complex16
	{
		real8								partie_reelle;
		real8								partie_imaginaire;
	} struct_complexe16;

	typedef struct_complexe8				complex8;
	typedef struct_complexe16				complex16;
#endif

// vim: ts=4
