/*===========================================================================* 
 *  RCD.CMD                                                     version 1.2  * 
 *                                                                           * 
 *  This REXX script can be used like the NCD command that is part of Norton * 
 *  Utilities.  This is my first try at creating a useful REXX script.       * 
 *  This script is FREEWARE.  Please use it all you wish, and If you can     * 
 *  improve it, please do so.  All I ask is that if you change this command  * 
 *  and distribute an improved version, that I get a copy of the changes.    * 
 *  You can contact me with suggestions or bug reports on the Internet at    * 
 *  'easyrob@cs.utexas.edu'.  Thanks.                                        * 
 *                                                                           * 
 *---------------------------------------------------------------------------* 
 *  Usage: rcd [-r| r] <dirname>                                             * 
 *                                                                           * 
 *  Flags: -r      Reads current directory structure and updates the         * 
 *                 rcd database.  The database is kept in \rcd.db on         * 
 *                 the current drive and is automatically created If         * 
 *                 it does not exist.                                        * 
 *                                                                           * 
 *  Changes current directory to a directory named in the database that      * 
 *  matches or has <dirname> as a substring.  If there is more than one      * 
 *  possible destination then each choice is shown and the ENTER key         * 
 *  chooses the destination.  The TAB and arrow keys move through the        * 
 *  list and the ESC key quits without changing the directory.               * 
 *---------------------------------------------------------------------------* 
 *  Developed by:  Robert D. Reynolds                                        * 
 *                                                                           * 
 *  The beginning: 07/07/92       RDR                                        * 
 *           v1.0: 07/10/92       RDR                                        * 
 *           v1.1: 07/11/92       RDR - Fixed bug with spaces in directory   * 
 *                                      names.                               * 
 *           v1.2: 07/14/92       RDR - Uses more REXX internal functions    * 
 *                                      fixes bug when target was not found  * 
 *                                      and problem with $DIRCMD.            * 
 *                                                                           * 
 *===========================================================================*/
"@ECHO OFF"

/*-- Get arguements ---------------------------------------------------------*/

Arg arguements
Parse Var arguements target rest

/*-- Set up variables -------------------------------------------------------*/

version = "1.2"
data_base = '\rcd.db'
re_read_db = 0
exist_db = Lines(data_base)
junk = Stream(data_base,C,'CLOSE')

/*-- Check for re-read database flag and trim Target ------------------------*/

If target="-R" | target="/R" Then 
Do
    re_read_db = 1
    If rest<>"\" & rest<>"/" Then
        target = FileSpec('NAME',rest)
End
Else If target<>"\" & target<>"/" Then 
         target = FileSpec('NAME',target)

/*-- Create database If necessary -------------------------------------------*/

If exist_db=0 | re_read_db=1 Then
Do
     If re_read_db=1 & exist_db=1 Then 
     Do
         Call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
         rc = SysFileDelete(data_base)
         If rc<>0 Then
         Do
             Say " Unable to delete database; Aborting!"
             Exit
         End
     End
     Say " Creating the database for this drive...."
     Call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
     Call SysFileTree '\*', 'db.', 'SD'
     Do i = 1 to db.0
         Call LineOut data_base, SubWord(db.i,5)
         if RC=1 Then Leave
     End
     junk = Stream(data_base,C,'CLOSE')
     If RC=0 Then
         Say " Database created successfully!"
     Else
     Do
         Say " Error occurred while creating the database!"
         Exit
     End
End

/*-- If no parameters display usage message ---------------------------------*/

If target="" & re_read_db=0 Then
Do
    Say " RCD v" || version || " by Robert D. Reynolds"
    Say ""
    Say " Usage: rcd [-r|/r] DirName"
    Say ""
    Say " Flags: -r     Reads current directory structure and updates the"
    Say "               rcd database.  The database is kept in \rcd.db on"
    Say "               the current drive and is automatically created If"
    Say "               it does not exist."
    Say ""
    Say " Changes current directory to a directory named in the database that"
    Say " matches or has DirName as a substring.  If there is more than one"
    Say " possible destination then each choice is shown and the <ENTER> key"
    Say " chooses the destination.  The <TAB> and arrow keys move through the"
    Say " list and the <ESC> key quits without changing the directory."

    Exit
End

If target="" Then Exit 
If target="\" | target="/" Then 
Do
    Call Directory "\"
    Exit
End

/*-- Scan database ----------------------------------------------------------*/

dir_list.0 = 0
matches.0 = 0
possible_dirs.0 = 0
current = directory()

Call RxFuncAdd 'SysFileSearch', 'RexxUtil', 'SysFileSearch'
Call SysFileSearch target, data_base, 'dir_list.'

Do i = 1 to dir_list.0
    d = Translate( dir_list.i )
    subd = FileSpec("NAME",d)
    If d=current Then                 /* Do not include If current directory */
        Iterate
    If target=subd Then               /* If exact match add to matches */
    Do
        j = matches.0 + 1
        matches.j = d
        matches.0 = j
    End
    If Pos(target,subd)>=1 Then       /* If substring add to possible_dirs */
    Do
        j = possible_dirs.0 + 1
        possible_dirs.j = d
        possible_dirs.0 = j
    End
End

/*-- Change directory -------------------------------------------------------*/

Select
    When matches.0=1                              /* Just one match */
        Then Call Directory matches.1
    When possible_dirs.0=1                        /* Just one possible */
        Then Call Directory possible_dirs.1
    When possible_dirs.0>1                        /* Ask user what directory */
        Then
        Do
            Call RxFuncAdd 'SysCurPos', 'RexxUtil', 'SysCurPos'
            Call RxFuncAdd 'SysGetKey', 'RexxUtil', 'SysGetKey'

            found=0
            i = 1 
            Do Forever
                Say Left(Strip(Right(possible_dirs.i,79)),79)
                Parse Value SysCurPos() With row col
                inkey = 0
                Do While inkey=224 | inkey=0      /* Throw away modIfier key */
                    Parse Value SysGetKey('NOECHO') With key
                    inkey = c2d(key)
                End
                select
                    When inkey=27                          /*ESC*/
                        Then Exit 
                    When inkey=72 | inkey=75 | inkey=15    /* UP,RT,SHFT-TAB */
                        Then If I<>1 Then I = I - 1
                    When inkey=13                          /* CR */
                        Then
                        Do 
                            found=1
                            Leave
                        End
                Otherwise
                    If I<>possible_dirs.0 Then I = I + 1
                End
                junk = SysCurPos(row-1,0)
            End
            If found Then Call Directory possible_dirs.i
        End
Otherwise
    Say " No Match Found!"
End

Exit

/*---------------------------------------------------------------------------*/
