/* This REXX script installs the QueenCy object on your WPS desktop. */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

say "QueenCy Desktop Installation Utility"
say ""
say "Do you want your QueenCy object with association to JPEG, BMP"
say "files (otherwise without associations)?"
say ""
say "(y or n)? "

key = SysGetKey('NOECHO')
parse upper var key key
if key <> 'N' then call assoc
call noassoc

noassoc:
say "Creating QueenCy object on your desktop..."

currentDirectory = directory()
programName = "\QueenCy.EXE"
iconName = "\QueenCy.ICO"
programPath = insert( currentDirectory, programName )

PRGOPTION="PROGTYPE=PM;EXENAME="||programPath||";OBJECTID=<QueenCy>;ICONFILE="||iconName||";STARTUPDIR="||currentDirectory||";ASSOCFILTER=*.ACD"

if SysCreateObject("WPProgram", ,
                   "QueenCy", ,
                   "<WP_DESKTOP>", , 
                   PRGOPTION, ,
                   "REPLACE") Then Do
    Say "QueenCy object successfully created."
    Exit 0
End

Say "Object creation was not successful!"
call end

assoc:
say "Creating QueenCy object on your desktop with associations..."

currentDirectory = directory()
programName = "\QueenCy.EXE"
iconName = "\QueenCy.ICO"
programPath = insert( currentDirectory, programName )

PRGOPTION="PROGTYPE=PM;EXENAME="||programPath||";OBJECTID=<QueenCy>;ICONFILE="||iconName||";STARTUPDIR="||currentDirectory||";ASSOCFILTER=*.ACD,*.JPG,*.BMP"

if SysCreateObject("WPProgram", ,
                   "QueenCy", ,
                   "<WP_DESKTOP>", , 
                   PRGOPTION, ,
                   "REPLACE") Then Do
    Say "QueenCy object successfully created."
    Exit 0
End

Say "Object creation was not successful!"

end:
Exit 0

