/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.video;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.video.PreviewObject;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class Preview {
    private byte[] preview_data;
    private int loadSizeForward;
    private int active_collection;
    private int processed_PID;
    private int[] position;
    private String processed_file;
    private boolean silent = true;
    private List positionList;
    private PreviewObject preview_object;
    private Object[] predefined_Pids;

    public Preview(int n) {
        this.loadSizeForward = n;
        this.position = new int[2];
        this.positionList = new ArrayList();
        this.processed_PID = -1;
        this.processed_file = "";
    }

    public String getProcessedFile() {
        return this.processed_file;
    }

    public String getProcessedPID() {
        if (this.processed_PID < 0) {
            return "no (P)ID";
        }
        return "(P)ID 0x" + Common.adaptString(Integer.toHexString(this.processed_PID).toUpperCase(), 4);
    }

    public long load(long l, int n, List list, boolean bl, boolean bl2, boolean bl3, int n2, Object[] objectArray, int n3) {
        return this.load(l, n, list, bl, bl2, bl3, n2, objectArray, n3, false);
    }

    public long load(long l, int n, List list, boolean bl, boolean bl2, boolean bl3, int n2, Object[] objectArray, int n3, boolean bl4) {
        this.predefined_Pids = objectArray;
        this.active_collection = n3;
        this.preview_data = new byte[n];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        try {
            int n7 = 0;
            while (n7 < list.size()) {
                this.preview_object = (PreviewObject)list.get(n7);
                n4 = this.preview_object.getType();
                if (l < this.preview_object.getEnd()) {
                    XInputFile xInputFile = this.preview_object.getFile();
                    xInputFile.randomAccessOpen("r");
                    xInputFile.randomAccessSeek(l - this.preview_object.getStart());
                    xInputFile.randomAccessRead(this.preview_data, n6, n);
                    xInputFile.randomAccessClose();
                    if (this.preview_object.getEnd() - l < (long)n && n7 < list.size() - 1) {
                        int n8 = (int)(this.preview_object.getEnd() - l);
                        byte[] byArray = new byte[n];
                        this.preview_object = (PreviewObject)list.get(++n7);
                        xInputFile = this.preview_object.getFile();
                        xInputFile.randomAccessSingleRead(byArray, 0L);
                        System.arraycopy(byArray, 0, this.preview_data, n8, n - n8);
                        byArray = null;
                    }
                    n5 = xInputFile.getStreamInfo().getStreamSubType();
                    break;
                }
                ++n7;
            }
            this.preview_data = this.search(this.preview_data, l, n4, n5);
            long l2 = Common.getMpvDecoderClass().decodeArray(this.preview_data, bl, bl2, bl3, n2, bl4);
            int n9 = this.positionList.size() - 1;
            while (n9 >= 0) {
                this.position = (int[])this.positionList.get(n9);
                if ((long)this.position[1] <= l2) {
                    l += (long)this.position[0];
                    n9 = 0;
                }
                --n9;
            }
            if (this.positionList.size() == 0) {
                l += l2;
            }
            int n10 = 0;
            while (!bl4 && n10 < list.size()) {
                this.preview_object = (PreviewObject)list.get(n10);
                if (l < this.preview_object.getEnd()) {
                    this.processed_file = n10 + "/" + (list.size() - 1) + " - " + this.preview_object.getFile().getName();
                    break;
                }
                ++n10;
            }
            this.preview_data = null;
            if (!bl4) {
                Common.getMpvDecoderClass().setProcessedPosition(l, list);
                Common.getMpvDecoderClass().setPidAndFileInfo(String.valueOf(this.getProcessedPID()) + "   Part: " + this.getProcessedFile());
                Common.getGuiInterface().repaintPicturePanel();
            }
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
        return l;
    }

    private byte[] parseMPG1(byte[] byArray, int[] nArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        int n = 0;
        int n2 = 7;
        int n3 = 6;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        int n7 = byArray.length - n2;
        while (n6 < n7) {
            int n8 = CommonParsing.validateStartcode(byArray, n6);
            if (n8 < 0) {
                n6 += -n8;
                continue;
            }
            int n9 = CommonParsing.getPES_IdField(byArray, n6);
            if (n9 < 185) {
                n6 += 4;
                continue;
            }
            if (bl) {
                byteArrayOutputStream.write(byArray, n, n6 - n);
            }
            n = n6;
            if (nArray.length > 0 && Arrays.binarySearch(nArray, n9) < 0) {
                bl = false;
            } else if ((n5 == n9 || n5 == -1) && (0xF0 & n9) == 224) {
                n5 = n9;
                int n10 = n6 + n3;
                block12: while (true) {
                    switch (0xC0 & byArray[n10]) {
                        case 64: {
                            n10 += 2;
                            continue block12;
                        }
                        case 128: {
                            n10 += 3;
                            continue block12;
                        }
                        case 192: {
                            ++n10;
                            continue block12;
                        }
                    }
                    switch (0x30 & byArray[n10]) {
                        default: {
                            continue block12;
                        }
                        case 32: {
                            n10 += 5;
                            break block12;
                        }
                        case 48: {
                            n10 += 10;
                            break block12;
                        }
                        case 16: {
                            n10 += 5;
                            break block12;
                        }
                        case 0: {
                            ++n10;
                            break block12;
                        }
                    }
                    break;
                }
                n = n10;
                int[] nArray2 = new int[]{n6, byteArrayOutputStream.size()};
                this.positionList.add(nArray2);
                bl = true;
            } else {
                bl = false;
            }
            int n11 = n9 < 187 ? 12 : 0;
            n4 = CommonParsing.getPES_LengthField(byArray, n6);
            if (n4 == 0) {
                n11 = n2;
            }
            n6 += n11 == 0 ? n3 + n4 : n11;
        }
        this.processed_PID = n5;
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] parseMPG2(byte[] byArray, int[] nArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        int n = 0;
        int n2 = 9;
        int n3 = 6;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        int n7 = byArray.length - n2;
        while (n6 < n7) {
            int n8 = CommonParsing.validateStartcode(byArray, n6);
            if (n8 < 0) {
                n6 += -n8;
                continue;
            }
            int n9 = CommonParsing.getPES_IdField(byArray, n6);
            if (n9 < 185) {
                n6 += 4;
                continue;
            }
            if (bl) {
                byteArrayOutputStream.write(byArray, n, n6 - n);
            }
            n = n6;
            if (nArray.length > 0 && Arrays.binarySearch(nArray, n9) < 0) {
                bl = false;
            } else if ((n5 == n9 || n5 == -1) && (0xF0 & n9) == 224) {
                n5 = n9;
                n = n6 + n2 + CommonParsing.getPES_ExtensionLengthField(byArray, n6);
                int[] nArray2 = new int[]{n6, byteArrayOutputStream.size()};
                this.positionList.add(nArray2);
                bl = true;
            } else {
                bl = false;
            }
            int n10 = n9 < 187 ? 12 : 0;
            n4 = CommonParsing.getPES_LengthField(byArray, n6);
            if (n4 == 0) {
                n10 = n2;
            }
            n6 += n10 == 0 ? n3 + n4 : n10;
        }
        this.processed_PID = n5;
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] parsePVA(byte[] byArray, int[] nArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        int n = 0;
        int n2 = 8;
        int n3 = 8;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        int n7 = byArray.length - n2;
        while (n6 < n7) {
            if ((0xFF & byArray[n6]) != 65 || (0xFF & byArray[n6 + 1]) != 86 || (0xFF & byArray[n6 + 4]) != 85) {
                ++n6;
                continue;
            }
            if (bl) {
                byteArrayOutputStream.write(byArray, n, n6 - n);
            }
            n = n6;
            int n8 = 0xFF & byArray[n6 + 2];
            if (n8 == 1) {
                n5 = 1;
                n = (0x10 & byArray[n6 + 5]) != 0 ? n6 + n3 + 4 : n6 + n3;
                int[] nArray2 = new int[]{n6, byteArrayOutputStream.size()};
                this.positionList.add(nArray2);
                bl = true;
            } else {
                bl = false;
            }
            n4 = (0xFF & byArray[n6 + 6]) << 8 | 0xFF & byArray[n6 + 7];
            n6 += n3 + n4;
        }
        this.processed_PID = n5;
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] parseTS(byte[] byArray, int[] nArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[]{91, 72, 79, 74, 73, 78, 32, 65};
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = 0;
        int n4 = byArray.length - 9;
        while (n3 < n4) {
            block22: {
                int n5;
                block25: {
                    block24: {
                        block23: {
                            block21: {
                                if (byArray[n3] != 127 || byArray[n3 + 1] != 65 || byArray[n3 + 2] != 4 || byArray[n3 + 3] != -3) break block21;
                                if (bl && n <= n3) {
                                    byteArrayOutputStream.write(byArray, n, n3 - n);
                                }
                                bl = false;
                                n = (n3 += 1183) + 1;
                                break block22;
                            }
                            if (n3 >= byArray.length - 5 || byArray[n3 + 2] != 0 || byArray[n3 + 3] != 0 || byArray[n3 + 4] != 71) break block23;
                            if (bl && n <= n3) {
                                byteArrayOutputStream.write(byArray, n, n3 - n);
                            }
                            bl = false;
                            n = (n3 += 3) + 1;
                            break block22;
                        }
                        if (n3 >= byArray.length - 36 || byArray[n3 + 2] != 0 || byArray[n3 + 3] != 0 || byArray[n3 + 36] != 71) break block24;
                        if (bl && n <= n3) {
                            byteArrayOutputStream.write(byArray, n, n3 - n);
                        }
                        bl = false;
                        n = (n3 += 35) + 1;
                        break block22;
                    }
                    if (n3 >= byArray.length || byArray[n3] != 71) break block22;
                    n5 = 0;
                    if (n3 >= byArray.length - 188 || byArray[n3 + 188] == 71 || byArray[n3 + 188] == 127) break block25;
                    int n6 = n3 + 188;
                    int n7 = n3 + 189;
                    int n8 = byArray2.length;
                    while (n6 > n3) {
                        int n9 = 0;
                        while (n6 > n3 && byArray[n6] != byArray2[n9]) {
                            --n6;
                        }
                        while (n6 > n3 && n9 < n8 && n6 + n9 < n7) {
                            if (byArray[n6 + n9] != byArray2[n9]) break;
                            ++n9;
                        }
                        if (n9 <= 0) continue;
                        if (n9 < n8 && n6 + n9 < n7) {
                            --n6;
                            continue;
                        }
                        if (n6 + 512 + (n7 - n6) >= byArray.length) break;
                        n5 = 512;
                        System.arraycopy(byArray, n6 + n5, byArray, n6, n7 - n6 - 1);
                        System.arraycopy(byArray, n3, byArray, n3 + n5, n6 - n3);
                        break;
                    }
                    if (!(n5 == 0 && n3 < byArray.length - 224 && byArray[n3 + 190] == 0 && byArray[n3 + 191] == 0 && byArray[n3 + 224] == 71 || n5 == 0 && n3 < byArray.length - 224 && byArray[n3 + 190] == 0 && byArray[n3 + 191] == 0 && byArray[n3 + 192] == 71) && n5 == 0) break block22;
                }
                if (bl && n <= n3) {
                    byteArrayOutputStream.write(byArray, n, n3 - n);
                }
                n = n3;
                int n10 = (0x1F & byArray[n3 + 1]) << 8 | 0xFF & byArray[n3 + 2];
                if (nArray.length > 0 && Arrays.binarySearch(nArray, n10) < 0) {
                    bl = false;
                } else if ((n2 == n10 || n2 == -1) && (0xD & byArray[n3 + 3] >>> 4) == 1) {
                    n = (0x20 & byArray[n3 + 3]) != 0 ? n3 + 5 + (0xFF & byArray[n3 + 4]) : n3 + 4;
                    if ((0x40 & byArray[n3 + 1]) != 0) {
                        if (byArray[n] == 0 && byArray[n + 1] == 0 && byArray[n + 2] == 1 && (0xF0 & byArray[n + 3]) == 224) {
                            n2 = n10;
                            n = n + 9 + (0xFF & byArray[n + 8]);
                            int[] nArray2 = new int[]{n3, byteArrayOutputStream.size()};
                            this.positionList.add(nArray2);
                        } else {
                            bl = false;
                        }
                    }
                    if (n2 == n10) {
                        bl = true;
                    }
                } else {
                    bl = false;
                }
                n3 += 187;
                n3 += n5;
                n += n5;
            }
            ++n3;
        }
        if (bl && n < byArray.length && n3 <= byArray.length) {
            byteArrayOutputStream.write(byArray, n, n3 - n);
        }
        this.processed_PID = n2;
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] parseTS192(byte[] byArray, int[] nArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = 0;
        int n4 = byArray.length - 9;
        while (n3 < n4) {
            if (n3 < byArray.length - 192 && byArray[n3] == 71) {
                if (bl && n <= n3) {
                    byteArrayOutputStream.write(byArray, n, n3 - n - 4);
                }
                n = n3;
                int n5 = (0x1F & byArray[n3 + 1]) << 8 | 0xFF & byArray[n3 + 2];
                if (nArray.length > 0 && Arrays.binarySearch(nArray, n5) < 0) {
                    bl = false;
                } else if ((n2 == n5 || n2 == -1) && (0xD & byArray[n3 + 3] >>> 4) == 1) {
                    n = (0x20 & byArray[n3 + 3]) != 0 ? n3 + 5 + (0xFF & byArray[n3 + 4]) : n3 + 4;
                    if ((0x40 & byArray[n3 + 1]) != 0) {
                        if (byArray[n] == 0 && byArray[n + 1] == 0 && byArray[n + 2] == 1 && (0xF0 & byArray[n + 3]) == 224) {
                            n2 = n5;
                            n = n + 9 + (0xFF & byArray[n + 8]);
                            int[] nArray2 = new int[]{n3, byteArrayOutputStream.size()};
                            this.positionList.add(nArray2);
                        } else {
                            bl = false;
                        }
                    }
                    if (n2 == n5) {
                        bl = true;
                    }
                } else {
                    bl = false;
                }
                n3 += 191;
            }
            ++n3;
        }
        this.processed_PID = n2;
        return byteArrayOutputStream.toByteArray();
    }

    public long previewFile(XInputFile xInputFile, long l, int n, boolean bl, boolean bl2, int n2) {
        this.preview_data = new byte[n];
        this.predefined_Pids = new Object[0];
        int n3 = xInputFile.getStreamInfo().getStreamType();
        int n4 = xInputFile.getStreamInfo().getStreamSubType();
        try {
            xInputFile.randomAccessOpen("r");
            xInputFile.randomAccessSeek(l);
            xInputFile.randomAccessRead(this.preview_data, 0, n);
            xInputFile.randomAccessClose();
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        this.preview_data = this.search(this.preview_data, l, n3, n4);
        long l2 = Common.getMpvDecoderClass().decodeArray(this.preview_data, false, bl, bl2, n2, true);
        this.preview_data = null;
        return l += l2;
    }

    private byte[] search(byte[] byArray, long l, int n, int n2) {
        this.positionList.clear();
        int[] nArray = new int[this.predefined_Pids.length];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = Integer.parseInt(this.predefined_Pids[n3].toString().substring(2), 16);
            ++n3;
        }
        Arrays.sort(nArray);
        switch (n) {
            case 8: {
                return byArray;
            }
            case 1: 
            case 3: {
                return this.parseMPG2(byArray, nArray);
            }
            case 2: {
                return this.parseMPG1(byArray, nArray);
            }
            case 4: {
                return this.parsePVA(byArray, nArray);
            }
            case 5: {
                if (n2 == 5) {
                    return this.parseTS192(byArray, nArray);
                }
                return this.parseTS(byArray, nArray);
            }
        }
        return byArray;
    }

    public long silentload(long l, int n, List list, boolean bl, boolean bl2, boolean bl3, int n2, Object[] objectArray, int n3) {
        return this.load(l, n, list, bl, bl2, bl3, n2, objectArray, n3, true);
    }
}

