/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.util.ArrayList;

public class TS_PMTParser {
    private int last_version_number = -1;
    private int service_id = -1;
    private int pmt_pid = -1;
    private int pcr_pid = -1;
    private int pid_mask = 8191;
    private int pid_mask_inv = 57344;
    private int length_mask = 4095;
    private int length_mask_inv = 61440;
    private ArrayList video_streams = null;
    private ArrayList audio_streams = null;
    private ArrayList teletext_streams = null;
    private ArrayList subtitle_streams = null;

    public TS_PMTParser(int n, int n2) {
        this.pmt_pid = n2;
        this.service_id = n;
    }

    private void getDescriptor(byte[] byArray, int n, int n2, int n3, int n4) {
        String string = "";
        int n5 = 0;
        int n6 = n + n2;
        try {
            block33: while (n < n6 && n < byArray.length) {
                switch (0xFF & byArray[n]) {
                    case 89: {
                        int n7;
                        int n8;
                        int n9;
                        n4 = 89;
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = String.valueOf(string) + "(";
                        int n10 = n + 2;
                        while (n10 < n5) {
                            n9 = n10;
                            while (n9 < n10 + 3) {
                                string = String.valueOf(string) + (char)(0xFF & byArray[n9]);
                                ++n9;
                            }
                            n8 = 0xFF & byArray[n10 + 3];
                            n7 = (0xFF & byArray[n10 + 4]) << 16 | 0xFF & byArray[n10 + 5];
                            int n11 = (0xFF & byArray[n10 + 6]) << 16 | 0xFF & byArray[n10 + 7];
                            string = String.valueOf(string) + "_0x" + Integer.toHexString(n8).toUpperCase();
                            string = String.valueOf(string) + "_p" + n7;
                            string = String.valueOf(string) + "_a" + n11 + " ";
                            n10 += 8;
                        }
                        string = String.valueOf(string) + ")";
                        break block33;
                    }
                    case 86: {
                        int n7;
                        int n8;
                        int n9;
                        n4 = 86;
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = String.valueOf(string) + "(";
                        int n10 = n + 2;
                        while (n10 < n5) {
                            n9 = n10;
                            while (n9 < n10 + 3) {
                                string = String.valueOf(string) + (char)(0xFF & byArray[n9]);
                                ++n9;
                            }
                            n8 = (0xF8 & byArray[n10 + 3]) >>> 3;
                            n7 = 0xFF & byArray[n10 + 4];
                            string = String.valueOf(string) + "_";
                            switch (n8) {
                                case 1: {
                                    string = String.valueOf(string) + "i";
                                    break;
                                }
                                case 2: {
                                    string = String.valueOf(string) + "s";
                                    break;
                                }
                                case 3: {
                                    string = String.valueOf(string) + "ai";
                                    break;
                                }
                                case 4: {
                                    string = String.valueOf(string) + "ps";
                                    break;
                                }
                                case 5: {
                                    string = String.valueOf(string) + "s.hip";
                                    break;
                                }
                                default: {
                                    string = String.valueOf(string) + "res";
                                }
                            }
                            string = String.valueOf(string) + Integer.toHexString((7 & byArray[n10 + 3]) == 0 ? 8 : 7 & byArray[n10 + 3]).toUpperCase();
                            string = String.valueOf(string) + (n7 < 16 ? "0" : "") + Integer.toHexString(n7).toUpperCase() + " ";
                            n10 += 5;
                        }
                        string = String.valueOf(string) + ")";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 10: {
                        string = String.valueOf(string) + "(";
                        int n10 = n + 2;
                        while (n10 < n + 5) {
                            string = String.valueOf(string) + (char)(0xFF & byArray[n10]);
                            ++n10;
                        }
                        string = String.valueOf(string) + ")";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 106: {
                        string = String.valueOf(string) + "(AC-3)";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 195: {
                        switch (0xFF & byArray[++n + 1]) {
                            case 4: {
                                string = String.valueOf(string) + "(VPS)";
                                n4 = 195;
                                break;
                            }
                            case 5: {
                                string = String.valueOf(string) + "(WSS)";
                                break;
                            }
                            case 6: {
                                string = String.valueOf(string) + "(CC)";
                                break;
                            }
                            case 1: {
                                string = String.valueOf(string) + "(EBU-TTX)";
                                break;
                            }
                            case 7: {
                                string = String.valueOf(string) + "(VBI)";
                                break;
                            }
                        }
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 82: {
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = String.valueOf(string) + "(#" + (0xFF & byArray[n + 2]) + ")";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 107: {
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = String.valueOf(string) + "(RDS)";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 5: {
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = String.valueOf(string) + "(";
                        int n10 = n + 2;
                        while (n10 < n5) {
                            string = String.valueOf(string) + (char)(0xFF & byArray[n10]);
                            ++n10;
                        }
                        string = String.valueOf(string) + ")";
                    }
                    default: {
                        ++n;
                        n += 0xFF & byArray[n];
                    }
                }
                ++n;
            }
            String string2 = "PID: 0x" + Integer.toHexString(n3).toUpperCase();
            switch (n4) {
                case 89: {
                    this.subtitle_streams.add(String.valueOf(n3));
                    break;
                }
                case 86: {
                    this.teletext_streams.add(String.valueOf(n3));
                    break;
                }
                case 2: {
                    this.video_streams.add(String.valueOf(n3));
                    break;
                }
                case 4: {
                    this.audio_streams.add(String.valueOf(n3));
                    break;
                }
                default: {
                    this.audio_streams.add(String.valueOf(n3));
                    break;
                }
                case 27: 
                case 195: {
                    return;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public int getPID() {
        return this.pmt_pid;
    }

    public int getServiceID() {
        return this.service_id;
    }

    private int getValue(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n + n2 - 1;
        while (n4 < n2) {
            n3 |= (0xFF & byArray[n5 - n4]) << n4 * 8;
            ++n4;
        }
        return n3;
    }

    public int parsePMT(byte[] byArray) {
        int n;
        if (byArray.length < 6) {
            return -1;
        }
        int n2 = this.getValue(byArray, 0, 2);
        int n3 = this.getValue(byArray, 2, 1);
        if (n2 != 2 || (0xF0 & n3) != 176) {
            return -2;
        }
        int n4 = this.length_mask & this.getValue(byArray, 2, 2);
        if (n4 > byArray.length - 4) {
            n4 = byArray.length - 4;
        }
        if (this.service_id != (n = this.getValue(byArray, 4, 2))) {
            return -3;
        }
        n3 = this.getValue(byArray, 6, 1);
        if ((0xC0 & n3) != 192) {
            return -4;
        }
        int n5 = 0x1F & n3 >> 1;
        if (this.last_version_number >= 0 && this.last_version_number == n5) {
            return -5;
        }
        int n6 = n3 & 1;
        if (n6 == 0) {
            return -6;
        }
        int n7 = this.getValue(byArray, 7, 1);
        int n8 = this.getValue(byArray, 8, 1);
        n3 = this.getValue(byArray, 9, 2);
        if ((n3 & this.pid_mask_inv) != this.pid_mask_inv) {
            return -7;
        }
        this.pcr_pid = n3 & this.pid_mask;
        n3 = this.getValue(byArray, 11, 2);
        if ((n3 & this.length_mask_inv) != this.length_mask_inv) {
            return -8;
        }
        int n9 = this.length_mask & n3;
        int n10 = 13 + n9;
        while (n10 < n4 + 4 && n10 < byArray.length) {
            int n11 = this.getValue(byArray, n10++, 1);
            n3 = this.getValue(byArray, n10 += 2, 2);
            if ((n3 & this.pid_mask_inv) != this.pid_mask_inv) continue;
            int n12 = this.pid_mask & n3;
            n3 = this.getValue(byArray, n10 += 2, 2);
            if ((n3 & this.length_mask_inv) != this.length_mask_inv) continue;
            n9 = this.length_mask & n3;
            switch (n11) {
                case 1: 
                case 2: {
                    this.getDescriptor(byArray, n10, n9, n12, 2);
                    break;
                }
                case 3: 
                case 4: {
                    this.getDescriptor(byArray, n10, n9, n12, 4);
                    break;
                }
                case 27: {
                    this.getDescriptor(byArray, n10, n9, n12, 27);
                    break;
                }
                case 6: 
                case 128: 
                case 129: 
                case 130: 
                case 131: {
                    this.getDescriptor(byArray, n10, n9, n12, 6);
                    break;
                }
            }
            n10 += n9;
        }
        this.last_version_number = n5;
        return 0;
    }
}

