/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.JobProcessing;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.io.IDDBufferedOutputStream;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.parser.StreamProcessBase;
import net.sourceforge.dvb.projectx.subtitle.BMP;
import net.sourceforge.dvb.projectx.subtitle.Bitmap;
import net.sourceforge.dvb.projectx.subtitle.ColorAreas;
import net.sourceforge.dvb.projectx.subtitle.Subpicture;
import net.sourceforge.dvb.projectx.subtitle.Sup2VobSub;
import net.sourceforge.dvb.projectx.thirdparty.Ifo;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class StreamProcessSubpicture
extends StreamProcessBase {
    private final String[] subdecode_errors = new String[]{"", "", "", Resource.getString("subpicture.msg.error3"), Resource.getString("subpicture.msg.error4"), Resource.getString("subpicture.msg.error5"), Resource.getString("subpicture.msg.error6"), Resource.getString("subpicture.msg.error7"), Resource.getString("subpicture.msg.error8"), Resource.getString("subpicture.msg.error9")};
    private String Extension = ".new";
    private boolean debug;
    private boolean KeepOriginalTimecode;
    private boolean ExportAsVobSub;
    private boolean UseAdditionalOffset;
    private boolean ShowSubpictureWindow;
    private boolean Message_2;
    private int AdditionalOffset_Value;
    private int X_Offset = 0;
    private int Y_Offset = 0;
    private int DisplayMode = 0;
    private int ExportType = 0;
    private int Pictures = 0;
    private int LastPGCSet = 0;
    private String SubpictureColorModel;
    private String PageId_Value;
    private String SubtitleExportFormat;
    private String FileParent;

    public StreamProcessSubpicture(String string) {
        this.Extension = string;
    }

    public StreamProcessSubpicture(JobCollection jobCollection, XInputFile xInputFile, String string, String string2, String string3, int n) {
        this.get_XY_Offset(jobCollection, n);
        this.getDisplayMode(jobCollection, n);
        String string4 = jobCollection.getSettings().getProperty(Keys.KEY_SubtitleExportFormat);
        this.processStream(jobCollection, xInputFile, string, string2, string3, n, string4);
        string4 = jobCollection.getSettings().getProperty(Keys.KEY_SubtitleExportFormat_2);
        if (!string4.equalsIgnoreCase("null")) {
            this.processStream(jobCollection, xInputFile, string, string2, string3, n, string4);
        }
    }

    private void getDisplayMode(JobCollection jobCollection, int n) {
        this.DisplayMode = jobCollection.getSettings().getIntProperty(Keys.KEY_SubtitleChangeDisplay);
    }

    private void get_XY_Offset(JobCollection jobCollection, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(jobCollection.getSettings().getProperty(Keys.KEY_SubtitleMovePosition_Value), ",");
        int n2 = 0;
        int[] nArray = new int[2];
        while (stringTokenizer.hasMoreTokens() && n2 < nArray.length) {
            try {
                nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (Exception exception) {}
            ++n2;
        }
        this.X_Offset = nArray[0];
        this.Y_Offset = nArray[1];
    }

    public void processStream(JobCollection jobCollection, XInputFile xInputFile, int n) {
        this.processStream(jobCollection, xInputFile, "-1", "sp", "-1", n, Keys.ITEMS_SubtitleExportFormat[7].toString());
    }

    private void processStream(JobCollection jobCollection, XInputFile xInputFile, String string, String string2, String string3, int n, String string4) {
        Subpicture subpicture = Common.getSubpictureClass();
        JobProcessing jobProcessing = jobCollection.getJobProcessing();
        String string5 = n == 1 ? jobCollection.getOutputName(xInputFile.getName()) : xInputFile.getName();
        this.FileParent = jobCollection.getOutputNameParent(string5);
        this.FileParent = String.valueOf(this.FileParent) + (n == 1 ? this.Extension : "");
        String string6 = String.valueOf(this.FileParent) + ".sup";
        long l = xInputFile.length();
        byte[] byArray = new byte[12];
        byte[] byArray2 = new byte[]{};
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = -1L;
        long l9 = 0L;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.ExportType = 0;
        this.Pictures = 0;
        this.LastPGCSet = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        this.debug = jobCollection.getSettings().getBooleanProperty(Keys.KEY_DebugLog);
        this.KeepOriginalTimecode = n == 1 ? true : jobCollection.getSettings().getBooleanProperty(Keys.KEY_SubtitlePanel_keepOriginalTimecode);
        this.ExportAsVobSub = jobCollection.getSettings().getBooleanProperty(Keys.KEY_SubtitlePanel_exportAsVobSub);
        this.UseAdditionalOffset = jobCollection.getSettings().getBooleanProperty(Keys.KEY_additionalOffset);
        this.ShowSubpictureWindow = jobCollection.getSettings().getBooleanProperty(Keys.KEY_showSubpictureWindow);
        this.Message_2 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_MessagePanel_Msg2);
        this.AdditionalOffset_Value = jobCollection.getSettings().getIntProperty(Keys.KEY_ExportPanel_additionalOffset_Value);
        this.SubpictureColorModel = jobCollection.getSettings().getProperty(Keys.KEY_SubpictureColorModel);
        this.PageId_Value = jobCollection.getSettings().getProperty(Keys.KEY_SubtitlePanel_PageId_Value);
        try {
            int n5;
            if (this.ShowSubpictureWindow) {
                Common.getGuiInterface().showSubpicture();
            }
            Hashtable hashtable = new Hashtable();
            ArrayList arrayList = Common.getColorModelsList();
            if (arrayList.indexOf(this.SubpictureColorModel) > 2) {
                hashtable = Common.getUserColourTable(this.SubpictureColorModel);
            }
            subpicture.reset();
            subpicture.dvb.setIRD(2 << arrayList.indexOf(this.SubpictureColorModel), hashtable, this.debug, this.PageId_Value);
            Common.setMessage(String.valueOf(Resource.getString("subpicture.msg.model", this.SubpictureColorModel)) + " " + this.PageId_Value);
            if (string4.equalsIgnoreCase(Keys.ITEMS_SubtitleExportFormat[6].toString())) {
                string6 = String.valueOf(this.FileParent) + ".son";
                this.ExportType = 1;
            }
            Common.setMessage(String.valueOf(Resource.getString("subpicture.msg.output")) + " " + string6.substring(string6.length() - 3));
            PushbackInputStream pushbackInputStream = new PushbackInputStream(xInputFile.getInputStream(), 65536);
            IDDBufferedOutputStream iDDBufferedOutputStream = new IDDBufferedOutputStream(new FileOutputStream(string6), 65536);
            PrintStream printStream = new PrintStream(iDDBufferedOutputStream);
            Common.setMessage(Resource.getString("subpicture.msg.tmpfile", xInputFile.getName(), String.valueOf(l)));
            if (this.ExportType == 0) {
                subpicture.set_XY_Offset(this.X_Offset, this.Y_Offset);
                subpicture.setDisplayMode(this.DisplayMode);
            }
            if (this.X_Offset != 0 || this.Y_Offset != 0) {
                Common.setMessage("-> move source picture position: X " + this.X_Offset + ", Y " + this.Y_Offset);
            }
            if (this.DisplayMode != 0) {
                Common.setMessage("-> set new picture display mode: " + Keys.ITEMS_SubtitleChangeDisplay[this.DisplayMode]);
            }
            Common.updateProgressBar(String.valueOf(Resource.getString("subpicture.progress")) + " " + xInputFile.getName(), 0L, 0L);
            long[] lArray = new long[1];
            long[] lArray2 = new long[1];
            long[] lArray3 = new long[1];
            long l10 = this.UseAdditionalOffset ? 90L * (long)this.AdditionalOffset_Value : 0L;
            long[][] lArray4 = this.loadTempOtherPts(string, "subpicture.msg.discard", "audio.msg.pts.firstonly", "subpicture.msg.pts.start_end", "", 5, false, this.debug);
            if (lArray4 != null) {
                lArray = lArray4[0];
                lArray2 = lArray4[1];
                bl2 = true;
                lArray4 = null;
            }
            bl2 = true;
            lArray4 = this.loadTempVideoPts(string3, this.debug);
            if (lArray4 != null) {
                lArray3 = lArray4[0];
                bl = true;
                lArray4 = null;
            }
            if (bl && bl2) {
                n5 = this.checkPTSMatch(lArray3, lArray);
                if (n5 < 0) {
                    Common.setMessage(Resource.getString("subpicture.msg.pts.mismatch"));
                    bl = false;
                    n2 = 0;
                } else {
                    n2 = n5;
                }
            }
            if (bl && bl2) {
                Common.setMessage(Resource.getString("subpicture.msg.adjust.at.video"));
                l4 = lArray3[0];
            }
            if (!bl && bl2) {
                Common.setMessage(Resource.getString("subpicture.msg.adjust.at.own"));
                l4 = 0L;
            }
            if (bl2) {
                l6 = lArray[n2];
                l3 = lArray2[n2];
            }
            lArray = null;
            lArray2 = null;
            while (l2 < l3) {
                l2 += pushbackInputStream.skip(l3 - l2);
            }
            while (l2 < l) {
                Common.updateProgressBar(l2, l);
                while (this.pause()) {
                }
                if (CommonParsing.isProcessCancelled()) {
                    CommonParsing.setProcessCancelled(false);
                    jobProcessing.setSplitSize(0L);
                    break;
                }
                pushbackInputStream.read(byArray, 0, 12);
                if (byArray[0] != 83 || byArray[1] != 80) {
                    if (this.Message_2 && !bl4) {
                        Common.setMessage(String.valueOf(Resource.getString("subpicture.msg.syncword.lost")) + " " + l2);
                    }
                    bl4 = true;
                    ++l2;
                    pushbackInputStream.unread(byArray, 1, 11);
                    continue;
                }
                if (this.Message_2 && bl4) {
                    Common.setMessage(String.valueOf(Resource.getString("subpicture.msg.syncword.found")) + " " + l2);
                }
                pushbackInputStream.unread(byArray, 0, 12);
                bl4 = false;
                n4 = ((0xFF & byArray[10]) << 8 | 0xFF & byArray[11]) + 10;
                byArray2 = new byte[n4];
                pushbackInputStream.read(byArray2);
                l2 += (long)n4;
                l6 = 0L;
                n5 = 0;
                while (n5 < 5) {
                    l6 |= (0xFFL & (long)byArray2[2 + n5]) << n5 * 8;
                    ++n5;
                }
                if (string.equals("-1")) {
                    l6 += l10;
                }
                if (l6 == l10 && l8 != -1L) {
                    l6 = l9;
                } else {
                    l9 = l6;
                }
                if (l8 == -1L) {
                    l8 = l6;
                }
                if (this.debug) {
                    System.out.println(" " + (l2 - (long)n4) + "/ " + n4 + "/ " + l6);
                }
                if (bl2) {
                    bl3 = bl ^ true;
                    while (bl && n3 < lArray3.length) {
                        if (l6 < lArray3[n3]) break;
                        if (l6 == lArray3[n3] || l6 < lArray3[n3 + 1]) {
                            bl3 = true;
                            break;
                        }
                        if ((n3 += 2) >= lArray3.length) continue;
                        l4 += lArray3[n3] - lArray3[n3 - 1];
                    }
                } else {
                    bl3 = true;
                }
                if (!bl && l4 == 0L && !this.KeepOriginalTimecode) {
                    l4 = l6;
                }
                l7 = l6 - l4;
                l5 = subpicture.decode_picture(byArray2, 10, Common.getGuiInterface().isSubpictureVisible(), jobProcessing.getStatusStrings(), l7, bl3, Common.getGuiInterface().isSubpictureVisible());
                if (l5 < -2L) {
                    Common.setMessage(Resource.getString("subpicture.msg.error", this.subdecode_errors[Math.abs((int)l5)], String.valueOf(l2 - (long)n4)));
                }
                if (this.debug) {
                    System.out.println("PTS: source " + Common.formatTime_1(l6 / 90L) + "(" + l6 + ")" + " /new " + Common.formatTime_1(l7 / 90L) + "(" + l7 + ")" + " / write: " + bl3 + " / dec.state: " + l5);
                }
                if (l5 < 0L) {
                    if (!bl5) {
                        Common.setMessage(Resource.getString("subpicture.msg.dvbsource"));
                    }
                    bl5 = true;
                    if (l5 == -1L) {
                        this.process_dvbsubpicture(jobProcessing, printStream, iDDBufferedOutputStream, subpicture, string6, l7);
                    }
                } else if (bl3) {
                    int n6 = 0;
                    while (n6 < 8) {
                        byArray2[2 + n6] = (byte)(0xFFL & l7 >>> n6 * 8);
                        ++n6;
                    }
                    iDDBufferedOutputStream.write(byArray2);
                    Common.getGuiInterface().showExportStatus(Resource.getString("subpicture.status"), ++this.Pictures);
                    Common.getGuiInterface().setSubpictureTitle(" " + Resource.getString("subpicture.preview.title.dvdexport", String.valueOf(this.Pictures), Common.formatTime_1(l7 / 90L)) + " " + Common.formatTime_1(l5 / 90L));
                    String string7 = subpicture.isForced_Msg();
                    if (string7 != null) {
                        Common.setMessage(String.valueOf(string7) + " " + Resource.getString("subpicture.msg.forced") + " " + this.Pictures);
                    }
                } else {
                    Common.getGuiInterface().setSubpictureTitle(" " + Resource.getString("subpicture.preview.title.noexport"));
                }
                if (!this.debug) continue;
                System.out.println("-> wr " + bl3 + " /v " + n3 + " /npts " + l7 + " /tdif " + l4 + " /pic " + this.Pictures + " /dtim " + l5);
                System.out.println("");
            }
            if (l5 == -2L) {
                l5 = subpicture.decode_picture(byArray2, 10, Common.getGuiInterface().isSubpictureVisible(), jobProcessing.getStatusStrings(), -1L, bl3, Common.getGuiInterface().isSubpictureVisible());
                if (l5 < -2L) {
                    Common.setMessage(Resource.getString("subpicture.msg.error", this.subdecode_errors[Math.abs((int)l5)], String.valueOf(l2 - (long)n4)));
                }
                if (this.debug) {
                    System.out.println("last picture in memory PTS: source " + Common.formatTime_1(l6 / 90L) + "(" + l6 + ")" + " /new " + Common.formatTime_1(l7 / 90L) + "(" + l7 + ")" + " / write: " + bl3 + " / dec.state: " + l5);
                }
                if (l5 == -1L) {
                    this.process_dvbsubpicture(jobProcessing, printStream, iDDBufferedOutputStream, subpicture, string6, l7);
                }
            }
            pushbackInputStream.close();
            printStream.flush();
            printStream.close();
            iDDBufferedOutputStream.flush();
            iDDBufferedOutputStream.close();
            if (string.equals("-1")) {
                Common.setMessage(String.valueOf(Resource.getString("subpicture.msg.pts.start_end", Common.formatTime_1(l8 / 90L))) + " " + Common.formatTime_1(l6 / 90L));
            }
            Common.setMessage(Resource.getString("subpicture.msg.summary", String.valueOf(this.Pictures)));
            if (!bl5 && this.ExportType == 1) {
                String string8 = String.valueOf(string6.substring(0, string6.length() - 3)) + "sup";
                Common.renameTo(string6, string8);
                string6 = string8;
            }
            File file = new File(string6);
            if (this.Pictures == 0) {
                file.delete();
            } else {
                if (bl5 && this.ExportType == 0) {
                    if (ColorAreas.active) {
                        jobProcessing.countMediaFilesExportLength(Ifo.createIfo(string6, ColorAreas.clut_pgc));
                    } else {
                        jobProcessing.countMediaFilesExportLength(Ifo.createIfo(string6, subpicture.getUserColorTableArray()));
                    }
                } else if (bl5 && this.ExportType == 1) {
                    jobProcessing.countMediaFilesExportLength(new File(BMP.write_ColorTable(this.FileParent, subpicture.getUserColorTable(), 256)).length());
                }
                Common.setMessage(String.valueOf(Resource.getString("msg.newfile")) + " " + string6);
                jobProcessing.countMediaFilesExportLength(file.length());
                jobProcessing.addSummaryInfo(String.valueOf(Resource.getString("subpicture.summary", Common.adaptString(jobProcessing.countPictureStream(), 2), String.valueOf(this.Pictures), this.infoPTSMatch(string, string3, bl, bl2))) + "'" + file + "'");
                if (this.ExportType == 0 && this.ExportAsVobSub) {
                    new Sup2VobSub(string6, subpicture.getUserColorTableArray());
                }
            }
            Common.updateProgressBar(l, l);
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        if (this.ShowSubpictureWindow) {
            Common.getGuiInterface().hideSubpicture();
        }
        ColorAreas.active = false;
    }

    private void process_dvbsubpicture(JobProcessing jobProcessing, PrintStream printStream, IDDBufferedOutputStream iDDBufferedOutputStream, Subpicture subpicture, String string, long l) {
        try {
            String string2 = "00000" + this.Pictures;
            String string3 = String.valueOf(this.FileParent) + "_st" + string2.substring(string2.length() - 5);
            Enumeration enumeration = BMP.getKeys();
            while (enumeration.hasMoreElements()) {
                String string4 = enumeration.nextElement().toString();
                int n = Integer.parseInt(string4);
                String string5 = Integer.toHexString(n).toUpperCase();
                String string6 = String.valueOf(string3) + "p" + string5;
                Bitmap bitmap = BMP.getBitmap(n);
                if (this.ExportType == 0) {
                    iDDBufferedOutputStream.write(subpicture.writeRLE(bitmap));
                } else {
                    int n2;
                    if (this.Pictures == 0) {
                        String[] stringArray = Common.getTeletextClass().getSONHead(new File(string).getParent(), (long)CommonParsing.getVideoFramerate());
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            printStream.println(stringArray[n3]);
                            ++n3;
                        }
                    }
                    subpicture.updateUserColorTable(bitmap);
                    string6 = BMP.buildBMP_palettized(string6, bitmap, subpicture.getUserColorTable(), 256);
                    jobProcessing.countMediaFilesExportLength(new File(string6).length());
                    int n4 = subpicture.setPGClinks();
                    if ((0xFFFF & n4) != (0xFFFF & this.LastPGCSet)) {
                        String string7 = "";
                        n2 = 0;
                        while (n2 < 4) {
                            string7 = String.valueOf(string7) + "" + (0xF & n4 >>> n2 * 4) + " ";
                            ++n2;
                        }
                        printStream.println("Color\t\t(" + string7.trim() + ")");
                    }
                    if ((0xFFFF0000 & n4) != (0xFFFF0000 & this.LastPGCSet)) {
                        String string8 = "";
                        n2 = 0;
                        while (n2 < 4) {
                            string8 = String.valueOf(string8) + "" + (0xF & n4 >>> (4 + n2) * 4) + " ";
                            ++n2;
                        }
                        printStream.println("Contrast\t(" + string8.trim() + ")");
                    }
                    this.LastPGCSet = n4;
                    printStream.println("Display_Area\t(" + Common.adaptString(bitmap.getX(), 3) + " " + Common.adaptString(bitmap.getY(), 3) + " " + Common.adaptString(bitmap.getMaxX(), 3) + " " + Common.adaptString(bitmap.getMaxY(), 3) + ")");
                    printStream.println(String.valueOf(string3.substring(string3.length() - 4)) + "\t\t" + Common.formatTime_2(bitmap.getInTime() / 90L, (long)CommonParsing.getVideoFramerate()) + "\t" + Common.formatTime_2(bitmap.getInTime() / 90L + (long)(bitmap.getPlayTime() * 10), (long)CommonParsing.getVideoFramerate()) + "\t" + new File(string6).getName());
                    if (this.debug) {
                        System.out.println("-> " + string6);
                    }
                }
                Common.getGuiInterface().setSubpictureTitle(" " + Resource.getString("subpicture.preview.title.dvbexport", String.valueOf(bitmap.getPageId()), String.valueOf(this.Pictures), Common.formatTime_1(l / 90L)) + " " + Common.formatTime_1(bitmap.getPlayTime() * 10));
            }
            if (!BMP.isEmpty()) {
                Common.getGuiInterface().showExportStatus(Resource.getString("subpicture.status"), ++this.Pictures);
            }
            BMP.clear();
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public void set_XY_Offset(int n, int n2) {
        this.X_Offset = n;
        this.Y_Offset = n2;
    }
}

