/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.File;
import java.util.Hashtable;
import java.util.List;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.JobProcessing;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.parser.StreamConverter;
import net.sourceforge.dvb.projectx.parser.StreamDemultiplexer;
import net.sourceforge.dvb.projectx.parser.StreamProcess;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class StreamParserBase {
    public int ERRORCODE = 0;
    public int MainBufferSize = 0x7D0000;
    public static StreamDemultiplexer streamdemultiplexer;
    public static StreamConverter streamconverter;
    public static List demuxList;
    public static Hashtable streamobjects;
    public static boolean CreateD2vIndex;
    public static boolean SplitProjectFile;
    public static String fchild;
    public static String fparent;
    public static long OverheadSize;

    public StreamParserBase() {
        this.init();
    }

    public void addCellTime(JobProcessing jobProcessing) {
        jobProcessing.addCellTime(jobProcessing.getExportedVideoFrameNumber());
    }

    public void addCellTimeFromFileSegment(JobProcessing jobProcessing) {
    }

    public void createStreamProcess(int n, JobCollection jobCollection, String[] stringArray, String string) {
        Common.setMessage("");
        Common.setMessage(this.formatIDString(Resource.getString(string), streamdemultiplexer.getPID(), streamdemultiplexer.getID(), streamdemultiplexer.subID()));
        new StreamProcess(n, jobCollection, stringArray);
    }

    public String formatIDString(String string, int n, int n2, int n3) {
        String string2 = "++> " + string;
        string2 = String.valueOf(string2) + ": PID 0x" + Common.adaptString(Integer.toHexString(n).toUpperCase(), 4);
        string2 = String.valueOf(string2) + " / PesID 0x" + Common.adaptString(Integer.toHexString(n2).toUpperCase(), 2);
        string2 = String.valueOf(string2) + " / SubID 0x" + Common.adaptString(Integer.toHexString(n3).toUpperCase(), 2);
        string2 = String.valueOf(string2) + " :";
        return string2;
    }

    public Hashtable getStreamObjects(JobProcessing jobProcessing) {
        return jobProcessing.getStreamObjects();
    }

    public void init() {
        this.MainBufferSize = Integer.parseInt(Common.getSettings().getProperty(Keys.KEY_MainBuffer));
        if (this.MainBufferSize <= 0) {
            this.MainBufferSize = 4096000;
        }
        streamdemultiplexer = null;
        streamconverter = null;
        demuxList = null;
        streamobjects = null;
        CreateD2vIndex = false;
        SplitProjectFile = false;
        OverheadSize = 2048000L;
        fchild = "";
        fparent = "";
    }

    public void initConversion(JobCollection jobCollection, String string, int n, int n2, int n3) {
        if (n <= 0) {
            return;
        }
        String[] stringArray = new String[]{"", ".vdr", ".mpg", ".pva", ".ts"};
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                streamconverter.init(jobCollection, String.valueOf(string) + "[remux]" + stringArray[n], this.MainBufferSize, n, n3);
                break;
            }
            case 5: {
                streamconverter.init(jobCollection, String.valueOf(string) + "[filter]" + stringArray[n2], this.MainBufferSize, n, n3);
                break;
            }
        }
    }

    public long nextFilePTS(JobCollection jobCollection, int n, int n2, long l, int n3) {
        return this.nextFilePTS(jobCollection, n, n2, l, n3, 0L);
    }

    public long nextFilePTS(JobCollection jobCollection, int n, int n2, long l, int n3, long l2) {
        return this.nextFilePTS(jobCollection, n, n2, l, 0L, n3, 0L);
    }

    /*
     * Exception decompiling
     */
    public long nextFilePTS(JobCollection var1_1, int var2_2, int var3_3, long var4_4, long var6_5, int var8_6, long var9_7) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: First case is not immediately after switch.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:442)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String parseStream(JobCollection jobCollection, XInputFile xInputFile, int n, int n2, String string) {
        return null;
    }

    public boolean pause() {
        return Common.waitingMainProcess();
    }

    public String processElementaryStreams(String string, int n, int[] nArray, JobCollection jobCollection, JobProcessing jobProcessing) {
        if (n != 0) {
            streamconverter.close(jobProcessing, CommonParsing.isInfoScan());
            return string;
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < demuxList.size()) {
            streamdemultiplexer = (StreamDemultiplexer)demuxList.get(n2);
            if (streamdemultiplexer.getType() == 3) {
                if (n3 > 0) {
                    Common.setMessage("!> further videostream found (PID 0x" + Integer.toHexString(streamdemultiplexer.getPID()).toUpperCase() + " / ID 0x" + Integer.toHexString(streamdemultiplexer.getID()).toUpperCase() + ") -> ignored");
                } else {
                    if (CreateD2vIndex || SplitProjectFile) {
                        jobProcessing.getProjectFileD2V().write(jobProcessing.getProjectFileExportLength(), jobProcessing.getExportedVideoFrameNumber());
                    }
                    Common.setMessage("");
                    Common.setMessage(this.formatIDString(Resource.getString("ExportPanel.Streamtype.MpgVideo"), streamdemultiplexer.getPID(), streamdemultiplexer.getID(), streamdemultiplexer.subID()));
                    Common.setMessage(String.valueOf(Resource.getString("video.msg.summary")) + " " + jobProcessing.getExportedVideoFrameNumber() + "-" + nArray[0] + "-" + nArray[1] + "-" + nArray[2] + "-" + nArray[3] + "-" + nArray[4]);
                    string = streamdemultiplexer.closeVideo(jobProcessing, String.valueOf(jobCollection.getOutputDirectory()) + jobCollection.getFileSeparator());
                    ++n3;
                }
            }
            ++n2;
        }
        this.processNonVideoElementaryStreams(string, n, nArray, jobCollection, jobProcessing);
        return string;
    }

    public void processNonVideoElementaryStreams(String string, int n, int[] nArray, JobCollection jobCollection, JobProcessing jobProcessing) {
        this.processNonVideoElementaryStreams(string, n, nArray, jobCollection, jobProcessing, null, null);
    }

    public void processNonVideoElementaryStreams(String string, int n, int[] nArray, JobCollection jobCollection, JobProcessing jobProcessing, List list, XInputFile xInputFile) {
        int[] nArray2 = jobProcessing.getStreamNumbers();
        String[] stringArray = new String[]{Keys.KEY_Streamtype_Ac3Audio[0], Keys.KEY_Streamtype_Teletext[0], Keys.KEY_Streamtype_MpgAudio[0], "", Keys.KEY_Streamtype_PcmAudio[0], Keys.KEY_Streamtype_Subpicture[0], Keys.KEY_Streamtype_Ac3Audio[0], Keys.KEY_Streamtype_PcmAudio[0]};
        int n2 = 0;
        while (n2 < demuxList.size()) {
            streamdemultiplexer = (StreamDemultiplexer)demuxList.get(n2);
            int n3 = streamdemultiplexer.getType();
            if (n3 != 3 && streamdemultiplexer.getID() != 0) {
                String[] stringArray2 = streamdemultiplexer.close(jobProcessing, string);
                if (stringArray2[0].equals("")) {
                    Common.setMessage(this.formatIDString(Resource.getString("StreamParser.NoExport"), streamdemultiplexer.getPID(), 0xFF & streamdemultiplexer.getID(), streamdemultiplexer.subID()));
                } else {
                    if (streamdemultiplexer.getStreamNumber() < 0) {
                        streamdemultiplexer.setStreamNumber(nArray2[n3]);
                        int n4 = n3;
                        nArray2[n4] = nArray2[n4] + 1;
                    }
                    String string2 = String.valueOf(stringArray2[3]) + (streamdemultiplexer.getStreamNumber() > 0 ? "-" + Common.adaptString(nArray2[n3], 2) : "") + "." + stringArray2[2];
                    Common.renameTo(stringArray2[0], string2);
                    stringArray2[0] = string2;
                    stringArray2[3] = string;
                    switch (n3) {
                        case 0: 
                        case 6: {
                            if (streamdemultiplexer.subID() != 0 && (0xF0 & streamdemultiplexer.subID()) != 128) {
                                Common.setMessage(this.formatIDString(Resource.getString("StreamParser.NoExport"), streamdemultiplexer.getPID(), 0xFF & streamdemultiplexer.getID(), streamdemultiplexer.subID()));
                                break;
                            }
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: {
                            this.createStreamProcess(n3, jobCollection, stringArray2, stringArray[n3]);
                            break;
                        }
                    }
                    if (list != null) {
                        list.add(stringArray2[0]);
                        list.add(xInputFile);
                        list.add(stringArray2[1]);
                        list.add(stringArray2[2]);
                        Common.setMessage("tmpfiles " + list.size());
                        if (jobProcessing.getSplitSize() == 0L) {
                            new File(string2).delete();
                            new File(stringArray2[1]).delete();
                        }
                    } else {
                        new File(string2).delete();
                        new File(stringArray2[1]).delete();
                    }
                }
            }
            ++n2;
        }
    }

    public void setFileName(JobCollection jobCollection, JobProcessing jobProcessing, XInputFile xInputFile) {
        this.setFileName(jobCollection, jobProcessing, xInputFile, "");
    }

    public void setFileName(JobCollection jobCollection, JobProcessing jobProcessing, XInputFile xInputFile, String string) {
        String string2 = xInputFile.getName();
        string2 = string2.replace('?', '_');
        string2 = string2.replace('*', '_');
        string2 = string2.replace(':', '_');
        string2 = string2.replace('/', '_');
        string2 = string2.replace('\"', '_');
        string2 = string2.replace('<', '_');
        string2 = string2.replace('>', '_');
        string2 = string2.replace('|', '_');
        fchild = jobCollection.getOutputName(string2);
        fparent = jobCollection.getOutputNameParent(fchild);
        fparent = String.valueOf(fparent) + (jobProcessing.getSplitSize() > 0L ? "(" + jobProcessing.getSplitPart() + ")" : string);
    }

    public void setOverheadSize(JobCollection jobCollection) {
        OverheadSize = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Input_useReadOverhead) ? 2048000 : 0;
    }
}

