/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MemoryMonitor
extends JPanel {
    public Surface surf;
    JPanel controls;
    boolean doControls;
    JTextField tf;
    JCheckBox box;

    public MemoryMonitor() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), "Memory Monitor"));
        this.surf = new Surface();
        this.add(this.surf);
        this.controls = new JPanel();
        this.controls.setToolTipText("click to start/stop monitoring + memory saving");
        Font font = new Font("serif", 0, 10);
        this.tf = new JTextField("1000");
        this.tf.setPreferredSize(new Dimension(40, 14));
        this.controls.add(this.tf);
        JLabel jLabel = new JLabel("ms");
        this.controls.add(jLabel);
        this.box = new JCheckBox("call gc()");
        this.box.setPreferredSize(new Dimension(80, 14));
        this.box.setSelected(true);
        this.controls.add(this.box);
        this.controls.setPreferredSize(new Dimension(100, 36));
        this.controls.setMaximumSize(new Dimension(100, 36));
        jLabel.setFont(font);
        jLabel.setForeground(Color.black);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MemoryMonitor.this.removeAll();
                if (MemoryMonitor.this.doControls ^= true) {
                    MemoryMonitor.this.surf.stop();
                    MemoryMonitor.this.add(MemoryMonitor.this.controls);
                } else {
                    try {
                        long l = Long.parseLong(MemoryMonitor.this.tf.getText().trim());
                        if (l >= 50L) {
                            MemoryMonitor.this.surf.sleepAmount = l;
                        }
                    }
                    catch (Exception exception) {}
                    MemoryMonitor.this.surf.start();
                    MemoryMonitor.this.add(MemoryMonitor.this.surf);
                }
                MemoryMonitor.this.validate();
                MemoryMonitor.this.repaint();
            }
        });
    }

    public class Surface
    extends JPanel
    implements Runnable {
        public Thread thread;
        public long sleepAmount = 1000L;
        private int w;
        private int h;
        private BufferedImage bimg;
        private Graphics2D big;
        private Font font = new Font("Times New Roman", 0, 11);
        private Runtime r = Runtime.getRuntime();
        private int columnInc;
        private int[] pts;
        private int ptNum;
        private int ascent;
        private int descent;
        private float freeMemory;
        private float totalMemory;
        private Rectangle graphOutlineRect = new Rectangle();
        private Rectangle2D mfRect = new Rectangle2D.Float();
        private Rectangle2D muRect = new Rectangle2D.Float();
        private Line2D graphLine = new Line2D.Float();
        private Color graphColor = new Color(46, 139, 87);
        private Color mfColor = new Color(0, 100, 0);
        private String usedStr;
        private int gc_counter = 0;

        public Surface() {
            this.setBackground(Color.black);
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ Surface this$1;
                {
                    this.this$1 = surface;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (this.this$1.thread == null) {
                        this.this$1.start();
                    } else {
                        this.this$1.stop();
                    }
                }
            });
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(100, 36);
        }

        public void paint(Graphics graphics) {
            if (this.big == null) {
                return;
            }
            this.big.setBackground(this.getBackground());
            this.big.clearRect(0, 0, this.w, this.h);
            float f = this.r.freeMemory();
            float f2 = this.r.totalMemory();
            this.big.setColor(Color.green);
            this.big.drawString(String.valueOf(String.valueOf((int)f2 / 1024)) + "K allocated", 4.0f, (float)this.ascent + 0.5f);
            this.usedStr = String.valueOf(String.valueOf((int)(f2 - f) / 1024)) + "K used";
            this.big.drawString(this.usedStr, 4.0f, 0.5f + (float)(this.ascent * 2));
            float f3 = 82.0f;
            float f4 = (f2 - f) * f3 / f2;
            this.big.drawRect(4, this.h - 10, (int)f3, 6);
            this.big.setColor(new Color(0, 150, 0));
            this.big.fillRect(5, this.h - 9, (int)f4 - 2, 5);
            if (this.gc_counter > 4) {
                if (this.thread != null && MemoryMonitor.this.box.isSelected() && f < 2048000.0f) {
                    this.big.setColor(Color.red);
                    this.big.fillRect(90, this.h - 9, 4, 4);
                    System.gc();
                }
                this.gc_counter = 0;
            } else {
                ++this.gc_counter;
            }
            graphics.drawImage(this.bimg, 0, 0, this);
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread && !this.isShowing() || this.getSize().width == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            while (this.thread == thread && this.isShowing()) {
                Dimension dimension = this.getSize();
                if (dimension.width != this.w || dimension.height != this.h) {
                    this.w = dimension.width;
                    this.h = dimension.height;
                    this.bimg = (BufferedImage)this.createImage(this.w, this.h);
                    this.big = this.bimg.createGraphics();
                    this.big.setFont(this.font);
                    FontMetrics fontMetrics = this.big.getFontMetrics(this.font);
                    this.ascent = fontMetrics.getAscent();
                    this.descent = fontMetrics.getDescent();
                }
                this.repaint();
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            this.thread = null;
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("MemoryMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.notify();
        }
    }
}

