/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import net.sourceforge.dvb.projectx.common.Common;

public class GOPEditor
extends JDialog {
    private StreamObject streamobject;
    private ArrayList sourcedata = new ArrayList();
    private ArrayList sinkdata = new ArrayList();
    private JList sourcelist = new JList();
    private JList sinklist = new JList();
    private JTable tableView;
    private JTextField textField;
    private Thread thread;
    private byte[] data = null;
    private long[][] pts_indices = null;
    private int s1 = 12;
    private int s2 = 9;
    private boolean stopCount = false;
    private int cnt = 0;
    private final int FRAME = 0;
    private final int SEQUENCE = 179;
    private final int SEQUENCE_END = 183;
    private final int GOP = 184;
    private final int USER_DATA = 178;
    private final int EXTENSION = 181;
    private double lastFrameRate = -1.0;
    private Object[][] ObjectTable = new Object[this.s1][this.s2];
    static /* synthetic */ Class class$java$lang$String;

    public GOPEditor(JFrame jFrame) {
        super(jFrame, "GOP Editor", true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GOPEditor.this.close();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        ((Component)this).setBounds(200, 100, 770, 500);
        jPanel.add(this.buildPanel1());
        this.getContentPane().add(jPanel);
    }

    static /* synthetic */ int access$10(GOPEditor gOPEditor) {
        return gOPEditor.s2;
    }

    protected JPanel buildPanel1() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = new JButton("Reset All");
        jButton.setMnemonic('o');
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GOPEditor.this.reload();
            }
        });
        JButton jButton2 = new JButton("copy chunk");
        jButton2.setMnemonic('c');
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GOPEditor.this.copy();
            }
        });
        JButton jButton3 = new JButton("remove chunk(s)");
        jButton3.setMnemonic('r');
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GOPEditor.this.remove();
            }
        });
        JButton jButton4 = new JButton("check changes");
        jButton4.setMnemonic('e');
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GOPEditor.this.check();
            }
        });
        JButton jButton5 = new JButton("save & close");
        jButton5.setMnemonic('a');
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GOPEditor.this.save();
            }
        });
        JButton jButton6 = new JButton("close unchanged");
        jButton6.setMnemonic('u');
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GOPEditor.this.close();
            }
        });
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        jPanel.add(jButton2);
        jPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        jPanel.add(jButton3);
        jPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        jPanel.add(jButton4);
        jPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        jPanel.add(jButton5);
        jPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        jPanel.add(jButton6);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.sourcelist);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add((Component)this.createTable(), "Center");
        this.textField = new JTextField();
        jPanel2.add(this.textField);
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private void check() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void close() {
        this.dispose();
    }

    private void copy() {
        int n = this.tableView.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.streamobject = (StreamObject)this.sourcedata.get(n);
        if (this.streamobject instanceof Frame) {
            Frame frame = (Frame)this.streamobject;
            Frame frame2 = new Frame();
            frame2.copy(frame.getType(), frame.getDataType(), frame.getOffset(), frame.getLength(), frame.getChunk() + 1000);
            frame2.copy2(frame.getFrameType(), frame.getTempRef());
            this.sourcedata.add(n + 1, frame2);
            this.setSourceTable();
        }
    }

    protected JScrollPane createTable() {
        final String[] stringArray = new String[]{"Chunk", "Start", "End", "t.Ref", "Delta(ms)", "ind.PTS", "Timecode", "Type", "ErrID"};
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        DefaultTableCellRenderer defaultTableCellRenderer2 = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(4);
        defaultTableCellRenderer2.setHorizontalAlignment(0);
        DefaultTableCellRenderer defaultTableCellRenderer3 = new DefaultTableCellRenderer(){
            Color redColor = new Color(255, 180, 180);
            String str;

            public void setValue(Object object) {
                this.setBackground(Color.white);
                this.setText("");
                if (object == null) {
                    return;
                }
                this.str = object.toString();
                if (!this.str.equals("0")) {
                    this.setText(Integer.toHexString(Integer.parseInt(this.str)));
                    this.setBackground(this.redColor);
                }
            }
        };
        defaultTableCellRenderer3.setHorizontalAlignment(0);
        DefaultTableCellRenderer defaultTableCellRenderer4 = new DefaultTableCellRenderer(){
            Color cyanColor = new Color(220, 255, 255);
            Color greenColor = new Color(220, 255, 220);
            Color blueColor = new Color(220, 220, 255);
            Color yellowColor = new Color(255, 255, 220);
            Color magentaColor = new Color(255, 220, 255);
            Color redColor = new Color(255, 180, 180);
            String str;

            public void setValue(Object object) {
                this.setBackground(Color.white);
                if (object == null) {
                    this.setText("");
                    return;
                }
                this.str = object.toString();
                this.setText(this.str);
                if (this.str.indexOf("Frame I") >= 0) {
                    this.setBackground(this.greenColor);
                } else if (this.str.indexOf("Frame P") >= 0) {
                    this.setBackground(this.blueColor);
                } else if (this.str.indexOf("Frame B") >= 0) {
                    this.setBackground(this.yellowColor);
                } else if (this.str.indexOf("Sequence") >= 0) {
                    this.setBackground(this.cyanColor);
                } else if (this.str.indexOf("GOP") >= 0) {
                    this.setBackground(this.magentaColor);
                }
                if (this.str.indexOf("!") >= 0) {
                    this.setBackground(this.redColor);
                }
            }
        };
        defaultTableCellRenderer4.setHorizontalAlignment(2);
        DefaultTableCellRenderer defaultTableCellRenderer5 = new DefaultTableCellRenderer(){
            Color redColor = new Color(255, 180, 180);
            String str;
            double val;

            public void setValue(Object object) {
                this.setBackground(Color.white);
                if (object == null) {
                    this.setText("");
                    return;
                }
                this.str = object.toString();
                this.setText(this.str);
                this.val = Double.parseDouble(this.str);
                if (Math.abs(this.val * 90.0) > GOPEditor.this.getLastFrameRate() / 2.0) {
                    this.setBackground(this.redColor);
                }
            }
        };
        defaultTableCellRenderer5.setHorizontalAlignment(0);
        DefaultTableCellRenderer defaultTableCellRenderer6 = new DefaultTableCellRenderer(){
            Color redColor = new Color(255, 180, 180);
            String str;

            public void setValue(Object object) {
                this.setBackground(Color.white);
                this.setText("");
                if (object == null) {
                    return;
                }
                this.str = object.toString();
                this.setText(this.str);
                if (this.str.indexOf("e") >= 0) {
                    this.setBackground(this.redColor);
                }
            }
        };
        defaultTableCellRenderer6.setHorizontalAlignment(0);
        AbstractTableModel abstractTableModel = new AbstractTableModel(){
            String str;

            public Class getColumnClass(int n) {
                Object object = this.getValueAt(0, n);
                if (object == null) {
                    return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = GOPEditor.class$("java.lang.String"));
                }
                return object.getClass();
            }

            public int getColumnCount() {
                return stringArray.length;
            }

            public String getColumnName(int n) {
                return stringArray[n];
            }

            public int getRowCount() {
                return ObjectTable.length;
            }

            public Object getValueAt(int n, int n2) {
                return ObjectTable[n][n2];
            }

            public boolean isCellEditable(int n, int n2) {
                return this.getColumnClass(n2) == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = GOPEditor.class$("java.lang.String")));
            }

            public void setValueAt(Object object, int n, int n2) {
                ((GOPEditor)this).ObjectTable[n][n2] = object;
            }
        };
        this.tableView = new JTable(abstractTableModel);
        this.tableView.setRowHeight(20);
        this.tableView.setGridColor(new Color(220, 220, 220));
        this.tableView.setSelectionBackground(new Color(220, 220, 255));
        this.tableView.setSelectionForeground(Color.black);
        this.tableView.getColumn(stringArray[0]).setCellRenderer(defaultTableCellRenderer2);
        this.tableView.getColumn(stringArray[0]).setMaxWidth(45);
        this.tableView.getColumn(stringArray[1]).setCellRenderer(defaultTableCellRenderer);
        this.tableView.getColumn(stringArray[1]).setMaxWidth(70);
        this.tableView.getColumn(stringArray[2]).setCellRenderer(defaultTableCellRenderer);
        this.tableView.getColumn(stringArray[2]).setMaxWidth(70);
        this.tableView.getColumn(stringArray[3]).setMaxWidth(50);
        this.tableView.getColumn(stringArray[3]).setCellRenderer(defaultTableCellRenderer6);
        this.tableView.getColumn(stringArray[4]).setCellRenderer(defaultTableCellRenderer5);
        this.tableView.getColumn(stringArray[4]).setMaxWidth(70);
        this.tableView.getColumn(stringArray[5]).setCellRenderer(defaultTableCellRenderer2);
        this.tableView.getColumn(stringArray[5]).setMaxWidth(100);
        this.tableView.getColumn(stringArray[6]).setCellRenderer(defaultTableCellRenderer2);
        this.tableView.getColumn(stringArray[6]).setMaxWidth(100);
        this.tableView.getColumn(stringArray[7]).setMaxWidth(280);
        this.tableView.getColumn(stringArray[7]).setCellRenderer(defaultTableCellRenderer4);
        this.tableView.getColumn(stringArray[8]).setMaxWidth(50);
        this.tableView.getColumn(stringArray[8]).setCellRenderer(defaultTableCellRenderer3);
        this.tableView.sizeColumnsToFit(3);
        this.tableView.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() < 1) {
                    return;
                }
                int n = GOPEditor.this.tableView.getSelectedRow();
                if (n >= 0 && GOPEditor.this.tableView.getValueAt(n, 0) == null) {
                    n = -1;
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tableView);
        return jScrollPane;
    }

    public byte[] editGOP(byte[] byArray, long[][] lArray) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        this.data = byArray;
        this.pts_indices = lArray;
        this.setTextField("");
        this.sourcedata.clear();
        this.sinkdata.clear();
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        int n9 = this.data.length - 3;
        while (n6 < n9) {
            if (this.data[n6] == 0 && this.data[n6 + 1] == 0 && this.data[n6 + 2] == 1) {
                int n10 = 0xFF & this.data[n6 + 3];
                if (n10 > 0 && n10 < 176) {
                    if (n10 == n8) {
                        n5 |= 0x10000;
                    } else if (n10 < n8) {
                        n5 |= 0x20000;
                    } else if (n10 > n8 + 1) {
                        n5 |= 0x40000;
                    }
                    ++n5;
                }
                switch (n10) {
                    case 0: 
                    case 179: 
                    case 183: 
                    case 184: {
                        this.setSliceInfo(n5);
                        if (n10 == 0) {
                            n5 = 0;
                            n8 = n10;
                        }
                        if (n3 < 0) {
                            n3 = n10;
                            n7 = n6;
                            break;
                        }
                        this.streamobject = this.setObject(n3, n, this.data, n7, n6 - n7, n2++);
                        int n11 = this.pts_indices[0].length - 1;
                        while (n11 >= 0) {
                            if (n4 != n11 && this.pts_indices[1][n11] <= (long)n7 && this.streamobject != null) {
                                this.streamobject.setPTSValue(this.pts_indices[0][n11]);
                                n4 = n11;
                                break;
                            }
                            --n11;
                        }
                        n3 = n10;
                        n7 = n6;
                        break;
                    }
                    default: {
                        if (n10 <= 0 || n10 >= 176) break;
                        n8 = n10;
                        break;
                    }
                }
            }
            ++n6;
        }
        this.setSliceInfo(n5);
        this.updatePTSInfo();
        this.validatePTSInfo();
        this.validateSequence();
        this.getErrors();
        this.setSourceTable();
        this.setSourceList();
        this.setSinkList();
        this.show();
        return this.data;
    }

    public void getErrors() {
        int n = 0;
        int n2 = 0;
        int n3 = this.sourcedata.size();
        while (n2 < n3) {
            this.streamobject = (StreamObject)this.sourcedata.get(n2);
            n |= this.streamobject.getError();
            ++n2;
        }
        if ((7 & n) != 0) {
            this.setTextField(String.valueOf(this.getTextField()) + "Error Frame; ");
        }
        if ((0x10 & n) != 0) {
            this.setTextField(String.valueOf(this.getTextField()) + "Error PTS Indication; ");
        }
        if ((0x20 & n) != 0) {
            this.setTextField(String.valueOf(this.getTextField()) + "Error tRef's; ");
        }
    }

    private double getLastFrameRate() {
        return this.lastFrameRate;
    }

    private String getTextField() {
        return this.textField.getText();
    }

    private void reload() {
        this.editGOP(this.data, this.pts_indices);
    }

    private void remove() {
        int[] nArray = this.tableView.getSelectedRows();
        int n = nArray.length - 1;
        while (n >= 0) {
            this.sourcedata.remove(nArray[n]);
            --n;
        }
        this.setSourceTable();
    }

    private byte[] save() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n = 0;
            int n2 = this.sinkdata.size();
            while (n < n2) {
                Frame frame;
                int n3;
                this.streamobject = (StreamObject)this.sinkdata.get(n);
                int n4 = this.streamobject.getOffset();
                int n5 = this.streamobject.getLength();
                if (this.streamobject instanceof Frame && (n3 = (frame = (Frame)this.streamobject).getTempRef()) >= 0) {
                    this.setTempRef(this.data, n4, n3);
                }
                byteArrayOutputStream.write(this.data, n4, n5);
                ++n;
            }
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            JOptionPane.showMessageDialog(this, "export done..");
        }
        catch (Exception exception) {
            System.out.println("error");
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void setLastFrameRate(double d) {
        this.lastFrameRate = d;
    }

    private StreamObject setObject(int n, int n2, byte[] byArray, int n3, int n4, int n5) {
        switch (n) {
            case 0: {
                this.streamobject = new Frame();
                this.streamobject.set(n2, byArray, n3, n4, n5);
                break;
            }
            case 179: {
                this.streamobject = new SequenceHeader();
                this.streamobject.set(n2, byArray, n3, n4, n5);
                break;
            }
            case 183: {
                this.streamobject = new SequenceEnd();
                this.streamobject.set(n2, byArray, n3, n4, n5);
                break;
            }
            case 184: {
                this.streamobject = new GOPHeader();
                this.streamobject.set(n2, byArray, n3, n4, n5);
                break;
            }
            case 178: {
                this.streamobject = new UserData();
                this.streamobject.set(n2, byArray, n3, n4, n5);
                break;
            }
            default: {
                return null;
            }
        }
        this.sourcedata.add(this.streamobject);
        return this.streamobject;
    }

    private void setSinkList() {
        this.sinklist.setListData(this.sinkdata.toArray());
    }

    private void setSliceInfo(int n) {
        if (this.streamobject != null && this.streamobject.getType() == 0) {
            String string = String.valueOf(this.streamobject.getDataType()) + " - Slices: " + String.valueOf(0xFFFF & n);
            if ((0x10000 & n) != 0) {
                string = String.valueOf(string) + " dupl! ";
            }
            if ((0x20000 & n) != 0) {
                string = String.valueOf(string) + " sequ! ";
            }
            if ((0x40000 & n) != 0) {
                string = String.valueOf(string) + " miss! ";
            }
            this.streamobject.setError(this.streamobject.getError() | n >>> 16);
            this.streamobject.setDataType(string);
        }
    }

    private void setSourceList() {
        this.sourcelist.setListData(this.sourcedata.toArray());
    }

    private void setSourceTable() {
        int n = this.sourcedata.size();
        this.ObjectTable = new Object[n][this.s2];
        int n2 = 0;
        while (n2 < n) {
            StreamObject streamObject = (StreamObject)this.sourcedata.get(n2);
            this.ObjectTable[n2] = streamObject.getObjectTable();
            ++n2;
        }
        this.tableView.clearSelection();
        this.tableView.revalidate();
        this.tableView.repaint();
    }

    private void setTempRef(byte[] byArray, int n, int n2) {
        byArray[n + 4] = (byte)(0xFF & n2 >> 2);
        byArray[n + 5] = (byte)(0xC0 & n2 << 6 | 0x3F & byArray[n + 5]);
    }

    private void setTextField(String string) {
        this.textField.setText(string);
    }

    private void updatePTSInfo() {
        long l = -1L;
        int n = 0;
        int n2 = this.sourcedata.size();
        while (n < n2) {
            this.streamobject = (StreamObject)this.sourcedata.get(n);
            if (this.streamobject.getPTSValue() != -1L) {
                l = this.streamobject.getPTSValue();
            }
            if (this.streamobject instanceof Frame) {
                if (this.streamobject.getPTSValue() != -1L || l == -1L) break;
                this.streamobject.setPTSValue(l);
                break;
            }
            ++n;
        }
    }

    private void updateTable(Object[][] objectArray) {
        this.ObjectTable = objectArray == null ? new Object[this.s1][this.s2] : objectArray;
        this.tableView.clearSelection();
        this.tableView.revalidate();
        this.tableView.repaint();
    }

    private void validatePTSInfo() {
        double d = -1.0;
        double d2 = this.getLastFrameRate();
        if (d2 < 0.0) {
            return;
        }
        int n = 0;
        int n2 = this.sourcedata.size();
        while (n < n2) {
            this.streamobject = (StreamObject)this.sourcedata.get(n);
            if (this.streamobject instanceof Frame) {
                double d3;
                Frame frame = (Frame)this.streamobject;
                int n3 = frame.getTempRef();
                double d4 = frame.getPTSValue();
                double d5 = d4 - (double)n3 * d2;
                if (d < 0.0) {
                    d = d5;
                }
                if (Math.abs(d3 = d4 - (double)n3 * d2 - d) > d2 / 2.0) {
                    frame.setError(frame.getError() | 0x10);
                }
                frame.setDelta(d3);
            }
            ++n;
        }
    }

    private void validateSequence() {
        int n;
        double d = this.getLastFrameRate();
        int[] nArray = new int[this.sourcedata.size()];
        boolean bl = false;
        Arrays.fill(nArray, -1);
        int n2 = 0;
        int n3 = this.sourcedata.size();
        while (n2 < n3) {
            this.streamobject = (StreamObject)this.sourcedata.get(n2);
            if (this.streamobject instanceof Frame) {
                Frame frame = (Frame)this.streamobject;
                n = frame.getTempRef();
                nArray[n2] = n << 16 | n2;
            }
            ++n2;
        }
        Arrays.sort(nArray);
        int n4 = 0;
        int n5 = -1;
        int n6 = nArray.length;
        while (n4 < n6) {
            if (nArray[n4] >= 0) {
                int n7 = 0xFFFF & nArray[n4];
                n = nArray[n4] >>> 16;
                if (n5 < 0) {
                    n5 = n;
                } else if (n != n5) {
                    this.streamobject = (StreamObject)this.sourcedata.get(n7);
                    this.streamobject.setError(this.streamobject.getError() | 0x20);
                }
                ++n5;
            }
            ++n4;
        }
    }

    class Frame
    extends StreamObject {
        private int frametype = 0;
        private int tempref = -1;
        private String[] types = new String[]{"-", "I", "P", "B", "D", "-", "-", "-"};

        public Frame() {
            this.type = 0;
            this.datatype = "Frame ";
            this.setDataType(this.datatype);
        }

        public void copy2(int n, int n2) {
            this.frametype = n;
            this.tempref = n2;
            this.objecttable[3] = String.valueOf(this.getTempRef());
        }

        public int getFrameType() {
            return this.frametype;
        }

        public int getTempRef() {
            return this.tempref;
        }

        public void set(int n, byte[] byArray, int n2, int n3, int n4) {
            this.frametype = 7 & byArray[n2 + 5] >> 3;
            this.tempref = (0xFF & byArray[n2 + 4]) << 2 | 3 & byArray[n2 + 5] >> 6;
            this.setDataType(String.valueOf(this.getDataType()) + this.types[this.getFrameType()]);
            this.objecttable[3] = String.valueOf(this.getTempRef());
            this.setOffsets(n, n2, n3, n4);
        }

        public String toString() {
            return "#" + this.chunk + " (" + this.getOffset() + "->" + (this.getOffset() + this.getLength()) + ")" + this.datatype + this.types[this.frametype] + " - tref: " + String.valueOf(this.tempref);
        }
    }

    class SequenceHeader
    extends StreamObject {
        private String[] aspratio = new String[]{"res.", "1.000 (1:1)", "0.6735 (4:3)", "0.7031 (16:9)", "0.7615 (2.21:1)", "0.8055", "0.8437", "0.9375", "0.9815", "1.0255", "1.0695", "1.1250", "1.1575", "1.2015", "res."};
        private String[] fps_table_str = new String[]{"forbidden fps", "23.976fps", "24fps", "25fps", "29.97fps", "30fps", "50fps", "59.94fps", "60fps", "n.def.", "n.def.", "n.def.", "n.def.", "n.def.", "n.def.", "n.def."};
        private double[] fps_table = new double[]{-1.0, 3753.7537537537537, 3750.0, 3600.0, 3003.003003003003, 3000.0, 1800.0, 1501.5015015015015, 1500.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};

        public SequenceHeader() {
            this.type = 179;
            this.datatype = "SequenceHeader";
            this.setDataType(this.datatype);
        }

        public void set(int n, byte[] byArray, int n2, int n3, int n4) {
            String string = " ";
            string = String.valueOf(string) + String.valueOf((0xFF & byArray[n2 + 4]) << 4 | (0xF0 & byArray[n2 + 5]) >>> 4);
            string = String.valueOf(string) + "*";
            string = String.valueOf(string) + String.valueOf((0xF & byArray[n2 + 5]) << 8 | 0xFF & byArray[n2 + 6]);
            string = String.valueOf(string) + ", ";
            string = String.valueOf(string) + this.fps_table_str[0xF & byArray[n2 + 7]];
            string = String.valueOf(string) + ", ";
            string = String.valueOf(string) + this.aspratio[0xF & byArray[n2 + 7] >>> 4];
            this.datatype = String.valueOf(this.datatype) + string;
            this.setDataType(this.datatype);
            this.setOffsets(n, n2, n3, n4);
            GOPEditor.this.setLastFrameRate(this.fps_table[0xF & byArray[n2 + 7]]);
        }
    }

    class GOPHeader
    extends StreamObject {
        private String[] drop = new String[]{"--,", "drop,"};
        private String[] closed = new String[]{"--,", "closed,"};
        private String[] broken = new String[]{"--", "broken"};

        public GOPHeader() {
            this.type = 184;
            this.datatype = "GOPHeader";
            this.setDataType(this.datatype);
        }

        public void set(int n, byte[] byArray, int n2, int n3, int n4) {
            String string = " ";
            string = String.valueOf(string) + this.drop[1 & byArray[n2 + 4] >> 7];
            string = String.valueOf(string) + this.closed[1 & byArray[n2 + 7] >> 6];
            string = String.valueOf(string) + this.broken[1 & byArray[n2 + 7] >> 5];
            string = String.valueOf(string) + " ";
            string = String.valueOf(string) + String.valueOf((0x7C & byArray[n2 + 4]) >>> 2);
            string = String.valueOf(string) + ":";
            string = String.valueOf(string) + String.valueOf((3 & byArray[n2 + 4]) << 4 | (0xF0 & byArray[n2 + 5]) >>> 4);
            string = String.valueOf(string) + ":";
            string = String.valueOf(string) + String.valueOf((7 & byArray[n2 + 5]) << 3 | (0xE0 & byArray[n2 + 6]) >>> 5);
            string = String.valueOf(string) + ":";
            string = String.valueOf(string) + String.valueOf((0x1F & byArray[n2 + 6]) << 1 | (0x80 & byArray[n2 + 7]) >>> 7);
            this.datatype = String.valueOf(this.datatype) + string;
            this.setDataType(this.datatype);
            this.setOffsets(n, n2, n3, n4);
        }
    }

    class UserData
    extends StreamObject {
        public UserData() {
            this.type = 178;
            this.datatype = "UserData";
            this.setDataType(this.datatype);
        }

        public void set(int n, byte[] byArray, int n2, int n3, int n4) {
            String string = new String(byArray, n2 + 4, n3 - 4);
            this.datatype = String.valueOf(this.datatype) + " '" + string + "'";
            this.setDataType(this.datatype);
            this.setOffsets(n, n2, n3, n4);
        }
    }

    class SequenceEnd
    extends StreamObject {
        public SequenceEnd() {
            this.type = 183;
            this.datatype = "SequenceEnd";
            this.setDataType(this.datatype);
        }
    }

    class StreamObject {
        public int chunk = -1;
        public int type = -1;
        public int offset = -1;
        public int length = -1;
        public int error = 0;
        public Object[] objecttable = new Object[GOPEditor.access$10(GOPEditor.this)];
        public long pts = -1L;
        public double delta = -1.0;
        public String datatype = "StreamObject";

        public void copy(int n, String string, int n2, int n3, int n4) {
            this.type = n;
            this.offset = n2;
            this.length = n3;
            this.chunk = n4;
            this.setDataType(string);
            this.objecttable[0] = String.valueOf(this.chunk);
            this.objecttable[1] = String.valueOf(this.offset);
            this.objecttable[2] = String.valueOf(this.offset + this.length);
        }

        public int getChunk() {
            return this.chunk;
        }

        public String getDataType() {
            return this.datatype;
        }

        public int getError() {
            return this.error;
        }

        public int getLength() {
            return this.length;
        }

        public Object[] getObjectTable() {
            return this.objecttable;
        }

        public int getOffset() {
            return this.offset;
        }

        public long getPTSValue() {
            return this.pts;
        }

        public int getType() {
            return this.type;
        }

        public void set(int n, byte[] byArray, int n2, int n3, int n4) {
            this.setOffsets(n, n2, n3, n4);
        }

        public void setDataType(String string) {
            this.datatype = string;
            this.objecttable[7] = this.datatype;
        }

        public void setDelta(double d) {
            this.delta = d;
            double d2 = this.delta / 90.0 * 1000.0;
            d2 = (double)Math.round(d2) / 1000.0;
            this.objecttable[4] = String.valueOf(d2);
        }

        public void setError(int n) {
            this.error = n;
            this.objecttable[8] = String.valueOf(this.error);
            if ((n & 0x20) != 0) {
                this.objecttable[3] = String.valueOf(this.objecttable[3].toString()) + "e";
            }
        }

        public void setOffsets(int n, int n2, int n3, int n4) {
            this.offset = n + n2;
            this.length = n3;
            this.chunk = n4;
            this.objecttable[0] = String.valueOf(this.chunk);
            this.objecttable[1] = String.valueOf(this.offset);
            this.objecttable[2] = String.valueOf(this.offset + this.length);
        }

        public void setPTSValue(long l) {
            this.pts = l;
            this.objecttable[5] = String.valueOf(this.pts);
            this.objecttable[6] = Common.formatTime_1(this.pts / 90L);
        }

        public String toString() {
            return "#" + this.getChunk() + " (" + this.getOffset() + "->" + (this.getOffset() + this.getLength()) + ")" + this.datatype;
        }
    }
}

