/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import net.sourceforge.dvb.projectx.audio.AudioFormat;

public class AudioFormatDTS
extends AudioFormat {
    private int[] dts_frequency_index;
    private int[] dts_bitrate_index;
    private String[] dts_acmod;
    private int[] dts_channels;

    public AudioFormatDTS() {
        int[] nArray = new int[16];
        nArray[1] = 8000;
        nArray[2] = 16000;
        nArray[3] = 32000;
        nArray[4] = 64000;
        nArray[5] = 128000;
        nArray[6] = 11025;
        nArray[7] = 22050;
        nArray[8] = 44100;
        nArray[9] = 88200;
        nArray[10] = 176400;
        nArray[11] = 12000;
        nArray[12] = 24000;
        nArray[13] = 48000;
        nArray[14] = 96000;
        nArray[15] = 192000;
        this.dts_frequency_index = nArray;
        int[] nArray2 = new int[32];
        nArray2[0] = 32000;
        nArray2[1] = 56000;
        nArray2[2] = 64000;
        nArray2[3] = 96000;
        nArray2[4] = 112000;
        nArray2[5] = 128000;
        nArray2[6] = 192000;
        nArray2[7] = 224000;
        nArray2[8] = 256000;
        nArray2[9] = 320000;
        nArray2[10] = 384000;
        nArray2[11] = 448000;
        nArray2[12] = 512000;
        nArray2[13] = 576000;
        nArray2[14] = 640000;
        nArray2[15] = 768000;
        nArray2[16] = 896000;
        nArray2[17] = 1024000;
        nArray2[18] = 1152000;
        nArray2[19] = 1280000;
        nArray2[20] = 1344000;
        nArray2[21] = 1408000;
        nArray2[22] = 1411200;
        nArray2[23] = 1472000;
        nArray2[24] = 0x177000;
        nArray2[25] = 1920000;
        nArray2[26] = 2048000;
        nArray2[27] = 0x2EE000;
        nArray2[28] = 3840000;
        nArray2[29] = 4096000;
        this.dts_bitrate_index = nArray2;
        this.dts_acmod = new String[]{"1", "DM", "2/0", "2/0", "2/0", "3/0", "2.1/0", "3.1/0", "2/2", "3/2", "2/2/2", "2/2/2", "3/2/2", "3.1/2/2", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        int[] nArray3 = new int[64];
        nArray3[0] = 1;
        nArray3[1] = 2;
        nArray3[2] = 2;
        nArray3[3] = 2;
        nArray3[4] = 2;
        nArray3[5] = 3;
        nArray3[6] = 3;
        nArray3[7] = 4;
        nArray3[8] = 4;
        nArray3[9] = 5;
        nArray3[10] = 6;
        nArray3[11] = 6;
        nArray3[12] = 7;
        nArray3[13] = 8;
        this.dts_channels = nArray3;
    }

    public int compareHeader() {
        if (this.getLastID() != this.getID()) {
            return 1;
        }
        if (this.getLastLayer() != this.getLayer()) {
            return 2;
        }
        if (this.getLastSamplingFrequency() != this.getSamplingFrequency()) {
            return 4;
        }
        if (this.getLastBitrate() != this.getBitrate()) {
            return 8;
        }
        if (this.getLastMode() != this.getMode()) {
            return 16;
        }
        if (this.getLastModeExtension() != this.getModeExtension()) {
            return 32;
        }
        if (this.getLastSize() != this.getSize()) {
            return 64;
        }
        return 0;
    }

    public String displayHeader() {
        return "DTS, " + this.dts_acmod[this.getLastMode()] + "(" + this.dts_channels[this.getLastMode()] + "), " + this.getLastSamplingFrequency() + "Hz, " + (double)this.getLastBitrate() / 1000.0 + "kbps, " + this.getLastSize() + "BpF";
    }

    public int parseHeader(byte[] byArray, int n) {
        if (byArray[n] != 127 || byArray[n + 1] != -2 || byArray[n + 2] != -128 || byArray[n + 3] != 1) {
            return -1;
        }
        this.setID(0);
        this.setEmphasis(0);
        this.setProtectionBit(1);
        this.setSamplingFrequency(this.dts_frequency_index[0xF & byArray[n + 8] >>> 2]);
        if (this.getSamplingFrequency() < 1) {
            return -4;
        }
        this.setBitrate(this.dts_bitrate_index[(3 & byArray[n + 8]) << 3 | 7 & byArray[n + 9] >>> 5]);
        if (this.getBitrate() < 1) {
            return -3;
        }
        this.setLayer(0);
        this.setPaddingBit(0);
        this.setPrivateBit(0);
        this.setMode((0xF & byArray[n + 7]) << 2 | (0xC0 & byArray[n + 8]) >>> 6);
        this.setModeExtension(0);
        this.setChannel(this.dts_channels[this.getMode()]);
        this.setCopyright(0);
        this.setOriginal(0);
        this.setSize((1 & byArray[n + 4]) << 6 | (0xFC & byArray[n + 5]) >>> 2);
        this.setSize(this.getSize() + 1 << 5);
        this.setFrameTimeLength(90000.0 * (double)this.getSize() / (double)this.getSamplingFrequency());
        this.setSize((3 & byArray[n + 5]) << 12 | (0xFF & byArray[n + 6]) << 4 | (0xF0 & byArray[n + 7]) >>> 4);
        this.setSize(this.getSize() + 1);
        this.setSizeBase(this.getSize());
        return 1;
    }

    public int parseNextHeader(byte[] byArray, int n) {
        if (byArray[n] != 127 || byArray[n + 1] != -2 || byArray[n + 2] != -128 || byArray[n + 3] != 1) {
            return -1;
        }
        this.setNextID(0);
        this.setNextEmphasis(0);
        this.setNextProtectionBit(1);
        this.setNextSamplingFrequency(this.dts_frequency_index[0xF & byArray[n + 8] >>> 2]);
        if (this.getNextSamplingFrequency() < 1) {
            return -4;
        }
        this.setNextBitrate(this.dts_bitrate_index[(3 & byArray[n + 8]) << 3 | 7 & byArray[n + 9] >>> 5]);
        if (this.getNextBitrate() < 1) {
            return -3;
        }
        this.setNextLayer(0);
        this.setNextPaddingBit(0);
        this.setNextPrivateBit(0);
        this.setNextMode((0xF & byArray[n + 7]) << 2 | (0xC0 & byArray[n + 8]) >>> 6);
        this.setNextModeExtension(0);
        this.setNextChannel(this.dts_channels[this.getNextMode()]);
        this.setNextCopyright(0);
        this.setNextOriginal(0);
        this.setNextSize((1 & byArray[n + 4]) << 6 | (0xFC & byArray[n + 5]) >>> 2);
        this.setNextSize(this.getNextSize() + 1 << 5);
        this.setNextFrameTimeLength(90000.0 * (double)this.getNextSize() / (double)this.getNextSamplingFrequency());
        this.setNextSize((3 & byArray[n + 5]) << 12 | (0xFF & byArray[n + 6]) << 4 | (0xF0 & byArray[n + 7]) >>> 4);
        this.setNextSize(this.getNextSize() + 1);
        this.setNextSizeBase(this.getNextSize());
        return 1;
    }
}

