/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import java.util.Arrays;
import net.sourceforge.dvb.projectx.audio.AudioFormat;
import net.sourceforge.dvb.projectx.parser.CommonParsing;

public class AudioFormatAC3
extends AudioFormat {
    private int bsid = 0;
    private int CRC16_POLY = 98309;
    private int[] crc_table = new int[256];
    private int[] ac3_frequency_index;
    private int[] ac3_bitrate_index;
    private int[][] ac3_size_table;
    private String[] bsmod;
    private String[] cmixlev;
    private String[] surmixlev;
    private String[] dsurmod;
    private String[] acmod;
    private String[][] lfe;
    private int[] ac3_channels;
    private final int[] armode;
    private final int[] arsample;
    private final int[] arbitrate;
    private final int[][] ac3const;
    private WaveHeader WaveHeader_Ch1;

    public AudioFormatAC3() {
        int[] nArray = new int[4];
        nArray[0] = 48000;
        nArray[1] = 44100;
        nArray[2] = 32000;
        this.ac3_frequency_index = nArray;
        int[] nArray2 = new int[32];
        nArray2[0] = 32000;
        nArray2[1] = 40000;
        nArray2[2] = 48000;
        nArray2[3] = 56000;
        nArray2[4] = 64000;
        nArray2[5] = 80000;
        nArray2[6] = 96000;
        nArray2[7] = 112000;
        nArray2[8] = 128000;
        nArray2[9] = 160000;
        nArray2[10] = 192000;
        nArray2[11] = 224000;
        nArray2[12] = 256000;
        nArray2[13] = 320000;
        nArray2[14] = 384000;
        nArray2[15] = 448000;
        nArray2[16] = 512000;
        nArray2[17] = 576000;
        nArray2[18] = 640000;
        this.ac3_bitrate_index = nArray2;
        this.ac3_size_table = new int[][]{{128, 160, 192, 224, 256, 320, 384, 448, 512, 640, 768, 896, 1024, 1280, 1536, 1792, 2048, 2304, 2560}, {138, 174, 208, 242, 278, 348, 416, 486, 556, 696, 834, 974, 1114, 1392, 1670, 1950, 2228, 2506, 2786}, {192, 240, 288, 336, 384, 480, 576, 672, 768, 960, 1152, 1344, 1536, 1920, 2304, 2688, 3120, 3456, 3840}};
        this.bsmod = new String[]{", CM", ", ME", ", K:VI", ", K:HI", ", K:D", ", K:C", ", K:E", ", K:VO"};
        this.cmixlev = new String[]{"", ", cm -3.0dB", ", cm -4.5dB", ", cm -6.0dB", ", cm -4.5dB"};
        this.surmixlev = new String[]{"", ", sm -3dB", ", sm -6dB", ", sm 0dB", ", sm -6dB"};
        this.dsurmod = new String[]{"", ", notDS", ", DS", ""};
        this.acmod = new String[]{"1+1", "1/0", "2/0", "3/0", "2/1", "3/1", "2/2", "3/2"};
        this.lfe = new String[][]{{".0", ".1"}, {"", "lfe"}};
        this.ac3_channels = new int[]{2, 1, 2, 3, 3, 4, 4, 5};
        int[] nArray3 = new int[8];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 3;
        nArray3[4] = 3;
        nArray3[5] = 4;
        nArray3[6] = 4;
        nArray3[7] = 5;
        this.armode = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 48000;
        nArray4[1] = 44100;
        nArray4[2] = 32000;
        this.arsample = nArray4;
        int[] nArray5 = new int[21];
        nArray5[1] = 40000;
        nArray5[2] = 48000;
        nArray5[3] = 56000;
        nArray5[4] = 64000;
        nArray5[5] = 80000;
        nArray5[6] = 96000;
        nArray5[7] = 112000;
        nArray5[8] = 128000;
        nArray5[9] = 160000;
        nArray5[10] = 192000;
        nArray5[11] = 224000;
        nArray5[12] = 256000;
        nArray5[13] = 320000;
        nArray5[14] = 384000;
        nArray5[15] = 448000;
        nArray5[16] = 512000;
        nArray5[17] = 576000;
        nArray5[18] = 640000;
        this.arbitrate = nArray5;
        this.ac3const = new int[][]{{288000000, 160, 192, 224, 256, 320, 384, 448, 512, 640, 768, 896, 1024, 1280, 1536, 1792, 2080, 2304, 2560}, {313469388, 174, 208, 242, 278, 348, 416, 486, 556, 696, 834, 974, 1114, 1392, 1670, 1950, 2228, 2506, 2786}, {432000000, 240, 288, 336, 384, 480, 576, 672, 768, 960, 1152, 1344, 1536, 1920, 2304, 2688, 3120, 3456, 3840}};
        this.initCRCTable();
    }

    private void clearCRC(byte[] byArray, int n) {
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[n - 2] = 0;
        byArray[n - 1] = 0;
    }

    public int compareHeader() {
        if (this.getLastID() != this.getID()) {
            return 1;
        }
        if (this.getLastLayer() != this.getLayer()) {
            return 2;
        }
        if (this.getLastSamplingFrequency() != this.getSamplingFrequency()) {
            return 4;
        }
        if (this.getLastBitrate() != this.getBitrate()) {
            return 8;
        }
        if (this.getLastMode() != this.getMode()) {
            return 16;
        }
        if (this.getLastModeExtension() != this.getModeExtension()) {
            return 32;
        }
        if (this.getLastOriginal() != this.getOriginal()) {
            return 64;
        }
        if (this.getLastEmphasis() != this.getEmphasis()) {
            return 128;
        }
        if (this.getLastProtectionBit() != this.getProtectionBit()) {
            return 256;
        }
        return 0;
    }

    private void computeCRC(byte[] byArray, int n) {
        int n2 = n >>> 1;
        int n3 = 2 * ((n2 >>> 1) + (n2 >>> 3));
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        n4 = this.determineCRC(byArray, 4, n3, 0);
        n6 = this.pow_poly(this.CRC16_POLY >>> 1, (n3 << 3) - 16, this.CRC16_POLY);
        n4 = this.mul_poly(n6, n4, this.CRC16_POLY);
        byArray[2] = (byte)(0xFF & n4 >> 8);
        byArray[3] = (byte)(0xFF & n4);
        n5 = this.determineCRC(byArray, n3, (n2 << 1) - 2, 0);
        byArray[2 * n2 - 2] = (byte)(0xFF & n5 >> 8);
        byArray[2 * n2 - 1] = (byte)(0xFF & n5);
    }

    private int determineCRC(byte[] byArray, int n, int n2, int n3) {
        int n4 = n;
        while (n4 < n2) {
            n3 = (this.crc_table[0xFF & byArray[n4] ^ n3 >> 8] ^ n3 << 8) & 0xFFFF;
            ++n4;
        }
        return n3;
    }

    public String displayHeader() {
        return "AC-3" + this.bsmod[this.getLastLayer()] + ", " + this.acmod[this.getLastMode()] + this.lfe[1][1 & this.getLastModeExtension()] + "(" + this.ac3_channels[this.getLastMode()] + this.lfe[0][1 & this.getLastModeExtension()] + ")" + ", bsid " + this.getLastProtectionBit() + ", dn -" + this.getLastOriginal() + "dB" + this.dsurmod[this.getLastModeExtension() >>> 1] + this.cmixlev[this.getLastEmphasis()] + this.surmixlev[this.getLastPrivateBit()] + ", " + this.getLastSamplingFrequency() + "Hz, " + this.getLastBitrate() / 1000 + "kbps";
    }

    public byte[] editFrame(byte[] byArray, int n) {
        switch (n) {
            case 1: {
                this.setChannelFlags(byArray, 7);
                break;
            }
            case 2: {
                byArray = this.setNewBitrate(byArray);
                break;
            }
            case 3: {
                byArray = this.setSilence(byArray);
                break;
            }
            case 4: {
                byArray = this.setBsid(byArray);
                break;
            }
        }
        return byArray;
    }

    private int getAC3Bitrate(byte[] byArray, int n) {
        return this.ac3_bitrate_index[0x1F & byArray[n + 4] >>> 1];
    }

    private int getAC3Bsmod(byte[] byArray, int n) {
        return 7 & byArray[n + 5];
    }

    private int getAC3Mode(byte[] byArray, int n) {
        return 7 & byArray[n + 6] >>> 5;
    }

    private int getAC3SamplingFrequency(byte[] byArray, int n) {
        return this.ac3_frequency_index[3 & byArray[n + 4] >>> 6];
    }

    private int getBSI(byte[] byArray, int n) {
        int[] nArray = new int[]{n << 3};
        int n2 = 0;
        int n3 = 0;
        this.getBits(byArray, nArray, 16);
        this.getBits(byArray, nArray, 16);
        this.getBits(byArray, nArray, 2);
        this.getBits(byArray, nArray, 6);
        this.getBits(byArray, nArray, 5);
        this.getBits(byArray, nArray, 3);
        n2 = this.getBits(byArray, nArray, 3);
        if ((n2 & 1) > 0 && n2 != 1) {
            this.getBits(byArray, nArray, 2);
        }
        if ((n2 & 4) > 0) {
            this.getBits(byArray, nArray, 2);
        }
        if (n2 == 2) {
            this.getBits(byArray, nArray, 2);
        }
        this.getBits(byArray, nArray, 1);
        this.getBits(byArray, nArray, 5);
        if (this.getBits(byArray, nArray, 1) == 1) {
            this.getBits(byArray, nArray, 8);
        }
        if (this.getBits(byArray, nArray, 1) == 1) {
            this.getBits(byArray, nArray, 8);
        }
        if (this.getBits(byArray, nArray, 1) == 1) {
            this.getBits(byArray, nArray, 5);
            this.getBits(byArray, nArray, 2);
        }
        if (n2 == 0) {
            this.getBits(byArray, nArray, 5);
            if (this.getBits(byArray, nArray, 1) == 1) {
                this.getBits(byArray, nArray, 8);
            }
            if (this.getBits(byArray, nArray, 1) == 1) {
                this.getBits(byArray, nArray, 8);
            }
            if (this.getBits(byArray, nArray, 1) == 1) {
                this.getBits(byArray, nArray, 5);
                this.getBits(byArray, nArray, 2);
            }
        }
        this.getBits(byArray, nArray, 1);
        this.getBits(byArray, nArray, 1);
        if (this.getBits(byArray, nArray, 1) == 1) {
            this.getBits(byArray, nArray, 14);
        }
        if (this.getBits(byArray, nArray, 1) == 1) {
            this.getBits(byArray, nArray, 14);
        }
        if (this.getBits(byArray, nArray, 1) == 1) {
            n3 = this.getBits(byArray, nArray, 6);
            this.getBits(byArray, nArray, (n3 + 1) * 8);
        }
        return nArray[0];
    }

    public byte[] getExtraWaveHeader(int n, boolean bl) {
        if (n == 1) {
            return bl ? this.WaveHeader_Ch1.getPlaceHolder() : this.WaveHeader_Ch1.getHeader();
        }
        return new byte[0];
    }

    private boolean hasAC3Syncword(byte[] byArray, int n) {
        return byArray[n] == 11 && byArray[n + 1] == 119;
    }

    private void initCRCTable() {
        int n = 0;
        while (n < 256) {
            int n2 = n << 8;
            int n3 = 0;
            while (n3 < 8) {
                n2 = (n2 & 0x8000) != 0 ? n2 << 1 & 0xFFFF ^ this.CRC16_POLY & 0xFFFF : (n2 <<= 1);
                ++n3;
            }
            this.crc_table[n] = n2;
            ++n;
        }
    }

    public void initExtraWaveHeader(boolean bl, boolean bl2, boolean bl3) {
        this.WaveHeader_Ch1 = new WaveHeader(bl3);
    }

    private int mul_poly(int n, int n2, int n3) {
        int n4 = 0;
        while (n > 0) {
            if ((n & 1) > 0) {
                n4 ^= n2;
            }
            n >>>= 1;
            if (((n2 <<= 1) & 0x10000) <= 0) continue;
            n2 ^= n3;
        }
        return n4;
    }

    public int parseHeader(byte[] byArray, int n) {
        if (!this.hasAC3Syncword(byArray, n)) {
            return -1;
        }
        this.setID(0);
        this.setEmphasis(0);
        this.setPrivateBit(0);
        this.setSamplingFrequency(this.getAC3SamplingFrequency(byArray, n));
        if (this.getSamplingFrequency() < 1) {
            return -4;
        }
        this.setBitrate(this.getAC3Bitrate(byArray, n));
        if (this.getBitrate() < 1) {
            return -3;
        }
        this.setProtectionBit(0x1F & byArray[n + 5] >> 3);
        this.setLayer(this.getAC3Bsmod(byArray, n));
        this.setPaddingBit(1 & byArray[n + 4]);
        this.setMode(this.getAC3Mode(byArray, n));
        this.setModeExtension(0);
        int n2 = (0xFF & byArray[n + 6]) << 8 | 0xFF & byArray[n + 7];
        int n3 = 0;
        if ((this.getMode() & 1) > 0 && this.getMode() != 1) {
            this.setEmphasis(1 + (3 & byArray[n + 6] >>> 3));
            ++n3;
        }
        if ((this.getMode() & 4) > 0) {
            this.setPrivateBit(1 + (3 & byArray[n + 6] >>> (n3 > 0 ? 1 : 3)));
            ++n3;
        }
        if (this.getMode() == 2) {
            this.setModeExtension(this.getModeExtension() | 6 & n2 >>> 10 - 2 * n3);
            ++n3;
        }
        if (n3 < 4) {
            this.setModeExtension(this.getModeExtension() | 1 & n2 >>> 12 - 2 * n3);
            this.setOriginal(0x1F & n2 >>> 7 - 2 * n3);
        }
        this.setChannel(this.ac3_channels[this.getMode()] + (1 & this.getModeExtension()));
        this.setCopyright(0);
        this.setFrameTimeLength(1.3824E8 / (double)this.getSamplingFrequency());
        this.setSizeBase(this.ac3_size_table[3 & byArray[n + 4] >>> 6][0x1F & byArray[n + 4] >>> 1]);
        this.setSize(this.getSamplingFrequency() == this.ac3_frequency_index[1] ? this.getSizeBase() + this.getPaddingBit() * 2 : this.getSizeBase());
        return 1;
    }

    public int parseNextHeader(byte[] byArray, int n) {
        if (!this.hasAC3Syncword(byArray, n)) {
            return -1;
        }
        this.setNextID(0);
        this.setNextEmphasis(0);
        this.setNextPrivateBit(0);
        this.setNextSamplingFrequency(this.getAC3SamplingFrequency(byArray, n));
        if (this.getNextSamplingFrequency() < 1) {
            return -4;
        }
        this.setNextBitrate(this.getAC3Bitrate(byArray, n));
        if (this.getNextBitrate() < 1) {
            return -3;
        }
        this.setNextProtectionBit(0x1F & byArray[n + 5] >> 3);
        this.setNextLayer(this.getAC3Bsmod(byArray, n));
        this.setNextPaddingBit(1 & byArray[n + 4]);
        this.setNextMode(this.getAC3Mode(byArray, n));
        this.setNextModeExtension(0);
        int n2 = (0xFF & byArray[n + 6]) << 8 | 0xFF & byArray[n + 7];
        int n3 = 0;
        if ((this.getNextMode() & 1) > 0 && this.getNextMode() != 1) {
            this.setNextEmphasis(1 + (3 & byArray[n + 6] >>> 3));
            ++n3;
        }
        if ((this.getNextMode() & 4) > 0) {
            this.setNextPrivateBit(1 + (3 & byArray[n + 6] >>> (n3 > 0 ? 1 : 3)));
            ++n3;
        }
        if (this.getNextMode() == 2) {
            this.setNextModeExtension(this.getNextModeExtension() | 6 & n2 >>> 10 - 2 * n3);
            ++n3;
        }
        if (n3 < 4) {
            this.setNextModeExtension(this.getNextModeExtension() | 1 & n2 >>> 12 - 2 * n3);
            this.setNextOriginal(0x1F & n2 >>> 7 - 2 * n3);
        }
        this.setNextChannel(this.ac3_channels[this.getNextMode()] + (1 & this.getNextModeExtension()));
        this.setNextCopyright(0);
        this.setNextFrameTimeLength(1.3824E8 / (double)this.getNextSamplingFrequency());
        this.setNextSizeBase(this.ac3_size_table[3 & byArray[n + 4] >>> 6][0x1F & byArray[n + 4] >>> 1]);
        this.setNextSize(this.getNextSamplingFrequency() == this.ac3_frequency_index[1] ? this.getNextSizeBase() + this.getNextPaddingBit() * 2 : this.getNextSizeBase());
        return 1;
    }

    public void parseRiffData(byte[] byArray, int n) {
        int[] nArray = new int[10];
        nArray[2] = this.arsample[(0xC0 & byArray[4]) >>> 6];
        nArray[4] = this.armode[(0xE0 & byArray[6]) >>> 5];
        nArray[6] = this.arbitrate[(0x3F & byArray[4]) >>> 1];
        nArray[8] = this.ac3const[(0xC0 & byArray[4]) >>> 6][(0x3E & byArray[4]) >>> 1] + ((1 & byArray[4]) != 0 ? 2 : 0);
        this.setExtraWaveData(nArray, n);
    }

    private int pow_poly(int n, int n2, int n3) {
        int n4 = 1;
        while (n2 > 0) {
            if ((n2 & 1) > 0) {
                n4 = this.mul_poly(n4, n, n3);
            }
            n = this.mul_poly(n, n, n3);
            n2 >>>= 1;
        }
        return n4;
    }

    private byte[] setBsid(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        if (this.getLastProtectionBit() == (0x1F & byArray2[5] >> 3)) {
            return byArray2;
        }
        byArray2[5] = (byte)(this.getLastProtectionBit() << 3 | 7 & byArray2[5]);
        this.clearCRC(byArray2, byArray2.length);
        this.computeCRC(byArray2, this.ac3_size_table[3 & byArray2[4] >>> 6][0x1F & byArray2[4] >>> 1]);
        return byArray2;
    }

    private void setChannelFlags(byte[] byArray, int n) {
        byArray[6] = (byte)(0xF & byArray[6] | n << 5);
    }

    public void setExtraWaveData(int[] nArray, int n) {
        if (n == 1) {
            this.WaveHeader_Ch1.setWaveData(nArray);
        }
    }

    public void setExtraWaveLength(long l, long l2, int n) {
        if (n == 1) {
            this.WaveHeader_Ch1.setWaveLength(l, l2);
        }
    }

    private byte[] setNewBitrate(byte[] byArray) {
        int n = 0x1F & byArray[4] >>> 1;
        int n2 = (int)(0x1FL & CommonParsing.getAudioProcessingFlags() >>> 4);
        if (n == n2) {
            return byArray;
        }
        if (n > n2) {
            n2 = n;
            if (CommonParsing.getAudioProcessingFlags() >>> 18 > 0L) {
                CommonParsing.setAudioProcessingFlags(CommonParsing.getAudioProcessingFlags() | 0xCL);
            }
        }
        CommonParsing.setAudioProcessingFlags(0xFFFFFFFFFFFFF00FL & CommonParsing.getAudioProcessingFlags() | (long)(n2 << 4));
        byte[] byArray2 = new byte[this.ac3_size_table[3 & byArray[4] >>> 6][n2]];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[4] = (byte)(byArray2[4] & 0xC0);
        byArray2[4] = (byte)(byArray2[4] | n2 << 1);
        this.clearCRC(byArray2, byArray.length);
        this.computeCRC(byArray2, this.ac3_size_table[3 & byArray2[4] >>> 6][n2]);
        return byArray2;
    }

    private byte[] setSilence(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n = this.getBSI(byArray2, 0);
        if ((n & 7) == 0) {
            Arrays.fill(byArray2, n >>> 3, byArray2.length, (byte)0);
        } else {
            Arrays.fill(byArray2, n + 1 >>> 3, byArray2.length, (byte)0);
            int n2 = n >>> 3;
            byArray2[n2] = (byte)(byArray2[n2] & 65280 >>> (n & 7));
        }
        this.clearCRC(byArray2, byArray2.length);
        this.computeCRC(byArray2, this.ac3_size_table[3 & byArray2[4] >>> 6][0x1F & byArray2[4] >>> 1]);
        return byArray2;
    }

    public int validateCRC(byte[] byArray, int n, int n2) {
        int n3 = n2 >>> 1;
        int n4 = 2 * ((n3 >>> 1) + (n3 >>> 3));
        int n5 = -1;
        n5 = this.determineCRC(byArray, 2, n4, 0);
        if (n5 != 0) {
            return 1;
        }
        if ((n5 = this.determineCRC(byArray, n4, n2, n5)) != 0) {
            return 2;
        }
        return 0;
    }

    private class WaveHeader {
        private byte[] riffac3;
        private long Samples;
        private long SampleCount;
        private final int HeaderLength_AC3 = 46;
        private final int AC3_WaveFormat = 1;
        private int WaveFormat;

        public WaveHeader(boolean bl) {
            byte[] byArray = new byte[46];
            byArray[0] = 82;
            byArray[1] = 73;
            byArray[2] = 70;
            byArray[3] = 70;
            byArray[8] = 87;
            byArray[9] = 65;
            byArray[10] = 86;
            byArray[11] = 69;
            byArray[12] = 102;
            byArray[13] = 109;
            byArray[14] = 116;
            byArray[15] = 32;
            byArray[16] = 18;
            byArray[21] = 32;
            byArray[22] = 1;
            byArray[24] = 1;
            byArray[36] = 18;
            byArray[38] = 100;
            byArray[39] = 97;
            byArray[40] = 116;
            byArray[41] = 97;
            this.riffac3 = byArray;
            this.Samples = 0L;
            this.SampleCount = 0L;
            this.HeaderLength_AC3 = 46;
            this.AC3_WaveFormat = 1;
            this.WaveFormat = bl ? 1 : 0;
        }

        public byte[] getHeader() {
            if (this.WaveFormat == 1) {
                return this.riffac3;
            }
            return new byte[0];
        }

        public byte[] getPlaceHolder() {
            if (this.WaveFormat == 1) {
                return new byte[46];
            }
            return new byte[0];
        }

        public void setWaveData(int[] nArray) {
            this.Samples += (long)nArray[2];
            ++this.SampleCount;
            int n = AudioFormatAC3.this.getValue(this.riffac3, 24, 4, true);
            int n2 = AudioFormatAC3.this.getValue(this.riffac3, 32, 2, true);
            if (n2 == 0) {
                AudioFormatAC3.this.setValue(this.riffac3, 32, 2, true, nArray[8]);
            } else if (n2 != 1 && n2 != nArray[8]) {
                AudioFormatAC3.this.setValue(this.riffac3, 32, 2, true, 1);
            }
            if (n == 1) {
                AudioFormatAC3.this.setValue(this.riffac3, 24, 4, true, nArray[2]);
            } else if (n != 0 && n != nArray[2]) {
                AudioFormatAC3.this.setValue(this.riffac3, 24, 4, true, 0);
            }
            if ((0xFF & this.riffac3[22]) < nArray[4]) {
                this.riffac3[22] = (byte)nArray[4];
            }
        }

        public void setWaveLength(long l, long l2) {
            int n = (int)l - 46;
            int n2 = 0;
            while (n2 < 4) {
                this.riffac3[4 + n2] = (byte)(0xFF & n + 38 >>> n2 * 8);
                this.riffac3[42 + n2] = (byte)(0xFF & n >>> n2 * 8);
                ++n2;
            }
            if (l <= 100L) {
                return;
            }
            int n3 = (int)l2;
            int n4 = (int)(1000L * (long)n / (long)n3);
            AudioFormatAC3.this.setValue(this.riffac3, 28, 4, true, n4);
        }
    }
}

