/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return RET

/*:VRX         GETCOLOR_Close
*/
GETCOLOR_Close:
    call Quit
return

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
/* Arguments: VRWINDOW(),FORECOLOR,BACKCOLOR,TITLE */
/* Returns: FORECOLOR BACKCOLOR if OK pressed, or "" if Cancel pressed */
IF INITARGS.1="<default>" THEN INITARGS.1="(0,0,0)"
IF INITARGS.2="<default>" THEN INITARGS.2="(255,255,255)"
CALL VRSET "DT_1","FORECOLOR",INITARGS.1,"BACKCOLOR",INITARGS.2,"CAPTION","Forecolor:"||"D"x||INITARGS.1"D"x||"Backcolor:"||"D"x||INITARGS.2
/* Color names -> RGB values */
COL.BLACK="(0,0,0)"
COL.BLUE="(0,0,255)"
COL.BROWN="(128,128,0)"
COL.CYAN="(0,255,255)"
COL.DARKBLUE="(0,0,128)"
COL.DARKCYAN="(0,0,128)"
COL.DARKGRAY="(128,128,128)"
COL.DARKGREEN="(0,128,0)"
COL.DARKPINK="(128,0,128)"
COL.DARKRED="(128,0,0)"
COL.GREEN="(0,255,0)"
COL.PALEGRAY="(204,204,204)"
COL.PINK="(255,0,255)"
COL.RED="(255,0,0)"
COL.WHITE="(255,255,255)"
COL.YELLOW="(255,255,0)"
/* End color names */
    CALL RB_1_CLICK
    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1, "Caption", INITARGS.3
    call VRMethod window, "Activate"
    drop window
    RET=""
return

/*:VRX         PB_Cancel_Click
*/
PB_Cancel_Click: 
CALL QUIT
return

/*:VRX         PB_OK_Click
*/
PB_OK_Click: 
RET=VRGET("DT_1","FORECOLOR") VRGET("DT_1","BACKCOLOR")
CALL QUIT
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         RB_1_Click
*/
RB_1_Click: 
C=VRGET("DT_1","FORECOLOR")
IF LEFT(C,1)="(" THEN NOP
ELSE DO /* Color name */
    IF C="<default>" THEN C="(0,0,0)"
    ELSE IF COL.C="COL."C THEN C="(128,128,128)"
    ELSE C=COL.C
END
PARSE VALUE C WITH "("R","G"," B")"
CALL VRSET "SL_RED","PERCENTILE",TRUNC(R/2.55)
CALL VRSET "SL_GREEN","PERCENTILE",TRUNC(G/2.55)
CALL VRSET "SL_BLUE","PERCENTILE",TRUNC(B/2.55)
return

/*:VRX         RB_2_Click
*/
RB_2_Click: 
C=VRGET("DT_1","BACKCOLOR")
IF LEFT(C,1)="(" THEN NOP
ELSE DO /* Color name */
    IF C="<default>" THEN C="(255,255,255)"
    ELSE IF COL.C="COL."C THEN C="(128,128,128)"
    ELSE C=COL.C
END
PARSE VALUE C WITH "("R","G"," B")" /* If no space, generates Invalid Hex Or Bin String error on ","B */
CALL VRSET "SL_RED","PERCENTILE",TRUNC(R/2.55)
CALL VRSET "SL_GREEN","PERCENTILE",TRUNC(G/2.55)
CALL VRSET "SL_BLUE","PERCENTILE",TRUNC(B/2.55)
return

/*:VRX         SL_Blue_Change
*/
SL_Blue_Change: 
CALL SLIDERCHANGED
return

/*:VRX         SL_Blue_Track
*/
SL_Blue_Track: 
CALL SLIDERCHANGED
return

/*:VRX         SL_Green_Change
*/
SL_Green_Change: 
CALL SLIDERCHANGED
return

/*:VRX         SL_Green_Track
*/
SL_Green_Track: 
CALL SLIDERCHANGED
return

/*:VRX         SL_Red_Change
*/
SL_Red_Change: 
CALL SLIDERCHANGED
return

/*:VRX         SL_Red_Track
*/
SL_Red_Track: 
CALL SLIDERCHANGED
return

/*:VRX         SLIDERCHANGED
*/
SLIDERCHANGED: 
IF VRGET("RB_1","SET") THEN PROP="FORECOLOR"
ELSE PROP="BACKCOLOR"
VAL="("TRUNC(VRGET("SL_RED","PERCENTILE")*2.55)","TRUNC(VRGET("SL_GREEN","PERCENTILE")*2.55)","TRUNC(VRGET("SL_BLUE","PERCENTILE")*2.55)")"
CALL VRSET "DT_1",PROP,VAL
CALL VRSET "DT_1","CAPTION","Forecolor:"||"D"x||VRGET("DT_1","FORECOLOR")"D"x||"Backcolor:"||"D"x||VRGET("DT_1","BACKCOLOR")
return

