/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    CALL VRREDIRECTSTDIO "OFF"
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         __VXREXX____APPENDS__
*/
__VXREXX____APPENDS__:
/*
*/
return
/*:VRX         CHECKCHANGE
*/
CHECKCHANGE: 
IF \VRMETHOD("MLE_EDITOR","QUERYCHANGED") THEN RETURN 0
Buttons.1 = "~Save"
Buttons.2 = "Save ~as"
Buttons.3 = "~Discard"
Buttons.4 = "Cancel"
Buttons.0 = 4
id = VRMessage( VRWindow(), FILENAME" has been changed. Do you want to save it?", TITLE, "W", "Buttons.", 1, 4 )
SELECT
    WHEN ID=1 THEN DO; SYNCMODE=1; CALL FILESAVE_CLICK; SYNCMODE=0; END
    WHEN ID=2 THEN DO; SYNCMODE=1; CALL FILESAVEAS_CLICK; SYNCMODE=0; END
    WHEN ID=4 THEN RETURN 1
OTHERWISE NOP
END
return 0

/*:VRX         Edit_Close
*/
Edit_Close:
    call Quit
return

/*:VRX         EDITFIND_Click
*/
EDITFIND_Click: 
CALL VRSET "FIND","VISIBLE",1
CALL VRMETHOD "FIND","ACTIVATE"
CALL VRMETHOD "EF_FIND","SETFOCUS"
return

/*:VRX         EDITUNDO_Click
*/
EDITUNDO_Click: 
CALL VRMETHOD "MLE_EDITOR","UNDO"
return

/*:VRX         EDMACRO
*/
EDMACRO: 
/* Similar to VRMACRO. */
MACROFILE=ARG(1)
IF VRPARSEFILENAME(MACROFILE,"E")="" THEN MACROFILE=MACROFILE".EDM"
MACRO=""
DO I=1 TO DIR.0
    MACRO=STREAM(DIR.I"\"MACROFILE,"C","QUERY EXISTS")
    IF MACRO\="" THEN LEAVE
END
IF MACRO\="" THEN DO
    CMD='CALL "'MACRO'"'
    IF ARG()>1 THEN CMD=CMD" ARG(2)"
    DO I=3 TO ARG()
        CMD=CMD",ARG("I")"
    END
    SIGNAL ON SYNTAX NAME MACROERROR
    INTERPRET CMD
END
RETURN

MACROERROR:
CALL VRMESSAGE VRWINDOW(),"A syntax error occurred trying to run """MACRO"""."'0D0A0D0A'x"The REXX error code is: "RC" -- "ERRORTEXT(RC)".","Error in macro"
RETURN

INITEDMACRO:
/* Initialization needed for EDMACRO */

/* DIR. - directories to search for macros */
DIR.0=3 /* 3 directories to search */
DIR.1=HOMEDIR /* Search the "home" directory (which contains the INI file etc), usually the executable directory */
DIR.2=DIRECTORY() /* Search the directory which was current at program init */
DIR.3="." /* Search the current directory */

RETURN

/*:VRX         FILEEXIT_Click
*/
FILEEXIT_Click: 
CALL QUIT
return

/*:VRX         FILENEW_Click
*/
FILENEW_Click: 
IF CHECKCHANGE() THEN RETURN
FILENAME="Untitled"
CALL REFRESH
CALL VRMETHOD "MLE_EDITOR","SETCHANGED",0
return

/*:VRX         FILEOPEN_Click
*/
FILEOPEN_Click: 
IF CHECKCHANGE() THEN RETURN
FN = VRFileDialog( VRWindow(), "Open filename:", "Open" )
IF FN="" THEN RETURN
FILENAME=FN
CALL REFRESH
CALL VRMETHOD "MLE_EDITOR","SETCHANGED",0
return

/*:VRX         FILESAVE_Click
*/
FILESAVE_Click: 
IF FILENAME="Untitled" THEN SIGNAL FILESAVEAS_CLICK
IF SYNCMODE=1 THEN DO
    CALL VRCREATEFILE FILENAME
    CALL CHAROUT FILENAME,VRGET("MLE_EDITOR","VALUE")
    CALL CHAROUT FILENAME
    RETURN
END
DO WHILE SAVETHREAD\=-1
    INTERPRET VREVENT()
    IF VRGET(VRWINDOW(),"SHUTDOWN") THEN SIGNAL HALT
END
CALL VRMETHOD "MLE_EDITOR","SETCHANGED",0
VALTOSAVE=VRGET("MLE_EDITOR","VALUE")
CALL VRMETHOD "APPLICATION","PUTVAR","VALTOSAVE"
SAVETHREAD=VRMETHOD("APPLICATION","STARTTHREAD","SAVE",FILENAME)
return

/*:VRX         FILESAVEAS_Click
*/
FILESAVEAS_Click: 
FN=VRFILEDIALOG(VRWINDOW(),"Save as filename:","S",FILENAME)
IF FN="" THEN RETURN
FILENAME=FN
CALL FILESAVE_CLICK
CALL REFRESHINFO
return

/*:VRX         FIND_Close
*/
FIND_Close: 
CALL VRSET "FIND","VISIBLE",0
CALL VRMETHOD VRWINDOW(),"ACTIVATE"
return

/*:VRX         Fini
*/
Fini:
    DO WHILE SAVETHREAD\=-1
        INTERPRET VREVENT()
    END
    CALL VRMETHOD "APPLICATION","LISTTHREADS","TID."
    DO I=2 TO TID.0
        CALL VRMETHOD "APPLICATION","HALTTHREAD",TID.I
    END
    window = VRWindow()
    call VRSet window, "Visible", 0
    CALL WIN2INI
    CALL WRITEINI
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         HELPABOUT_Click
*/
HELPABOUT_Click: 
MSG.0=2
MSG.1="Programmer's Editor v"VERSION
MSG.2="Copyright C. Angelico 2000 - All rights reserved"
IF RIGHT(VERSION,1)="A" THEN MSG.2="ALPHA RELEASE - Use at your own risk!"
IF RIGHT(VERSION,1)="B" THEN MSG.2="BETA RELEASE - Please send me an email and tell me how you like it!"
CALL VRMESSAGESTEM VRWINDOW(),"MSG.","About Programmer's Editor"
return

/*:VRX         INI2WIN
*/
INI2WIN: 
SAVE="LEFT TOP WIDTH HEIGHT WINDOWSTATE"
APP=VRGET(WINDOW,"NAME")
DO I=1 TO WORDS(SAVE)
    KEY=WORD(SAVE,I)
    CALL VRSET WINDOW,KEY,INI.APP.KEY
END
return

/*:VRX         Init
*/
Init:
#INCLUDE "Edit.VER"
    CALL VRLOAD VRWINDOW(),VRWINDOWPATH(),"FIND"
    SAVETHREAD=-1
    PROG=VRGET("APPLICATION","PROGRAM")
    IF PROG="" THEN HOMEDIR="." /* Use current directory */
    ELSE HOMEDIR=VRPARSEFILENAME(PROG,"DP") /* Use directory containing EXE */
    INIFILE=HOMEDIR"\EDIT.INI"
    CALL READINI
    TITLE="Programmer's Editor"
    CALL INITEDMACRO
    CALL EDMACRO "ONSTART",VRWINDOW()
    IF INITARGS.0>0 THEN FILENAME=INITARGS.1
    ELSE FILENAME="Untitled"
    CALL REFRESH
    window = VRWindow()
    CALL INI2WIN
    MLE="FONT FORECOLOR BACKCOLOR"
    APP="EDITOR"
    DO I=1 TO WORDS(MLE)
        KEY=WORD(MLE,I)
        F=INI.APP.KEY
        IF F\="" THEN CALL VRSET "MLE_EDITOR",WORD(MLE,I),F
    END
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         LOADOPTIONS
*/
LOADOPTIONS: 

return

/*:VRX         MLE_EDITOR_DoubleClick
*/
MLE_EDITOR_DoubleClick: 
IF VRINFO("CTRLPRESSED")&(BOOKS\="") THEN VIEW BOOKS VRGET("MLE_EDITOR","SELECTEDTEXT")
return

/*:VRX         MLE_EDITOR_DragDrop
*/
MLE_EDITOR_DragDrop: 
IF CHECKCHANGE() THEN RETURN
OP=TRANSLATE(VRINFO("OPERATION"))
FN=VRINFO("SOURCEFILE")
SELECT
    WHEN OP="MOVE" THEN DO
        IF CHECKCHANGE() THEN RETURN
        FILENAME=FN
        CALL REFRESH
        CALL VRMETHOD "MLE_EDITOR","SETCHANGED",0
    END
    WHEN OP="COPY" THEN DO
        CALL VRMETHOD "MLE_EDITOR","INSERT",CHARIN(FN,,CHARS(FN))
        CALL STREAM FN,"C","CLOSE"
    END
    WHEN OP="LINK" THEN CALL VRMETHOD "MLE_EDITOR","INSERT",FN
    OTHERWISE NOP
END
return

/*:VRX         MLE_EDITOR_KeyPress
*/
MLE_EDITOR_KeyPress: 
K=VRGET(VRINFO("O"),"KEYSTRING")
SELECT
    WHEN ((K="{Enter}")|(K="{Newline}"))&VRGET("OPTAUTOINDENT","CHECKED") THEN DO
        CURSOR=VRGET(VRINFO("O"),"SELECTEDSTART")
        VALUE=VRGET(VRINFO("O"),"VALUE")
        PARSE VALUE REVERSE(LEFT(VALUE,CURSOR-1)) WITH PREVLINE "0A0D"x
        PREVLINE=REVERSE(PREVLINE)
        V=VERIFY(PREVLINE,"0920"x)
        IF V=0 THEN PREVTAB=PREVLINE /* If only tabs/spaces, whole line is used */
        ELSE PREVTAB=LEFT(PREVLINE,V-1)
        CALL VRSET VRINFO("O"),"KEYSTRING",K||PREVTAB
    END
    WHEN (K="{Tab}")&VRGET("OPTTABINDENT","CHECKED") THEN DO
        SSTART=VRGET(VRINFO("O"),"SELECTEDSTART")
        SEND=VRGET(VRINFO("O"),"SELECTEDEND")
        IF SSTART\=SEND THEN DO /* If something selected */
            START=MIN(SSTART,SEND)
            END=MAX(SSTART,SEND)
            VAL=VRGET(VRINFO("O"),"VALUE")
            IF START=1 THEN DO; BEFORE=""; PARSE VALUE VAL WITH SEL =(END) AFTER; END
            ELSE PARSE VALUE VAL WITH BEFORE =(START) SEL =(END) AFTER
            IF POS("0D0A"x,SEL)=0 THEN RETURN
            REMOVEDAFTER=RIGHT(SEL,2)="0D0A"x
            IF REMOVEDAFTER THEN SEL=DBRRIGHT(SEL,2)
            NEWSEL=COPIES("09"x,(RIGHT(BEFORE,2)="0D0A"x)|(BEFORE="")) /* If selection starts with beginning of line, tab out 1st line as well */
            NEWCHARS=LENGTH(NEWSEL)
            DO WHILE POS("0D0A"x,SEL)>0
                PARSE VALUE SEL WITH L "0D0A"x SEL
                NEWSEL=NEWSEL||L"0D0A09"x
                NEWCHARS=NEWCHARS+1
            END
            NEWSEL=NEWSEL||SEL
            IF REMOVEDAFTER THEN NEWSEL=NEWSEL"0D0A"x
            FIRSTVIS=VRMETHOD(VRINFO("O"),"QUERYFIRSTCHAR")
            IF FIRSTVIS>SSTART THEN DO
                /* Increment FIRSTVIS by something? */
            END
            IF SSTART>SEND THEN SSTART=SSTART+NEWCHARS
            ELSE SEND=SEND+NEWCHARS
            CALL VRSET VRINFO("O"),"VALUE",BEFORE||NEWSEL||AFTER,"SELECTEDSTART",SSTART,"SELECTEDEND",SEND,"KEYSTRING",""
            CALL VRMETHOD VRINFO("O"),"SETFIRSTCHAR",FIRSTVIS
        END
    END
    WHEN (K="{Backtab}")&VRGET("OPTTABINDENT","CHECKED") THEN DO
        SSTART=VRGET(VRINFO("O"),"SELECTEDSTART")
        SEND=VRGET(VRINFO("O"),"SELECTEDEND")
        IF SSTART\=SEND THEN DO /* If something selected */
            CALL VRSET VRINFO("O"),"KEYSTRING",""
            START=MIN(SSTART,SEND)
            END=MAX(SSTART,SEND)
            VAL=VRGET(VRINFO("O"),"VALUE")
            IF START=1 THEN DO; BEFORE=""; PARSE VALUE VAL WITH SEL =(END) AFTER; END
            ELSE PARSE VALUE VAL WITH BEFORE =(START) SEL =(END) AFTER
            REMOVEDAFTER=0
            IF RIGHT(SEL,2)="0D0A"x THEN DO; REMOVEDAFTER=1; SEL=DBRRIGHT(SEL,2); END
            LESSCHARS=0
            IF (RIGHT(BEFORE,2)="0D0A"x)|(BEFORE="") THEN DO
                IF LEFT(SEL,1)\="09"x THEN RETURN /* If no tab on 1st line, can't backtab */
                SEL=DBRLEFT(SEL,1) /* Backtab 1st line */
                LESSCHARS=1
            END
            NEWSEL=""
            DO WHILE POS("0D0A"x,SEL)>0
                PARSE VALUE SEL WITH L "0D0A"x SEL
                IF LEFT(SEL,1)\="09"x THEN RETURN /* If no tab on 1st line, can't backtab */
                SEL=DBRLEFT(SEL,1) /* Backtab 1st line */
                LESSCHARS=LESSCHARS+1
                NEWSEL=NEWSEL||L"0D0A"x
            END
            NEWSEL=NEWSEL||SEL
            IF REMOVEDAFTER THEN NEWSEL=NEWSEL"0D0A"x
            IF SSTART>SEND THEN SSTART=SSTART-LESSCHARS
            ELSE SEND=SEND-LESSCHARS
            CALL VRSET VRINFO("O"),"VALUE",BEFORE||NEWSEL||AFTER,"SELECTEDSTART",SSTART,"SELECTEDEND",SEND
        END
    END
    WHEN (K="{Ctrl}{Up}")|(K="{Ctrl}{Down}") THEN DO
        CALL VRMETHOD VRINFO("O"),"SETFIRSTCHAR",VRMETHOD(VRINFO("O"),"CHARFROMLINE",VRMETHOD(VRINFO("O"),"LINEFROMCHAR",VRMETHOD(VRINFO("O"),"QUERYFIRSTCHAR"))+(K="{Ctrl}{Down}")-(K="{Ctrl}{Up}"))
    END
    OTHERWISE NOP
END
return

/*:VRX         OPTAUTOINDENT_Click
*/
OPTAUTOINDENT_Click: 
CALL VRSET VRINFO("O"),"CHECKED",\VRGET(VRINFO("O"),"CHECKED")
return

/*:VRX         OPTHELPBOOKS_Click
*/
OPTHELPBOOKS_Click: 
id = VRPrompt( VRWindow(), "Enter books to search on Ctrl-Double-click (separate multiple books with '+')", "BOOKS", "Editor" )
KEY=TRANSLATE(VRPARSEFILENAME(FILENAME,"E"))
IF KEY="" THEN KEY="."
APP="BOOKS"
INI.APP.KEY=BOOKS
return

/*:VRX         OPTSAVE_Click
*/
OPTSAVE_Click: 
CALL WRITEINI
return

/*:VRX         OPTSETCOLOR_Click
*/
OPTSETCOLOR_Click: 
PARSE VALUE GETCOLOR(VRWINDOW(),VRGET("MLE_EDITOR","FORECOLOR"),VRGET("MLE_EDITOR","BACKCOLOR"),"Select new colors") WITH F B
IF F="" THEN RETURN
CALL VRSET "MLE_EDITOR","FORECOLOR",F
APP="EDITOR"
INI.APP.FORECOLOR=F
CALL VRSET "MLE_EDITOR","BACKCOLOR",B
INI.APP.BACKCOLOR=B
return

/*:VRX         OPTSETFONT_Click
*/
OPTSETFONT_Click: 
F=VRFONTDIALOG(VRWINDOW(),VRGET("MLE_EDITOR","FONT"),"Select a new font")
IF F="" THEN RETURN
CALL VRSET "MLE_EDITOR","FONT",F
INI.EDITOR.FONT=F
return

/*:VRX         OPTTABINDENT_Click
*/
OPTTABINDENT_Click: 
CALL VRSET VRINFO("O"),"CHECKED",\VRGET(VRINFO("O"),"CHECKED")
return

/*:VRX         OPTWORDWRAP_Click
*/
OPTWORDWRAP_Click: 
STATE=\VRGET(VRINFO("O"),"CHECKED")
CALL VRSET VRINFO("O"),"CHECKED",STATE
CALL VRSET "MLE_EDITOR","WORDWRAP",STATE
return

/*:VRX         PB_CANCEL_Click
*/
PB_CANCEL_Click: 
CALL FIND_CLOSE
return

/*:VRX         PB_FIND_Click
*/
PB_FIND_Click: 
IF VRMETHOD("MLE_EDITOR","SEARCH",VRGET("EF_FIND","VALUE"))=-1 THEN DO
    SS=VRGET("MLE_EDITOR","SELECTEDSTART")
    SE=VRGET("MLE_EDITOR","SELECTEDEND")
    P=VRGET("MLE_EDITOR","PAINTING")
    FC=VRMETHOD("MLE_EDITOR","QUERYFIRSTCHAR")
    CALL VRSET "MLE_EDITOR","PAINTING",0
    CALL VRSET "MLE_EDITOR","SELECTEDSTART",1,"SELECTEDEND",1
    IF VRMETHOD("MLE_EDITOR","SEARCH",VRGET("EF_FIND","VALUE"))=-1 THEN DO
        CALL VRSET "MLE_EDITOR","SELECTEDSTART",SS,"SELECTEDEND",SE
        CALL VRMETHOD "MLE_EDITOR","SETFIRSTCHAR",FC
        CALL VRSET "MLE_EDITOR","PAINTING",P
        CALL VRMESSAGE "FIND","The text '"VRGET("EF_FIND","VALUE")"' cannot be found.","Find"
    END
    ELSE CALL VRSET "MLE_EDITOR","PAINTING",P
END
return

/*:VRX         PB_REPLACE_Click
*/
PB_REPLACE_Click: 
CALL VRMETHOD "MLE_EDITOR","CLEAR"
CALL VRMETHOD "MLE_EDITOR","INSERT",VRGET("EF_REPLACE","VALUE")
CALL PB_FIND_CLICK
return

/*:VRX         Quit
*/
Quit:
    IF CHECKCHANGE() THEN RETURN
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         READINI
*/
READINI: 
INI.=""
DO WHILE CHARS(INIFILE)>0
    PARSE VALUE LINEIN(INIFILE) WITH APPKEY"="INI.APPKEY
END
CALL STREAM INIFILE,"C","CLOSE"
return

/*:VRX         REFRESH
*/
REFRESH: 
IF LEFT(FILENAME,1)='"' THEN PARSE VALUE FILENAME WITH '"'FN'"'
ELSE FN=FILENAME
IF FN="Untitled" THEN FILE=""
ELSE DO
    CALL STREAM FN,"C","CLOSE"
    CALL STREAM FN,"C","OPEN READ"
    FILE=CHARIN(FN,,CHARS(FN))
    CALL STREAM FN,"C","CLOSE"
    IF RIGHT(FILE,1)="1A"x THEN FILE=DBRRIGHT(FILE,1) /* If file has terminating AR (26, 0x1A), strip last character. */
    IF POS("0D0D0A"x,FILE)>0 THEN DO
        B.1="~Compress"
        B.2="~Leave"
        B.0=2
        IF VRMESSAGE(VRWINDOW(),"This file contains 0D0D0As. If you continue without conversion, they will be converted into 0D0A0D0As. Do you wish to convert 0D0D0As into 0D0As or leave them?","Programmer's Editor - Warning","W","B.",1,2)=1 THEN DO WHILE POS("0D0D0A"x,FILE)>0
            FILE=DELSTR(FILE,POS("0D0D0A"x,FILE),1)
        END
    END
END
CALL VRSET "MLE_EDITOR","VALUE",FILE
REFRESHINFO:
CALL VRSET VRWINDOW(),"CAPTION",TITLE" - "FN
KEY=TRANSLATE(VRPARSEFILENAME(FN,"E"))
IF KEY="" THEN KEY="."
APP="BOOKS"
BOOKS=INI.APP.KEY
APP="RUN"
EXECUTE=INI.APP.KEY
CALL VRMETHOD "MLE_EDITOR","SETCHANGED",0
return

/*:VRX         RUNCONFIG_Click
*/
RUNCONFIG_Click: 
id = VRPrompt( VRWindow(), "Enter command to be used when Shift-F5 or Ctrl-F9 is pressed:", "EXECUTE", "Editor" )
KEY=TRANSLATE(VRPARSEFILENAME(FILENAME,"E"))
IF KEY="" THEN KEY="."
APP="RUN"
INI.APP.KEY=BOOKS
return

/*:VRX         RUNRESTART_Click
*/
RUNRESTART_Click: 
CALL RUNRUN_CLICK
return

/*:VRX         RUNRUN_Click
*/
RUNRUN_Click: 
"START "FIXUP(EXECUTE)
return

FIXUP: PROCEDURE EXPOSE FILENAME
PARSE ARG CMD
DO WHILE POS("^",CMD)>0
    PARSE VALUE CMD WITH BEFORE"^"VAR"^"AFTER
    SELECT
        WHEN VAR="FILE" THEN VAL=FILENAME
    OTHERWISE VAL=VAR
    END
    CMD=BEFORE||VAL||AFTER
END
RETURN CMD

/*:VRX         VIEWSTATUS_Click
*/
VIEWSTATUS_Click: 
CURSOR=VRGET("MLE_EDITOR","SELECTEDEND")
VALUE=VRGET("MLE_EDITOR","VALUE")
L=LEFT(VALUE,CURSOR-1)
LINES=1
DO WHILE POS("0D0A"x,L)>0
    PARSE VALUE L WITH LINE "0D0A"x L
    LINES=LINES+1
END
STATUS.0=7
STATUS.1="Current line: "LINES
STATUS.2="Current column: "LENGTH(L)+1
STATUS.3="Selected start: "VRGET("MLE_EDITOR","SELECTEDSTART")
STATUS.4="Selected end: "VRGET("MLE_EDITOR","SELECTEDEND")
STATUS.5=""
STATUS.6="Programmer's Editor v"VERSION
STATUS.7="Thankyou for using the Programmer's Editor."
IF RIGHT(VERSION,1)="A" THEN STATUS.7="ALPHA RELEASE"
IF RIGHT(VERSION,1)="B" THEN STATUS.7="BETA RELEASE"
CALL VRMESSAGESTEM VRWINDOW(),"STATUS.","Status information"
return

/*:VRX         WIN2INI
*/
WIN2INI: 
APP=VRGET(WINDOW,"NAME")
INI.APP.WINDOWSTATE=VRGET(WINDOW,"WINDOWSTATE")
CALL VRSET WINDOW,"WINDOWSTATE","NORMAL"
SAVE="LEFT TOP WIDTH HEIGHT"
DO I=1 TO WORDS(SAVE)
    KEY=WORD(SAVE,I)
    INI.APP.KEY=VRGET(WINDOW,KEY)
END
return

/*:VRX         WRITEINI
*/
WRITEINI: 
CALL VRDELETEFILE INIFILE
CALL RXVARDUMP "TMP."
DO I=1 TO TMP.0
    IF ABBREV(TRANSLATE(TMP.I.NAME),"INI.") THEN CALL LINEOUT INIFILE,SUBSTR(TMP.I.NAME,5)"="TMP.I.VALUE
END
DROP TMP.
CALL LINEOUT INIFILE
return

