#include "TransWin.h"
#include "BMP.h"
#include "message.h"
#include "defines.h"


TransparentWindow :: TransparentWindow( ClockManager* mgr, HAB aHab )
	: NoTitlebarWindow( aHab )
{
    this->manager = mgr;
    transFrame = transClient = TRUE;
};


TransparentWindow :: TransparentWindow
    ( ClockManager* mgr, HAB aHab, HWND parent )
	: NoTitlebarWindow( aHab, parent)
{
    this->manager = mgr;
    transFrame = transClient = TRUE;
};


TransparentWindow :: TransparentWindow
    ( ClockManager* mgr, HAB aHab, HWND parent, ULONG clientStyle )
	: NoTitlebarWindow( aHab, parent, clientStyle )
{
    this->manager = mgr;
    transFrame = transClient = TRUE;
};


TransparentWindow :: TransparentWindow
  (ClockManager* mgr, HAB aHab,HWND parent,ULONG clientStyle,ULONG frameStyle)
		: NoTitlebarWindow( aHab, parent, clientStyle, frameStyle)
{
    this->manager = mgr;
    transFrame = transClient = TRUE;
};


TransparentWindow :: TransparentWindow(
    ClockManager* mgr, HAB hab, HWND parent, ULONG flStyle,
    LONG x, LONG y, LONG cx, LONG cy )
	: NoTitlebarWindow( hab, parent, flStyle, x, y, cx, cy )
{
    this->manager = mgr;
    transFrame = transClient = TRUE;
};


TransparentWindow :: ~TransparentWindow()
{
};


void TransparentWindow :: makeTransparent( HPS localHps, BOOL isClient )
{
    BMP *bmp = (BMP*)( this->manager->Bitmap() );

    if( bmp->Hbm == NULLHANDLE ){
	GpiErase( localHps );
    } else {
	POINTL point;
	HWND hwnd;
	if( this->hwndFrame == NULLHANDLE ){
	    hwnd = this->hwndClient;
	    point.x = point.y = 0;
	}else{
	    hwnd = this->hwndFrame;
	    if( isClient == TRUE ){
		point.x = -WinQuerySysValue( HWND_DESKTOP, SV_CXSIZEBORDER );
		point.y = -WinQuerySysValue( HWND_DESKTOP, SV_CYSIZEBORDER );
	    }else{
		point.x = 0;
		point.y = 0;
		}
	    }

	SWP swp;
	WinQueryWindowPos( hwnd, &swp );
	RECTL rect;
	rect.xLeft   = swp.x;
	rect.yBottom = swp.y;
	rect.xRight  = swp.x + swp.cx;
	rect.yTop    = swp.y + swp.cy;
	WinDrawBitmap( localHps, bmp->Hbm(), &rect, &point,
	DBM_IMAGEATTRS, DBM_IMAGEATTRS, DBM_NORMAL );
	}
}


MRESULT EXPENTRY TransparentWindow :: frameProc
	( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
    switch( msg ){
      case WM_PAINT:
	{
	if( this->transFrame == FALSE ) break;
	HPS localHps = WinBeginPaint( this->hwndFrame, NULLHANDLE, NULL );
	this->makeTransparent( localHps, FALSE );
	WinEndPaint( localHps );
	return (MRESULT)0;
	}

      case WM_ACTIVATE:
	// WvV[WɔCƁAt[`Ă܂
	return (MRESULT)0;

      case WM_MOVE:
	// قƂǂQ񏑂ĂEEE
	WinInvalidateRect( this->hwndFrame, NULL, FALSE );
	WinInvalidateRect( this->hwndClient, NULL, FALSE );
	return (MRESULT)0;
      }

    return NoTitlebarWindow :: frameProc( hwnd, msg, mp1, mp2 );
}


MRESULT EXPENTRY TransparentWindow :: clientProc
	( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
    switch( msg ){
      case WM_PAINT:
	{
	HPS localHps = WinBeginPaint( this->hwndClient, NULLHANDLE, NULL );
	this->makeTransparent( localHps,TRUE );
	WinEndPaint( localHps );
	return (MRESULT)0;
	}
    }

    return NoTitlebarWindow :: clientProc( hwnd, msg, mp1, mp2 );
}
