/* ^Cgo[̂ȂEBhE */
/*   1996.3.3 -  by Akishi.Murata */

#include "NoBarWin.h"
#include "defines.h"

NoTitlebarWindow :: NoTitlebarWindow( HAB aHab )
	: Window( aHab )
{
};


NoTitlebarWindow :: NoTitlebarWindow( HAB aHab, HWND parent )
	: Window( aHab, parent)
{
};


NoTitlebarWindow :: NoTitlebarWindow( HAB aHab, HWND parent, ULONG clientStyle )	: Window( aHab, parent, clientStyle )
{
};


NoTitlebarWindow :: NoTitlebarWindow
	(HAB aHab,HWND parent,ULONG clientStyle,ULONG frameStyle)
		: Window( aHab, parent, clientStyle, frameStyle)
{
};


NoTitlebarWindow :: NoTitlebarWindow(
    HAB hab, HWND parent, ULONG flStyle, LONG x, LONG y, LONG cx, LONG cy )
	: Window( hab, parent, flStyle, x, y, cx, cy )
{
};


NoTitlebarWindow :: ~NoTitlebarWindow()
{
};


MRESULT EXPENTRY NoTitlebarWindow :: frameProc
    ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
    switch( msg ){
      case WM_ADJUSTWINDOWPOS:
	{
	PSWP pswp = (PSWP)PVOIDFROMMP(mp1);
	if( pswp->cx < CX_MINFRAME ) pswp->cx = CX_MINFRAME;
	if( pswp->cy < CY_MINFRAME ) pswp->cy = CY_MINFRAME;
	return (MRESULT)0;
	}

      case WM_QUERYTRACKINFO:
	{
	USHORT tfFlag = SHORT1FROMMP(mp1);
	PTRACKINFO track = (PTRACKINFO)PVOIDFROMMP(mp2);
	this->calcTrackinfo( tfFlag, track );

	return (MRESULT)TRUE;
	}
      }

    // ʃNX̏ɔC
    return Window::frameProc( hwnd, msg, mp1, mp2 );
}


MRESULT EXPENTRY NoTitlebarWindow :: clientProc
    ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
    switch( msg ){
      case WM_BUTTON1DOWN:
        this->relocate( TF_MOVE );
	return (MRESULT)TRUE;
      }

    // ̃bZ[W͏ʃNXɔC
    return Window::clientProc( hwnd, msg, mp1, mp2 );
}


// }EX̃hbOŃEBhEړETCYύX
void NoTitlebarWindow :: relocate( ULONG tfFlag )
{
    if( this->hwndFrame != NULLHANDLE ){
	WinSendMsg( this->hwndFrame, WM_TRACKFRAME, 
	    MPFROMLONG(tfFlag), MPFROMLONG(0L) );
	return;
	}

    TRACKINFO track;
    calcTrackinfo( tfFlag, &track );
    WinTrackRect( this->hwndParent, NULLHANDLE, &track );
    WinSetWindowPos(
	this->hwndClient,
	HWND_TOP,
	track.rclTrack.xLeft,
	track.rclTrack.yBottom,
	track.rclTrack.xRight - track.rclTrack.xLeft,
	track.rclTrack.yTop - track.rclTrack.yBottom,
	SWP_MOVE | SWP_SHOW | SWP_ZORDER);

//    WinPostMsg( hwnd, WM_MOVE, 0, 0 );

    return;
}


// VXe@\EBhEł悤ɂĂꂽA
// Ȗʓ|ȂƂ͂ȂĂނ̂ǁB
void NoTitlebarWindow :: calcTrackinfo( ULONG tfFlag, PTRACKINFO track )
{
    HWND hwnd = (hwndFrame == NULLHANDLE) ? hwndClient : hwndFrame;

    track->cxBorder = track->cyBorder = 4;
    track->cxGrid = track->cyGrid = 1;
    track->cxKeyboard = track->cyKeyboard = 10;

    SWP swp;
    WinQueryWindowPos( hwnd, &swp );
    track->rclTrack.xLeft   = swp.x;
    track->rclTrack.yBottom = swp.y;
    track->rclTrack.xRight  = swp.x + swp.cx;
    track->rclTrack.yTop    = swp.y + swp.cy;

    track->rclBoundary.xLeft   = 0;
    track->rclBoundary.yBottom = 0;
    if( this->hwndParent == HWND_DESKTOP ){
	track->rclBoundary.xRight=WinQuerySysValue(HWND_DESKTOP,SV_CXSCREEN);
	track->rclBoundary.yTop  =WinQuerySysValue(HWND_DESKTOP,SV_CYSCREEN);
    }else{
	SWP pswp;
	WinQueryWindowPos( this->hwndParent, &pswp );
	track->rclBoundary.xRight  = pswp.cx;
	track->rclBoundary.yTop    = pswp.cy;
	}

    track->ptlMinTrackSize.x = track->ptlMaxTrackSize.x = swp.cx;
    track->ptlMinTrackSize.y = track->ptlMaxTrackSize.y = swp.cy;

    if( tfFlag == TF_MOVE ){
	track->fs = TF_MOVE;
	track->ptlMinTrackSize.x = track->ptlMaxTrackSize.x = swp.cx;
	track->ptlMinTrackSize.y = track->ptlMaxTrackSize.y = swp.cy;
    }else{
	track->fs = (ULONG)tfFlag;
	// ̊֐͂ݒ肵߂ɂ悤Ȃ̂ł
	track->ptlMinTrackSize.x = CX_MINFRAME;
	track->ptlMinTrackSize.y = CY_MINFRAME;
	track->ptlMaxTrackSize.x = CX_MAXFRAME;
	track->ptlMaxTrackSize.y = CY_MAXFRAME;
	}

    return;
}
