/*
  Picture Clock /2 Module  Default Digital clock
*/

extern "C"{

#include "Module.h"
#include "stdio.h"
#include "string.h"

struct _Date{
  int day;
  int month;
};

typedef struct _Date Date;

#define CX_SPACE 8
#define CY_SPACE 8
#define CY_MIDSPACE 4

static PSZ APPNAME = "Date 1.0";
static PSZ WINPOS = "Window Position";


MRESULT APIENTRY PC2ModuleProcedure
    (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  static PSZ weekday[7] = {
    "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Satday"
    };
  static PSZ month[12] = {
    "January", "Febrary", "March", "April", "May", "June",
    "July", "August", "September", "October", "November", "December"
    };

  switch( msg ){
  case MDL_ID:
    return MPFROMP(MDLID_V100);

  case MDL_INIT:
    {
      HINI hini = (HINI)LONGFROMMP(mp1);
      ModuleInfo* minfo = ((ModuleInfo*)PVOIDFROMMP(mp2));
      Date* info = (Date*)minfo->buffer;
      char string[128];

      PrfQueryProfileString
	( hini, APPNAME, WINPOS, "10 10 80 35", string, 1024 );
      int x, y, cx, cy;
      sscanf( string, "%d %d %d %d", &x, &y, &cx, &cy );
      WinSetWindowPos
	(minfo->hwndFrame, HWND_TOP, x, y, cx, cy, 
	 SWP_NOADJUST | SWP_SIZE | SWP_MOVE | SWP_SHOW | SWP_ZORDER );
      info->day = 0;

      return 0;
    }

  case MDL_TERMINATE:
    return 0;

  case MDL_SAVESETTINGS:
    {
      HINI hini = LONGFROMMP(mp1);
      ModuleInfo* minfo = (ModuleInfo*)PVOIDFROMMP(mp2);
      SWP swp;
      WinQueryWindowPos( minfo->hwndFrame, &swp );
      char string[128];
      sprintf( string, "%d %d %d %d", swp.x, swp.y, swp.cx, swp.cy );
      PrfWriteProfileString( hini, APPNAME, WINPOS, string );

      return 0;
    }

  case MDL_DRAW:
    {
      ModuleInfo* minfo = (ModuleInfo*)PVOIDFROMMP(mp2);
      PDATETIME pdt = &(minfo->datetime);
      char string[128];

      HPS hps = LONGFROMMP(mp1);
      GpiSetColor( hps, CLR_BLACK );
      POINTL ptl;
      ptl.x = minfo->width;
      ptl.y = minfo->height;
      GpiMove( hps, &ptl );
      ptl.x = ptl.y = 0;
      GpiBox( hps, DRO_FILL, &ptl, 0, 0 );

      FATTRS attr;
      attr.usRecordLength = sizeof(FATTRS);
      attr.fsSelection = FATTR_SEL_BOLD;
      attr.lMatch = 0;
      strcpy( attr.szFacename, "Times New Roman" );
      attr.idRegistry = 0;
      attr.usCodePage = 0;
      attr.lMaxBaselineExt = 0;
      attr.lAveCharWidth = 0;
      attr.fsType = FATTR_TYPE_MBCS;
      attr.fsFontUse = FATTR_FONTUSE_OUTLINE;
      GpiCreateLogFont( hps, NULL, 1, &attr );
      GpiSetCharSet( hps, 1 );

      GpiSetColor( hps, CLR_GREEN );

      POINTL fontSize;
      fontSize.x = (minfo->width) * 10 / 85;
      fontSize.y = (minfo->height) * 45 / 100;
      SIZEF size;
      size.cx = MAKEFIXED( fontSize.x, 0 );
      size.cy = MAKEFIXED( fontSize.y, 0 );
      GpiSetCharBox( hps, &size );

      ptl.x = fontSize.x / 5;
      ptl.y = fontSize.y * 3 / 10;
      GpiCharStringAt( hps, &ptl, strlen(weekday[minfo->datetime.weekday]),
		       weekday[minfo->datetime.weekday] );

      ptl.x = fontSize.x / 5;
      ptl.y = fontSize.y * 13 / 10;
      GpiCharStringAt( hps, &ptl, strlen(month[minfo->datetime.month-1]),
		      month[minfo->datetime.month-1] );

      size.cx = MAKEFIXED( fontSize.x, 0 );
      size.cy = MAKEFIXED( fontSize.y<<1, 0 );
      GpiSetCharBox( hps, &size );
      ptl.x = fontSize.x * 7;
      ptl.y = fontSize.y * 3 / 10;
      sprintf( string, "%2d", minfo->datetime.day );
      GpiCharStringAt( hps, &ptl, 2, string );
      
      GpiSetCharSet( hps, 0 );
      GpiDeleteSetId( hps, 1 );

      return 0;
    }
	
  case MDL_TRIGGER:
    {
      ModuleInfo* minfo = (ModuleInfo*)PVOIDFROMMP(mp1);
      Date* inf = (Date*)(minfo->buffer);
      int day = minfo->datetime.day;
      int month = minfo->datetime.month;
      if( inf->day != day || inf->month != month){
	inf->day = day;
	inf->month = month;
	return MRFROMLONG( TRG_CALLDRAW | TRG_NODRAWBACK | TRG_DRAWFRAME );
      }
      return MRFROMLONG( TRG_DRAWFRAME | TRG_NODRAWBACK );
    }
    
  case MDL_TITLE:
    return MRFROMP( "Wt" );

  default:
    return 0;
  }
}

// end of extern "C"
}
