/*
 * Decompiled with CFR 0.152.
 */
package pm.inout;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.tree.DefaultElement;
import pm.inout.PM_XML;
import pm.picture.PM_MetadataContainer;
import pm.sequence.PM_Sequence;
import pm.sequence.PM_SequenceAlbum;
import pm.sequence.PM_SequenceBase;
import pm.sequence.PM_SequenceExtended;
import pm.sequence.PM_SequenceNew;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;
import pm.utilities.PM_XML_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_SequencesInoutXML
extends PM_XML
implements PM_Interface {
    protected List<PM_Sequence> listAlbum = new ArrayList<PM_Sequence>();
    protected List<PM_Sequence> listBase = new ArrayList<PM_Sequence>();
    protected List<PM_Sequence> listExtended = new ArrayList<PM_Sequence>();
    protected List<PM_Sequence> listNew = new ArrayList<PM_Sequence>();
    protected static boolean changed = false;
    public static final String TAG_ALLE_TOCS = "alle-tocs";
    public static final String TAG_TOC = "toc";
    public static final String TOC_ATTR_TYPE = "type";
    public static final String TOC_ATTR_VON = "von";
    public static final String TOC_ATTR_BIS = "bis";
    public static final String TOC_ATTR_INHALT = "inhalt";
    public static final String TOC_ATTR_INDEX = "index";
    public static final String TOC_ATTR_QS = "qs";
    public static final String TOC_ATTR_ORT = "ort";
    public static final String TOC_ATTR_NAME = "name";
    public static final String TOC_ATTR_SG_NAME = "sg-name";
    public static final String TOC_ATTR_ANZAHL = "anzahl";
    public static final String TOC_ATTR_MARKIEREN = "markieren";
    private static final String XML_TYPE_GESCHLOSSEN = "einfach";
    private static final String XML_TYPE_OFFEN = "komplex";
    private static final String XML_TYPE_NEU = "neu";

    protected PM_SequencesInoutXML() {
        this.rootTagName = "pm-metadaten-global";
    }

    protected void open() {
        if (this.xmlFile != null) {
            return;
        }
        File file = PM_Configuration.getInstance().getTopLevelPictureDirectory();
        String string = file.getAbsolutePath() + File.separator + "pm_metadaten_root" + File.separator + "pm_sequenzen.xml";
        this.xmlFile = new File(string);
        this.openDocument(4);
    }

    protected void close(List<PM_Sequence> list) {
        this.document = DocumentHelper.createDocument();
        this.document.addElement(this.rootTagName);
        this.updateDocument(list);
        this.writeDocument();
    }

    protected void readAllSequences() {
        this.listNew = new ArrayList<PM_Sequence>();
        this.listBase = new ArrayList<PM_Sequence>();
        this.listExtended = new ArrayList<PM_Sequence>();
        this.listAlbum = new ArrayList<PM_Sequence>();
        PM_MetadataContainer pM_MetadataContainer = PM_MetadataContainer.getInstance();
        XPath xPath = null;
        List list = null;
        xPath = DocumentHelper.createXPath("//alle-tocs");
        list = xPath.selectNodes(this.document);
        if (list.size() == 0) {
            Element element = this.document.getRootElement();
            List list2 = element.elements();
            DefaultElement defaultElement = new DefaultElement(TAG_ALLE_TOCS);
            list2.add(defaultElement);
            return;
        }
        xPath = DocumentHelper.createXPath("//toc");
        list = xPath.selectNodes(this.document);
        for (Element element : list) {
            PM_Sequence pM_Sequence;
            String string = PM_XML_Utils.getAttribute(element, TOC_ATTR_TYPE);
            String string2 = PM_XML_Utils.getAttribute(element, TOC_ATTR_NAME);
            String string3 = PM_XML_Utils.getAttribute(element, TOC_ATTR_SG_NAME);
            String string4 = PM_XML_Utils.getAttribute(element, TOC_ATTR_VON);
            String string5 = PM_XML_Utils.getAttribute(element, TOC_ATTR_BIS);
            String string6 = PM_XML_Utils.getAttribute(element, TOC_ATTR_INHALT);
            String string7 = PM_XML_Utils.getAttribute(element, TOC_ATTR_INDEX);
            String string8 = PM_XML_Utils.getAttribute(element, TOC_ATTR_QS);
            String string9 = PM_XML_Utils.getAttribute(element, TOC_ATTR_ORT);
            int n = 0;
            if (pM_MetadataContainer.getInitSequences().containsKey(string2)) {
                n = pM_MetadataContainer.getInitSequences().get(string2);
            }
            if (string2.startsWith("b")) {
                if (string2.equals("b")) {
                    pM_Sequence = new PM_SequenceBase(string6, string2);
                    pM_Sequence.setStringLeaf(true);
                    this.listBase.add(pM_Sequence);
                    continue;
                }
                if (!this.inInitDicAllSequences(string2)) continue;
                pM_Sequence = new PM_SequenceBase(string6, string2);
                pM_Sequence.setAnzahlBilder(n);
                this.listBase.add(pM_Sequence);
                continue;
            }
            if (string2.startsWith("s")) {
                if (string2.equals("s")) {
                    pM_Sequence = new PM_SequenceExtended(string6, string2);
                    pM_Sequence.setStringLeaf(true);
                    this.listExtended.add(pM_Sequence);
                    continue;
                }
                if (!this.inInitDicAllSequences(string2)) continue;
                pM_Sequence = new PM_SequenceExtended(string6, string2);
                pM_Sequence.setAnzahlBilder(n);
                this.listExtended.add(pM_Sequence);
                continue;
            }
            if (string2.startsWith("n")) {
                if (!this.inInitDicAllSequences(string2)) continue;
                pM_Sequence = new PM_SequenceNew(string6, string2);
                pM_Sequence.setAnzahlBilder(n);
                this.listNew.add(pM_Sequence);
                continue;
            }
            if (!string.equals(XML_TYPE_OFFEN)) continue;
            if (string2.equals("a")) {
                pM_Sequence = new PM_SequenceAlbum(string6);
                pM_Sequence.setStringLeaf(true);
                this.listAlbum.add(pM_Sequence);
                continue;
            }
            pM_Sequence = new PM_SequenceAlbum(string6);
            pM_Sequence.setAnzahlBilder(n);
            ((PM_SequenceAlbum)pM_Sequence).setVon(string4);
            ((PM_SequenceAlbum)pM_Sequence).setBis(string5);
            ((PM_SequenceAlbum)pM_Sequence).setIndex(string7);
            ((PM_SequenceAlbum)pM_Sequence).setQual(string8);
            ((PM_SequenceAlbum)pM_Sequence).setOrt(string9);
            ((PM_SequenceAlbum)pM_Sequence).setSeqClosedName(string3);
            this.listAlbum.add(pM_Sequence);
        }
        this.setVersionWrite(1);
    }

    private boolean inInitDicAllSequences(String string) {
        PM_MetadataContainer pM_MetadataContainer = PM_MetadataContainer.getInstance();
        if (!pM_MetadataContainer.getInitSequences().containsKey(string)) {
            return false;
        }
        pM_MetadataContainer.getInitSequences().remove(string);
        return true;
    }

    private void updateDocument(List<PM_Sequence> list) {
        DefaultElement defaultElement = null;
        defaultElement = new DefaultElement(TAG_ALLE_TOCS);
        this.document.getRootElement().add(defaultElement);
        for (PM_Sequence pM_Sequence : list) {
            DefaultElement defaultElement2 = new DefaultElement(TAG_TOC);
            String string = this.typeToXmlType(pM_Sequence.getType());
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = pM_Sequence.getPath();
            String string7 = "";
            String string8 = "";
            String string9 = "";
            if (pM_Sequence.getStringLeaf()) {
                string2 = pM_Sequence.getSequenceCharacter();
            } else {
                string2 = pM_Sequence.getShortName();
                if (pM_Sequence instanceof PM_SequenceAlbum) {
                    PM_SequenceAlbum pM_SequenceAlbum = (PM_SequenceAlbum)pM_Sequence;
                    string4 = pM_SequenceAlbum.getVon();
                    string5 = pM_SequenceAlbum.getBis();
                    string7 = pM_SequenceAlbum.getIndex();
                    string8 = pM_SequenceAlbum.getQual();
                    string9 = pM_SequenceAlbum.getOrt();
                    PM_Sequence pM_Sequence2 = pM_SequenceAlbum.getSeqClosed();
                    if (pM_Sequence2 != null) {
                        string3 = pM_Sequence2.getShortName();
                    }
                }
            }
            this.updateAttribute(defaultElement2, TOC_ATTR_TYPE, string);
            this.updateAttribute(defaultElement2, TOC_ATTR_NAME, string2);
            this.updateAttribute(defaultElement2, TOC_ATTR_VON, string4);
            this.updateAttribute(defaultElement2, TOC_ATTR_BIS, string5);
            this.updateAttribute(defaultElement2, TOC_ATTR_INHALT, string6);
            this.updateAttribute(defaultElement2, TOC_ATTR_INDEX, string7);
            this.updateAttribute(defaultElement2, TOC_ATTR_QS, string8);
            this.updateAttribute(defaultElement2, TOC_ATTR_ORT, string9);
            this.updateAttribute(defaultElement2, TOC_ATTR_SG_NAME, string3);
            defaultElement.add(defaultElement2);
        }
    }

    private String typeToXmlType(PM_Interface.SequenceType sequenceType) {
        if (sequenceType == PM_Interface.SequenceType.EXTENDED || sequenceType == PM_Interface.SequenceType.BASE) {
            return XML_TYPE_GESCHLOSSEN;
        }
        if (sequenceType == PM_Interface.SequenceType.ALBUM) {
            return XML_TYPE_OFFEN;
        }
        if (sequenceType == PM_Interface.SequenceType.NEW) {
            return XML_TYPE_NEU;
        }
        return XML_TYPE_OFFEN;
    }

    protected int getSequendeNumber(String string) {
        if (string.length() == 0) {
            return 0;
        }
        return PM_Utils.stringToInt(string.substring(1));
    }
}

