/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pm.gui.PM_FocusPanel;
import pm.gui.PM_IndexView;
import pm.gui.PM_PictureView;
import pm.gui.PM_WindowBase;
import pm.gui.PM_WindowMain;
import pm.inout.PM_All_InitValues;
import pm.picture.PM_Picture;
import pm.picture.PM_PictureMetadaten;
import pm.search.PM_LuceneLists;
import pm.utilities.PM_Action;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;
import pm.utilities.PM_UtilsGrafik;

public class PM_WindowPicture
extends PM_WindowBase
implements PM_Interface {
    private Image image = null;
    private final PM_IndexView indexViewThumbnails;
    private JScrollPane scrollMetaPanel = null;
    private PM_FocusPanel metaPanel = null;
    private PM_FocusPanel belowPanel = null;
    private JPanel windowPicture = null;
    private JTextField datumImport = null;
    private JTextField index = null;
    private JTextField ort = null;
    private JTextField bemerkungen = null;
    private PM_Picture picture = null;
    private JRadioButton q1 = null;
    private JRadioButton q2 = null;
    private JRadioButton q3 = null;
    private JRadioButton q4 = null;
    private JCheckBox checkBoxSpiegeln = null;
    private JButton buttonUndo = null;
    private JList indexListe = null;
    private JList ortsListe = null;
    private PM_LuceneLists luceneIndexInstance;
    private JComboBox datumJahr = null;
    private JComboBox datumMonat = null;
    private JComboBox datumTag = null;
    private JComboBox datumStunde = null;
    private JComboBox datumMinute = null;
    private JComboBox datumSekunde = null;
    private boolean stopChangeDatum = true;
    private JLabel labelAbweichendesDatum = null;
    private PM_Listener metadatenChangeListener;
    private JSplitPane splitListenPane = null;
    private JSplitPane splitPaneVertical = null;
    private String indexChanged = "";
    private String ortChanged = "";
    private String bemerkungenChanged = "";
    private int qsChanged = 0;
    private Date datumChanged = new Date();
    private boolean spiegelnChanged = false;
    private int rotationChanged = 0;
    private JButton buttonCut;
    private JButton buttonClear;
    JLabel labelSortDatum = null;
    JLabel indexLabel;
    JLabel ortLabel;
    JLabel bemerkungenLabel;
    JLabel qLabel;
    JLabel drehenLabel;
    JLabel spiegelnLabel;
    JPanel panelDatumName = null;
    JPanel panelSortDatum = null;
    JPanel panelIndex = null;
    JPanel panelOrt = null;
    JPanel panelBemerkungen = null;
    JPanel panelQualitaetDrehen = null;
    JPanel datPanel = null;
    JPanel indexP = null;
    JPanel ortP = null;
    JPanel bemerkungenP = null;
    JPanel qualitaet = null;
    JPanel drehen = null;
    JPanel qualitaetDrehen = null;
    JTextField degrees = null;
    private int lastSelected = -1;
    private boolean changed = false;

    public PM_WindowPicture(PM_WindowMain pM_WindowMain, int n) {
        super(pM_WindowMain, n, false);
        this.windowMain = pM_WindowMain;
        this.luceneIndexInstance = PM_LuceneLists.getInstance();
        this.indexViewThumbnails = pM_WindowMain.getIndexViewThumbnails();
        this.metaPanel = this.getMetaPanel();
        this.scrollMetaPanel = new JScrollPane(this.metaPanel);
        this.scrollMetaPanel.setHorizontalScrollBarPolicy(31);
        this.scrollMetaPanel.setVerticalScrollBarPolicy(21);
        this.belowPanel = this.getBelowPanel();
        JScrollPane jScrollPane = new JScrollPane(this.belowPanel);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        this.setLayout(new BorderLayout());
        this.splitPaneVertical = this.getCenterPanel();
        int n2 = PM_All_InitValues.getInstance().getValueInt(this, "vertical-devider");
        if (n2 == 0) {
            n2 = 50;
        }
        this.splitPaneVertical.setDividerLocation(n2);
        this.add((Component)this.scrollMetaPanel, "North");
        this.add((Component)this.splitPaneVertical, "Center");
        this.add((Component)jScrollPane, "South");
        this.metadatenChangeListener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                if (PM_WindowPicture.this.picture == null) {
                    return;
                }
                if (pM_Action.getObject() instanceof PM_Picture) {
                    PM_Picture pM_Picture = (PM_Picture)pM_Action.getObject();
                    if (PM_WindowPicture.this.picture != pM_Picture) {
                        return;
                    }
                    if (pM_Action.getType() == 1) {
                        PM_WindowPicture.this.doClearBild();
                    }
                }
            }
        };
        PM_PictureMetadaten.addChangeListener(this.metadatenChangeListener);
        this.setAktiverFocus(this.index);
        this.addFocusPanel(this.metaPanel);
        this.addFocusPanel(new PM_FocusPanel(null, this.indexListe, this.indexListe));
        this.addFocusPanel(new PM_FocusPanel(null, this.ortsListe, this.ortsListe));
        this.addFocusPanel(this.belowPanel);
        this.setBackgroundMetaPanel(COLOR_BG_PANEL);
        this.windowZeichnen();
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_WindowPicture.this.setMsg();
            }
        };
        PM_MSG.addChangeListener(pM_Listener);
        this.setMsg();
    }

    private void setMsg() {
        this.labelSortDatum.setText(PM_MSG.getMsg("winPicLabelDate"));
        this.indexLabel.setText(PM_MSG.getMsg("index1"));
        this.ortLabel.setText(PM_MSG.getMsg("index1"));
        this.bemerkungenLabel.setText(PM_MSG.getMsg("winPicLabRemark"));
        this.qLabel.setText(PM_MSG.getMsg("category14"));
        this.drehenLabel.setText(PM_MSG.getMsg("winPicLabRotate"));
        this.spiegelnLabel.setText(PM_MSG.getMsg("winPicLabMirror"));
        this.buttonCut.setText(PM_MSG.getMsg("winPicButtonCut"));
        this.buttonClear.setText(PM_MSG.getMsg("winPicButtonClear"));
        this.buttonUndo.setText(PM_MSG.getMsg("winPicButtonUndo"));
    }

    public PM_Picture getPictureSelected() {
        return this.picture;
    }

    public boolean appendPicture(PM_PictureView pM_PictureView) {
        this.requestToChange();
        this.picture = pM_PictureView.getPicture();
        this.image = this.picture.getImageThumbnail();
        this.doSetGuiFromMetadaten();
        this.windowZeichnen();
        return true;
    }

    private void luceneIndexOrtChanged(PM_Action pM_Action) {
        this.indexListe.setListData(this.luceneIndexInstance.getSortedIndex());
        this.ortsListe.setListData(this.luceneIndexInstance.getSortedOrt());
        this.windowZeichnen();
    }

    public void close() {
        this.requestToChange();
        PM_All_InitValues.getInstance().putValueInt(this, "devider", this.splitListenPane.getDividerLocation());
        PM_All_InitValues.getInstance().putValueInt(this, "vertical-devider", this.splitPaneVertical.getDividerLocation());
    }

    public void rereadAllThumbs() {
        this.requestToChange();
    }

    public boolean requestToChange() {
        if (this.picture == null) {
            return true;
        }
        if (!this.istGeaendert()) {
            return true;
        }
        this.picture.meta.setIndex1(this.indexChanged);
        this.picture.meta.setIndex2(this.ortChanged);
        this.picture.meta.setRemarks(this.bemerkungenChanged);
        if (this.picture.meta.getDateCurrent().getTime() != this.datumChanged.getTime()) {
            this.picture.meta.setDateCurrent(this.datumChanged);
        }
        this.picture.meta.setCategory(this.qsChanged);
        this.picture.meta.setRotation(this.rotationChanged);
        this.picture.meta.setMirror(this.spiegelnChanged);
        this.windowMain.rereadPictureViewThumbnail(this.picture);
        this.indexChanged = "";
        this.ortChanged = "";
        this.bemerkungenChanged = "";
        this.qsChanged = 0;
        this.rotationChanged = 0;
        this.datumChanged = new Date();
        this.spiegelnChanged = false;
        this.geaendert(false);
        return true;
    }

    private void windowZeichnen() {
        this.windowPicture.repaint();
        this.scrollMetaPanel.repaint();
        this.metaPanel.repaint();
    }

    private PM_FocusPanel getBelowPanel() {
        PM_FocusPanel pM_FocusPanel = new PM_FocusPanel();
        pM_FocusPanel.setBackground(Color.yellow);
        pM_FocusPanel.setLayout(new FlowLayout(0));
        this.buttonCut = new JButton("Ausschneiden");
        pM_FocusPanel.add(this.buttonCut);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_WindowPicture.this.picture == null) {
                    return;
                }
                PM_WindowPicture.this.requestToChange();
                PM_WindowPicture.this.windowMain.doBildZeigenOriginal(PM_WindowPicture.this.picture, PM_WindowPicture.this.indexViewThumbnails.getPictureListDarstellen());
                PM_WindowPicture.this.windowPicture.repaint();
                PM_WindowPicture.this.metaPanel.repaint();
            }
        };
        this.buttonCut.addActionListener(actionListener);
        this.buttonClear = new JButton("L\u00f6schen");
        pM_FocusPanel.add(this.buttonClear);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowPicture.this.doClearBild();
            }
        };
        this.buttonClear.addActionListener(actionListener2);
        this.buttonUndo = new JButton("R\u00fcckg\u00e4ngig");
        this.geaendert(false);
        pM_FocusPanel.add(this.buttonUndo);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowPicture.this.doUndo();
            }
        };
        this.buttonUndo.addActionListener(actionListener3);
        ArrayList arrayList = new ArrayList();
        pM_FocusPanel.setFocusListe(arrayList);
        pM_FocusPanel.setLastFocus(this.buttonCut);
        pM_FocusPanel.setContainer(pM_FocusPanel);
        return pM_FocusPanel;
    }

    private void setBackgroundMetaPanel(Color color) {
        this.labelSortDatum.setBackground(color);
        this.panelDatumName.setBackground(color);
        this.panelSortDatum.setBackground(color);
        this.panelIndex.setBackground(color);
        this.panelOrt.setBackground(color);
        this.panelBemerkungen.setBackground(color);
        this.panelQualitaetDrehen.setBackground(color);
        this.datPanel.setBackground(color);
        this.indexP.setBackground(color);
        this.ortP.setBackground(color);
        this.bemerkungenP.setBackground(color);
        this.qualitaet.setBackground(color);
        this.drehen.setBackground(color);
        this.qualitaetDrehen.setBackground(color);
        this.index.setBackground(COLOR_ENABLED);
        this.ort.setBackground(COLOR_ENABLED);
        this.bemerkungen.setBackground(COLOR_ENABLED);
        this.datumTag.setBackground(COLOR_ENABLED);
        this.datumMonat.setBackground(COLOR_ENABLED);
        this.datumJahr.setBackground(COLOR_ENABLED);
        this.datumStunde.setBackground(COLOR_ENABLED);
        this.datumMinute.setBackground(COLOR_ENABLED);
        this.datumSekunde.setBackground(COLOR_ENABLED);
        this.q1.setBackground(COLOR_ENABLED);
        this.q2.setBackground(COLOR_ENABLED);
        this.q3.setBackground(COLOR_ENABLED);
        this.q4.setBackground(COLOR_ENABLED);
    }

    private PM_FocusPanel getMetaPanel() {
        PM_FocusPanel pM_FocusPanel = new PM_FocusPanel(){

            public void setBackgroundColor(Color color) {
                PM_WindowPicture.this.setBackgroundMetaPanel(color);
            }
        };
        pM_FocusPanel.setLayout(new BoxLayout(pM_FocusPanel, 1));
        this.panelDatumName = new JPanel(new FlowLayout(0));
        this.panelSortDatum = new JPanel(new FlowLayout(0));
        this.panelIndex = new JPanel(new FlowLayout(0));
        this.panelOrt = new JPanel(new FlowLayout(0));
        this.panelBemerkungen = new JPanel(new FlowLayout(0));
        this.panelQualitaetDrehen = new JPanel(new FlowLayout(0));
        this.datPanel = new JPanel();
        this.datPanel.setLayout(new FlowLayout(0));
        this.labelSortDatum = new JLabel("Datum:");
        this.datPanel.add(this.labelSortDatum);
        this.datumImport = new JTextField();
        Font font = this.datumImport.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        this.datumImport.setFont(font2);
        this.datumImport.setEditable(false);
        this.datumImport.setEnabled(false);
        this.datumImport.setColumns(11);
        this.datPanel.add(this.datumImport);
        this.datumTag = new JComboBox(PM_Utils.getTage(false));
        this.datPanel.add(this.datumTag);
        this.datPanel.add(new JLabel("."));
        this.datumMonat = new JComboBox(PM_Utils.getMonate(false));
        this.datPanel.add(this.datumMonat);
        this.datPanel.add(new JLabel("."));
        Vector<String> vector = PM_Utils.getJahre(false);
        vector.add(0, "1970");
        this.datumJahr = new JComboBox<String>(vector);
        this.datPanel.add(this.datumJahr);
        this.datPanel.add(new JLabel("/"));
        this.datumStunde = new JComboBox(PM_Utils.getStunden(false));
        this.datPanel.add(this.datumStunde);
        this.datPanel.add(new JLabel(":"));
        this.datumMinute = new JComboBox(PM_Utils.getMinuten(false));
        this.datPanel.add(this.datumMinute);
        this.datPanel.add(new JLabel(":"));
        this.datumSekunde = new JComboBox(PM_Utils.getSekunden(false));
        this.datPanel.add(this.datumSekunde);
        this.clearSortDatum();
        this.stopChangeDatum = true;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_WindowPicture.this.stopChangeDatum) {
                    return;
                }
                String string = PM_WindowPicture.this.datumTag.getSelectedItem() + "." + PM_WindowPicture.this.datumMonat.getSelectedItem() + "." + PM_WindowPicture.this.datumJahr.getSelectedItem() + " " + PM_WindowPicture.this.datumStunde.getSelectedItem() + ":" + PM_WindowPicture.this.datumMinute.getSelectedItem() + ":" + PM_WindowPicture.this.datumSekunde.getSelectedItem();
                PM_WindowPicture.this.datumChanged = PM_Utils.datumToDate(string);
                if (PM_WindowPicture.this.buttonUndo != null) {
                    PM_WindowPicture.this.geaendert(true);
                }
            }
        };
        this.datumTag.addActionListener(actionListener);
        this.datumMonat.addActionListener(actionListener);
        this.datumJahr.addActionListener(actionListener);
        this.datumStunde.addActionListener(actionListener);
        this.datumMinute.addActionListener(actionListener);
        this.datumSekunde.addActionListener(actionListener);
        this.panelSortDatum.add(this.datPanel);
        this.labelAbweichendesDatum = new JLabel();
        this.panelSortDatum.add(this.labelAbweichendesDatum);
        this.indexP = new JPanel();
        this.indexP.setLayout(new FlowLayout(0));
        this.indexLabel = new JLabel("Index 1");
        this.indexP.add(this.indexLabel);
        this.index = new JTextField("    ");
        this.index.setColumns(40);
        KeyListener keyListener = new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
                PM_WindowPicture.this.windowMain.keyTextFieldPressed(keyEvent);
                if ((keyEvent.getModifiers() & 2) != 0) {
                    return;
                }
                if (PM_WindowPicture.this.picture == null || ((PM_WindowPicture)PM_WindowPicture.this).picture.meta == null) {
                    return;
                }
                PM_WindowPicture.this.indexChanged = PM_WindowPicture.this.index.getText();
                PM_WindowPicture.this.geaendert(true);
            }

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
            }
        };
        this.index.addKeyListener(keyListener);
        this.indexP.add(this.index);
        this.panelIndex.add(this.indexP);
        this.ortP = new JPanel();
        this.ortP.setLayout(new FlowLayout(0));
        this.ortLabel = new JLabel("Index 2");
        this.ortP.add(this.ortLabel);
        this.ort = new JTextField("    ");
        this.ort.setColumns(40);
        KeyListener keyListener2 = new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
                PM_WindowPicture.this.windowMain.keyTextFieldPressed(keyEvent);
                if ((keyEvent.getModifiers() & 2) != 0) {
                    return;
                }
                if (PM_WindowPicture.this.picture == null || ((PM_WindowPicture)PM_WindowPicture.this).picture.meta == null) {
                    return;
                }
                PM_WindowPicture.this.ortChanged = PM_WindowPicture.this.ort.getText();
                PM_WindowPicture.this.geaendert(true);
            }

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
            }
        };
        this.ort.addKeyListener(keyListener2);
        this.ortP.add(this.ort);
        this.panelOrt.add(this.ortP);
        this.bemerkungenP = new JPanel();
        this.bemerkungenP.setLayout(new FlowLayout(0));
        this.bemerkungenLabel = new JLabel("Bemerkungen");
        this.bemerkungenP.add(this.bemerkungenLabel);
        this.bemerkungen = new JTextField("    ");
        this.bemerkungen.setColumns(40);
        KeyListener keyListener3 = new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
                PM_WindowPicture.this.windowMain.keyTextFieldPressed(keyEvent);
                if ((keyEvent.getModifiers() & 2) != 0) {
                    return;
                }
                if (PM_WindowPicture.this.picture == null || ((PM_WindowPicture)PM_WindowPicture.this).picture.meta == null) {
                    return;
                }
                PM_WindowPicture.this.bemerkungenChanged = PM_WindowPicture.this.bemerkungen.getText();
                PM_WindowPicture.this.geaendert(true);
            }

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
            }
        };
        this.bemerkungen.addKeyListener(keyListener3);
        this.bemerkungenP.add(this.bemerkungen);
        this.panelBemerkungen.add(this.bemerkungenP);
        this.qualitaet = new JPanel();
        this.qualitaet.setLayout(new FlowLayout(0));
        this.qLabel = new JLabel("Kategorie");
        this.qualitaet.add(this.qLabel);
        this.q1 = new JRadioButton();
        this.q2 = new JRadioButton();
        this.q3 = new JRadioButton();
        this.q4 = new JRadioButton();
        this.q1.setActionCommand("q1");
        this.q2.setActionCommand("q2");
        this.q3.setActionCommand("q3");
        this.q4.setActionCommand("q4");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.q1);
        buttonGroup.add(this.q2);
        buttonGroup.add(this.q3);
        buttonGroup.add(this.q4);
        this.qualitaet.add(this.q1);
        this.qualitaet.add(this.q2);
        this.qualitaet.add(this.q3);
        this.qualitaet.add(this.q4);
        MyRadioListener myRadioListener = new MyRadioListener();
        this.q1.addActionListener(myRadioListener);
        this.q2.addActionListener(myRadioListener);
        this.q3.addActionListener(myRadioListener);
        this.q4.addActionListener(myRadioListener);
        this.drehen = new JPanel();
        this.drehen.setLayout(new FlowLayout(0));
        this.drehenLabel = new JLabel("drehen");
        this.drehen.add(this.drehenLabel);
        JButton jButton = new JButton("L");
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowPicture.this.doDrehen(PM_Interface.Rotate.LEFT);
            }
        };
        jButton.addActionListener(actionListener2);
        this.drehen.add(jButton);
        this.degrees = new JTextField();
        this.degrees.setColumns(3);
        this.degrees.setEnabled(false);
        this.drehen.add(this.degrees);
        JButton jButton2 = new JButton("R");
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowPicture.this.doDrehen(PM_Interface.Rotate.RIGHT);
            }
        };
        jButton2.addActionListener(actionListener3);
        this.drehen.add(jButton2);
        this.spiegelnLabel = new JLabel("spiegeln");
        this.drehen.add(this.spiegelnLabel);
        this.checkBoxSpiegeln = new JCheckBox();
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowPicture.this.doSpiegeln(PM_WindowPicture.this.checkBoxSpiegeln.isSelected());
            }
        };
        this.checkBoxSpiegeln.addActionListener(actionListener4);
        this.drehen.add(this.checkBoxSpiegeln);
        this.qualitaetDrehen = new JPanel();
        this.qualitaetDrehen.setLayout(new FlowLayout(0));
        this.qualitaetDrehen.add(this.qualitaet);
        this.qualitaetDrehen.add(this.drehen);
        this.panelQualitaetDrehen.add(this.qualitaetDrehen);
        pM_FocusPanel.add(this.panelSortDatum);
        pM_FocusPanel.add(this.panelDatumName);
        pM_FocusPanel.add(this.panelIndex);
        pM_FocusPanel.add(this.panelOrt);
        pM_FocusPanel.add(this.panelBemerkungen);
        pM_FocusPanel.add(this.panelQualitaetDrehen);
        this.doClearMetadaten();
        this.stopChangeDatum = true;
        ArrayList<JComboBox> arrayList = new ArrayList<JComboBox>();
        arrayList.add(this.datumTag);
        arrayList.add(this.datumMonat);
        arrayList.add(this.datumJahr);
        arrayList.add(this.datumStunde);
        arrayList.add(this.datumMinute);
        arrayList.add(this.datumSekunde);
        ArrayList<JTextField> arrayList2 = new ArrayList<JTextField>();
        arrayList2.add(this.index);
        ArrayList<JTextField> arrayList3 = new ArrayList<JTextField>();
        arrayList3.add(this.ort);
        ArrayList<JTextField> arrayList4 = new ArrayList<JTextField>();
        arrayList4.add(this.bemerkungen);
        ArrayList<JRadioButton> arrayList5 = new ArrayList<JRadioButton>();
        arrayList5.add(this.q1);
        arrayList5.add(this.q2);
        arrayList5.add(this.q3);
        arrayList5.add(this.q4);
        ArrayList<ArrayList<JComponent>> arrayList6 = new ArrayList<ArrayList<JComponent>>();
        arrayList6.add(arrayList);
        arrayList6.add(arrayList2);
        arrayList6.add(arrayList3);
        arrayList6.add(arrayList4);
        arrayList6.add(arrayList5);
        pM_FocusPanel.setFocusListe(arrayList6);
        pM_FocusPanel.setLastFocus(this.index);
        pM_FocusPanel.setContainer(pM_FocusPanel);
        return pM_FocusPanel;
    }

    private JSplitPane getCenterPanel() {
        this.indexListe = new JList();
        this.indexListe.setFont(this.luceneIndexInstance.getFont(this.indexListe.getFont()));
        this.indexListe.setSelectionMode(0);
        this.indexListe.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object e = PM_WindowPicture.this.indexListe.getSelectedValue();
                if (e == null) {
                    return;
                }
                if (PM_WindowPicture.this.lastSelected == -1) {
                    PM_WindowPicture.this.index.setText(PM_WindowPicture.this.index.getText() + " " + (String)e);
                    PM_WindowPicture.this.indexChanged = PM_WindowPicture.this.index.getText();
                    PM_WindowPicture.this.geaendert(true);
                    PM_WindowPicture.this.lastSelected = PM_WindowPicture.this.indexListe.getSelectedIndex();
                } else {
                    PM_WindowPicture.this.lastSelected = -1;
                }
            }
        });
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_WindowPicture.this.luceneIndexOrtChanged(pM_Action);
            }
        };
        this.luceneIndexInstance.addListener(pM_Listener);
        this.ortsListe = new JList();
        this.ortsListe.setFont(this.luceneIndexInstance.getFont(this.ortsListe.getFont()));
        this.ortsListe.setSelectionMode(0);
        this.ortsListe.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object e = PM_WindowPicture.this.ortsListe.getSelectedValue();
                if (e == null) {
                    return;
                }
                if (PM_WindowPicture.this.lastSelected == -1) {
                    PM_WindowPicture.this.ort.setText(PM_WindowPicture.this.ort.getText() + " " + (String)e);
                    PM_WindowPicture.this.ortChanged = PM_WindowPicture.this.ort.getText();
                    PM_WindowPicture.this.geaendert(true);
                    PM_WindowPicture.this.lastSelected = PM_WindowPicture.this.ortsListe.getSelectedIndex();
                } else {
                    PM_WindowPicture.this.lastSelected = -1;
                }
            }
        });
        PM_Listener pM_Listener2 = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_WindowPicture.this.luceneIndexOrtChanged(pM_Action);
            }
        };
        this.luceneIndexInstance.addListener(pM_Listener2);
        JScrollPane jScrollPane = new JScrollPane(this.indexListe);
        JScrollPane jScrollPane2 = new JScrollPane(this.ortsListe);
        this.splitListenPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        int n = PM_All_InitValues.getInstance().getValueInt(this, "devider");
        if (n == 0) {
            n = 150;
        }
        this.splitListenPane.setDividerLocation(n);
        this.windowPicture = new JPanel(){

            public void paintComponent(Graphics graphics) {
                PM_WindowPicture.this.doPaintComponent(graphics);
            }

            public Dimension getPreferredSize() {
                if (PM_WindowPicture.this.image == null) {
                    return new Dimension(10, 10);
                }
                int n = Math.max(PM_WindowPicture.this.image.getWidth(null), PM_WindowPicture.this.image.getHeight(null));
                return new Dimension(n += 40, n);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.windowPicture.setBackground(Color.YELLOW);
        JScrollPane jScrollPane3 = new JScrollPane(this.windowPicture);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane3, this.splitListenPane);
        jSplitPane.setDividerLocation(70);
        return jSplitPane;
    }

    private void doClearBild() {
        this.requestToChange();
        this.picture = null;
        this.image = null;
        this.doClearMetadaten();
        this.windowZeichnen();
        this.indexViewThumbnails.repaintViewport();
    }

    private void doUndo() {
        this.geaendert(false);
        this.doSetGuiFromMetadaten();
        this.windowZeichnen();
    }

    private void geaendert(boolean bl) {
        this.changed = bl;
        if (this.changed) {
            this.buttonUndo.setBackground(COLOR_WARNING);
        } else {
            this.buttonUndo.setBackground(COLOR_ENABLED);
        }
    }

    private boolean istGeaendert() {
        return this.changed;
    }

    private void doDrehen(PM_Interface.Rotate rotate) {
        if (this.picture == null) {
            return;
        }
        this.rotationChanged = PM_Utils.getNextRotation(this.rotationChanged, rotate);
        this.degrees.setText(String.valueOf(this.rotationChanged));
        this.geaendert(true);
        this.windowZeichnen();
    }

    private void doSpiegeln(boolean bl) {
        this.spiegelnChanged = bl;
        this.geaendert(true);
        this.windowZeichnen();
    }

    private void doSetGuiFromMetadaten() {
        if (this.picture == null || this.picture.meta == null) {
            return;
        }
        this.indexListe.clearSelection();
        this.ortsListe.clearSelection();
        this.doClearMetadaten();
        this.setDatumToSortedDatum(this.picture.meta.getDateCurrent());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        if (this.picture.meta.hasDateChanged()) {
            this.datumImport.setText(simpleDateFormat.format(this.picture.meta.getDateImport()));
        } else {
            this.datumImport.setText(simpleDateFormat.format(this.picture.meta.getDateCurrent()));
        }
        this.index.setText(this.picture.meta.getIndex1());
        this.ort.setText(this.picture.meta.getIndex2());
        this.bemerkungen.setText(this.picture.meta.getRemarks());
        this.checkBoxSpiegeln.setSelected(this.picture.meta.getMirror());
        this.degrees.setText(String.valueOf(this.picture.meta.getRotation()));
        switch (this.picture.meta.getCategory()) {
            case 1: {
                this.q1.setSelected(true);
                break;
            }
            case 2: {
                this.q2.setSelected(true);
                break;
            }
            case 3: {
                this.q3.setSelected(true);
                break;
            }
            case 4: {
                this.q4.setSelected(true);
            }
        }
        this.spiegelnChanged = this.picture.meta.getMirror();
        this.indexChanged = this.picture.meta.getIndex1();
        this.ortChanged = this.picture.meta.getIndex2();
        this.bemerkungenChanged = this.picture.meta.getRemarks();
        this.qsChanged = this.picture.meta.getCategory();
        this.rotationChanged = this.picture.meta.getRotation();
        this.datumChanged = this.picture.meta.getDateCurrent();
        this.stopChangeDatum = false;
        if (this.picture.meta.hasDateChanged()) {
            this.labelSortDatum.setForeground(Color.RED);
        }
    }

    private void setDatumToSortedDatum(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String string = PM_Utils.stringToString("000" + Integer.toString(calendar.get(1)), 4);
        String string2 = PM_Utils.stringToString("000" + Integer.toString(calendar.get(2) + 1), 2);
        String string3 = PM_Utils.stringToString("000" + Integer.toString(calendar.get(5)), 2);
        String string4 = PM_Utils.stringToString("000" + Integer.toString(calendar.get(11)), 2);
        String string5 = PM_Utils.stringToString("000" + Integer.toString(calendar.get(12)), 2);
        String string6 = PM_Utils.stringToString("000" + Integer.toString(calendar.get(13)), 2);
        boolean bl = this.stopChangeDatum;
        this.stopChangeDatum = true;
        this.datumJahr.setSelectedItem(string);
        this.datumMonat.setSelectedItem(string2);
        this.datumTag.setSelectedItem(string3);
        this.datumStunde.setSelectedItem(string4);
        this.datumMinute.setSelectedItem(string5);
        this.datumSekunde.setSelectedItem(string6);
        this.stopChangeDatum = bl;
    }

    private void clearSortDatum() {
        this.stopChangeDatum = true;
        this.datumJahr.setSelectedIndex(0);
        this.datumMonat.setSelectedIndex(0);
        this.datumTag.setSelectedIndex(0);
        this.datumStunde.setSelectedIndex(0);
        this.datumMinute.setSelectedIndex(0);
        this.datumSekunde.setSelectedIndex(0);
    }

    private void doClearMetadaten() {
        this.labelAbweichendesDatum.setText(null);
        this.labelAbweichendesDatum.setForeground(Color.BLACK);
        this.labelSortDatum.setForeground(Color.BLACK);
        this.datumImport.setText("");
        this.ort.setText(" ");
        this.index.setText(" ");
        this.bemerkungen.setText(" ");
        this.degrees.setText(" ");
        this.q1.setSelected(false);
        this.q2.setSelected(false);
        this.q3.setSelected(false);
        this.q4.setSelected(false);
        this.clearSortDatum();
    }

    private void doPaintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.image == null) {
            return;
        }
        double d = 1.0;
        Color color = graphics2D.getColor();
        Rectangle rectangle = null;
        Dimension dimension = this.picture.meta.getImageSize();
        if (this.picture.meta.hasCutRectangle()) {
            rectangle = this.picture.meta.getCutRectangle();
        }
        BufferedImage bufferedImage = PM_UtilsGrafik.getBufferedImage(this.image, rectangle, dimension, d);
        int n = 20;
        int n2 = 20;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n, n2);
        Point2D.Double double_ = PM_UtilsGrafik.getMovePoint(this.rotationChanged, (double)this.image.getWidth(null) * d, (double)this.image.getHeight(null) * d);
        affineTransform.translate(double_.x, double_.y);
        affineTransform.rotate((double)this.rotationChanged * Math.PI / 180.0);
        if (this.spiegelnChanged) {
            affineTransform.translate((double)this.image.getWidth(null) * d, 0.0);
            affineTransform.scale(-1.0, 1.0);
        }
        graphics2D.drawImage(bufferedImage, affineTransform, this);
        graphics2D.setColor(color);
        Font font = graphics2D.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        graphics2D.setFont(font2);
        graphics2D.drawString(this.picture.getFileOriginal().getPath(), 10, 12);
    }

    class MyRadioListener
    implements ActionListener {
        MyRadioListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PM_WindowPicture.this.picture == null) {
                return;
            }
            String string = actionEvent.getActionCommand().substring(1);
            PM_WindowPicture.this.qsChanged = PM_Utils.stringToInt(string);
            PM_WindowPicture.this.geaendert(true);
        }
    }
}

