/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import pm.gui.PM_WindowMain;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;

public class PM_WindowDialogGetTLD {
    private JDialog dialog;
    private JTextField topLevelDirectory;
    private boolean continueTLD = false;
    private JProgressBar progressBar = new JProgressBar(1, 5);
    private JLabel headerLabel;
    private JTextArea whatText;
    private JButton continueButton;
    private JButton stopButton;
    private JTextArea infoText;

    public File getTopLevelDirectory() {
        return this.getTLD();
    }

    private File getTLD() {
        this.dialog = this.getDialogGetTLD();
        int n = 300;
        int n2 = 200;
        Dimension dimension = PM_Utils.getScreenSize();
        int n3 = dimension.width / 2 - n / 2;
        int n4 = dimension.height / 2 - n2 / 2;
        this.dialog.setLocation(n3, n4);
        this.dialog.pack();
        this.dialog.setVisible(true);
        String string = this.topLevelDirectory.getText();
        if (string.length() == 0) {
            return null;
        }
        File file = new File(string);
        return file;
    }

    private JDialog getDialogGetTLD() {
        int n = 500;
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(n, 40));
        this.headerLabel = new JLabel(PM_MSG.getMsg("winDiaTldHeader"));
        Font font = this.headerLabel.getFont();
        Font font2 = new Font(font.getName(), 1, 20);
        this.headerLabel.setFont(font2);
        this.headerLabel.setPreferredSize(new Dimension(n, 40));
        jPanel.add((Component)this.headerLabel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        this.whatText = new JTextArea("");
        this.whatText.setPreferredSize(new Dimension(n, 30));
        font = this.whatText.getFont();
        font2 = new Font(font.getName(), 1, font.getSize());
        this.whatText.setFont(font2);
        this.whatText.setBackground(jPanel.getBackground());
        jPanel2.add(this.whatText);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.setPreferredSize(new Dimension(n, 35));
        jPanel3.add(new JLabel(PM_MSG.getMsg("tld") + ":"));
        this.topLevelDirectory = new JTextField(PM_Utils.getPropertyString(System.getProperties(), "user.home"));
        this.topLevelDirectory.setColumns(22);
        this.topLevelDirectory.setEditable(false);
        jPanel3.add(this.topLevelDirectory);
        JButton jButton = new JButton("...");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = PM_WindowDialogGetTLD.this.chooseTLD(PM_WindowDialogGetTLD.this.topLevelDirectory.getText());
                if (file == null) {
                    System.exit(0);
                }
                PM_WindowDialogGetTLD.this.continueTLD = true;
                PM_WindowDialogGetTLD.this.progressBar.setIndeterminate(true);
                int n = PM_WindowDialogGetTLD.this.lesenDir(file);
                PM_WindowDialogGetTLD.this.progressBar.setIndeterminate(false);
                PM_WindowDialogGetTLD.this.infoText.setText(PM_WindowDialogGetTLD.this.getChooseResultText(n, file));
                PM_WindowDialogGetTLD.this.topLevelDirectory.setText(file.getAbsolutePath());
                PM_WindowDialogGetTLD.this.continueButton.setEnabled(true);
                PM_WindowDialogGetTLD.this.stopButton.setEnabled(true);
            }
        };
        jButton.addActionListener(actionListener);
        jPanel3.add(jButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(n, 20));
        jPanel4.add(this.progressBar);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        String string = PM_MSG.getMsg("winDiaTldPrompt1") + PM_MSG.getMsg("winDiaTldPrompt2");
        this.infoText = new JTextArea(string);
        this.infoText.setPreferredSize(new Dimension(n, 95));
        jPanel5.add(this.infoText);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(2));
        this.continueButton = new JButton(PM_MSG.getMsg("continue"));
        jPanel6.add(this.continueButton);
        this.continueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_WindowDialogGetTLD.this.continueTLD) {
                    PM_WindowDialogGetTLD.this.dialog.dispose();
                }
                PM_WindowDialogGetTLD.this.continueTLD = true;
                File file = new File(PM_WindowDialogGetTLD.this.topLevelDirectory.getText());
                PM_WindowDialogGetTLD.this.progressBar.setIndeterminate(true);
                int n = PM_WindowDialogGetTLD.this.lesenDir(file);
                PM_WindowDialogGetTLD.this.progressBar.setIndeterminate(false);
                PM_WindowDialogGetTLD.this.infoText.setText(PM_WindowDialogGetTLD.this.getChooseResultText(n, file));
                PM_WindowDialogGetTLD.this.topLevelDirectory.setText(file.getAbsolutePath());
            }
        });
        this.stopButton = new JButton(PM_MSG.getMsg("quit"));
        jPanel6.add(this.stopButton);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowDialogGetTLD.this.topLevelDirectory.setText("");
                PM_WindowDialogGetTLD.this.dialog.dispose();
            }
        });
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        jPanel7.add(jPanel);
        jPanel7.add(jPanel2);
        jPanel7.add(jPanel3);
        jPanel7.add(jPanel4);
        jPanel7.add(jPanel5);
        jPanel7.add(jPanel6);
        JDialog jDialog = new JDialog((Frame)PM_WindowMain.getInstance(), true);
        jDialog.setUndecorated(true);
        jDialog.getContentPane().add(jPanel7);
        return jDialog;
    }

    private File chooseTLD(String string) {
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setDialogTitle(PM_MSG.getMsg("winDiaTldChooseTLD"));
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }

            public String getDescription() {
                return PM_MSG.getMsg("tld");
            }
        });
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            return file;
        }
        return null;
    }

    private String getChooseResultText(int n, File file) {
        String string = String.format(PM_MSG.getMsg("winDiaTldChooseResult1"), n, file.getPath()) + PM_MSG.getMsg("winDiaTldChooseResult2") + PM_MSG.getMsg("winDiaTldChooseResult3") + PM_MSG.getMsg("winDiaTldChooseResult4");
        return string;
    }

    private int lesenDir(File file) {
        File[] fileArray;
        int n = 0;
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                n += this.lesenDir(file2);
            }
            if (!file2.isFile() || !PM_Utils.isPictureFile(file2)) continue;
            ++n;
        }
        return n;
    }
}

