/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JPanel;
import pm.gui.PM_WindowDialogBase;
import pm.utilities.PM_Action;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_Utils;

public class PM_WindowDialogBackupDaten
extends PM_WindowDialogBase
implements PM_Interface {
    private File sourceDir;
    private File targetDir;
    private PM_WindowDialogBase.ZeilenPanel pruefen = new PM_WindowDialogBase.ZeilenPanel(this, "Daten. Pr\u00fcfen l\u00f6schen/neu", false);
    private PM_WindowDialogBase.ZeilenPanel dateienLoeschen = new PM_WindowDialogBase.ZeilenPanel(this, "Daten-Dateien l\u00f6schen", true);
    private PM_WindowDialogBase.ZeilenPanel dateienNeu = new PM_WindowDialogBase.ZeilenPanel(this, "neue Daten-Dateien \u00fcbertragen", true);
    private PM_WindowDialogBase.ZeilenPanel dateienUeberschreiben = new PM_WindowDialogBase.ZeilenPanel(this, "vorhandene Daten-Dateien \u00fcberschreiben", true);
    private PM_WindowDialogBase.ZeilenPanel fertig = new PM_WindowDialogBase.ZeilenPanel(this, "fertig", false);
    private List<File> listeDateienLoeschen = new ArrayList<File>();
    private List<File> listeDateienNeu = new ArrayList<File>();
    private List<File> listeDateienUeberschreiben = new ArrayList<File>();

    public PM_WindowDialogBackupDaten(PM_Configuration.BackUp backUp) {
        this.sourceDir = backUp.getFileDirFrom();
        this.targetDir = backUp.getFileDirTo();
    }

    public boolean init() {
        return true;
    }

    private void pruefen(PM_Listener pM_Listener) {
        this.lesenDateienLoeschen(this.targetDir);
        this.lesenDateienNeuUeberschreiben(this.sourceDir);
    }

    private void lesenDateienLoeschen(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                this.lesenDateienLoeschen(file2);
                continue;
            }
            this.addFileToListeDateiLoeschen(file2);
        }
    }

    private void addFileToListeDateiLoeschen(File file) {
        if (!file.isFile()) {
            return;
        }
        String string = PM_Utils.getRelativePath(this.targetDir, file);
        File file2 = new File(this.sourceDir + File.separator + string);
        if (!file2.isFile()) {
            this.listeDateienLoeschen.add(file);
        }
    }

    private void lesenDateienNeuUeberschreiben(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                this.lesenDateienNeuUeberschreiben(file2);
                continue;
            }
            this.addFileToListeDateiNeuUeberschreiben(file2);
        }
    }

    private void addFileToListeDateiNeuUeberschreiben(File file) {
        if (!file.isFile()) {
            return;
        }
        String string = PM_Utils.getRelativePath(this.sourceDir, file);
        File file2 = new File(this.targetDir + File.separator + string);
        if (!file2.isFile()) {
            this.listeDateienNeu.add(file2);
        } else if (file.lastModified() != file2.lastModified()) {
            this.listeDateienUeberschreiben.add(file2);
        }
    }

    private void loeschen(PM_Listener pM_Listener) {
        for (File file : this.listeDateienLoeschen) {
            pM_Listener.actionPerformed(new PM_Action(null));
            file.delete();
        }
    }

    private void neu(PM_Listener pM_Listener) {
        for (File file : this.listeDateienNeu) {
            pM_Listener.actionPerformed(new PM_Action(null));
            this.copyFile(file);
        }
    }

    private void ueberschreiben(PM_Listener pM_Listener) {
        for (File file : this.listeDateienUeberschreiben) {
            pM_Listener.actionPerformed(new PM_Action(null));
            this.copyFile(file);
        }
    }

    private void copyFile(File file) {
        String string = PM_Utils.getRelativePath(this.targetDir, file);
        File file2 = new File(this.sourceDir + File.separator + string);
        file.getParentFile().mkdirs();
        PM_Utils.copyFile(file2, file);
        file.setLastModified(file2.lastModified());
    }

    protected void setZeilen(JPanel jPanel) {
        jPanel.add(this.pruefen);
        jPanel.add(this.dateienLoeschen);
        jPanel.add(this.dateienNeu);
        jPanel.add(this.dateienUeberschreiben);
        jPanel.add(this.fertig);
    }

    protected void goDialog(JDialog jDialog, int n, PM_Listener pM_Listener) {
        switch (n) {
            case 1: {
                this.pruefen.start();
                this.setAnzahl(99999);
                this.pruefen(pM_Listener);
                this.dateienLoeschen.setAnzahl(this.listeDateienLoeschen.size());
                this.dateienNeu.setAnzahl(this.listeDateienNeu.size());
                this.dateienUeberschreiben.setAnzahl(this.listeDateienUeberschreiben.size());
                this.pruefen.stop();
                break;
            }
            case 2: {
                this.setAnzahl(this.listeDateienLoeschen.size());
                this.dateienLoeschen.start();
                this.loeschen(pM_Listener);
                this.dateienLoeschen.stop();
                this.setAnzahl(this.listeDateienNeu.size());
                this.dateienNeu.start();
                this.neu(pM_Listener);
                this.dateienNeu.stop();
                this.setAnzahl(this.listeDateienUeberschreiben.size());
                this.dateienUeberschreiben.start();
                this.ueberschreiben(pM_Listener);
                this.dateienUeberschreiben.stop();
                this.fertig.start();
                this.fertig.stop();
                break;
            }
            case 3: {
                jDialog.dispose();
            }
        }
    }
}

