/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import pm.gui.PM_IndexView;
import pm.gui.PM_WindowBase;
import pm.gui.PM_WindowMain;
import pm.gui.PM_WindowSequence;
import pm.picture.PM_Picture;
import pm.sequence.PM_Sequence;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;
import pm.utilities.PM_UtilsGrafik;

public class PM_PictureView
extends JComponent
implements PM_Interface,
MouseListener {
    protected PM_WindowMain windowMain = null;
    private PM_Picture picture = null;
    public static final int THUMBNAIL_BORDER = 6;
    public static final int THUMBNAIL_TEXT = 18;
    private PM_IndexView indexView;
    private Image imageThumbnail = null;

    protected PM_PictureView(PM_Picture pM_Picture, PM_WindowMain pM_WindowMain, PM_IndexView pM_IndexView) {
        this.picture = pM_Picture;
        this.windowMain = pM_WindowMain;
        this.indexView = pM_IndexView;
        this.addMouseListener(this);
        this.setToolTips();
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_PictureView.this.keyPressedArrow(37);
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_PictureView.this.keyPressedArrow(39);
            }
        };
        AbstractAction abstractAction3 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_PictureView.this.keyEnterPressed();
            }
        };
        AbstractAction abstractAction4 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_PictureView.this.keyPressedQs("1");
            }
        };
        AbstractAction abstractAction5 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_PictureView.this.keyPressedQs("2");
            }
        };
        AbstractAction abstractAction6 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_PictureView.this.keyPressedQs("3");
            }
        };
        AbstractAction abstractAction7 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_PictureView.this.keyPressedQs("4");
            }
        };
        AbstractAction abstractAction8 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_PictureView.this.keyPressedRotate(PM_Interface.Rotate.LEFT);
            }
        };
        AbstractAction abstractAction9 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_PictureView.this.keyPressedRotate(PM_Interface.Rotate.RIGHT);
            }
        };
        AbstractAction abstractAction10 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_PictureView.this.keyPressedMirror(83);
            }
        };
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "VK_LEFT");
        actionMap.put("VK_LEFT", abstractAction);
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "VK_RIGHT");
        actionMap.put("VK_RIGHT", abstractAction2);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "VK_ENTER");
        actionMap.put("VK_ENTER", abstractAction3);
        inputMap.put(KeyStroke.getKeyStroke(49, 0), "VK_1");
        actionMap.put("VK_1", abstractAction4);
        inputMap.put(KeyStroke.getKeyStroke(50, 0), "VK_2");
        actionMap.put("VK_2", abstractAction5);
        inputMap.put(KeyStroke.getKeyStroke(51, 0), "VK_3");
        actionMap.put("VK_3", abstractAction6);
        inputMap.put(KeyStroke.getKeyStroke(52, 0), "VK_4");
        actionMap.put("VK_4", abstractAction7);
        inputMap.put(KeyStroke.getKeyStroke(76, 0), "VK_L");
        actionMap.put("VK_L", abstractAction8);
        inputMap.put(KeyStroke.getKeyStroke(82, 0), "VK_R");
        actionMap.put("VK_R", abstractAction9);
        inputMap.put(KeyStroke.getKeyStroke(83, 0), "VK_S");
        actionMap.put("VK_S", abstractAction10);
    }

    private void keyPressedRotate(PM_Interface.Rotate rotate) {
        int n = PM_Utils.getNextRotation(this.picture.meta.getRotation(), rotate);
        this.picture.meta.setRotation(n);
        this.windowMain.rereadPictureViewThumbnail(this.picture);
    }

    private void keyPressedMirror(int n) {
        this.windowMain.rereadPictureViewThumbnail(this.picture);
    }

    private void keyPressedArrow(int n) {
        this.indexView.doSelectNextPictureView(this.getPicture(), n);
    }

    private void keyEnterPressed() {
        this.indexView.keyEnterPressed(this);
    }

    private void keyPressedQs(String string) {
        this.picture.meta.setCategory(string);
        this.repaint();
    }

    public void setToolTips() {
        File file = this.picture.getFileOriginal();
        Date date = this.picture.meta.getDateCurrent();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        String string = simpleDateFormat.format(date) + "/ K" + this.picture.meta.getCategory() + "/" + file.getPath();
        this.setToolTipText(string);
    }

    public void flushImageThumbnail() {
        this.imageThumbnail = null;
    }

    public void paintComponent(Graphics graphics) {
        this.doPaintComponentX(graphics);
    }

    private void doPaintComponentX(Graphics graphics) {
        Object object;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.indexView.isPictureClosed(this.picture) || this.picture.meta.isInvalid()) {
            this.imageThumbnail = null;
        }
        Dimension dimension = this.getPreferredSize();
        int n = dimension.width - 6 - 6;
        Rectangle rectangle = new Rectangle(6, 6, n, n);
        if (this.imageThumbnail == null && this.picture.hasImageThumbnail() && !this.indexView.isPictureClosed(this.picture) && !this.picture.meta.isInvalid()) {
            this.imageThumbnail = this.picture.getImageThumbnail();
        }
        if (this.imageThumbnail != null) {
            Cloneable cloneable;
            if (this.indexView.isPictureViewSelected(this)) {
                Color color = PM_WindowBase.COLOR_ENABLED_SEL;
                object = this.windowMain.getFocusOwner();
                if (object == this || object == this.indexView) {
                    color = PM_WindowBase.COLOR_BG_FOCUS;
                }
                graphics2D.setColor(color);
                graphics2D.drawRect(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
                graphics2D.fillRect(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
            }
            double d = rectangle.getWidth() / (double)Math.max(this.imageThumbnail.getWidth(null), this.imageThumbnail.getHeight(null));
            Rectangle rectangle2 = null;
            Dimension dimension2 = this.picture.meta.getImageSize();
            if (this.picture.meta.hasCutRectangle() && this.indexView.getAusschneiden()) {
                rectangle2 = this.picture.meta.getCutRectangle();
            }
            BufferedImage bufferedImage = PM_UtilsGrafik.getBufferedImage(this.imageThumbnail, rectangle2, dimension2, d);
            int n2 = 0;
            int n3 = 0;
            double d2 = this.imageThumbnail.getWidth(null);
            double d3 = this.imageThumbnail.getHeight(null);
            double d4 = d2 * d * (d3 / d2) / 4.0;
            if (this.indexView.getDrehenSpiegeln()) {
                int n4 = this.picture.meta.getRotation();
                if ((n4 == 0 || n4 == 180) && d2 > d3) {
                    n3 = (int)d4;
                } else {
                    n2 = (int)d4;
                }
            } else if (d2 > d3) {
                n3 = (int)d4;
            } else {
                n2 = (int)d4;
            }
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(6 + n2, 6 + n3);
            if (this.indexView.getDrehenSpiegeln()) {
                cloneable = PM_UtilsGrafik.getMovePoint(this.picture.meta.getRotation(), (double)this.imageThumbnail.getWidth(null) * d, (double)this.imageThumbnail.getHeight(null) * d);
                affineTransform.translate(cloneable.x, cloneable.y);
                affineTransform.rotate((double)this.picture.meta.getRotation() * Math.PI / 180.0);
                if (this.picture.meta.getMirror()) {
                    affineTransform.translate((double)this.imageThumbnail.getWidth(null) * d, 0.0);
                    affineTransform.scale(-1.0, 1.0);
                }
            }
            graphics2D.drawImage(bufferedImage, affineTransform, this);
            if (this.indexView.getPaintBildText()) {
                graphics2D.setFont(new Font("Arial", 1, 12));
                graphics2D.setColor(Color.YELLOW);
                cloneable = new Rectangle(this.imageThumbnail.getWidth(null), this.imageThumbnail.getHeight(null));
                Rectangle rectangle3 = PM_Utils.getDestinationRectangle((Rectangle)cloneable, rectangle);
                String string = "Bildtext";
                graphics2D.drawString(string, rectangle3.x + 2, rectangle3.y + rectangle3.height - 2);
            }
        }
        if (this.imageThumbnail == null) {
            if (this.picture.meta.isInvalid()) {
                graphics2D.setColor(Color.RED);
            } else {
                graphics2D.setColor(Color.WHITE);
            }
            graphics2D.drawRect(0, 0, (int)dimension.getWidth() - 6, (int)dimension.getWidth() - 6);
            graphics2D.fillRect(0, 0, (int)dimension.getWidth() - 6, (int)dimension.getWidth() - 6);
        }
        graphics2D.setFont(new Font("Arial", 1, 12));
        if (this.picture.meta.hasDateChanged() && this.indexView.getMarkImportDatum()) {
            graphics2D.setColor(Color.RED);
        } else {
            graphics2D.setColor(Color.BLUE);
        }
        graphics2D.drawString(this.getText(this.picture), 6, (int)dimension.getHeight() - 6);
        boolean bl = false;
        if (this.indexView.isLeft()) {
            object = this.windowMain.getIndexViewWindowRight();
            if (object != null) {
                if (((PM_IndexView)object).hasPicture(this.picture) && !((PM_IndexView)object).isPictureClosed(this.picture)) {
                    bl = true;
                }
            } else {
                boolean bl2 = bl = this.picture == this.windowMain.getWindowRightSelected().getPictureSelected();
            }
        }
        if (bl) {
            object = graphics2D.getStroke();
            graphics2D.setColor(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(3.0f, 0, 2, 3.0f, new float[]{50.0f, 10.0f}, 4.0f));
            graphics2D.drawRect(2, 2, (int)dimension.getWidth() - 3, (int)dimension.getWidth() - 3);
            graphics2D.setStroke((Stroke)object);
        }
        this.markBaseSequence(this.picture, graphics2D, dimension);
        if (!this.indexView.isLeft() && this.windowMain.getWindowRightSelected() instanceof PM_WindowSequence && PM_WindowSequence.isBaseSelected() && this.picture.meta.hasBaseSequence()) {
            object = this.picture.meta.getBaseSequenceName();
            graphics2D.setFont(new Font("Arial", 1, 12));
            graphics2D.setColor(Color.BLUE);
            graphics2D.drawString((String)object, 3, 14);
        }
    }

    private void markBaseSequence(PM_Picture pM_Picture, Graphics2D graphics2D, Dimension dimension) {
        boolean bl;
        PM_WindowBase pM_WindowBase = this.windowMain.getWindowRightSelected();
        if (!this.indexView.isLeft() && pM_WindowBase instanceof PM_WindowSequence && PM_WindowSequence.isBaseSelected()) {
            PM_Sequence pM_Sequence = ((PM_WindowSequence)pM_WindowBase).getSequenceDargestellt();
            bl = pM_Picture.meta.hasBaseSequence();
            String string = pM_Picture.meta.getBaseSequenceName();
            if (pM_Sequence != null && bl && !pM_Sequence.getShortName().equals(string) || pM_Sequence == null && bl) {
                graphics2D.setColor(Color.RED);
                graphics2D.setStroke(new BasicStroke(3.0f));
                graphics2D.drawRect(1, 1, (int)dimension.getWidth(), (int)dimension.getWidth());
                return;
            }
        }
        boolean bl2 = pM_Picture.meta.hasBaseSequence();
        bl = pM_Picture.meta.hasExtendedSequence();
        if (bl2) {
            return;
        }
        graphics2D.setColor(Color.RED);
        if (bl) {
            // empty if block
        }
        graphics2D.drawRect(0, 0, (int)dimension.getWidth(), (int)dimension.getWidth());
    }

    public void setPictureViewPreferredSize(Dimension dimension) {
        this.setPreferredSize(dimension);
    }

    public PM_IndexView getIndexView() {
        return this.indexView;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.picture.meta.isInvalid()) {
            return;
        }
        boolean bl = this.indexView.isPictureClosed(this.picture);
        if (!bl && mouseEvent.getButton() == 1) {
            if (this.picture.getImageThumbnail() != null) {
                this.indexView.doMouseClickLeft(this, mouseEvent.getClickCount());
            }
        } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
            this.indexView.doPopUp(this, this.picture, mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public PM_Picture getPicture() {
        return this.picture;
    }

    private String getText(PM_Picture pM_Picture) {
        int n = this.indexView.getPictureSize();
        int n2 = this.indexView.getPictureIndex(pM_Picture);
        String string = Integer.toString(n2 + 1) + "/" + Integer.toString(n);
        if (this.indexView.getTextAufloesung()) {
            DecimalFormat decimalFormat = new DecimalFormat("0.0");
            long l = pM_Picture.meta.getResolution();
            File file = pM_Picture.meta.getFileOriginal();
            Dimension dimension = pM_Picture.meta.getImageSize();
            String string2 = " " + dimension.width + "x" + dimension.height;
            String string3 = "(" + decimalFormat.format((double)l / 1000000.0) + " MPix";
            String string4 = " " + decimalFormat.format((double)file.length() / 1000.0) + " KB)";
            return string + string2 + string3 + string4;
        }
        String string5 = "";
        if (PM_IndexView.hasTempPictureList(pM_Picture)) {
            string5 = "t";
        }
        String string6 = "";
        if (pM_Picture.meta.getModified()) {
            string6 = "x";
        }
        String string7 = "";
        if (pM_Picture.meta.hasClosedSequence()) {
            string7 = string7 + "s";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd");
        String string8 = simpleDateFormat.format(pM_Picture.meta.getDateCurrent());
        return string5 + string6 + string + "-K" + pM_Picture.meta.getCategory() + "-" + string8;
    }
}

